/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.profile;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.style.profile.CodingStylePreviewPanel;
import oracle.jdevimpl.style.profile.CodingStyleProfile;
import oracle.jdevimpl.style.resource.CodingStyleArb;

public class CodingStyleImportsPanel
extends DefaultTraversablePanel {
    private static final String HELP_TOPIC = "f1_ideideseteditcodingstyleimports_html";
    private CodingStyleProfile profile;
    private CodingStylePreviewPanel preview;
    private JCheckBox groupImports;
    private WholeNumberField groupDepth;
    private JCheckBox useWideImports;
    private WholeNumberField importThreshold;
    private JCheckBox innerClasses;
    private boolean loading;

    private void $init$() {
        this.preview = new CodingStylePreviewPanel();
        this.groupImports = new JCheckBox();
        this.groupDepth = new WholeNumberField(8);
        this.useWideImports = new JCheckBox();
        this.importThreshold = new WholeNumberField(8);
        this.innerClasses = new JCheckBox();
    }

    public CodingStyleImportsPanel() {
        this.$init$();
        this.setHelpID(HELP_TOPIC);
        CheckBoxListener checkBoxListener = new CheckBoxListener(null);
        FieldListener fieldListener = new FieldListener(null);
        ResourceUtils.resButton((AbstractButton)this.groupImports, (String)CodingStyleArb.getString(36));
        JLabel groupDepthLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)groupDepthLabel, (Component)this.groupDepth, (String)CodingStyleArb.getString(57));
        new ItemSelectableTracker((ItemSelectable)this.groupImports, new Component[]{groupDepthLabel, this.groupDepth});
        this.groupImports.addItemListener(checkBoxListener);
        this.groupDepth.getDocument().addDocumentListener(fieldListener);
        ResourceUtils.resButton((AbstractButton)this.useWideImports, (String)CodingStyleArb.getString(66));
        JLabel importThresholdLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)importThresholdLabel, (Component)this.importThreshold, (String)CodingStyleArb.getString(93));
        new ItemSelectableTracker((ItemSelectable)this.useWideImports, new Component[]{importThresholdLabel, this.importThreshold});
        this.useWideImports.addItemListener(checkBoxListener);
        this.importThreshold.getDocument().addDocumentListener(fieldListener);
        ResourceUtils.resButton((AbstractButton)this.innerClasses, (String)CodingStyleArb.getString(21));
        this.innerClasses.addItemListener(checkBoxListener);
        JLabel previewLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)previewLabel, (Component)this.preview.getEditor(), (String)CodingStyleArb.getString(108));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 5, 2, 0);
        this.add(this.groupImports, gbc);
        gbc.gridwidth = -1;
        gbc.insets = new Insets(0, 29, 10, 3);
        this.add(groupDepthLabel, gbc);
        gbc.gridwidth = 0;
        gbc.insets = new Insets(0, 5, 10, 0);
        this.add((Component)this.groupDepth, gbc);
        gbc.insets = new Insets(0, 5, 2, 0);
        this.add(this.useWideImports, gbc);
        gbc.gridwidth = -1;
        gbc.insets = new Insets(0, 29, 10, 3);
        this.add(importThresholdLabel, gbc);
        gbc.gridwidth = 0;
        gbc.insets = new Insets(0, 5, 10, 0);
        this.add((Component)this.importThreshold, gbc);
        gbc.insets = new Insets(0, 5, 15, 0);
        this.add(this.innerClasses, gbc);
        gbc.insets = new Insets(0, 0, 3, 0);
        this.add(previewLabel, gbc);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add(this.preview, gbc);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public void onEntry(TraversableContext dataContext) {
        this.profile = (CodingStyleProfile)((Object)dataContext.find("Profile"));
        this.preview.setProfile(this.profile);
        this.preview.setSampleCode(this.getSampleCode());
        this.preview.update();
        try {
            this.loading = true;
            this.groupImports.setSelected(this.profile.getGroupImports());
            this.groupDepth.setText(Integer.toString(this.profile.getGroupPackageDepth()));
            this.useWideImports.setSelected(this.profile.getUseWideImports());
            this.importThreshold.setText(Integer.toString(this.profile.getWideImportThreshold()));
            this.innerClasses.setSelected(this.profile.getImportInnerClasses());
        }
        finally {
            this.loading = false;
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.profile = (CodingStyleProfile)((Object)dataContext.find("Profile"));
        this.saveToProfile();
    }

    private void saveToProfile() {
        this.profile.setGroupImports(this.groupImports.isSelected());
        this.profile.setGroupPackageDepth(this.groupDepth.getValue());
        this.profile.setUseWideImports(this.useWideImports.isSelected());
        this.profile.setWideImportThreshold(this.importThreshold.getValue());
        this.profile.setImportInnerClasses(this.innerClasses.isSelected());
    }

    private String getSampleCode() {
        StringBuffer buffer = new StringBuffer();
        if (this.profile != null) {
            boolean useWide = this.profile.getUseWideImports();
            int threshold = this.profile.getWideImportThreshold();
            if (useWide && threshold < 4) {
                buffer.append("import java.awt.*;");
            } else {
                buffer.append("import java.awt.Button;");
                buffer.append("import java.awt.Component;");
                buffer.append("import java.awt.Container;");
            }
            if (useWide && threshold < 3) {
                buffer.append("import java.awt.event.*;");
            } else {
                buffer.append("import java.awt.event.ActionEvent;");
                buffer.append("import java.awt.event.ActionListener;");
            }
            if (this.profile.getImportInnerClasses()) {
                if (useWide && threshold < 2) {
                    buffer.append("import java.util.*;");
                    buffer.append("import java.util.Map.Entry;");
                } else {
                    buffer.append("import java.util.Map;");
                    buffer.append("import java.util.Map.Entry;");
                }
            } else if (useWide && threshold < 2) {
                buffer.append("import java.util.*;");
            } else {
                buffer.append("import java.util.Map;");
            }
            if (useWide && threshold < 5) {
                buffer.append("import javax.swing.*;");
            } else {
                buffer.append("import javax.swing.JButton;");
                buffer.append("import javax.swing.JCheckBox;");
                buffer.append("import javax.swing.JPanel;");
                buffer.append("import javax.swing.JScrollPane;");
            }
        }
        return buffer.toString();
    }

    private void updatePreview() {
        this.saveToProfile();
        this.preview.setSampleCode(this.getSampleCode());
        this.preview.update();
    }

    static boolean ra$loading(CodingStyleImportsPanel codingStyleImportsPanel) {
        return codingStyleImportsPanel.loading;
    }

    static void mav$updatePreview(CodingStyleImportsPanel codingStyleImportsPanel) {
        codingStyleImportsPanel.updatePreview();
    }

    private class CheckBoxListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            if (!CodingStyleImportsPanel.ra$loading(CodingStyleImportsPanel.this)) {
                CodingStyleImportsPanel.mav$updatePreview(CodingStyleImportsPanel.this);
            }
        }

        private CheckBoxListener() {
        }

        CheckBoxListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class FieldListener
    implements DocumentListener {
        public void insertUpdate(DocumentEvent e) {
            this.handleEvent();
        }

        public void removeUpdate(DocumentEvent e) {
            this.handleEvent();
        }

        public void changedUpdate(DocumentEvent e) {
            this.handleEvent();
        }

        private void handleEvent() {
            if (!CodingStyleImportsPanel.ra$loading(CodingStyleImportsPanel.this)) {
                CodingStyleImportsPanel.mav$updatePreview(CodingStyleImportsPanel.this);
            }
        }

        private FieldListener() {
        }

        FieldListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

