/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.profile;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.style.profile.CodingStylePreviewPanel;
import oracle.jdevimpl.style.profile.CodingStyleProfile;
import oracle.jdevimpl.style.resource.CodingStyleArb;

public class CodingStyleNamingPanel
extends DefaultTraversablePanel {
    private static final String HELP_TOPIC = "f1_ideideseteditcodingstylenaming_html";
    private static final int FIELD_COLUMNS = 12;
    private CodingStylePreviewPanel preview;
    private CodingStyleProfile profile;
    private boolean loading;
    private JTextField fieldPrefix;
    private JTextField fieldSuffix;
    private JTextField staticFieldPrefix;
    private JTextField staticFieldSuffix;
    private JTextField parameterPrefix;
    private JTextField parameterSuffix;
    private JTextField localVariablePrefix;
    private JTextField localVariableSuffix;

    private void $init$() {
        this.fieldPrefix = new PrefixField(12);
        this.fieldSuffix = new SuffixField(12);
        this.staticFieldPrefix = new PrefixField(12);
        this.staticFieldSuffix = new SuffixField(12);
        this.parameterPrefix = new PrefixField(12);
        this.parameterSuffix = new SuffixField(12);
        this.localVariablePrefix = new PrefixField(12);
        this.localVariableSuffix = new SuffixField(12);
    }

    public CodingStyleNamingPanel() {
        this.$init$();
        this.setHelpID(HELP_TOPIC);
        this.preview = new CodingStylePreviewPanel();
        this.preview.setSampleCode(this.getSampleCode());
        JLabel previewLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)previewLabel, (Component)this.preview.getEditor(), (String)CodingStyleArb.getString(24));
        this.fieldPrefix.getDocument().addDocumentListener(new FieldListener(null));
        JLabel fieldPrefixLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)fieldPrefixLabel, (Component)this.fieldPrefix, (String)CodingStyleArb.getString(137));
        this.fieldSuffix.getDocument().addDocumentListener(new FieldListener(null));
        JLabel fieldSuffixLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)fieldSuffixLabel, (Component)this.fieldSuffix, (String)CodingStyleArb.getString(128));
        this.staticFieldPrefix.getDocument().addDocumentListener(new FieldListener(null));
        JLabel staticFieldPrefixLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)staticFieldPrefixLabel, (Component)this.staticFieldPrefix, (String)CodingStyleArb.getString(51));
        this.staticFieldSuffix.getDocument().addDocumentListener(new FieldListener(null));
        JLabel staticFieldSuffixLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)staticFieldSuffixLabel, (Component)this.staticFieldSuffix, (String)CodingStyleArb.getString(45));
        this.parameterPrefix.getDocument().addDocumentListener(new FieldListener(null));
        JLabel parameterPrefixLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)parameterPrefixLabel, (Component)this.parameterPrefix, (String)CodingStyleArb.getString(46));
        this.parameterSuffix.getDocument().addDocumentListener(new FieldListener(null));
        JLabel parameterSuffixLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)parameterSuffixLabel, (Component)this.parameterSuffix, (String)CodingStyleArb.getString(34));
        this.localVariablePrefix.getDocument().addDocumentListener(new FieldListener(null));
        JLabel localVariablePrefixLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)localVariablePrefixLabel, (Component)this.localVariablePrefix, (String)CodingStyleArb.getString(81));
        this.localVariableSuffix.getDocument().addDocumentListener(new FieldListener(null));
        JLabel localVariableSuffixLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)localVariableSuffixLabel, (Component)this.localVariableSuffix, (String)CodingStyleArb.getString(71));
        JPanel panel = new JPanel();
        String title = CodingStyleArb.getString(63);
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), BorderFactory.createEmptyBorder(0, 8, 8, 8)));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 3, 3);
        panel.add((Component)fieldPrefixLabel, gbc);
        gbc.insets = new Insets(0, 0, 3, 24);
        panel.add((Component)this.fieldPrefix, gbc);
        gbc.gridwidth = -1;
        gbc.insets = new Insets(0, 0, 3, 3);
        panel.add((Component)fieldSuffixLabel, gbc);
        gbc.gridwidth = 0;
        gbc.insets = new Insets(0, 0, 3, 0);
        panel.add((Component)this.fieldSuffix, gbc);
        gbc.gridwidth = 1;
        gbc.insets = new Insets(0, 0, 3, 3);
        panel.add((Component)staticFieldPrefixLabel, gbc);
        gbc.insets = new Insets(0, 0, 3, 24);
        panel.add((Component)this.staticFieldPrefix, gbc);
        gbc.gridwidth = -1;
        gbc.insets = new Insets(0, 0, 3, 3);
        panel.add((Component)staticFieldSuffixLabel, gbc);
        gbc.gridwidth = 0;
        gbc.insets = new Insets(0, 0, 3, 0);
        panel.add((Component)this.staticFieldSuffix, gbc);
        gbc.gridwidth = 1;
        gbc.insets = new Insets(0, 0, 3, 3);
        panel.add((Component)parameterPrefixLabel, gbc);
        gbc.insets = new Insets(0, 0, 3, 24);
        panel.add((Component)this.parameterPrefix, gbc);
        gbc.gridwidth = -1;
        gbc.insets = new Insets(0, 0, 3, 3);
        panel.add((Component)parameterSuffixLabel, gbc);
        gbc.gridwidth = 0;
        gbc.insets = new Insets(0, 0, 3, 0);
        panel.add((Component)this.parameterSuffix, gbc);
        gbc.gridwidth = 1;
        gbc.insets = new Insets(0, 0, 0, 3);
        panel.add((Component)localVariablePrefixLabel, gbc);
        gbc.insets = new Insets(0, 0, 0, 24);
        panel.add((Component)this.localVariablePrefix, gbc);
        gbc.gridwidth = -1;
        gbc.insets = new Insets(0, 0, 0, 3);
        panel.add((Component)localVariableSuffixLabel, gbc);
        gbc.gridwidth = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.localVariableSuffix, gbc);
        this.setLayout(new GridBagLayout());
        gbc.insets = new Insets(0, 0, 15, 0);
        this.add(panel, gbc);
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 3, 0);
        this.add(previewLabel, gbc);
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(this.preview, gbc);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public void onEntry(TraversableContext dataContext) {
        this.profile = (CodingStyleProfile)((Object)dataContext.find("Profile"));
        this.preview.setProfile(this.profile);
        this.preview.update();
        try {
            this.loading = true;
            this.fieldPrefix.setText(this.profile.getFieldPrefix());
            this.fieldSuffix.setText(this.profile.getFieldSuffix());
            this.staticFieldPrefix.setText(this.profile.getStaticFieldPrefix());
            this.staticFieldSuffix.setText(this.profile.getStaticFieldSuffix());
            this.parameterPrefix.setText(this.profile.getParameterPrefix());
            this.parameterSuffix.setText(this.profile.getParameterSuffix());
            this.localVariablePrefix.setText(this.profile.getLocalVariablePrefix());
            this.localVariableSuffix.setText(this.profile.getLocalVariableSuffix());
        }
        finally {
            this.loading = false;
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.profile = (CodingStyleProfile)((Object)dataContext.find("Profile"));
        this.saveToProfile();
    }

    private void saveToProfile() {
        this.profile.setFieldPrefix(this.normalize(this.fieldPrefix.getText()));
        this.profile.setFieldSuffix(this.normalize(this.fieldSuffix.getText()));
        this.profile.setStaticFieldPrefix(this.normalize(this.staticFieldPrefix.getText()));
        this.profile.setStaticFieldSuffix(this.normalize(this.staticFieldSuffix.getText()));
        this.profile.setParameterPrefix(this.normalize(this.parameterPrefix.getText()));
        this.profile.setParameterSuffix(this.normalize(this.parameterSuffix.getText()));
        this.profile.setLocalVariablePrefix(this.normalize(this.localVariablePrefix.getText()));
        this.profile.setLocalVariableSuffix(this.normalize(this.localVariableSuffix.getText()));
    }

    private String normalize(String str) {
        if (str != null && str.trim().length() == 0) {
            return null;
        }
        return str;
    }

    private String getSampleCode() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("package mypackage.naming;");
        buffer.append("public class Class1");
        buffer.append("{");
        buffer.append("private String ${field field};");
        buffer.append("private static String ${static staticField};");
        buffer.append("public int getValue(");
        buffer.append("String ${parameter parameter})");
        buffer.append("{");
        buffer.append("int ${local local} = 10;");
        buffer.append("return ${local local};");
        buffer.append("}");
        buffer.append("}");
        return buffer.toString();
    }

    static boolean ra$loading(CodingStyleNamingPanel codingStyleNamingPanel) {
        return codingStyleNamingPanel.loading;
    }

    static void mav$saveToProfile(CodingStyleNamingPanel codingStyleNamingPanel) {
        codingStyleNamingPanel.saveToProfile();
    }

    static CodingStylePreviewPanel ra$preview(CodingStyleNamingPanel codingStyleNamingPanel) {
        return codingStyleNamingPanel.preview;
    }

    private class FieldListener
    implements DocumentListener {
        public void insertUpdate(DocumentEvent e) {
            this.handleEvent();
        }

        public void removeUpdate(DocumentEvent e) {
            this.handleEvent();
        }

        public void changedUpdate(DocumentEvent e) {
            this.handleEvent();
        }

        private void handleEvent() {
            if (!CodingStyleNamingPanel.ra$loading(CodingStyleNamingPanel.this)) {
                CodingStyleNamingPanel.mav$saveToProfile(CodingStyleNamingPanel.this);
                CodingStyleNamingPanel.ra$preview(CodingStyleNamingPanel.this).update();
            }
        }

        private FieldListener() {
        }

        FieldListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class PrefixField
    extends JTextField {
        public PrefixField(int cols) {
            super(cols);
        }

        protected Document createDefaultModel() {
            return new JavaIdentifierDocument(true);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    private class SuffixField
    extends JTextField {
        public SuffixField(int cols) {
            super(cols);
        }

        protected Document createDefaultModel() {
            return new JavaIdentifierDocument(false);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    private class JavaIdentifierDocument
    extends PlainDocument {
        private boolean isPrefix;

        public JavaIdentifierDocument(boolean isPrefix) {
            this.isPrefix = isPrefix;
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            boolean valid = true;
            char[] chars = str.toCharArray();
            int i = 0;
            if (this.isPrefix && offs == 0) {
                valid = Character.isJavaIdentifierStart(chars[i++]);
            }
            while (valid && i < chars.length) {
                valid = Character.isJavaIdentifierPart(chars[i++]);
            }
            if (valid) {
                super.insertString(offs, str, a);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

