/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.profile;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.button.ButtonBar;
import oracle.ide.nulls.NullIcon;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.explorer.OverlayedIcon;
import oracle.jdevimpl.java.explorer.SideBySideIcon;
import oracle.jdevimpl.style.profile.CodingStyleProfile;
import oracle.jdevimpl.style.resource.CodingStyleArb;

public class CodingStyleOrderPanel
extends DefaultTraversablePanel {
    private static final String HELP_TOPIC = "f1_ideideseteditcodingstyleorder_html";
    private static final int ACCESS_LEVEL_PUBLIC = 0;
    private static final int ACCESS_LEVEL_PROTECTED = 1;
    private static final int ACCESS_LEVEL_PACKAGE = 2;
    private static final int ACCESS_LEVEL_PRIVATE = 3;
    private JList list;
    private JButton upButton;
    private JButton downButton;
    private boolean moving;
    private CodingStyleProfile profile;
    private ArrayList listItems;
    private DefaultListModel model;

    private void $init$() {
        this.listItems = new ArrayList();
        this.model = new DefaultListModel();
    }

    public CodingStyleOrderPanel() {
        this.$init$();
        this.setHelpID(HELP_TOPIC);
        this.listItems.add(new JavaMember(0, true, OracleIcons.getIcon((String)"field.png"), CodingStyleArb.getString(117), 0));
        this.listItems.add(new JavaMember(1, true, OracleIcons.getIcon((String)"field.png"), CodingStyleArb.getString(99), 1));
        this.listItems.add(new JavaMember(2, true, OracleIcons.getIcon((String)"field.png"), CodingStyleArb.getString(133), 2));
        this.listItems.add(new JavaMember(3, true, OracleIcons.getIcon((String)"field.png"), CodingStyleArb.getString(102), 3));
        this.listItems.add(new JavaMember(0, false, OracleIcons.getIcon((String)"field.png"), CodingStyleArb.getString(13), 4));
        this.listItems.add(new JavaMember(1, false, OracleIcons.getIcon((String)"field.png"), CodingStyleArb.getString(105), 5));
        this.listItems.add(new JavaMember(2, false, OracleIcons.getIcon((String)"field.png"), CodingStyleArb.getString(67), 6));
        this.listItems.add(new JavaMember(3, false, OracleIcons.getIcon((String)"field.png"), CodingStyleArb.getString(52), 7));
        this.listItems.add(new JavaMember(-1, false, OracleIcons.getIcon((String)"constructor.png"), CodingStyleArb.getString(109), 8));
        this.listItems.add(new JavaMember(-1, false, OracleIcons.getIcon((String)"method.png"), CodingStyleArb.getString(2), 9));
        this.listItems.add(new JavaMember(-1, false, OracleIcons.getIcon((String)"class.png"), CodingStyleArb.getString(37), 10));
        this.updateModel();
        this.list = new JList(this.model);
        this.list.setSelectionMode(2);
        this.list.setSelectedIndex(0);
        this.list.setCellRenderer(new JavaMemberRenderer(null));
        this.list.addListSelectionListener(new SelectionListener(null));
        JLabel label = new JLabel();
        ResourceUtils.resLabel((JLabel)label, (Component)this.list, (String)CodingStyleArb.getString(112));
        JScrollPane scrollPane = new JScrollPane(this.list);
        ButtonBar buttons = new ButtonBar();
        buttons.setOrientation(1);
        buttons.setAlignment(1);
        this.upButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.upButton, (String)CodingStyleArb.getString(124));
        ButtonListener listener = new ButtonListener(null);
        this.upButton.addActionListener(listener);
        buttons.add((Component)this.upButton);
        this.downButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.downButton, (String)CodingStyleArb.getString(40));
        this.downButton.addActionListener(listener);
        buttons.add((Component)this.downButton);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(8, 3));
        panel.add((Component)scrollPane, "Center");
        panel.add((Component)buttons, "East");
        panel.add((Component)label, "North");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridwidth = -1;
        gbc.gridheight = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(panel, gbc);
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.weightx = 3.0;
        gbc.weighty = 0.0;
        this.add(new JLabel(), gbc);
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 5));
    }

    public void onEntry(TraversableContext dataContext) {
        this.profile = (CodingStyleProfile)((Object)dataContext.find("Profile"));
        Collections.sort(this.listItems);
        this.updateModel();
        this.updateButtons();
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        CodingStyleProfile profile = (CodingStyleProfile)((Object)dataContext.find("Profile"));
        byte last = 0;
        boolean orderChanged = false;
        int size = this.model.getSize();
        int i = 0;
        while (i < size) {
            JavaMember item = (JavaMember)this.model.get(i);
            byte current = profile.getMemberOrder(item.getId());
            if (current < last) {
                orderChanged = true;
                break;
            }
            last = current;
            ++i;
        }
        if (orderChanged) {
            int i2 = 0;
            while (i2 < size) {
                JavaMember item = (JavaMember)this.model.get(i2);
                profile.setMemberOrder(item.getId(), (byte)i2);
                ++i2;
            }
        }
    }

    private void updateButtons() {
        int[] selection = this.list.getSelectedIndices();
        if (selection.length > 0) {
            this.upButton.setEnabled(selection[0] > 0);
            this.downButton.setEnabled(selection[selection.length - 1] < this.model.getSize() - 1);
        } else {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    private void moveUp() {
        try {
            this.moving = true;
            int[] selection = this.list.getSelectedIndices();
            int[] newSelection = new int[selection.length];
            int i = 0;
            while (i < selection.length) {
                int current = selection[i];
                Object item = this.model.get(current);
                this.model.removeElementAt(current);
                this.model.add(current - 1, item);
                newSelection[i] = current - 1;
                ++i;
            }
            this.list.setSelectedIndices(newSelection);
        }
        finally {
            this.moving = false;
            this.updateButtons();
        }
    }

    private void moveDown() {
        try {
            this.moving = true;
            int[] selection = this.list.getSelectedIndices();
            int[] newSelection = new int[selection.length];
            int i = selection.length - 1;
            while (i >= 0) {
                int current = selection[i];
                Object item = this.model.get(current);
                this.model.removeElementAt(current);
                if (current + 1 == this.model.getSize()) {
                    this.model.addElement(item);
                } else {
                    this.model.add(current + 1, item);
                }
                newSelection[i] = current + 1;
                --i;
            }
            this.list.setSelectedIndices(newSelection);
        }
        finally {
            this.moving = false;
            this.updateButtons();
        }
    }

    private void updateModel() {
        int size = this.model.getSize();
        Iterator iterator = this.listItems.iterator();
        while (iterator.hasNext()) {
            this.model.addElement(iterator.next());
        }
        if (size > 0) {
            this.model.removeRange(0, size - 1);
        }
        if (this.list != null) {
            this.list.setSelectedIndex(0);
        }
    }

    static CodingStyleProfile ra$profile(CodingStyleOrderPanel codingStyleOrderPanel) {
        return codingStyleOrderPanel.profile;
    }

    static JButton ra$upButton(CodingStyleOrderPanel codingStyleOrderPanel) {
        return codingStyleOrderPanel.upButton;
    }

    static void mav$moveUp(CodingStyleOrderPanel codingStyleOrderPanel) {
        codingStyleOrderPanel.moveUp();
    }

    static JButton ra$downButton(CodingStyleOrderPanel codingStyleOrderPanel) {
        return codingStyleOrderPanel.downButton;
    }

    static void mav$moveDown(CodingStyleOrderPanel codingStyleOrderPanel) {
        codingStyleOrderPanel.moveDown();
    }

    static boolean ra$moving(CodingStyleOrderPanel codingStyleOrderPanel) {
        return codingStyleOrderPanel.moving;
    }

    static void mav$updateButtons(CodingStyleOrderPanel codingStyleOrderPanel) {
        codingStyleOrderPanel.updateButtons();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JavaMember
    implements Comparable {
        private Icon icon;
        private String name;
        private int id;

        public JavaMember(int accessLevel, boolean isStatic, Icon icon, String name, int id) {
            this.name = name;
            this.id = id;
            if (icon == null) {
                icon = new NullIcon();
            }
            Object accessIcon = new NullIcon(13, 16);
            if (accessLevel >= 0) {
                switch (accessLevel) {
                    case 0: {
                        accessIcon = JavaArb.getIcon(336);
                        break;
                    }
                    case 1: {
                        accessIcon = JavaArb.getIcon(102);
                        break;
                    }
                    case 2: {
                        accessIcon = JavaArb.getIcon(121);
                        break;
                    }
                    case 3: {
                        accessIcon = JavaArb.getIcon(244);
                        break;
                    }
                    default: {
                        accessIcon = null;
                        break;
                    }
                }
                if (accessIcon != null && isStatic) {
                    Icon staticIcon = JavaArb.getIcon(142);
                    accessIcon = new OverlayedIcon(staticIcon, (Icon)accessIcon);
                }
            }
            this.icon = new SideBySideIcon(icon, (Icon)accessIcon, 1);
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return this.name;
        }

        public int compareTo(Object o) {
            if (!(o instanceof JavaMember)) {
                throw new ClassCastException();
            }
            JavaMember other = (JavaMember)o;
            Byte b1 = new Byte(CodingStyleOrderPanel.ra$profile(CodingStyleOrderPanel.this).getMemberOrder(this.id));
            Byte b2 = new Byte(CodingStyleOrderPanel.ra$profile(CodingStyleOrderPanel.this).getMemberOrder(other.id));
            return b1.compareTo(b2);
        }
    }

    private class JavaMemberRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof JavaMember) {
                JavaMember member = (JavaMember)value;
                this.setText(member.getName());
                this.setIcon(member.getIcon());
            }
            return this;
        }

        private JavaMemberRenderer() {
        }

        JavaMemberRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == CodingStyleOrderPanel.ra$upButton(CodingStyleOrderPanel.this)) {
                CodingStyleOrderPanel.mav$moveUp(CodingStyleOrderPanel.this);
            } else if (source == CodingStyleOrderPanel.ra$downButton(CodingStyleOrderPanel.this)) {
                CodingStyleOrderPanel.mav$moveDown(CodingStyleOrderPanel.this);
            }
        }

        private ButtonListener() {
        }

        ButtonListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class SelectionListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            if (!CodingStyleOrderPanel.ra$moving(CodingStyleOrderPanel.this)) {
                CodingStyleOrderPanel.mav$updateButtons(CodingStyleOrderPanel.this);
            }
        }

        private SelectionListener() {
        }

        SelectionListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

