/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.profile;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.JavaPreferences;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.write.SourcePreferences;
import oracle.javatools.util.CopyOnWriteList;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdeveloper.style.CodingStyleOptionsListener;

public class CodingStyleProfile
extends HashStructureAdapter
implements CodingStyleOptions,
Copyable,
JavaPreferences {
    public static final String DATA_KEY = "Profile";
    private static final String NAME = "profile.name";
    private static final String FIELD_PREFIX = "field.prefix";
    private static final String FIELD_SUFFIX = "field.suffix";
    private static final String STATIC_FIELD_PREFIX = "static.field.prefix";
    private static final String STATIC_FIELD_SUFFIX = "static.field.suffix";
    private static final String PARAMETER_PREFIX = "parameter.prefix";
    private static final String PARAMETER_SUFFIX = "parameter.suffix";
    private static final String LOCAL_VARIABLE_PREFIX = "local.variable.prefix";
    private static final String LOCAL_VARIABLE_SUFFIX = "local.variable.suffix";
    private static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"coding-style-profile");
    private static final String ROOT_TAG = "profile";
    private SourcePreferences preferences;
    private boolean modified;
    private boolean disableEvents;
    private final CopyOnWriteList listeners;
    public static final String PROPERTY_INDENT_SIZE = "indentSize";
    public static final String PROPERTY_INDENT_REPLACE_WITH_TABS = "indentReplaceWithTabs";
    public static final String PROPERTY_INDENT_TAB_SIZE = "tabSize";
    public static final String PROPERTY_INDENT_CLASS_MEMBERS = "indentClassMembers";
    public static final String PROPERTY_INDENT_CONTROL_BLOCKS = "indentControlBlocks";
    public static final String PROPERTY_INDENT_BLOCK_CHILDREN = "indentBlockChildren";
    public static final String PROPERTY_INDENT_SWITCH_CASES = "indentSwitchCases";
    public static final String PROPERTY_BLANKLINES_PRESERVED = "blanklinesPreserved";
    public static final String PROPERTY_BLANKLINES_AFTER_PACKAGE = "blanklinesAfterPackage";
    public static final String PROPERTY_BLANKLINES_AFTER_IMPORTS = "blanklinesAfterImports";
    public static final String PROPERTY_BLANKLINES_BEFORE_FIRST_CLASS = "blanklinesBeforeFirstClass";
    public static final String PROPERTY_BLANKLINES_BEFORE_FIRST_MEMBER = "blanklinesBeforeFirstMember";
    public static final String PROPERTY_BLANKLINES_AFTER_LAST_MEMBER = "blanklinesAfterLastMember";
    public static final String PROPERTY_BLANKLINES_BEFORE_FIELD = "blanklinesBeforeField";
    public static final String PROPERTY_BLANKLINES_BEFORE_METHOD = "blanklinesBeforeMethod";
    public static final String PROPERTY_BLANKLINES_BEFORE_MEMBER_CLASS = "blanklinesBeforeMemberClass";
    public static final String PROPERTY_BLANKLINES_EMPTY_CLASS = "blanklinesEmptyClass";
    public static final String PROPERTY_BLANKLINES_EMPTY_ANONYMOUS = "blanklinesEmptyAnonymous";
    public static final String PROPERTY_BLANKLINES_EMPTY_METHOD = "blanklinesEmptyMethod";
    public static final String PROPERTY_BLANKLINES_EMPTY_BLOCK = "blanklinesEmptyBlock";
    public static final String PROPERTY_BRACE_POSITION_CLASS = "classBracePosition";
    public static final String PROPERTY_BRACE_POSITION_METHOD = "methodBracePosition";
    public static final String PROPERTY_BRACE_POSITION_BLOCK = "blockBracePosition";
    public static final String PROPERTY_BRACE_POSITION_ARRAY = "arrayBracePosition";
    public static final String PROPERTY_BRACE_POSITION_SWITCH_CASE = "switchCaseBracePosition";
    public static final String PROPERTY_NEWLINE_EXTENDS = "newlineExtends";
    public static final String PROPERTY_NEWLINE_IMPLEMENTS = "newlineImplements";
    public static final String PROPERTY_NEWLINE_THROWS = "newlineThrows";
    public static final String PROPERTY_NEWLINE_ELSE = "newlineElse";
    public static final String PROPERTY_NEWLINE_WHILE = "newlineWhile";
    public static final String PROPERTY_NEWLINE_CATCH = "newlineCatch";
    public static final String PROPERTY_NEWLINE_FINALLY = "newlineFinally";
    public static final String PROPERTY_SPACE_BEFORE_COMMA = "spaceBeforeComma";
    public static final String PROPERTY_SPACE_AFTER_COMMA = "spaceAfterComma";
    public static final String PROPERTY_SPACE_BEFORE_SEMICOLON = "spaceBeforeSemicolon";
    public static final String PROPERTY_SPACE_AFTER_SEMICOLON = "spaceAfterSemicolon";
    public static final String PROPERTY_SPACE_BEFORE_QUESTION = "spaceBeforeQuestion";
    public static final String PROPERTY_SPACE_AFTER_QUESTION = "spaceAfterQuestion";
    public static final String PROPERTY_SPACE_BEFORE_COLON = "spaceBeforeColon";
    public static final String PROPERTY_SPACE_AFTER_COLON = "spaceAfterColon";
    public static final String PROPERTY_SPACE_AFTER_TYPECAST = "spaceAfterTypecast";
    public static final String PROPERTY_SPACE_BEFORE_ARGUMENTS = "spaceBeforeArguments";
    public static final String PROPERTY_SPACE_BEFORE_PARAMETERS = "spaceBeforeParameters";
    public static final String PROPERTY_SPACE_AFTER_KEYWORD = "spaceAfterKeyword";
    public static final String PROPERTY_SPACE_AROUND_ASSIGNMENT = "spaceAroundAssignment";
    public static final String PROPERTY_SPACE_AROUND_BINARY_OPERATOR = "spaceAroundBinaryOperator";
    public static final String PROPERTY_SPACE_WITHIN_PARENTHESIS = "spaceWithinParenthesis";
    public static final String PROPERTY_SPACE_WITHIN_BRACKETS = "spaceWithinBrackets";
    public static final String PROPERTY_SPACE_BEFORE_OPEN_BRACE = "spaceBeforeOpenBrace";
    public static final String PROPERTY_WRAP_LINE_WIDTH = "wrapLineWidth";
    public static final String PROPERTY_WRAP_ALIGN = "wrapAlign";
    public static final String PROPERTY_WRAP_MODIFIERS = "wrapModifiers";
    public static final String PROPERTY_WRAP_EXTENDS = "wrapExtends";
    public static final String PROPERTY_WRAP_THROWS = "wrapThrows";
    public static final String PROPERTY_WRAP_PARAMETER_LIST = "wrapParameterList";
    public static final String PROPERTY_WRAP_DOT_CHAIN = "wrapDotChain";
    public static final String PROPERTY_WRAP_FOR_STATEMENT = "wrapForStatement";
    public static final String PROPERTY_WRAP_BINARY_OPERATOR = "wrapBinaryOperator";
    public static final String PROPERTY_WRAP_TERNARY_EXPRESSION = "wrapTernaryExpression";
    public static final String PROPERTY_WRAP_ARRAY_CONSTANT = "wrapArrayConstant";
    public static final String PROPERTY_WRAP_INVOKE_ARGUMENTS = "wrapInvokeArguments";
    public static final String PROPERTY_GROUP_IMPORTS = "groupImports";
    public static final String PROPERTY_GROUP_PACKAGE_DEPTH = "groupPackageDepth";
    public static final String PROPERTY_IMPORT_INNER_CLASSES = "importInnerClasses";
    public static final String PROPERTY_USE_WIDE_IMPORTS = "useWideImports";
    public static final String PROPERTY_WIDE_IMPORT_THRESHOLD = "wideImportThreshold";
    public static final String IMPORT_NARROW_THRESHOLD_PREVIOUS = "import.narrow_threshold.previous";
    public static final String PROPERTY_FIELD_PREFIX = "fieldPrefix";
    public static final String PROPERTY_FIELD_SUFFIX = "fieldSuffix";
    public static final String PROPERTY_STATIC_FIELD_PREFIX = "staticFieldPrefix";
    public static final String PROPERTY_STATIC_FIELD_SUFFIX = "staticFieldSuffix";
    public static final String PROPERTY_PARAMETER_PREFIX = "parameterPrefix";
    public static final String PROPERTY_PARAMETER_SUFFIX = "parameterSuffix";
    public static final String PROPERTY_LOCAL_VARIABLE_PREFIX = "localVariablePrefix";
    public static final String PROPERTY_LOCAL_VARIABLE_SUFFIX = "localVariableSuffix";

    private void $init$() {
        this.listeners = new CopyOnWriteList();
    }

    public CodingStyleProfile() {
        this(HashStructure.newInstance());
    }

    CodingStyleProfile(HashStructure hash) {
        super(hash);
        this.$init$();
        this.preferences = new SourcePreferences(hash);
        hash.addStructureChangeListener((StructureChangeListener)new ChangeListener(null));
    }

    public void addCodingStyleOptionsListener(CodingStyleOptionsListener listener) {
        if (listener != null) {
            this.listeners.addIfAbsent((Object)listener);
        }
    }

    public void removeCodingStyleOptionsListener(CodingStyleOptionsListener listener) {
        if (listener != null) {
            this.listeners.remove((Object)listener);
        }
    }

    public void exportTo(URL url) throws IOException {
        HashStructureIO io = new HashStructureIO(NAMESPACE_URI, ROOT_TAG);
        io.save(url, (Object)this._hash);
    }

    public static CodingStyleProfile importFrom(URL url) throws IOException {
        HashStructureIO io = new HashStructureIO(NAMESPACE_URI, ROOT_TAG);
        return new CodingStyleProfile((HashStructure)io.load(url));
    }

    public boolean isModified() throws TransientMarker {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public boolean isDirty() throws TransientMarker {
        return this._hash.isDirty();
    }

    public void setDirty(boolean dirty) {
        this._hash.markDirty(dirty);
    }

    public SourcePreferences getSourcePreferences() {
        return this.preferences;
    }

    public String getName() {
        return this._hash.getString(NAME);
    }

    public void setName(String name) {
        this._hash.putString(NAME, name, true);
    }

    public int getIndentSize() {
        return this.preferences.getInt(0);
    }

    public void setIndentSize(int indentSize) {
        this.preferences.setInt(0, indentSize);
    }

    public boolean getIndentReplaceWithTabs() {
        return this.preferences.getBoolean(1);
    }

    public void setIndentReplaceWithTabs(boolean indentReplaceWithTabs) {
        this.preferences.setBoolean(1, indentReplaceWithTabs);
    }

    public int getTabSize() {
        return this.preferences.getInt(2);
    }

    public void setTabSize(int tabSize) {
        this.preferences.setInt(2, tabSize);
    }

    public boolean getIndentClassMembers() {
        return this.preferences.getBoolean(3);
    }

    public void setIndentClassMembers(boolean indentClassMembers) {
        this.preferences.setBoolean(3, indentClassMembers);
    }

    public boolean getIndentControlBlocks() {
        return this.preferences.getBoolean(5);
    }

    public void setIndentControlBlocks(boolean indentControlBlocks) {
        this.preferences.setBoolean(5, indentControlBlocks);
    }

    public boolean getIndentBlockChildren() {
        return this.preferences.getBoolean(4);
    }

    public void setIndentBlockChildren(boolean indentBlockChildren) {
        this.preferences.setBoolean(4, indentBlockChildren);
    }

    public boolean getIndentSwitchCases() {
        return this.preferences.getBoolean(6);
    }

    public void setIndentSwitchCases(boolean indentSwitchCases) {
        this.preferences.setBoolean(6, indentSwitchCases);
    }

    public int getBlanklinesPreserved() {
        return this.preferences.getInt(7);
    }

    public void setBlanklinesPreserved(int blanklinesPreserved) {
        this.preferences.setInt(7, blanklinesPreserved);
    }

    public int getBlanklinesAfterPackage() {
        return this.preferences.getInt(8);
    }

    public void setBlanklinesAfterPackage(int blanklinesAfterPackage) {
        this.preferences.setInt(8, blanklinesAfterPackage);
    }

    public int getBlanklinesAfterImports() {
        return this.preferences.getInt(9);
    }

    public void setBlanklinesAfterImports(int blanklinesAfterImports) {
        this.preferences.setInt(9, blanklinesAfterImports);
    }

    public int getBlanklinesBeforeFirstClass() {
        return this.preferences.getInt(10);
    }

    public void setBlanklinesBeforeFirstClass(int blanklinesBeforeFirstClass) {
        this.preferences.setInt(10, blanklinesBeforeFirstClass);
    }

    public int getBlanklinesBeforeFirstMember() {
        return this.preferences.getInt(11);
    }

    public void setBlanklinesBeforeFirstMember(int blanklinesBeforeFirstMember) {
        this.preferences.setInt(11, blanklinesBeforeFirstMember);
    }

    public int getBlanklinesAfterLastMember() {
        return this.preferences.getInt(12);
    }

    public void setBlanklinesAfterLastMember(int blanklinesAfterLastMember) {
        this.preferences.setInt(12, blanklinesAfterLastMember);
    }

    public int getBlanklinesBeforeField() {
        return this.preferences.getInt(14);
    }

    public void setBlanklinesBeforeField(int blanklinesBeforeField) {
        this.preferences.setInt(14, blanklinesBeforeField);
    }

    public int getBlanklinesBeforeMethod() {
        return this.preferences.getInt(15);
    }

    public void setBlanklinesBeforeMethod(int blanklinesBeforeMethod) {
        this.preferences.setInt(15, blanklinesBeforeMethod);
    }

    public int getBlanklinesBeforeMemberClass() {
        return this.preferences.getInt(16);
    }

    public void setBlanklinesBeforeMemberClass(int blanklinesBeforeMemberClass) {
        this.preferences.setInt(16, blanklinesBeforeMemberClass);
    }

    public int getBlanklinesEmptyClass() {
        return this.preferences.getInt(17);
    }

    public void setBlanklinesEmptyClass(int blanklinesEmptyClass) {
        this.preferences.setInt(17, blanklinesEmptyClass);
    }

    public int getBlanklinesEmptyAnonymous() {
        return this.preferences.getInt(18);
    }

    public void setBlanklinesEmptyAnonymous(int blanklinesEmptyAnonymous) {
        this.preferences.setInt(18, blanklinesEmptyAnonymous);
    }

    public int getBlanklinesEmptyMethod() {
        return this.preferences.getInt(19);
    }

    public void setBlanklinesEmptyMethod(int blanklinesEmptyMethod) {
        this.preferences.setInt(19, blanklinesEmptyMethod);
    }

    public int getBlanklinesEmptyBlock() {
        return this.preferences.getInt(20);
    }

    public void setBlanklinesEmptyBlock(int blanklinesEmptyBlock) {
        this.preferences.setInt(20, blanklinesEmptyBlock);
    }

    public int getClassBracePosition() {
        return this.preferences.getBoolean(21) ? 1 : 0;
    }

    public void setClassBracePosition(int position) {
        boolean sameLine = position == 0;
        this.preferences.setBoolean(21, sameLine ^ true);
    }

    public int getMethodBracePosition() {
        return this.preferences.getBoolean(22) ? 1 : 0;
    }

    public void setMethodBracePosition(int position) {
        boolean sameLine = position == 0;
        this.preferences.setBoolean(22, sameLine ^ true);
    }

    public int getBlockBracePosition() {
        return this.preferences.getBoolean(23) ? 1 : 0;
    }

    public void setBlockBracePosition(int position) {
        boolean sameLine = position == 0;
        this.preferences.setBoolean(23, sameLine ^ true);
    }

    public int getArrayBracePosition() {
        return this.preferences.getBoolean(24) ? 1 : 0;
    }

    public void setArrayBracePosition(int position) {
        boolean sameLine = position == 0;
        this.preferences.setBoolean(24, sameLine ^ true);
    }

    public int getSwitchCaseBracePosition() {
        return this.preferences.getBoolean(25) ? 1 : 0;
    }

    public void setSwitchCaseBracePosition(int position) {
        boolean sameLine = position == 0;
        this.preferences.setBoolean(25, sameLine ^ true);
    }

    public boolean getNewlineExtends() {
        return this.preferences.getBoolean(26);
    }

    public void setNewlineExtends(boolean newlineExtends) {
        this.preferences.setBoolean(26, newlineExtends);
    }

    public boolean getNewlineImplements() {
        return this.preferences.getBoolean(27);
    }

    public void setNewlineImplements(boolean newlineImplements) {
        this.preferences.setBoolean(27, newlineImplements);
    }

    public boolean getNewlineThrows() {
        return this.preferences.getBoolean(28);
    }

    public void setNewlineThrows(boolean newlineThrows) {
        this.preferences.setBoolean(28, newlineThrows);
    }

    public boolean getNewlineElse() {
        return this.preferences.getBoolean(29);
    }

    public void setNewlineElse(boolean newlineElse) {
        this.preferences.setBoolean(29, newlineElse);
    }

    public boolean getNewlineWhile() {
        return this.preferences.getBoolean(30);
    }

    public void setNewlineWhile(boolean newlineWhile) {
        this.preferences.setBoolean(30, newlineWhile);
    }

    public boolean getNewlineCatch() {
        return this.preferences.getBoolean(31);
    }

    public void setNewlineCatch(boolean newlineCatch) {
        this.preferences.setBoolean(31, newlineCatch);
    }

    public boolean getNewlineFinally() {
        return this.preferences.getBoolean(32);
    }

    public void setNewlineFinally(boolean newlineFinally) {
        this.preferences.setBoolean(32, newlineFinally);
    }

    public boolean getSpaceBeforeComma() {
        return this.preferences.getBoolean(33);
    }

    public void setSpaceBeforeComma(boolean spaceBeforeComma) {
        this.preferences.setBoolean(33, spaceBeforeComma);
    }

    public boolean getSpaceAfterComma() {
        return this.preferences.getBoolean(34);
    }

    public void setSpaceAfterComma(boolean spaceAfterComma) {
        this.preferences.setBoolean(34, spaceAfterComma);
    }

    public boolean getSpaceBeforeSemicolon() {
        return this.preferences.getBoolean(35);
    }

    public void setSpaceBeforeSemicolon(boolean spaceBeforeSemicolon) {
        this.preferences.setBoolean(35, spaceBeforeSemicolon);
    }

    public boolean getSpaceAfterSemicolon() {
        return this.preferences.getBoolean(36);
    }

    public void setSpaceAfterSemicolon(boolean spaceAfterSemicolon) {
        this.preferences.setBoolean(36, spaceAfterSemicolon);
    }

    public boolean getSpaceBeforeQuestion() {
        return this.preferences.getBoolean(37);
    }

    public void setSpaceBeforeQuestion(boolean spaceBeforeQuestion) {
        this.preferences.setBoolean(37, spaceBeforeQuestion);
    }

    public boolean getSpaceAfterQuestion() {
        return this.preferences.getBoolean(38);
    }

    public void setSpaceAfterQuestion(boolean spaceAfterQuestion) {
        this.preferences.setBoolean(38, spaceAfterQuestion);
    }

    public boolean getSpaceBeforeColon() {
        return this.preferences.getBoolean(39);
    }

    public void setSpaceBeforeColon(boolean spaceBeforeColon) {
        this.preferences.setBoolean(39, spaceBeforeColon);
    }

    public boolean getSpaceAfterColon() {
        return this.preferences.getBoolean(40);
    }

    public void setSpaceAfterColon(boolean spaceAfterColon) {
        this.preferences.setBoolean(40, spaceAfterColon);
    }

    public boolean getSpaceAfterTypecast() {
        return this.preferences.getBoolean(41);
    }

    public void setSpaceAfterTypecast(boolean spaceAfterTypecast) {
        this.preferences.setBoolean(41, spaceAfterTypecast);
    }

    public boolean getSpaceBeforeArguments() {
        return this.preferences.getBoolean(42);
    }

    public void setSpaceBeforeArguments(boolean spaceBeforeArguments) {
        this.preferences.setBoolean(42, spaceBeforeArguments);
    }

    public boolean getSpaceBeforeParameters() {
        return this.preferences.getBoolean(43);
    }

    public void setSpaceBeforeParameters(boolean spaceBeforeParameters) {
        this.preferences.setBoolean(43, spaceBeforeParameters);
    }

    public boolean getSpaceAfterKeyword() {
        return this.preferences.getBoolean(44);
    }

    public void setSpaceAfterKeyword(boolean spaceAfterKeyword) {
        this.preferences.setBoolean(44, spaceAfterKeyword);
    }

    public boolean getSpaceAroundAssignment() {
        return this.preferences.getBoolean(45);
    }

    public void setSpaceAroundAssignment(boolean spaceAroundAssignment) {
        this.preferences.setBoolean(45, spaceAroundAssignment);
    }

    public boolean getSpaceAroundBinaryOperator() {
        return this.preferences.getBoolean(46);
    }

    public void setSpaceAroundBinaryOperator(boolean spaceAroundBinaryOperator) {
        this.preferences.setBoolean(46, spaceAroundBinaryOperator);
    }

    public boolean getSpaceWithinParenthesis() {
        return this.preferences.getBoolean(47);
    }

    public void setSpaceWithinParenthesis(boolean spaceWithinParenthesis) {
        this.preferences.setBoolean(47, spaceWithinParenthesis);
    }

    public boolean getSpaceWithinBrackets() {
        return this.preferences.getBoolean(48);
    }

    public void setSpaceWithinBrackets(boolean spaceWithinBrackets) {
        this.preferences.setBoolean(48, spaceWithinBrackets);
    }

    public boolean getSpaceBeforeOpenBrace() {
        return this.preferences.getBoolean(49);
    }

    public void setSpaceBeforeOpenBrace(boolean spaceBeforeOpenBrace) {
        this.preferences.setBoolean(49, spaceBeforeOpenBrace);
    }

    public int getWrapLineWidth() {
        return this.preferences.getInt(50);
    }

    public void setWrapLineWidth(int wrapLineWidth) {
        this.preferences.setInt(50, wrapLineWidth);
    }

    public boolean getWrapAlign() {
        return this.preferences.getBoolean(51);
    }

    public void setWrapAlign(boolean wrapAlign) {
        this.preferences.setBoolean(51, wrapAlign);
    }

    public int getWrapModifiers() {
        return this.preferences.getInt(52);
    }

    public void setWrapModifiers(int wrapModifiers) {
        this.preferences.setInt(52, wrapModifiers);
    }

    public int getWrapExtends() {
        return this.preferences.getInt(53);
    }

    public void setWrapExtends(int wrapExtends) {
        this.preferences.setInt(53, wrapExtends);
    }

    public int getWrapThrows() {
        return this.preferences.getInt(54);
    }

    public void setWrapThrows(int wrapThrows) {
        this.preferences.setInt(54, wrapThrows);
    }

    public int getWrapParameterList() {
        return this.preferences.getInt(55);
    }

    public void setWrapParameterList(int wrapParameterList) {
        this.preferences.setInt(55, wrapParameterList);
    }

    public int getWrapDotChain() {
        return this.preferences.getInt(56);
    }

    public void setWrapDotChain(int wrapDotChain) {
        this.preferences.setInt(56, wrapDotChain);
    }

    public int getWrapForStatement() {
        return this.preferences.getInt(57);
    }

    public void setWrapForStatement(int wrapForStatement) {
        this.preferences.setInt(57, wrapForStatement);
    }

    public int getWrapBinaryOperator() {
        return this.preferences.getInt(58);
    }

    public void setWrapBinaryOperator(int wrapBinaryOperator) {
        this.preferences.setInt(58, wrapBinaryOperator);
    }

    public int getWrapTernaryExpression() {
        return this.preferences.getInt(59);
    }

    public void setWrapTernaryExpression(int wrapTernaryExpression) {
        this.preferences.setInt(59, wrapTernaryExpression);
    }

    public int getWrapArrayConstant() {
        return this.preferences.getInt(60);
    }

    public void setWrapArrayConstant(int wrapArrayConstant) {
        this.preferences.setInt(60, wrapArrayConstant);
    }

    public int getWrapInvokeArguments() {
        return this.preferences.getInt(61);
    }

    public void setWrapInvokeArguments(int wrapInvokeArguments) {
        this.preferences.setInt(61, wrapInvokeArguments);
    }

    public boolean getGroupImports() {
        return this.preferences.getBoolean(62);
    }

    public void setGroupImports(boolean groupImports) {
        this.preferences.setBoolean(62, groupImports);
    }

    public int getGroupPackageDepth() {
        return this.preferences.getInt(63);
    }

    public void setGroupPackageDepth(int groupPackageDepth) {
        this.preferences.setInt(63, groupPackageDepth);
    }

    public boolean getImportInnerClasses() {
        return this.preferences.getBoolean(64);
    }

    public void setImportInnerClasses(boolean importInnerClasses) {
        this.preferences.setBoolean(64, importInnerClasses);
    }

    public boolean getUseWideImports() {
        return this.preferences.getInt(65) != -1;
    }

    public void setUseWideImports(boolean useWideImports) {
        int previous = this._hash.getInt(IMPORT_NARROW_THRESHOLD_PREVIOUS, 1);
        this.preferences.setInt(65, useWideImports ? previous : -1);
    }

    public int getWideImportThreshold() {
        return this.getUseWideImports() ? this.preferences.getInt(65) : this._hash.getInt(IMPORT_NARROW_THRESHOLD_PREVIOUS, 1);
    }

    public void setWideImportThreshold(int wideImportThreshold) {
        if (this.getUseWideImports()) {
            this.preferences.setInt(65, wideImportThreshold);
        } else {
            wideImportThreshold = Math.max(wideImportThreshold, 1);
            this._hash.putInt(IMPORT_NARROW_THRESHOLD_PREVIOUS, wideImportThreshold);
        }
    }

    public String getFieldPrefix() {
        return this._hash.getString(FIELD_PREFIX);
    }

    public void setFieldPrefix(String prefix) {
        this._hash.putString(FIELD_PREFIX, prefix);
    }

    public String getFieldSuffix() {
        return this._hash.getString(FIELD_SUFFIX);
    }

    public void setFieldSuffix(String suffix) {
        this._hash.putString(FIELD_SUFFIX, suffix);
    }

    public String getStaticFieldPrefix() {
        return this._hash.getString(STATIC_FIELD_PREFIX);
    }

    public void setStaticFieldPrefix(String prefix) {
        this._hash.putString(STATIC_FIELD_PREFIX, prefix);
    }

    public String getStaticFieldSuffix() {
        return this._hash.getString(STATIC_FIELD_SUFFIX);
    }

    public void setStaticFieldSuffix(String suffix) {
        this._hash.putString(STATIC_FIELD_SUFFIX, suffix);
    }

    public String getParameterPrefix() {
        return this._hash.getString(PARAMETER_PREFIX);
    }

    public void setParameterPrefix(String prefix) {
        this._hash.putString(PARAMETER_PREFIX, prefix);
    }

    public String getParameterSuffix() {
        return this._hash.getString(PARAMETER_SUFFIX);
    }

    public void setParameterSuffix(String suffix) {
        this._hash.putString(PARAMETER_SUFFIX, suffix);
    }

    public String getLocalVariablePrefix() {
        return this._hash.getString(LOCAL_VARIABLE_PREFIX);
    }

    public void setLocalVariablePrefix(String prefix) {
        this._hash.putString(LOCAL_VARIABLE_PREFIX, prefix);
    }

    public String getLocalVariableSuffix() {
        return this._hash.getString(LOCAL_VARIABLE_SUFFIX);
    }

    public void setLocalVariableSuffix(String suffix) {
        this._hash.putString(LOCAL_VARIABLE_SUFFIX, suffix);
    }

    public byte getMemberOrder(int member) {
        return this.preferences.getMemberOrder(member);
    }

    public void setMemberOrder(int member, byte order) {
        this.preferences.setMemberOrder(member, order);
    }

    public HashStructure getMemberOrderHashStructure() {
        return this.preferences.getMemberOrderHashStructure();
    }

    public void setMemberOrderHashStructure(HashStructure hash) {
        String key = JavaPreferences.PREFERENCES_keys[67];
        if (hash != null) {
            hash.copyTo(this._hash.getOrCreateHashStructure(key));
        } else {
            this._hash.remove(key);
        }
    }

    public char[] getIndentChars(int level) {
        if (level == 0 || this.getIndentSize() == 0) {
            return new char[0];
        }
        int numSpaces = level * this.getIndentSize();
        int numTabs = 0;
        if (this.getIndentReplaceWithTabs()) {
            int tabSize = this.getTabSize();
            numTabs = numSpaces / tabSize;
            numSpaces %= tabSize;
        }
        char[] chars = new char[numTabs + numSpaces];
        int i = 0;
        while (i < numTabs) {
            chars[i] = 9;
            ++i;
        }
        while (i < chars.length) {
            chars[i] = 32;
            ++i;
        }
        return chars;
    }

    public String format(String input) {
        TextBuffer textBuffer = TextBufferFactory.createArrayTextBuffer();
        textBuffer.insert(0, input.toCharArray());
        SourceFile file = JavaParser.parse((ReadTextBuffer)textBuffer);
        file.setPreferences(this.preferences);
        StringWriter writer = new StringWriter();
        file.print(new PrintWriter((Writer)writer, true));
        return writer.getBuffer().toString();
    }

    public String getFieldName(String base) {
        return this.generateName(base, this.getFieldPrefix(), this.getFieldSuffix());
    }

    public String getStaticFieldName(String base) {
        return this.generateName(base, this.getStaticFieldPrefix(), this.getStaticFieldSuffix());
    }

    public String getParameterName(String base) {
        return this.generateName(base, this.getParameterPrefix(), this.getParameterSuffix());
    }

    public String getLocalVariableName(String base) {
        return this.generateName(base, this.getLocalVariablePrefix(), this.getLocalVariableSuffix());
    }

    private String generateName(String base, String prefix, String suffix) {
        base = base == null ? "" : base.trim();
        prefix = prefix == null ? "" : prefix.trim();
        suffix = suffix == null ? "" : suffix.trim();
        StringBuffer result = new StringBuffer(base.length() + prefix.length() + suffix.length());
        result.append(base);
        if (base.length() > 1) {
            char c;
            result.insert(0, prefix);
            result.append(suffix);
            int len = prefix.length();
            if (len > 0 && Character.isLetter(c = prefix.charAt(len - 1))) {
                result.setCharAt(len, Character.toUpperCase(result.charAt(len)));
            }
        }
        return result.toString();
    }

    public Object copyTo(Object target) {
        if (target == null) {
            target = new CodingStyleProfile();
        }
        CodingStyleProfile copy = (CodingStyleProfile)((Object)target);
        try {
            copy.disableEvents();
            Object object = super.copyTo(target);
            return object;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            copy.enableEvents();
            copy.fireOptionsChanged();
        }
    }

    private void disableEvents() {
        this.disableEvents = true;
    }

    private void enableEvents() {
        this.disableEvents = false;
    }

    private void fireOptionsChanged() {
        Object[] items = this.listeners.getItems();
        int length = items.length;
        int i = 0;
        while (i < length) {
            CodingStyleOptionsListener listener = (CodingStyleOptionsListener)items[i];
            listener.optionsChanged((CodingStyleOptions)this);
            ++i;
        }
    }

    public String applyNamingConventions(String text) {
        String output = text;
        output = this.replaceTag(output, "field", this.getFieldPrefix(), this.getFieldSuffix());
        output = this.replaceTag(output, "static", this.getStaticFieldPrefix(), this.getStaticFieldSuffix());
        output = this.replaceTag(output, "parameter", this.getParameterPrefix(), this.getParameterSuffix());
        output = this.replaceTag(output, "local", this.getLocalVariablePrefix(), this.getLocalVariableSuffix());
        return output;
    }

    private String replaceTag(String text, String tag, String prefix, String suffix) {
        StringBuffer result = new StringBuffer();
        Pattern pattern = Pattern.compile("\\$\\{" + tag + " (.*?)\\}");
        Matcher matcher = pattern.matcher(text);
        int current = 0;
        while (matcher.find(current)) {
            int start = matcher.start();
            int end = matcher.end();
            result.append(text.substring(current, start));
            String name = matcher.group(1);
            result.append(this.generateName(name, prefix, suffix));
            current = end;
        }
        result.append(text.substring(current));
        return result.toString();
    }

    static boolean ra$disableEvents(CodingStyleProfile codingStyleProfile) {
        return codingStyleProfile.disableEvents;
    }

    static void mav$fireOptionsChanged(CodingStyleProfile codingStyleProfile) {
        codingStyleProfile.fireOptionsChanged();
    }

    private class ChangeListener
    extends StructureChangeListener {
        public void structureValuesChanged(StructureChangeEvent e) {
            if (!CodingStyleProfile.ra$disableEvents(CodingStyleProfile.this)) {
                CodingStyleProfile.mav$fireOptionsChanged(CodingStyleProfile.this);
            }
        }

        private ChangeListener() {
        }

        ChangeListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

