/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.treetable;

import oracle.jdevimpl.style.treetable.AbstractCodingStyleTreeItem;

public class CodingStyleTreeNumber
extends AbstractCodingStyleTreeItem {
    private int min;
    private int max;
    private int value;

    public CodingStyleTreeNumber(String propertyName, String name, int min, int max) {
        this(propertyName, name, null, min, max);
    }

    public CodingStyleTreeNumber(String propertyName, String name, String sample, int min, int max) {
        super(propertyName, name, sample);
        this.min = min;
        this.max = max;
    }

    public Object getValue(int column) {
        switch (column) {
            case 0: {
                return this.name;
            }
            case 1: {
                return this.getValue();
            }
        }
        return this.name;
    }

    public Object getValue() {
        return new Integer(this.value);
    }

    public void setValue(Object value) {
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            this.value = integer;
        } else {
            try {
                this.value = Integer.parseInt(value.toString());
            }
            catch (NumberFormatException nfe) {
                this.value = 0;
            }
        }
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }
}

