/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor;

import java.awt.Component;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.palette.PaletteEvent;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PaletteListener;
import oracle.ide.palette.PaletteManager;
import oracle.ide.palette.PaletteWindow;
import oracle.ide.view.View;
import oracle.jdeveloper.uieditor.UIEditor;
import oracle.jdevimpl.uieditor.UIEditorImpl;

public final class CursorManager
implements PaletteListener,
oracle.ide.palette2.PaletteListener {
    private static final Cursor DEFAULT = null;
    private static final Cursor CROSSHAIR = new Cursor(1);
    private static CursorManager INSTANCE;
    private ArrayList views;
    private Cursor cursor;
    private PaletteWindow palette;
    private oracle.ide.palette2.PaletteWindow palette2;
    private oracle.ide.palette2.PaletteItem palette2Item;
    private boolean isPalette1;

    private void $init$() {
        this.views = new ArrayList(5);
        this.cursor = DEFAULT;
        this.isPalette1 = true;
    }

    public static synchronized CursorManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CursorManager();
        }
        return INSTANCE;
    }

    private CursorManager() {
        this.$init$();
        PaletteManager mgr = PaletteManager.getPaletteManager();
        PaletteWindow paletteWindow = this.palette = mgr != null ? mgr.getPaletteWindow() : null;
        if (this.palette != null) {
            PaletteItem item = this.palette.getSelectedItem();
            if (item != null && !item.isPointer()) {
                this.cursor = CROSSHAIR;
            }
            this.palette.addPaletteListener((PaletteListener)this);
        }
        this.palette2Listener();
    }

    public synchronized void registerView(View view) {
        if (!this.views.contains(view)) {
            this.views.add(view);
            Component gui = view.getGUI();
            if (gui != null) {
                gui.setCursor(this.cursor);
            }
        }
    }

    public synchronized void unregisterView(View view) {
        if (this.views.contains(view)) {
            Component gui = view.getGUI();
            if (gui != null) {
                gui.setCursor(DEFAULT);
            }
            this.views.remove(view);
        }
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void paletteOpened(PaletteEvent e) {
        this.isPalette1 = true;
        if (this.palette != null) {
            PaletteItem item = this.palette.getSelectedItem();
            this.cursor = item != null && !item.isPointer() ? CROSSHAIR : DEFAULT;
        }
        this.updateViews();
    }

    public void paletteClosed(PaletteEvent e) {
        this.isPalette1 = true;
        this.cursor = DEFAULT;
        this.updateViews();
    }

    public void selectionChanged(PaletteEvent e) {
        this.isPalette1 = true;
        if (this.palette != null) {
            PaletteItem item = this.palette.getSelectedItem();
            this.cursor = item != null && !item.isPointer() ? CROSSHAIR : DEFAULT;
        }
        this.updateViews();
    }

    public void itemPressed(PaletteEvent e) {
        this.isPalette1 = true;
        if (this.palette != null) {
            PaletteItem item = this.palette.getSelectedItem();
            this.cursor = item != null && !item.isPointer() ? CROSSHAIR : DEFAULT;
        }
        this.updateViews();
    }

    public void stickyModeActivated(PaletteEvent e) {
        this.isPalette1 = true;
    }

    public void stickyModeDeactivated(PaletteEvent e) {
        this.isPalette1 = true;
    }

    private synchronized void updateViews() {
        Iterator i = this.views.iterator();
        if (i != null) {
            while (i.hasNext()) {
                Component gui = ((View)i.next()).getGUI();
                if (gui == null) continue;
                gui.setCursor(this.cursor);
            }
        }
    }

    public boolean isPalette1() {
        return this.isPalette1;
    }

    public oracle.ide.palette2.PaletteItem getPalette2Item() {
        return this.palette2Item;
    }

    private void palette2Listener() {
        oracle.ide.palette2.PaletteManager mgr2 = oracle.ide.palette2.PaletteManager.getPaletteManager();
        oracle.ide.palette2.PaletteWindow paletteWindow = this.palette2 = mgr2 != null ? mgr2.getPaletteWindow() : null;
        if (this.palette2 != null) {
            this.palette2.addPaletteListener((oracle.ide.palette2.PaletteListener)this);
            this.cursor = DEFAULT;
        }
    }

    public void paletteOpened(oracle.ide.palette2.PaletteEvent event) {
        this.isPalette1 = false;
    }

    public void paletteClosed(oracle.ide.palette2.PaletteEvent event) {
        this.isPalette1 = false;
    }

    public void selectionChanged(oracle.ide.palette2.PaletteEvent event) {
        this.isPalette1 = false;
    }

    public void itemSelected(oracle.ide.palette2.PaletteEvent event) {
        this.isPalette1 = false;
        oracle.ide.palette2.PaletteItem paletteItem = (oracle.ide.palette2.PaletteItem)event.getSource();
        if (paletteItem != null) {
            if (event.getAction() == "PALETTE2_ITEM_SELECTED") {
                this.palette2Item = paletteItem;
                this.cursor = CROSSHAIR;
                this.updateViews();
            } else if (event.getAction() == "PALETTE2_ITEM_DEFAULTCREATE") {
                UIEditorImpl editorImpl;
                this.palette2Item = paletteItem;
                this.updateViews();
                Editor editor = EditorManager.getEditorManager().getCurrentEditor();
                if (editor instanceof UIEditor && (editorImpl = (UIEditorImpl)editor) != null) {
                    editorImpl.defaultCreate(null);
                    EditorManager.getEditorManager().activateCurrentEditorFrame();
                }
            }
        }
    }

    public void itemUnselected(oracle.ide.palette2.PaletteEvent event) {
        this.isPalette1 = false;
        if (this.palette2Item == null) {
            return;
        }
        oracle.ide.palette2.PaletteItem paletteItem = (oracle.ide.palette2.PaletteItem)event.getSource();
        if (paletteItem.getItemId().equals(this.palette2Item.getItemId()) && paletteItem.getProviderId().equals(this.palette2Item.getProviderId())) {
            this.palette2Item = null;
            this.cursor = DEFAULT;
            this.updateViews();
        }
    }

    public void stickyModeActivated(oracle.ide.palette2.PaletteEvent event) {
        this.isPalette1 = false;
    }

    public void stickyModeDeactivated(oracle.ide.palette2.PaletteEvent event) {
        this.isPalette1 = false;
    }
}

