/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.tree.TreeNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.explorer.ExplorerWindow;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.datatransfer.ExtendedTransferable;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.cmt.CmtComponent;
import oracle.jdeveloper.cmt.CmtComponentManager;
import oracle.jdeveloper.cmt.CmtComponentSource;
import oracle.jdeveloper.cmt.CmtComponents;
import oracle.jdeveloper.cmt.CmtEvent;
import oracle.jdeveloper.cmt.CmtEventState;
import oracle.jdeveloper.cmt.CmtFolder;
import oracle.jdeveloper.cmt.CmtModel;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.cmt.CmtPackages;
import oracle.jdeveloper.cmt.CmtSelectionModel;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.legacy.JotNames;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.uieditor.ModelFactory;
import oracle.jdeveloper.uieditor.UIEditor;
import oracle.jdeveloper.uieditor.UIEditorCanvas;
import oracle.jdeveloper.uieditor.UIManager;
import oracle.jdeveloper.uieditor.datatransfer.DataAndPositions;
import oracle.jdeveloper.uieditor.datatransfer.Operation;
import oracle.jdeveloper.uieditor.datatransfer.OperationProcessor;
import oracle.jdeveloper.uieditor.datatransfer.UIPosition;
import oracle.jdeveloper.uieditor.dnd.DropMenuInvoker;
import oracle.jdeveloper.uieditor.uicanvas.LayoutAssistant;
import oracle.jdeveloper.uieditor.uicanvas.SelectNib;
import oracle.jdeveloper.uieditor.uicanvas.UICanvas;
import oracle.jdevimpl.cmtimpl.JbClipboard;
import oracle.jdevimpl.uieditor.UIEditorArb;
import oracle.jdevimpl.uieditor.UIUtils;
import oracle.jdevimpl.uieditor.datatransfer.PasteOperationFactory;
import oracle.jdevimpl.uieditor.orphancanvas.OrphanModel;
import oracle.jdevimpl.uieditor.uicanvas.ModelNode;

public final class UIEditorController
implements Controller {
    private static UIEditorController INSTANCE;
    private static final int RESIZE_CMD_ID;
    private static final int ADD_CMD_ID;
    private static final int MOVE_CMD_ID;
    private static final Point ORIGIN;
    private final OperationProcessor pasteProcessor;

    static {
        RESIZE_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.uieditor.UIEditorController.Resize");
        ADD_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.uieditor.UIEditorController.Add");
        MOVE_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.uieditor.UIEditorController.Move");
        ORIGIN = new Point(0, 0);
        PasteOperationFactory opFactory = new PasteOperationFactory();
        UIManager.registerOperationFactory(opFactory);
    }

    private void $init$() {
        this.pasteProcessor = new OperationProcessor(null);
    }

    private UIEditorController() {
        this.$init$();
    }

    public static synchronized UIEditorController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UIEditorController();
        }
        return INSTANCE;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int id = action.getCommandId();
        switch (id) {
            case 17: {
                Node node;
                Object view;
                View view2 = view = context != null ? context.getView() : null;
                if (view instanceof UIEditor) {
                    view = ((UIEditor)((Object)view)).getActiveCanvas();
                } else if (view instanceof ExplorerWindow) {
                    view = ((ExplorerWindow)view).getExplorer();
                }
                if (view instanceof UIEditorCanvas && !UIEditorController.warnReadOnly(node = context.getNode())) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Clipboard clipboard = toolkit.getSystemClipboard();
                    JbClipboard proxy = JbClipboard.getInstance();
                    ArrayList roots = UIEditorController.getSelectionRoots(context);
                    proxy.copy(roots);
                    ClipboardStack.pushCurrentClipboard();
                    clipboard.setContents(proxy, proxy);
                    this.deleteNodes(context, true);
                }
                return true;
            }
            case 18: {
                Object view;
                View view3 = view = context != null ? context.getView() : null;
                if (view instanceof UIEditor) {
                    view = ((UIEditor)((Object)view)).getActiveCanvas();
                } else if (view instanceof ExplorerWindow) {
                    view = ((ExplorerWindow)view).getExplorer();
                }
                if (view instanceof UIEditorCanvas) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Clipboard clipboard = toolkit.getSystemClipboard();
                    JbClipboard proxy = JbClipboard.getInstance();
                    ArrayList roots = UIEditorController.getSelectionRoots(context);
                    proxy.copy(roots);
                    ClipboardStack.pushCurrentClipboard();
                    clipboard.setContents(proxy, proxy);
                }
                return true;
            }
            case 19: {
                Object view;
                View view4 = view = context != null ? context.getView() : null;
                if (view instanceof UIEditor) {
                    view = ((UIEditor)((Object)view)).getActiveCanvas();
                } else if (view instanceof ExplorerWindow) {
                    view = ((ExplorerWindow)view).getExplorer();
                }
                try {
                    try {
                        if (view instanceof UIEditorCanvas) {
                            this.update(action, context);
                            boolean showMenu = false;
                            Iterator itor = this.pasteProcessor.getSupportedOperations();
                            Operation firstOp = (Operation)itor.next();
                            if (itor.hasNext()) {
                                Operation nextOp = (Operation)itor.next();
                                if (firstOp.getSuitabilityRank() == nextOp.getSuitabilityRank()) {
                                    showMenu = true;
                                }
                            }
                            if (!showMenu) {
                                List dataAndPosList = this.pasteProcessor.getListOfDataAndPositions(firstOp);
                                DataAndPositions firstDataAndPos = (DataAndPositions)dataAndPosList.get(0);
                                if (dataAndPosList.size() > 1) {
                                    DataAndPositions secondDataAndPos = (DataAndPositions)dataAndPosList.get(0);
                                    boolean bl = showMenu = firstDataAndPos.getData().getSuitabilityRank() == secondDataAndPos.getData().getSuitabilityRank();
                                }
                            }
                            if (!showMenu) {
                                this.pasteProcessor.forceSimpleApply();
                            } else {
                                CmtModelNode target;
                                Element[] selection = context.getSelection();
                                if (selection != null && selection.length == 1 && (target = (CmtModelNode)selection[0]) != null && !(target instanceof CmtFolder)) {
                                    DropMenuInvoker handler = new DropMenuInvoker((Component)target.getSubcomponent().getLiveInstance(), new Point(0, 0), target.getCmtModel(), this.pasteProcessor, new 1());
                                    handler.invoke();
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                finally {
                    UIManager.setPasteTransferable(null);
                }
                return true;
            }
            case 20: {
                Node node;
                Object view;
                View view5 = view = context != null ? context.getView() : null;
                if (view instanceof UIEditor) {
                    view = ((UIEditor)((Object)view)).getActiveCanvas();
                } else if (view instanceof ExplorerWindow) {
                    view = ((ExplorerWindow)view).getExplorer();
                }
                if (view instanceof UIEditorCanvas && !UIEditorController.warnReadOnly(node = context.getNode())) {
                    this.deleteNodes(context, false);
                }
                return true;
            }
            case 22: {
                View view;
                View view6 = view = context != null ? context.getView() : null;
                if (view instanceof UIEditor) {
                    this.selectAll((UIEditor)view);
                }
                return true;
            }
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int id;
        int n = id = action != null ? action.getCommandId() : -1;
        if (id == 17 || id == 20) {
            Object view;
            View view2 = view = context != null ? context.getView() : null;
            if (view instanceof UIEditor) {
                view = ((UIEditor)((Object)view)).getActiveCanvas();
            } else if (view instanceof ExplorerWindow) {
                view = ((ExplorerWindow)view).getExplorer();
            }
            if (!(view instanceof UIEditorCanvas)) {
                action.setEnabled(false);
                return true;
            }
            Node node = context.getNode();
            if (node == null) {
                action.setEnabled(false);
            } else {
                Element[] selection = context.getSelection();
                if (selection.length == 0) {
                    action.setEnabled(false);
                } else {
                    CmtModel model = ((CmtModelNode)selection[0]).getCmtModel();
                    CmtModelNode root = model != null ? model.getRoot() : null;
                    boolean enabled = true;
                    if (root != null) {
                        int i = 0;
                        while (i < selection.length) {
                            if (selection[i] == root && ((CmtModelNode)selection[i]).getName().equals("this")) {
                                enabled = false;
                                break;
                            }
                            if (selection[i] instanceof CmtFolder) {
                                enabled = false;
                                break;
                            }
                            ++i;
                        }
                    } else {
                        enabled = false;
                    }
                    action.setEnabled(enabled);
                }
            }
            return true;
        }
        if (id == 18) {
            Object view;
            View view3 = view = context != null ? context.getView() : null;
            if (view instanceof UIEditor) {
                view = ((UIEditor)((Object)view)).getActiveCanvas();
            } else if (view instanceof ExplorerWindow) {
                view = ((ExplorerWindow)view).getExplorer();
            }
            if (!(view instanceof UIEditorCanvas)) {
                action.setEnabled(false);
                return true;
            }
            Element[] selection = context.getSelection();
            boolean enabled = true;
            if (selection == null || selection.length == 0) {
                enabled = false;
            } else {
                int i = 0;
                while (i < selection.length) {
                    if (selection[i] instanceof CmtFolder) {
                        enabled = false;
                        break;
                    }
                    ++i;
                }
            }
            action.setEnabled(enabled);
            return true;
        }
        if (id == 19) {
            Object view;
            View view4 = view = context != null ? context.getView() : null;
            if (view instanceof UIEditor) {
                view = ((UIEditor)((Object)view)).getActiveCanvas();
            } else if (view instanceof ExplorerWindow) {
                view = ((ExplorerWindow)view).getExplorer();
            }
            if (!(view instanceof UIEditorCanvas)) {
                action.setEnabled(false);
                return true;
            }
            Node node = context.getNode();
            if (node == null) {
                action.setEnabled(false);
            } else {
                Element[] selection = context.getSelection();
                CmtModelNode target = null;
                if (selection != null && selection.length == 1) {
                    target = (CmtModelNode)selection[0];
                }
                if (target != null && !(target instanceof CmtFolder)) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Clipboard clipboard = toolkit.getSystemClipboard();
                    Transferable data = clipboard.getContents(this);
                    ExtendedTransferable eTrans = ExtendedTransferable.getExtendedTransferable((Transferable)data);
                    UIManager.setPasteTransferable((Transferable)(eTrans != null ? eTrans : data));
                    eTrans = UIManager.getPasteTransferable();
                    if (eTrans != null) {
                        this.pasteProcessor.setEditable(true);
                        this.pasteProcessor.setView(context.getView());
                        this.pasteProcessor.setTransferable(eTrans);
                        ArrayList<UIPosition> positions = new ArrayList<UIPosition>();
                        CmtModelNode parent = target;
                        positions.add(new UIPosition(ORIGIN, target));
                        while (parent != null && !parent.mayHaveChildren()) {
                            parent = (CmtModelNode)parent.getParent();
                        }
                        if (parent != null && parent != target && !(parent instanceof CmtFolder)) {
                            positions.add(new UIPosition(ORIGIN, parent));
                        }
                        this.pasteProcessor.update(positions);
                        action.setEnabled(this.pasteProcessor.hasSupportedOperation());
                    } else {
                        action.setEnabled(false);
                    }
                } else {
                    action.setEnabled(false);
                }
            }
            return true;
        }
        if (id == 22) {
            View view;
            View view5 = view = context != null ? context.getView() : null;
            if (!(view instanceof UIEditor)) {
                action.setEnabled(false);
                return true;
            }
            UIEditorCanvas canvas = ((UIEditor)view).getActiveCanvas();
            CmtModel model = canvas != null ? canvas.getModel() : null;
            action.setEnabled(model != null && model.getRoot() != null);
            return true;
        }
        Iterator i = UIManager.getFactories();
        if (i != null) {
            while (i.hasNext()) {
                ModelFactory factory = (ModelFactory)i.next();
                if (!factory.isRegistered(action)) continue;
                action.setEnabled(false);
                return true;
            }
        }
        return false;
    }

    public void addNode(Context context, String type, CmtModelNode target, CmtModelNode aheadOf) throws Exception {
        Exception[] result = new Exception[]{null};
        Project prj = context.getProject();
        CmtComponents mgr = CmtComponentManager.getCmtComponents(prj);
        URL url = context.getNode().getURL();
        CmtComponentSource src = (CmtComponentSource)mgr.getComponent(url);
        2 task = new 2(this, src, context, type, target, aheadOf, result);
        prj.applyBatchChanges((Runnable)task);
        if (result[0] != null) {
            throw result[0];
        }
    }

    private void addNodeImpl(Context context, String type, CmtModelNode target, CmtModelNode aheadOf) {
        String initializer = UIUtils.getToolInitializer();
        CmtModelNode node = null;
        Project prj = context.getProject();
        URL url = context.getNode().getURL();
        CmtComponents mgr = CmtComponentManager.getCmtComponents(prj);
        CmtComponentSource data = (CmtComponentSource)mgr.getComponent(url);
        if (target != null) {
            node = target.getCmtModel().add(target, type, aheadOf, initializer);
        }
        if (node == null) {
            CmtModel[] models = data.getModels();
            CmtModel orphanModel = null;
            int i = 0;
            while (i < models.length) {
                CmtModel model = models[i];
                if (model instanceof OrphanModel) {
                    orphanModel = model;
                } else {
                    node = model.add(model.getRoot(), type, aheadOf, initializer);
                }
                if (node != null) break;
                ++i;
            }
            if (node == null && orphanModel != null) {
                node = orphanModel.add(orphanModel.getRoot(), type, aheadOf, initializer);
            }
        }
        if (node != null) {
            CmtComponent comp;
            CmtSubcomponent sub = node.getSubcomponent();
            CmtComponent cmtComponent = comp = sub != null ? sub.getOuterComponent() : null;
            if (comp != null && comp instanceof CmtComponentSource) {
                ((CmtComponentSource)comp).getSelectionModel().setSelection(new CmtModelNode[]{node});
                UpdateMessage.fireChildAdded((Subject)((CmtComponentSource)comp), (Element)node);
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void moveNodes(UIEditor editor, CmtModelNode[] sources, CmtModelNode target, Point[] locations, Point mouseOffset) throws Exception {
        CmtComponentSource src = null;
        try {
            src = editor.getComponentSource();
            src.beginTrans();
            UIEditorCanvas canvas = editor.getActiveCanvas();
            CmtModel model = canvas.getModel();
            int i = 0;
            while (i < sources.length) {
                model.move(sources[i], locations[i], target, mouseOffset);
                ++i;
            }
            src.commit(UIEditorArb.getString(25));
            src = null;
        }
        catch (Exception e) {
            if (src != null) {
                src.abort();
            }
            throw e;
        }
    }

    public void addNode(UIEditor editor, String type, String initializer, String libNames, String techScopes, CmtModelNode target, Point location, Dimension size) throws Exception {
        Exception[] result = new Exception[]{null};
        Project prj = editor.getContext().getProject();
        CmtComponentSource src = editor.getComponentSource();
        3 task = new 3(this, src, editor, libNames, techScopes, target, type, location, size, initializer, result);
        prj.applyBatchChanges((Runnable)task);
        if (result[0] != null) {
            throw result[0];
        }
    }

    public static boolean updateProjectProperties(Context context, String libNames, String techScopes) {
        Project prj = context.getProject();
        boolean modified = false;
        if (prj == null) {
            return modified;
        }
        try {
            if (techScopes != null && techScopes.length() > 0) {
                StringTokenizer tokenizer = new StringTokenizer(techScopes, ";");
                String[] scopes = new String[tokenizer.countTokens()];
                int i = 0;
                while (tokenizer.hasMoreTokens()) {
                    String scopeName = tokenizer.nextToken().trim();
                    scopes[i++] = scopeName;
                }
                if (i > 0) {
                    modified = TechnologyScopeConfiguration.getInstance((PropertyStorage)prj).updateTechnologyScope(scopes);
                }
            }
            if (libNames != null && libNames.length() > 0) {
                StringTokenizer tokenizer = new StringTokenizer(libNames, ";");
                while (tokenizer.hasMoreTokens()) {
                    String libName = tokenizer.nextToken().trim();
                    boolean bl = modified = JProjectLibraries.getInstance((PropertyStorage)prj).addLibrary((Object)libName) || modified;
                }
            }
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
        if (modified) {
            CmtPackages cmtPkgs;
            CmtComponents cmtMgr = CmtComponentManager.getCmtComponents(prj);
            CmtPackages cmtPackages = cmtPkgs = cmtMgr != null ? cmtMgr.getPackages() : null;
            if (cmtPkgs != null) {
                cmtPkgs.flushCache();
            }
        }
        return modified;
    }

    public void resizeNode(UIEditor editor, SelectNib nib) throws Exception {
        CmtComponentSource src = null;
        try {
            src = editor.getComponentSource();
            src.beginTrans();
            ModelNode node = (ModelNode)nib.target;
            UICanvas canvas = (UICanvas)editor.getActiveCanvas();
            node.resize(canvas.getSelectionEffects(), nib);
            Ide.getStatusBar().setText(null);
            src.commit(UIEditorArb.getString(49));
            src = null;
        }
        catch (Exception e) {
            if (src != null) {
                src.abort();
            }
            throw e;
        }
    }

    public static void mouseAddingNode(ModelNode source, ModelNode target, Point location, Dimension size) {
        if (target != null && target.getLayoutAssistant() != null) {
            Ide.getStatusBar().setText(target.getLayoutAssistant().prepareAddStatus(source, target, location, size));
        }
    }

    public static void mouseMoveNode(boolean treatContainerAsComponent, ModelNode source, ModelNode target, Point location) {
        if (target != null && target.getLayoutAssistant() != null) {
            if (!treatContainerAsComponent && source != null && source.isContainer() && source.getLayoutAssistant() != null) {
                Component component = source.getLiveComponent();
                Point offset = component.getLocation();
                location.x -= offset.x;
                location.y -= offset.y;
                Ide.getStatusBar().setText(source.getLayoutAssistant().prepareMouseMoveStatus(null, source, location));
            } else {
                TreeNode grandparent = null;
                if (treatContainerAsComponent) {
                    grandparent = target.getParent();
                }
                if (source != null && !source.isContainer() && grandparent != null && grandparent instanceof ModelNode && ((ModelNode)grandparent).getLayoutAssistant() != null) {
                    Component component = target.getLiveComponent();
                    Point offset = component.getLocation();
                    location.x += offset.x;
                    location.y += offset.y;
                    Ide.getStatusBar().setText(((ModelNode)grandparent).getLayoutAssistant().prepareMouseMoveStatus(target, (ModelNode)grandparent, location));
                } else {
                    Ide.getStatusBar().setText(target.getLayoutAssistant().prepareMouseMoveStatus(source, target, location));
                }
            }
        }
    }

    public void mouseResizeNode(ModelNode source, Point location, Dimension size) {
        LayoutAssistant l;
        TreeNode target = source.getParent();
        if (target == null) {
            target = source;
            source = null;
        }
        if (target != null && target instanceof ModelNode && (l = ((ModelNode)target).getLayoutAssistant()) != null) {
            Ide.getStatusBar().setText(((ModelNode)target).getLayoutAssistant().prepareResizeStatus(source, location, size));
        }
    }

    private void deleteNodes(Context context, boolean isCut) {
        String name = null;
        Iterator roots = UIEditorController.getSelectionRoots(context).iterator();
        ArrayList<CmtModelNode> casualtyRoots = new ArrayList<CmtModelNode>();
        while (roots.hasNext()) {
            CmtModel model;
            CmtModelNode selected = (CmtModelNode)roots.next();
            if (selected == (model = selected.getCmtModel()).getRoot()) {
                if (selected.getName().equals("this")) continue;
                if (casualtyRoots.isEmpty()) {
                    name = selected.getName();
                }
                ((CmtComponentSource)model.getComponent()).removeModel(model);
                casualtyRoots.add(selected);
                continue;
            }
            if (casualtyRoots.isEmpty()) {
                name = selected.getName();
            }
            casualtyRoots.add(selected);
        }
        int count = casualtyRoots.size();
        if (count <= 0) {
            return;
        }
        if (count > 1) {
            name = UIEditorArb.getString(16);
        }
        CmtComponentSource src = null;
        try {
            ArrayList casualties = new ArrayList();
            CmtModelNode node = (CmtModelNode)casualtyRoots.get(0);
            CmtModel model = node.getCmtModel();
            src = (CmtComponentSource)model.getComponent();
            src.beginTrans();
            int i = 0;
            while (i < count) {
                CmtModelNode child = (CmtModelNode)casualtyRoots.get(i);
                this.addSubtree(child, casualties);
                ++i;
            }
            UpdateMessage.fireChildrenRemoved((Subject)src, casualties);
            int i2 = 0;
            while (i2 < count) {
                CmtModelNode child = (CmtModelNode)casualtyRoots.get(i2);
                child.release();
                if (child.getParent() != null) {
                    src.getStructure().removeNodeFromParent(child);
                }
                ++i2;
            }
            src.commit(isCut ? UIEditorArb.format(28, new String[]{name}) : UIEditorArb.format(14, new String[]{name}));
            src = null;
        }
        catch (Exception ex) {
            if (src != null) {
                src.abort();
            }
            Assert.printStackTrace((Throwable)ex);
        }
    }

    private static ArrayList getSelectionRoots(Context context) {
        Element[] selection = context.getSelection();
        ArrayList<CmtModelNode> roots = new ArrayList<CmtModelNode>();
        int i = 0;
        while (i < selection.length) {
            if (selection[i] instanceof CmtModelNode) {
                CmtModelNode node = (CmtModelNode)selection[i];
                TreeNode parent = node.getParent();
                boolean found = false;
                while (!found && parent != null) {
                    int j = 0;
                    while (j < selection.length) {
                        if (selection[j] == parent) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    parent = parent.getParent();
                }
                if (!found) {
                    roots.add(node);
                }
            }
            ++i;
        }
        return roots;
    }

    private void addSubtree(CmtModelNode root, List casualties) {
        if (root != null) {
            casualties.add(root);
            Enumeration<? extends TreeNode> children = root.children();
            if (children != null) {
                while (children.hasMoreElements()) {
                    CmtModelNode child = (CmtModelNode)children.nextElement();
                    this.addSubtree(child, casualties);
                }
            }
        }
    }

    public void generateDefaultEvent(UIEditor editor) {
        CmtEventState es;
        Element[] selection = editor.getSelection();
        if (selection.length != 1 || !(selection[0] instanceof CmtModelNode)) {
            return;
        }
        CmtSubcomponent sc = ((CmtModelNode)selection[0]).getSubcomponent();
        CmtComponentSource comp = sc != null ? (CmtComponentSource)sc.getOuterComponent() : null;
        CmtEventState cmtEventState = es = sc != null ? sc.getDefaultEventState() : null;
        if (comp == null || es == null) {
            return;
        }
        JavaClass cls = comp.getType();
        String clsName = cls.getQualifiedName();
        CmtEvent event = (CmtEvent)es.getProperty();
        JavaMethod method = event.getListenerMethod();
        JavaType[] paramTypes = method.getParameterTypes();
        String methodName = null;
        try {
            comp.beginTrans();
            String estext = es.getValueText();
            if (estext == null || estext.length() == 0) {
                es.setValueText(es.getDefaultHandlerText());
            }
            methodName = es.getValueText();
            comp.commit(UIEditorArb.getString(21));
            comp = null;
        }
        catch (Exception e) {
            if (comp != null) {
                comp.abort();
            }
            Assert.printStackTrace((Throwable)e);
        }
        try {
            if (methodName != null) {
                Context context = new Context(editor.getContext());
                Project prj = context.getProject();
                JavaManager mgr = JavaManager.getJavaManager((Project)prj);
                SourceClass srcCls = mgr.getSourceClass(clsName);
                SourceMethod srcMethod = srcCls.getSourceMethod(methodName, paramTypes);
                SourceBlock block = srcMethod.getBlock();
                List elems = block.getCodeElements();
                int offset = elems != null && elems.size() > 0 ? ((SourceElement)elems.get(0)).getStartOffset() : block.getStartOffset() + 1;
                context.setView(null);
                NavigationManager navMgr = NavigationManager.getNavigationManager();
                OffsetNavigationPoint point = new OffsetNavigationPoint(context, offset, 0);
                if (navMgr != null) {
                    navMgr.navigateTo((NavigationPoint)point, true);
                } else {
                    point.navigate();
                }
            }
        }
        catch (Exception e) {
            Assert.printStackTrace();
        }
    }

    private void selectAll(UIEditor editor) {
        UIEditorCanvas canvas;
        UIEditorCanvas uIEditorCanvas = canvas = editor != null ? editor.getActiveCanvas() : null;
        if (canvas == null) {
            return;
        }
        CmtModel model = canvas.getModel();
        CmtModelNode root = model != null ? model.getRoot() : null;
        ArrayList list = new ArrayList();
        this.flatList(root, list, null, false);
        CmtModelNode[] all = new CmtModelNode[list.size()];
        list.toArray(all);
        CmtComponentSource source = editor.getComponentSource();
        CmtSelectionModel selModel = source.getSelectionModel();
        selModel.setSelection(all);
    }

    private static boolean warnReadOnly(Node node) {
        if (node != null) {
            if (node.isReadOnly()) {
                Ide.getStatusBar().setText(UIEditorArb.getString(15));
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    private void flatList(CmtModelNode node, ArrayList nodes, Class filter, boolean includeRoot) {
        if ((filter == null || filter.isInstance(node)) && node != null) {
            Iterator i;
            if (includeRoot) {
                nodes.add(node);
            }
            if ((i = node.getChildren()) != null) {
                while (i.hasNext()) {
                    this.flatList((CmtModelNode)i.next(), nodes, filter, true);
                }
            }
        }
    }

    static void mav$addNodeImpl(UIEditorController uIEditorController, Context context, String string, CmtModelNode cmtModelNode, CmtModelNode cmtModelNode2) {
        uIEditorController.addNodeImpl(context, string, cmtModelNode, cmtModelNode2);
    }

    final class 1
    implements Runnable {
        public void run() {
            UIManager.setPasteTransferable(null);
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ CmtComponentSource v$src;
        private final /* synthetic */ Context v$context;
        private final /* synthetic */ String v$type;
        private final /* synthetic */ CmtModelNode v$target;
        private final /* synthetic */ CmtModelNode v$aheadOf;
        private final /* synthetic */ Exception[] v$result;
        final /* synthetic */ UIEditorController this$0;

        public void run() {
            boolean finished = false;
            try {
                this.v$src.beginTrans();
                UIEditorController.updateProjectProperties(this.v$context, UIUtils.getLibraryName(), UIUtils.getTechnologyScope());
                UIEditorController.mav$addNodeImpl(this.this$0, this.v$context, this.v$type, this.v$target, this.v$aheadOf);
                String shortName = JotNames.getShortClassName(this.v$type);
                this.v$src.commit(UIEditorArb.format(27, new String[]{shortName}));
                finished = true;
            }
            catch (Exception e) {
                if (!finished && this.v$src != null) {
                    this.v$src.abort();
                }
                this.v$result[0] = e;
            }
        }

        public 2(UIEditorController uIEditorController, CmtComponentSource cmtComponentSource, Context context, String string, CmtModelNode cmtModelNode, CmtModelNode cmtModelNode2, Exception[] exceptionArray) {
            this.v$result = exceptionArray;
            this.v$aheadOf = cmtModelNode2;
            this.v$target = cmtModelNode;
            this.v$type = string;
            this.v$context = context;
            this.v$src = cmtComponentSource;
            this.this$0 = uIEditorController;
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ CmtComponentSource v$src;
        private final /* synthetic */ UIEditor v$editor;
        private final /* synthetic */ String v$libNames;
        private final /* synthetic */ String v$techScopes;
        private final /* synthetic */ CmtModelNode v$target;
        private final /* synthetic */ String v$type;
        private final /* synthetic */ Point v$location;
        private final /* synthetic */ Dimension v$size;
        private final /* synthetic */ String v$initializer;
        private final /* synthetic */ Exception[] v$result;
        final /* synthetic */ UIEditorController this$0;

        public void run() {
            boolean finished = false;
            try {
                this.v$src.beginTrans();
                CmtModelNode[] oldSelection = this.v$src.getSelectionModel().getSelection();
                this.v$src.getSelectionModel().clearSelection();
                UIEditorController.updateProjectProperties(this.v$editor.getContext(), this.v$libNames, this.v$techScopes);
                CmtModelNode node = this.v$target.getCmtModel().add(this.v$target, this.v$type, this.v$location, this.v$size, this.v$initializer);
                if (node == null) {
                    UIEditorController.mav$addNodeImpl(this.this$0, this.v$editor.getContext(), this.v$type, null, null);
                } else {
                    this.v$src.getSelectionModel().setSelection(new CmtModelNode[]{node});
                    UpdateMessage.fireChildAdded((Subject)this.v$src, (Element)node);
                }
                String shortName = JotNames.getShortClassName(this.v$type);
                this.v$src.commit(UIEditorArb.format(27, new String[]{shortName}));
                if (this.v$src.getSelectionModel().getSelectionCount() == 0 && oldSelection != null) {
                    this.v$src.getSelectionModel().setSelection(oldSelection);
                }
                finished = true;
            }
            catch (Exception e) {
                if (!finished && this.v$src != null) {
                    this.v$src.abort();
                }
                this.v$result[0] = e;
            }
        }

        public 3(UIEditorController uIEditorController, CmtComponentSource cmtComponentSource, UIEditor uIEditor, String string, String string2, CmtModelNode cmtModelNode, String string3, Point point, Dimension dimension, String string4, Exception[] exceptionArray) {
            this.v$result = exceptionArray;
            this.v$initializer = string4;
            this.v$size = dimension;
            this.v$location = point;
            this.v$type = string3;
            this.v$target = cmtModelNode;
            this.v$techScopes = string2;
            this.v$libNames = string;
            this.v$editor = uIEditor;
            this.v$src = cmtComponentSource;
            this.this$0 = uIEditorController;
        }
    }
}

