/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.EditorManager;
import oracle.ide.layout.Layout;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.palette.ADAPaletteListener;
import oracle.ide.palette.PaletteEvent;
import oracle.ide.palette.PaletteManager;
import oracle.ide.palette.PaletteWindow;
import oracle.ide.print.PrintManager;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.jdeveloper.cmt.CmtComponentManager;
import oracle.jdeveloper.cmt.CmtComponentSource;
import oracle.jdeveloper.cmt.CmtComponents;
import oracle.jdeveloper.cmt.CmtMessage;
import oracle.jdeveloper.cmt.CmtModel;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.cmt.CmtParseException;
import oracle.jdeveloper.cmt.CmtSelectionEvent;
import oracle.jdeveloper.cmt.CmtSelectionListener;
import oracle.jdeveloper.cmt.CmtSelectionModel;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.uieditor.ModelFactory;
import oracle.jdeveloper.uieditor.UIEditor;
import oracle.jdeveloper.uieditor.UIEditorCanvas;
import oracle.jdeveloper.uieditor.UIEditorLogPage;
import oracle.jdeveloper.uieditor.UIEditorPrintFactory;
import oracle.jdeveloper.uieditor.UIManager;
import oracle.jdevimpl.uieditor.DefaultCanvas;
import oracle.jdevimpl.uieditor.UIEditorArb;
import oracle.jdevimpl.uieditor.UIEditorController;
import oracle.jdevimpl.uieditor.UIUtils;

public final class UIEditorImpl
extends UIEditor
implements ADAPaletteListener,
CmtSelectionListener {
    private static int COUNTER = 0;
    private RepaintManager repaintManager;
    private RepaintManager oldRepaintManager;
    private JPanel gui;
    private JPanel contentPane;
    private JPanel topMargin;
    private Controller controller;
    private Toolbar toolbar;
    private DefaultCanvas defaultCanvas;
    private UIEditorCanvas canvas;
    CmtComponentSource componentModel;
    private boolean isShown;
    private boolean isDirty;
    private int delayedUpdate;

    private void $init$() {
        this.gui = new TolerantPanel(null);
        this.contentPane = new JPanel();
        this.controller = new ChainedController(null);
        this.delayedUpdate = -1;
    }

    public UIEditorImpl() {
        PaletteWindow pWin;
        this.$init$();
        PaletteManager pMgr = PaletteManager.getPaletteManager();
        if (pMgr != null && (pWin = pMgr.getPaletteWindow()) != null) {
            pWin.addADAPaletteListener((ADAPaletteListener)this);
        }
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(0);
        borderLayout.setVgap(0);
        this.topMargin = new JPanel();
        this.topMargin.setLayout(borderLayout);
        this.topMargin.setBorder(BorderFactory.createEmptyBorder());
        this.defaultCanvas = new DefaultCanvas(UIEditorArb.getString(36), (View)this);
        this.canvas = this.defaultCanvas;
        borderLayout = new BorderLayout();
        borderLayout.setHgap(0);
        borderLayout.setVgap(0);
        this.contentPane.setLayout(borderLayout);
        this.gui.setLayout(new GridBagLayout());
        this.gui.add((Component)this.contentPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        PrintManager.getPrintManager().registerDocumentPrintFactory(UIEditorImpl.class, UIEditorPrintFactory.class);
    }

    private void fail() {
        if (this.componentModel != null) {
            Collection messages = this.componentModel.getMessages();
            if (UIEditorImpl.getErrorLog() != null) {
                UIEditorImpl.getErrorLog().clearAll(this);
                if (messages != null) {
                    UIEditorImpl.getErrorLog().log(messages);
                }
            }
            this.componentModel = null;
        }
        this.setSelectionInternal(null);
    }

    private boolean syncEditor(UpdateMessage msg) {
        boolean sync = this.isShown;
        if (!sync) {
            this.delayedUpdate = msg.getMessageID();
            this.isDirty = true;
            this.setSelectionInternal(View.EMPTY_SELECTION);
        }
        return sync;
    }

    public Controller getController() {
        return this.controller;
    }

    public Component getGUI() {
        return this.gui;
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }

    public Icon getTabIcon() {
        return UIEditorArb.getIcon(3);
    }

    public void setContext(Context context) {
        if (context == null || this.getContext() != null) {
            return;
        }
        Node node = context.getNode();
        if (node == null || !(node instanceof JavaSourceNode)) {
            return;
        }
        this._context = new Context(context);
        this._context.setView((View)this);
        try {
            this.setId("UIEditor" + ++COUNTER);
            this.contentPane.add(this.canvas.getGUI(), "Center");
            if (this.toolbar != null) {
                this.topMargin.remove((Component)this.toolbar);
                this.toolbar = null;
            }
            this.toolbar = this.canvas.getToolbar();
            if (this.toolbar != null) {
                this.topMargin.add((Component)this.toolbar, "Center");
            }
            this.initComponentModel();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Element[] getSelectionFromUI() {
        CmtSelectionModel selModel;
        CmtSelectionModel cmtSelectionModel = selModel = this.componentModel != null && !this.isDirty ? this.componentModel.getSelectionModel() : null;
        if (selModel != null) {
            return selModel.getSelection();
        }
        return View.EMPTY_SELECTION;
    }

    public void editorShown() {
        this.isShown = true;
    }

    public void editorHidden() {
        this.isShown = false;
    }

    public void open() {
        block24: {
            try {
                Collection messages;
                CmtModel[] models;
                Object msg = null;
                try {
                    if (this.canvas != null) {
                        this.canvas.stateChanged(1);
                    }
                    if (this.componentModel != null) {
                        this.componentModel.detach((Observer)this);
                        this.componentModel.getSelectionModel().removeCmtSelectionListener(this);
                        this.componentModel = null;
                    }
                    this.initComponentModel();
                }
                catch (ClassCastException e) {
                    Node node = this.getContext().getNode();
                    msg = UIEditorArb.format(34, new String[]{node != null ? node.getURL().getFile() : null});
                    msg = msg + "\n";
                }
                catch (Throwable e) {
                    msg = e.getLocalizedMessage();
                    if (msg == null || msg.toString().length() == 0) {
                        msg = UIEditorArb.getString(43);
                    }
                    msg = msg + "\n";
                }
                if (msg == null && this.componentModel == null) {
                    msg = UIEditorArb.getString(43) + "\n";
                }
                if (msg == null) {
                    Collection messages2 = this.componentModel.getMessages();
                    Iterator i = messages2.iterator();
                    while (i.hasNext()) {
                        if (((CmtMessage)i.next()).getType() != 3) continue;
                        msg = messages2;
                        this.componentModel = null;
                        break;
                    }
                }
                if (UIEditorImpl.getErrorLog() != null) {
                    UIEditorImpl.getErrorLog().clearAll(this);
                    if (msg != null) {
                        UIEditorImpl.getErrorLog().log(msg);
                    }
                }
                CmtModel[] cmtModelArray = models = this.componentModel != null ? this.componentModel.getModels() : null;
                if (models != null && models.length == 0) {
                    Project project = this.getContext().getProject();
                    UIManager.annotate(this.componentModel, CmtComponentManager.getCmtComponents(project));
                    models = this.componentModel.getModels();
                }
                this.contentPane.removeAll();
                this.canvas = this.defaultCanvas;
                this.contentPane.add(this.canvas.getGUI(), "Center");
                if (this.toolbar != null) {
                    this.topMargin.remove((Component)this.toolbar);
                    this.toolbar = null;
                }
                this.toolbar = this.canvas.getToolbar();
                if (this.toolbar != null) {
                    this.topMargin.add((Component)this.toolbar, "Center");
                }
                this.canvas.stateChanged(0);
                if (models == null || models.length == 0) {
                    this.setSelectionInternal(null);
                    break block24;
                }
                CmtModelNode[] elements = this.componentModel.getSelectionModel().getSelection();
                if (elements == null || elements.length == 0) {
                    elements = null;
                    int i = 0;
                    while (i < models.length) {
                        CmtModelNode node = models[i].getRoot();
                        if (node != null) {
                            elements = new CmtModelNode[]{node};
                            this.componentModel.getSelectionModel().setSelection(elements);
                            break;
                        }
                        ++i;
                    }
                } else {
                    this.setSelectionInternal((Element[])elements);
                }
                if (this.gui.hasFocus()) {
                    Component focusable;
                    Component component = focusable = this.canvas != null ? this.canvas.getDefaultFocusComponent() : null;
                    if (focusable != null) {
                        focusable.requestFocus();
                    }
                }
                if (UIEditorImpl.getErrorLog() != null && (messages = this.componentModel.getMessages()) != null && !messages.isEmpty()) {
                    UIEditorImpl.getErrorLog().log(messages);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (UIEditorImpl.getErrorLog() == null) break block24;
                UIEditorImpl.getErrorLog().log(UIEditorArb.getString(43));
            }
        }
    }

    public void activate() {
        if (this.repaintManager == null) {
            this.oldRepaintManager = RepaintManager.currentManager(this.getGUI());
            this.oldRepaintManager.paintDirtyRegions();
            this.repaintManager = new TolerantRepaintManager(null);
            RepaintManager.setCurrentManager(this.repaintManager);
        }
        this.sync();
        if (this.canvas != null) {
            this.canvas.activate();
        } else {
            super.activate();
        }
    }

    public void deactivate() {
        if (this.repaintManager != null) {
            this.repaintManager.paintDirtyRegions();
            this.repaintManager = null;
            RepaintManager.setCurrentManager(this.oldRepaintManager);
            this.oldRepaintManager = null;
        }
        if (this.canvas != null) {
            this.canvas.deactivate();
        } else {
            super.deactivate();
        }
    }

    public void sync() {
        if (this.isDirty) {
            this.isDirty = false;
            if (this.delayedUpdate == CmtComponentSource.FILE_PARSE_FAILED) {
                this.fail();
            } else {
                this.open();
            }
            this.delayedUpdate = -1;
        }
    }

    public void update(Object observed, UpdateMessage msg) {
        if (msg == null) {
            return;
        }
        int id = msg.getMessageID();
        if (id == CmtComponentSource.STRUCTURE_CHANGING) {
            return;
        }
        if (id == CmtComponentSource.FILE_PARSE_FAILED) {
            if (this.syncEditor(msg)) {
                this.fail();
            }
        } else {
            if (id == UpdateMessage.OBJECT_CLOSED) {
                return;
            }
            if (id == UpdateMessage.CHILD_ADDED || id == UpdateMessage.CHILD_REMOVED || id == UpdateMessage.CHILD_RENAMED) {
                return;
            }
            if (this.syncEditor(msg)) {
                if (msg.getOrigin() == this.getComponentSource()) {
                    this.contentPane.validate();
                    UIEditorCanvas active = this.getActiveCanvas();
                    if (active instanceof ViewSelectionListener) {
                        ((ViewSelectionListener)active).viewSelectionChanged(new ViewSelectionEvent((View)this));
                    }
                } else {
                    this.open();
                    if (this.owner() != null) {
                        this.owner().updateTitle((Object)this);
                    }
                }
            }
        }
    }

    public UIEditorCanvas getActiveCanvas() {
        return this.canvas;
    }

    private void initComponentModel() throws CmtParseException {
        if (this.componentModel == null) {
            URL url;
            Context context = this.getContext();
            Project prj = context.getProject();
            Node node = context != null ? context.getNode() : null;
            URL uRL = url = node != null ? node.getURL() : null;
            if (url != null) {
                CmtComponents mgr = CmtComponentManager.getCmtComponents(prj);
                CmtComponentSource cmtComponentSource = this.componentModel = mgr != null ? (CmtComponentSource)mgr.getComponent(url) : null;
                if (this.componentModel != null) {
                    this.componentModel.attach((Observer)this);
                    this.componentModel.getSelectionModel().addCmtSelectionListener(this);
                }
            }
        }
    }

    public CmtComponentSource getComponentSource() {
        return this.componentModel;
    }

    public void selectionChanged(CmtSelectionEvent e) {
        this.setSelectionInternal((Element[])((CmtSelectionModel)e.getSource()).getSelection());
    }

    private void setSelectionInternal(Element[] elements) {
        UIEditorCanvas target = null;
        CmtModel model = null;
        if (elements != null) {
            if (elements.length > 0) {
                CmtModelNode node = (CmtModelNode)elements[0];
                model = node.getCmtModel();
                ModelFactory factory = model != null ? UIManager.getFactory(model.getClass()) : null;
                UIEditorCanvas uIEditorCanvas = target = factory != null ? factory.getView(this) : null;
                if (target == null) {
                    target = this.defaultCanvas;
                }
            } else {
                target = this.canvas;
                model = this.canvas.getModel();
            }
        } else {
            target = this.defaultCanvas;
        }
        if (target != this.canvas) {
            this.contentPane.removeAll();
            if (this.canvas != null) {
                this.canvas.stateChanged(1);
            }
            this.canvas = target != null ? target : this.defaultCanvas;
            this.contentPane.add(this.canvas.getGUI(), "Center");
            if (this.toolbar != null) {
                this.topMargin.remove((Component)this.toolbar);
                this.toolbar = null;
            }
            this.toolbar = this.canvas.getToolbar();
            if (this.toolbar != null) {
                this.topMargin.add((Component)this.toolbar, "Center");
            }
            this.topMargin.repaint();
            if (this.canvas != null) {
                this.canvas.stateChanged(0);
            }
        }
        if (this.canvas != null && this.canvas.getModel() != model) {
            this.canvas.setModel(model);
        }
        if (this.canvas == this.defaultCanvas && elements == null) {
            this.defaultCanvas.setMessage(UIEditorArb.getString(36));
        }
        this.updateSelection();
        this.contentPane.repaint();
        this.gui.validate();
    }

    public void close() {
        PaletteWindow pWin;
        PaletteManager pMgr;
        if (this.canvas != null) {
            try {
                this.canvas.setModel(null);
                this.canvas.close();
            }
            catch (Throwable t) {
                Assert.printStackTrace((Throwable)t);
            }
        }
        super.close();
        if (this.componentModel != null) {
            this.componentModel.detach((Observer)this);
            this.componentModel.getSelectionModel().removeCmtSelectionListener(this);
            this.componentModel = null;
        }
        if ((pMgr = PaletteManager.getPaletteManager()) != null && (pWin = pMgr.getPaletteWindow()) != null) {
            pWin.removeADAPaletteListener((ADAPaletteListener)this);
        }
    }

    public void commit(String caption) {
        Component focusOwner;
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (kfm != null && (focusOwner = kfm.getFocusOwner()) != null && SwingUtilities.isDescendingFrom(focusOwner, this.gui)) {
            this.gui.requestFocus();
        }
        this.getComponentSource().commit(caption);
        if (this.canvas != null && this.canvas.getGUI() != null) {
            this.canvas.getGUI().validate();
        }
    }

    public void initializeLayout(Layout layout) {
        super.initializeLayout(layout);
        layout.setProperty("Layout.ShowStructure", Boolean.TRUE.toString());
        layout.setProperty("Layout.ShowInspector", Boolean.TRUE.toString());
        layout.setProperty("Layout.ShowPalette", Boolean.TRUE.toString());
        layout.setProperty("Layout.ShowConstraints", Boolean.TRUE.toString());
    }

    public void defaultCreate(PaletteEvent e) {
        if (EditorManager.getEditorManager().getCurrentEditor() != this) {
            return;
        }
        Element[] elems = this.getSelection();
        if (elems != null && elems.length > 0 && elems[0] instanceof CmtModelNode) {
            CmtModelNode node = (CmtModelNode)elems[0];
            CmtModelNode aheadOf = null;
            CmtModelNode parent = node;
            while (parent != null && !parent.mayHaveChildren()) {
                parent = (CmtModelNode)parent.getParent();
            }
            aheadOf = parent != node ? node : null;
            node = parent != null ? parent : node;
            try {
                try {
                    UIEditorController.getInstance().addNode(this.getContext(), UIUtils.getToolName(), node, aheadOf);
                }
                catch (Exception x) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            finally {
                UIUtils.toolUsed();
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public Component getFixedTopMargin() {
        return this.topMargin;
    }

    private final class ChainedController
    implements Controller {
        public boolean handleEvent(IdeAction action, Context context) {
            Controller controller;
            UIEditorCanvas view = UIEditorImpl.this.getActiveCanvas();
            Controller controller2 = controller = view != null ? view.getController() : null;
            if (controller != null && controller.handleEvent(action, context)) {
                return true;
            }
            if (controller != UIEditorController.getInstance()) {
                return UIEditorController.getInstance().handleEvent(action, context);
            }
            return false;
        }

        public boolean update(IdeAction action, Context context) {
            Controller controller;
            UIEditorCanvas view = UIEditorImpl.this.getActiveCanvas();
            Controller controller2 = controller = view != null ? view.getController() : null;
            if (controller != null && controller.update(action, context)) {
                return true;
            }
            if (controller != UIEditorController.getInstance()) {
                return UIEditorController.getInstance().update(action, context);
            }
            return false;
        }

        private ChainedController() {
        }

        ChainedController(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class TolerantPanel
    extends JPanel {
        private boolean isLogging;

        protected void validateTree() {
            block4: {
                try {
                    super.validateTree();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    if (this.isLogging) break block4;
                    this.isLogging = true;
                    UIEditorLogPage log = UIEditor.getErrorLog();
                    if (log != null) {
                        log.clearAll();
                        log.log(UIEditorArb.getString(48));
                    }
                    this.isLogging = false;
                }
            }
        }

        private TolerantPanel() {
        }

        TolerantPanel(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private final class TolerantRepaintManager
    extends RepaintManager {
        public void paintDirtyRegions() {
            block3: {
                try {
                    super.paintDirtyRegions();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    UIEditorLogPage log = UIEditor.getErrorLog();
                    if (log == null) break block3;
                    log.clearAll();
                    log.log(UIEditorArb.getString(48));
                }
            }
        }

        public void validateInvalidComponents() {
            block3: {
                try {
                    super.validateInvalidComponents();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    UIEditorLogPage log = UIEditor.getErrorLog();
                    if (log == null) break block3;
                    log.clearAll();
                    log.log(UIEditorArb.getString(48));
                }
            }
        }

        private TolerantRepaintManager() {
        }

        TolerantRepaintManager(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

