/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.share.collection.Range;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdeveloper.uieditor.UIEditorOptions;
import oracle.jdevimpl.uieditor.UIEditorArb;

public final class UIEditorOptionsPanel
extends DefaultTraversablePanel
implements ChangeListener {
    private static final String ANON_TEXT = "class Foo { private void jbInit() { addListener(new Listener() {  ... });} }";
    private static final String ADAPT_TEXT = "class Foo { private void jbInit() { addListener(new Adapter(this)); }\n}\nclass Adapter { ... }";
    GridBagLayout mainLayout;
    private GridBagLayout memberLayout;
    private JPanel memberPanel;
    private JLabel scopeLabel;
    private JComboBox scopeCombo;
    private JCheckBox beansInstantiateCheckBox;
    private GridBagLayout eventLayout;
    private JPanel eventPanel;
    private ButtonGroup eventGroup;
    private JRadioButton anonymousRadio;
    private JRadioButton adapterRadio;
    private BasicEditorPane exampleTextArea;
    private JScrollPane exampleScroller;
    private GridBagLayout gridLayout;
    private JPanel gridPanel;
    private JLabel spacingLabel;
    private NumericSpinBox spacingSpinBox;
    private JCheckBox snapToGridCheckBox;
    private JCheckBox showGridCheckBox;

    private void $init$() {
        this.mainLayout = new GridBagLayout();
        this.memberLayout = new GridBagLayout();
        this.memberPanel = new JPanel();
        this.scopeLabel = new JLabel();
        this.scopeCombo = new JComboBox();
        this.beansInstantiateCheckBox = new JCheckBox();
        this.eventLayout = new GridBagLayout();
        this.eventPanel = new JPanel();
        this.eventGroup = new ButtonGroup();
        this.anonymousRadio = new JRadioButton();
        this.adapterRadio = new JRadioButton();
        this.gridLayout = new GridBagLayout();
        this.gridPanel = new JPanel();
        this.spacingLabel = new JLabel();
        this.spacingSpinBox = new NumericSpinBox();
        this.snapToGridCheckBox = new JCheckBox();
        this.showGridCheckBox = new JCheckBox();
    }

    public UIEditorOptionsPanel() {
        this.$init$();
        try {
            this.jbInit();
            HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_prefuieditor_html");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onEntry(TraversableContext context) {
        UIEditorOptions options = (UIEditorOptions)((Object)context.find("UIEditorOptions"));
        this.load(options);
    }

    public void onExit(TraversableContext context) throws TraversalException {
        UIEditorOptions options = (UIEditorOptions)((Object)context.find("UIEditorOptions"));
        this.commit(options);
    }

    private void load(UIEditorOptions options) {
        if (options == null) {
            this.scopeCombo.setSelectedIndex(2);
            this.beansInstantiateCheckBox.setSelected(false);
            this.anonymousRadio.setSelected(true);
            this.spacingSpinBox.setIntValue(5);
            this.snapToGridCheckBox.setSelected(true);
            this.showGridCheckBox.setSelected(true);
            return;
        }
        this.scopeCombo.setSelectedIndex(options.getDefaultMemberScope());
        this.beansInstantiateCheckBox.setSelected(options.isUseBeansInstantiate());
        if (options.isUseAnonymousInnerClass()) {
            this.anonymousRadio.setSelected(true);
        } else {
            this.adapterRadio.setSelected(true);
        }
        this.spacingSpinBox.setIntValue(options.getGridSpacing());
        this.snapToGridCheckBox.setSelected(options.isSnapToGrid());
        this.showGridCheckBox.setSelected(options.isGridVisible());
    }

    private void commit(UIEditorOptions options) {
        if (options == null) {
            return;
        }
        options.setDefaultMemberScope(this.scopeCombo.getSelectedIndex());
        options.setUseBeansInstantiate(this.beansInstantiateCheckBox.isSelected());
        options.setUseAnonymousInnerClass(this.anonymousRadio.isSelected());
        options.setGridSpacing(this.spacingSpinBox.getIntValue());
        options.setSnapToGrid(this.snapToGridCheckBox.isSelected());
        options.setGridVisible(this.showGridCheckBox.isSelected());
    }

    private void jbInit() throws Exception {
        this.memberPanel.setBorder(BorderFactory.createTitledBorder(UIEditorArb.getString(5)));
        this.memberPanel.setLayout(this.memberLayout);
        ResourceUtils.resLabel((JLabel)this.scopeLabel, (Component)this.scopeCombo, (String)UIEditorArb.getString(6));
        this.scopeCombo.setModel(new DefaultComboBoxModel<String>(UIEditorOptions.TAGS));
        ResourceUtils.resButton((AbstractButton)this.beansInstantiateCheckBox, (String)UIEditorArb.getString(4));
        this.eventGroup.add(this.anonymousRadio);
        this.eventGroup.add(this.adapterRadio);
        this.eventPanel.setBorder(BorderFactory.createTitledBorder(UIEditorArb.getString(12)));
        ResourceUtils.resButton((AbstractButton)this.anonymousRadio, (String)UIEditorArb.getString(0));
        ResourceUtils.resButton((AbstractButton)this.adapterRadio, (String)UIEditorArb.getString(44));
        this.anonymousRadio.addChangeListener(this);
        this.adapterRadio.addChangeListener(this);
        this.exampleTextArea = EditorFactory.createStandaloneEditorPane();
        this.exampleTextArea.setLanguageSupport("Sample.java");
        this.exampleTextArea.setProtected(true);
        this.exampleScroller = new JScrollPane((Component)this.exampleTextArea);
        this.eventPanel.setLayout(this.eventLayout);
        this.gridPanel.setBorder(BorderFactory.createTitledBorder(UIEditorArb.getString(31)));
        this.gridPanel.setLayout(this.gridLayout);
        ResourceUtils.resLabel((JLabel)this.spacingLabel, (Component)this.spacingSpinBox, (String)UIEditorArb.getString(9));
        ResourceUtils.resButton((AbstractButton)this.snapToGridCheckBox, (String)UIEditorArb.getString(45));
        ResourceUtils.resButton((AbstractButton)this.showGridCheckBox, (String)UIEditorArb.getString(10));
        this.spacingSpinBox.setRange(new Range(1, 1000));
        this.setLayout(this.mainLayout);
        this.memberPanel.add((Component)this.scopeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.memberPanel.add((Component)this.scopeCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.memberPanel.add((Component)this.beansInstantiateCheckBox, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.memberPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.eventPanel.add((Component)this.anonymousRadio, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.eventPanel.add((Component)this.adapterRadio, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.eventPanel.add((Component)this.exampleScroller, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.add(this.eventPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.gridPanel.add((Component)this.spacingLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.gridPanel.add((Component)this.spacingSpinBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.gridPanel.add((Component)this.snapToGridCheckBox, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.gridPanel.add((Component)this.showGridCheckBox, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.gridPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void stateChanged(ChangeEvent e) {
        this.updateExample();
    }

    private void updateExample() {
        String text = this.anonymousRadio.isSelected() ? ANON_TEXT : ADAPT_TEXT;
        CodingStyleManager csm = CodingStyleManager.getCodingStyleManager();
        CodingStyleOptions styleOptions = csm.getCodingStyleOptions();
        this.exampleTextArea.setProtected(false);
        this.exampleTextArea.setText(styleOptions.format(text));
        this.exampleTextArea.setProtected(true);
        this.exampleTextArea.putProperty("tab-size", (Object)new Integer(styleOptions.getTabSize()));
        this.exampleTextArea.putProperty("right-margin-column", (Object)new Integer(styleOptions.getWrapLineWidth()));
    }
}

