/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controls.KeyNavigationManager;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorConstants;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.model.Element;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.Assert;
import oracle.ide.view.Pinnable;
import oracle.ide.view.View;
import oracle.ideimpl.explorer.CustomTree;
import oracle.ideimpl.explorer.CustomTreeKeyNavigation;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.cmt.CmtComponentManager;
import oracle.jdeveloper.cmt.CmtComponentSource;
import oracle.jdeveloper.cmt.CmtComponents;
import oracle.jdeveloper.cmt.CmtMessage;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.cmt.CmtParseException;
import oracle.jdeveloper.cmt.CmtSelectionEvent;
import oracle.jdeveloper.cmt.CmtSelectionListener;
import oracle.jdeveloper.cmt.CmtSelectionModel;
import oracle.jdeveloper.uieditor.AbstractCanvas;
import oracle.jdeveloper.uieditor.UIEditor;
import oracle.jdeveloper.uieditor.UIManager;
import oracle.jdevimpl.uieditor.CursorManager;
import oracle.jdevimpl.uieditor.UIEditorArb;
import oracle.jdevimpl.uieditor.UIEditorController;
import oracle.jdevimpl.uieditor.UIEditorImpl;
import oracle.jdevimpl.uieditor.UIExplorerController;
import oracle.jdevimpl.uieditor.UIUtils;
import oracle.jdevimpl.uieditor.uicanvas.ModelNode;

public final class UIExplorer
extends AbstractCanvas
implements TreeSelectionListener,
KeyListener,
MouseListener,
ActionListener,
FocusListener,
CmtSelectionListener,
Observer,
Pinnable {
    private static final String DFT_SYMBOL = "ui-explorer";
    private CustomTree tree;
    private KeyNavigationManager treeKeyMgr;
    private JScrollPane gui;
    private CmtComponentSource target;
    private ArrayList expandedPaths;
    private Timer timer;
    private boolean isChanging;
    private Context context;
    private int pinState;

    private void $init$() {
        this.gui = new JScrollPane();
        this.expandedPaths = new ArrayList();
        this.pinState = 0;
    }

    public UIExplorer() {
        this.$init$();
        this.timer = new Timer(250, this);
        this.timer.setRepeats(false);
        this.tree = new CustomTree((TreeModel)null);
        this.tree.setName(DFT_SYMBOL);
        this.tree.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.treeKeyMgr = new KeyNavigationManager((KeyNavigationManager.KeyComponentAdapter)new CustomTreeKeyNavigation((JTree)this.tree));
        this.tree.setSelectionModel((TreeSelectionModel)new DefaultTreeSelectionModel());
        this.tree.setCellRenderer((TreeCellRenderer)new UITreeCellRenderer());
        KeyStroke[] keyStrokes = new KeyStroke[]{KeyStroke.getKeyStroke(88, 2), KeyStroke.getKeyStroke(67, 2), KeyStroke.getKeyStroke(86, 2)};
        KeyUtil.removeKeyStrokesFromInputMap((JComponent)this.tree, (KeyStroke[])keyStrokes, (int)0);
        this.tree.setPreKeyListener((KeyListener)new 1());
        this.tree.setPostKeyListener((KeyListener)this);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setScrollsOnExpand(true);
        this.tree.addTreeSelectionListener((TreeSelectionListener)this);
        this.tree.setPreMouseListener((MouseListener)this);
        this.tree.addFocusListener((FocusListener)this);
        this.gui.setBorder(BorderFactory.createEmptyBorder());
        this.gui.setViewportView((Component)this.tree);
        CursorManager.getInstance().registerView((View)this);
    }

    private void saveExpansion() {
        try {
            if (this.getPinState() != 0 && this.target != null) {
                this.target.setLastDesignedNodes(this.getId(), this.getSelection());
            }
            this.expandedPaths.clear();
            TreeModel model = this.tree.getModel();
            if (model == null) {
                return;
            }
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
            TreePath rootPath = new TreePath(root.getPath());
            Enumeration e = this.tree.getExpandedDescendants(rootPath);
            if (e != null) {
                while (e.hasMoreElements()) {
                    this.expandedPaths.add(UIExplorer.convertTreePathToString((TreePath)e.nextElement()));
                }
            }
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    private void restoreExpansion() {
        try {
            TreeModel model = this.tree.getModel();
            if (model == null) {
                this.expandedPaths.clear();
                return;
            }
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
            TreePath nodePath = new TreePath(root);
            this.tree.collapsePath(nodePath);
            this.tree.expandPath(nodePath);
            Enumeration<TreeNode> e = root.breadthFirstEnumeration();
            int count = this.expandedPaths.size();
            if (e != null && count > 0) {
                String str = null;
                block2: while (e.hasMoreElements()) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                    nodePath = new TreePath(node.getPath());
                    str = UIExplorer.convertTreePathToString(nodePath);
                    int i = 0;
                    while (i < count) {
                        if (str.equals((String)this.expandedPaths.get(i))) {
                            this.tree.expandPath(nodePath);
                            continue block2;
                        }
                        ++i;
                    }
                }
            }
            this.expandedPaths.clear();
            if (this.target != null) {
                if (this.getPinState() == 0) {
                    this.selectionChanged(new CmtSelectionEvent(this.target.getSelectionModel()));
                } else {
                    Element[] selection = this.target.getLastDesignedNodes(this.getId());
                    TreePath[] paths = new TreePath[selection.length];
                    DefaultTreeModel treeModel = this.target.getStructure();
                    int i = 0;
                    while (i < selection.length) {
                        paths[i] = new TreePath(treeModel.getPathToRoot((TreeNode)selection[i]));
                        ++i;
                    }
                    this.tree.setSelectionPaths(paths);
                    if (paths.length > 0) {
                        this.tree.scrollPathToVisible(paths[0]);
                    }
                }
            }
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    private static final String convertTreePathToString(TreePath treePath) {
        StringBuffer path = new StringBuffer(60);
        Object[] objs = treePath.getPath();
        int i = 0;
        while (i < objs.length) {
            path.append(objs[i].toString());
            path.append(",");
            ++i;
        }
        return path.toString();
    }

    public Controller getController() {
        return UIExplorerController.getInstance();
    }

    public void setContext(Context ctx) {
        this.context = ctx != null ? new Context(ctx) : null;
        super.setContext(this.context);
        this.editor = null;
        if (this.context != null) {
            this.context.setView((View)this);
        }
        if (this.context != null && this.context.getNode() != null) {
            String name = this.context.getNode().getShortLabel();
            String title = UIEditorArb.format(52, name);
            AccessibleUtils.updateAccessibleName((Accessible)this.tree, (String)title, (boolean)true);
        }
    }

    public Context getContext(EventObject e) {
        if (this.context == null) {
            this.context = new Context((View)this, this.defaultWorkspace, this.defaultProject, this.defaultNode);
        }
        this.context.setEvent(e);
        this.context.setSelection(this.getSelection());
        return this.context;
    }

    protected Element[] getSelectionFromUI() {
        if (this.target != null) {
            if (this.getPinState() == 0) {
                return this.target.getSelectionModel().getSelection();
            }
            TreePath[] paths = this.tree.getSelectionPaths();
            CmtModelNode[] selection = new CmtModelNode[paths != null ? paths.length : 0];
            int i = 0;
            while (i < selection.length) {
                selection[i] = (Element)paths[i].getLastPathComponent();
                ++i;
            }
            return selection;
        }
        return View.EMPTY_SELECTION;
    }

    public Component getGUI() {
        return this.gui;
    }

    public void selectionChanged(CmtSelectionEvent e) {
        if (this.target == null || this.tree.getModel() == null) {
            return;
        }
        CmtSelectionModel selModel = this.target.getSelectionModel();
        CmtModelNode[] selection = selModel.getSelection();
        TreePath[] paths = new TreePath[selection.length];
        DefaultTreeModel treeModel = this.target.getStructure();
        int i = 0;
        while (i < selection.length) {
            paths[i] = new TreePath(treeModel.getPathToRoot(selection[i]));
            ++i;
        }
        this.tree.setSelectionPaths(paths);
        if (paths.length > 0) {
            this.tree.scrollPathToVisible(paths[0]);
        }
        this.updateSelection();
    }

    public void stateChanged(int state) {
        switch (state) {
            case 0: {
                CursorManager.getInstance().registerView((View)this);
                this.startObserving();
                break;
            }
            case 1: {
                CursorManager.getInstance().unregisterView((View)this);
                this.stopObserving();
                break;
            }
        }
        super.stateChanged(state);
    }

    public void update(Object observed, UpdateMessage message) {
        if (message == null) {
            return;
        }
        this.timer.stop();
        this.isChanging = false;
        int id = message.getMessageID();
        if (id == CmtComponentSource.STRUCTURE_CHANGING) {
            this.isChanging = true;
            this.saveExpansion();
        } else if (id == CmtComponentSource.FILE_PARSE_FAILED) {
            this.tree.setModel(null);
        } else if (id == UpdateMessage.OBJECT_CLOSED) {
            if (this.target != null) {
                this.target.detach(this);
                this.target.getSelectionModel().removeCmtSelectionListener(this);
                this.target = null;
            }
            this.tree.setModel(null);
        } else if (id != UpdateMessage.CHILD_ADDED && id != UpdateMessage.CHILD_REMOVED && id != UpdateMessage.CHILD_RENAMED) {
            if (this.target != null) {
                this.target.detach(this);
                this.target.getSelectionModel().removeCmtSelectionListener(this);
            }
            Context ctx = this.getContext();
            Project prj = ctx.getProject();
            URL url = ctx.getNode().getURL();
            CmtComponents mgr = CmtComponentManager.getCmtComponents(prj);
            this.target = (CmtComponentSource)mgr.getComponent(url);
            UIManager.annotate(this.target, mgr);
            if (this.target != null) {
                this.target.attach(this);
                if (this.getPinState() == 0) {
                    this.target.getSelectionModel().addCmtSelectionListener(this);
                }
                boolean wasChanging = this.isChanging;
                this.isChanging = true;
                this.tree.setModel((TreeModel)this.target.getStructure());
                this.isChanging = wasChanging;
            } else {
                boolean wasChanging = this.isChanging;
                this.isChanging = true;
                this.tree.setModel(null);
                this.isChanging = wasChanging;
            }
        }
        if (id == UpdateMessage.STRUCTURE_CHANGED) {
            this.restoreExpansion();
        }
    }

    private void startObserving() {
        try {
            CmtComponentSource component;
            Project prj = this.context.getProject();
            URL url = this.context.getNode().getURL();
            CmtComponents mgr = CmtComponentManager.getCmtComponents(prj);
            CmtComponentSource cmtComponentSource = component = mgr != null ? (CmtComponentSource)mgr.getComponent(url) : null;
            if (this.target != null) {
                this.target.detach(this);
            }
            this.target = component;
            if (this.target != null) {
                Collection messages = this.target.getMessages();
                Iterator iter = messages != null ? messages.iterator() : null;
                boolean isOK = true;
                if (iter != null) {
                    while (iter.hasNext()) {
                        CmtMessage msg = (CmtMessage)iter.next();
                        if (msg.getType() != 3) continue;
                        isOK = false;
                    }
                }
                UIManager.annotate(this.target, mgr);
                this.target.attach(this);
                if (this.getPinState() == 0) {
                    this.target.getSelectionModel().addCmtSelectionListener(this);
                }
                this.tree.setModel(isOK ? this.target.getStructure() : null);
            } else {
                this.tree.setModel(null);
            }
        }
        catch (CmtParseException e) {
            if (this.target != null) {
                this.target.detach(this);
                this.target.getSelectionModel().removeCmtSelectionListener(this);
            }
            this.target = null;
            this.tree.setModel(null);
        }
        catch (Exception e) {
            if (this.target != null) {
                this.target.detach(this);
                this.target.getSelectionModel().removeCmtSelectionListener(this);
            }
            this.target = null;
            this.tree.setModel(null);
            Assert.printStackTrace((Throwable)e);
        }
        this.restoreExpansion();
    }

    private void stopObserving() {
        this.saveExpansion();
        if (this.target != null) {
            this.target.detach(this);
            this.target.getSelectionModel().removeCmtSelectionListener(this);
            this.target = null;
        }
        this.tree.setModel(null);
    }

    public void menuWillShow(ContextMenu ctxMenu) {
        Context ctx;
        Context context = ctx = ctxMenu != null ? ctxMenu.getContext() : null;
        if (ctx == null) {
            return;
        }
        MouseEvent e = (MouseEvent)ctx.getEvent();
        TreePath path = this.tree.getPathForLocation(e.getX(), e.getY());
        Object node = path != null ? path.getLastPathComponent() : null;
        EditorManager.getEditorManager().getContextMenu();
        ctxMenu.add((Component)EditorConstants.CUT_ITEM, JDeveloperMenuConstants.SECTION_EDIT_CTXT_MENU);
        ctxMenu.add((Component)EditorConstants.COPY_ITEM, JDeveloperMenuConstants.SECTION_EDIT_CTXT_MENU);
        ctxMenu.add((Component)EditorConstants.PASTE_ITEM, JDeveloperMenuConstants.SECTION_EDIT_CTXT_MENU);
        super.menuWillShow(ctxMenu);
    }

    public boolean handleDefaultAction(Context ctx) {
        Editor editor;
        EditorManager mgr = EditorManager.getEditorManager();
        Editor editor2 = editor = mgr != null ? mgr.openEditorInFrame(UIEditorImpl.class, ctx) : null;
        if (editor instanceof UIEditor) {
            CmtSelectionModel model;
            CmtComponentSource source = ((UIEditor)editor).getComponentSource();
            CmtSelectionModel cmtSelectionModel = model = source != null ? source.getSelectionModel() : null;
            if (model != null) {
                model.setSelection((CmtModelNode[])ctx.getSelection());
            }
        }
        return editor != null;
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (!this.isChanging) {
            this.timer.restart();
        }
    }

    public void actionPerformed(ActionEvent e) {
        TreePath[] paths = this.tree.getSelectionPaths();
        CmtModelNode[] newSelection = new CmtModelNode[paths != null ? paths.length : 0];
        int i = 0;
        while (i < newSelection.length) {
            newSelection[i] = (CmtModelNode)paths[i].getLastPathComponent();
            ++i;
        }
        if (this.target != null) {
            if (this.getPinState() == 0) {
                this.target.getSelectionModel().setSelection(newSelection);
            } else {
                this.updateSelection();
            }
        }
    }

    private void dblClicked(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (e.getClickCount() == 2) {
            if (this.tree.getPathForLocation(e.getX(), e.getY()) != null) {
                this.fireDefaultAction(e);
            }
        } else if (e.getClickCount() > 2) {
            e.consume();
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (e.getClickCount() == 1 && UIUtils.getMode() == 3) {
            TreePath path = this.tree.getPathForLocation(e.getX(), e.getY());
            Object node = path != null ? path.getLastPathComponent() : null;
            CmtModelNode aheadOf = null;
            if (node instanceof ModelNode) {
                ModelNode parent = (ModelNode)node;
                while (parent != null && !parent.isContainer()) {
                    parent = parent.getParentNode();
                }
                aheadOf = parent != node ? (CmtModelNode)node : null;
                Object object = node = parent != null ? parent : node;
            }
            if (node instanceof CmtModelNode) {
                try {
                    try {
                        UIEditorController.getInstance().addNode(this.getContext(), UIUtils.getToolName(), (CmtModelNode)node, aheadOf);
                    }
                    catch (Exception x) {
                        Assert.printStackTrace();
                    }
                }
                finally {
                    UIUtils.toolUsed();
                }
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        this.tryPopup(e);
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.dblClicked(e);
        } else {
            this.tryPopup(e);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void tryPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            ContextMenu menu = this.getContextMenu();
            if (menu == null) {
                return;
            }
            TreePath current = this.tree.getPathForLocation(e.getX(), e.getY());
            if (current == null) {
                return;
            }
            TreePath[] paths = this.tree.getSelectionPaths();
            boolean isSelected = false;
            if (paths != null) {
                int i = 0;
                while (i < paths.length) {
                    if (paths[i] == current || paths[i].equals(current)) {
                        isSelected = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!isSelected && this.getUIEditor() != null) {
                CmtSelectionModel model;
                CmtComponentSource source = this.getUIEditor().getComponentSource();
                CmtSelectionModel cmtSelectionModel = model = source != null ? source.getSelectionModel() : null;
                if (model != null) {
                    model.setSelection(new CmtModelNode[]{(CmtModelNode)current.getLastPathComponent()});
                }
            }
            menu.show(this.owner().getContext((EventObject)e));
        }
    }

    protected void fireDefaultAction(InputEvent e) {
        Context context;
        ContextMenu menu = this.getContextMenu();
        if (menu == null) {
            return;
        }
        if (this.target != null && (context = this.getContext(e)).getElement() != null && menu.fireDefaultAction(context)) {
            e.consume();
        }
    }

    public void keyPressed(KeyEvent e) {
        int keyCode;
        this.treeKeyMgr.postKeyPressed(e);
        if (!e.isConsumed() && (keyCode = e.getKeyCode()) == 10) {
            this.fireDefaultAction(e);
        }
    }

    public void keyTyped(KeyEvent e) {
        this.treeKeyMgr.postKeyTyped(e);
    }

    public void keyReleased(KeyEvent e) {
        this.treeKeyMgr.postKeyReleased(e);
    }

    public void focusGained(FocusEvent e) {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        if (model != null) {
            TreePath[] paths = this.tree.getSelectionPaths();
            int length = paths != null ? paths.length : 0;
            while (length > 0) {
                TreeNode node = (TreeNode)paths[--length].getLastPathComponent();
                model.nodeChanged(node);
            }
        }
    }

    public void focusLost(FocusEvent e) {
        this.focusGained(e);
    }

    public int getPinState() {
        return this.pinState;
    }

    public void setPinState(int state) {
        if (state == this.pinState) {
            return;
        }
        this.pinState = state;
        switch (this.pinState) {
            case 0: {
                if (this.target == null) break;
                this.target.getSelectionModel().addCmtSelectionListener(this);
                if (this.tree.getModel() == null) break;
                this.selectionChanged(new CmtSelectionEvent(this.target.getSelectionModel()));
                break;
            }
            default: {
                if (this.target == null) break;
                this.target.getSelectionModel().removeCmtSelectionListener(this);
            }
        }
    }

    static KeyNavigationManager ra$treeKeyMgr(UIExplorer uIExplorer) {
        return uIExplorer.treeKeyMgr;
    }

    final class 1
    implements KeyListener {
        public void keyPressed(KeyEvent e) {
            UIExplorer.ra$treeKeyMgr(UIExplorer.this).preKeyPressed(e);
        }

        public void keyReleased(KeyEvent e) {
            UIExplorer.ra$treeKeyMgr(UIExplorer.this).preKeyReleased(e);
        }

        public void keyTyped(KeyEvent e) {
            UIExplorer.ra$treeKeyMgr(UIExplorer.this).preKeyTyped(e);
        }
    }

    private static final class UITreeCellRenderer
    extends DefaultTreeCellRenderer {
        private Color inactiveBackgroundSelectionColor = javax.swing.UIManager.getColor("oracle.ide.explorer.TreeExplorer.inactiveSelectionBackground");
        private Color inactiveTextSelectionColor = javax.swing.UIManager.getColor("oracle.ide.explorer.TreeExplorer.inactiveSelectionForeground");
        private boolean treeHasFocus;

        UITreeCellRenderer() {
            if (this.inactiveBackgroundSelectionColor == null) {
                this.inactiveBackgroundSelectionColor = this.backgroundSelectionColor;
            }
            if (this.inactiveTextSelectionColor == null) {
                this.inactiveTextSelectionColor = this.textSelectionColor;
            }
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Element element = (Element)value;
            if (element != null) {
                Icon icon = element.getIcon();
                if (icon != null) {
                    this.setIcon(icon);
                }
                this.setText(element.getShortLabel());
                this.setToolTipText(element.getToolTipText());
            }
            this.treeHasFocus = tree.hasFocus();
            return this;
        }

        public Color getBackgroundSelectionColor() {
            if (this.treeHasFocus) {
                return super.getBackgroundSelectionColor();
            }
            return this.inactiveBackgroundSelectionColor;
        }

        public Color getTextSelectionColor() {
            if (this.treeHasFocus) {
                return super.getTextSelectionColor();
            }
            return this.inactiveTextSelectionColor;
        }
    }
}

