/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor;

import java.util.List;
import oracle.ide.model.Element;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PaletteManager;
import oracle.ide.palette.PaletteWindow;
import oracle.ideimpl.palette2.PaletteControllerUI;
import oracle.jdevimpl.uieditor.CursorManager;

public final class UIUtils {
    public static final int RUN_MODE = 1;
    public static final int SELECT_MODE = 2;
    public static final int ADD_MODE = 3;
    public static final String LOOK_AND_FEEL_SECTION = "LookAndFeel";
    private static PaletteWindow PALETTE;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static synchronized PaletteWindow getPaletteWindow() {
        PaletteManager paletteManager;
        if (PALETTE == null && (paletteManager = PaletteManager.getPaletteManager()) != null) {
            PALETTE = paletteManager.getPaletteWindow();
        }
        return PALETTE;
    }

    public static int getMode() {
        if (CursorManager.getInstance().isPalette1()) {
            Element tool = UIUtils.getPaletteWindow().getContext().getElement();
            PaletteItem item = tool != null && tool instanceof PaletteItem ? (PaletteItem)tool : null;
            return item != null && !item.isPointer() ? 3 : 2;
        }
        oracle.ide.palette2.PaletteItem item2 = CursorManager.getInstance().getPalette2Item();
        return item2 != null ? 3 : 2;
    }

    public static String getToolPath() {
        if (CursorManager.getInstance().isPalette1()) {
            Element tool = UIUtils.getPaletteWindow().getContext().getElement();
            PaletteItem item = tool != null && tool instanceof PaletteItem ? (PaletteItem)tool : null;
            return item != null ? item.getClassPath() : null;
        }
        oracle.ide.palette2.PaletteItem item2 = CursorManager.getInstance().getPalette2Item();
        return item2 != null ? (String)item2.getData((Object)"classPath") : null;
    }

    public static String getToolName() {
        if (CursorManager.getInstance().isPalette1()) {
            Element tool = UIUtils.getPaletteWindow().getContext().getElement();
            PaletteItem item = tool != null && tool instanceof PaletteItem ? (PaletteItem)tool : null;
            return item != null ? item.getClassName() : null;
        }
        oracle.ide.palette2.PaletteItem item2 = CursorManager.getInstance().getPalette2Item();
        return item2 != null ? (String)item2.getData((Object)"className") : null;
    }

    static {
        $assertionsDisabled = UIUtils.class.desiredAssertionStatus() ^ true;
    }

    public static String getToolInitializer() {
        if (CursorManager.getInstance().isPalette1()) {
            Element tool = UIUtils.getPaletteWindow().getContext().getElement();
            PaletteItem item = tool != null && tool instanceof PaletteItem ? (PaletteItem)tool : null;
            return item != null ? item.getInitializer() : null;
        }
        String initializer = null;
        oracle.ide.palette2.PaletteItem item2 = CursorManager.getInstance().getPalette2Item();
        if (item2 == null) {
            item2 = PaletteControllerUI.getInstance().getSelectedItem();
        }
        if (!$assertionsDisabled && item2 == null) {
            throw new AssertionError();
        }
        String preInitializer = (String)item2.getData((Object)"info");
        try {
            if (preInitializer == null) {
                initializer = null;
            } else {
                int semiPos = preInitializer.indexOf(";");
                int lastBracket = preInitializer.indexOf("]");
                if (semiPos >= 0) {
                    initializer = preInitializer.substring(semiPos + 1, lastBracket);
                }
            }
        }
        catch (Exception ex) {
            initializer = null;
        }
        return initializer;
    }

    public static String getLibraryName() {
        if (CursorManager.getInstance().isPalette1()) {
            Element tool = UIUtils.getPaletteWindow().getContext().getElement();
            PaletteItem item = tool != null && tool instanceof PaletteItem ? (PaletteItem)tool : null;
            return item != null ? item.getLibrary() : null;
        }
        oracle.ide.palette2.PaletteItem item2 = CursorManager.getInstance().getPalette2Item();
        return item2 != null ? (String)item2.getData((Object)"library") : null;
    }

    public static String getTechnologyScope() {
        if (CursorManager.getInstance().isPalette1()) {
            Element tool = UIUtils.getPaletteWindow().getContext().getElement();
            PaletteItem item = tool != null && tool instanceof PaletteItem ? (PaletteItem)tool : null;
            return item != null ? item.getTechnologyScope() : null;
        }
        oracle.ide.palette2.PaletteItem item2 = CursorManager.getInstance().getPalette2Item();
        String techScopes = null;
        List tscopes = (List)item2.getData((Object)"technologyScopes");
        if (tscopes != null) {
            for (String scope : tscopes) {
                if (techScopes != null) {
                    techScopes = techScopes + ";";
                }
                techScopes = techScopes + scope;
            }
        }
        return techScopes;
    }

    public static void toolUsed() {
        if (CursorManager.getInstance().isPalette1()) {
            UIUtils.getPaletteWindow().reset();
        } else {
            oracle.ide.palette2.PaletteManager paletteManager = oracle.ide.palette2.PaletteManager.getPaletteManager();
            if (paletteManager != null) {
                oracle.ide.palette2.PaletteWindow pW = paletteManager.getPaletteWindow();
                pW.unSelectSelectedItem();
            }
        }
    }
}

