/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.assistant;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.explorer.Explorer;
import oracle.ide.util.Assert;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.cmt.CmtComponentSource;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.uieditor.ModelFactory;
import oracle.jdeveloper.uieditor.UIEditor;
import oracle.jdeveloper.uieditor.UIManager;
import oracle.jdeveloper.uieditor.uicanvas.ConstraintsPropertyState;
import oracle.jdeveloper.uieditor.uicanvas.LayoutConstants;
import oracle.jdeveloper.uieditor.uicanvas.SelectNib;
import oracle.jdeveloper.uieditor.uicanvas.SelectionEffects;
import oracle.jdeveloper.uieditor.uicanvas.UICanvas;
import oracle.jdeveloper.uieditor.uicanvas.UIModel;
import oracle.jdevimpl.uieditor.assistant.BasicLayoutAssistant;
import oracle.jdevimpl.uieditor.assistant.BorderConstraintsEditor;
import oracle.jdevimpl.uieditor.assistant.BorderExplorer;
import oracle.jdevimpl.uieditor.assistant.Res;

public class BorderLayoutAssistant
extends BasicLayoutAssistant {
    private static Explorer EXPLORER;
    private static final int NORTH = 0;
    private static final int SOUTH = 1;
    private static final int EAST = 2;
    private static final int WEST = 3;
    static final int CENTER = 4;
    static final String[] EDGES;
    static final String[] EDGE_FIELDS;
    public static JMenu ANCHOR_MENU;
    public static JMenuItem ANCHOR_N_ITEM;
    public static JMenuItem ANCHOR_S_ITEM;
    public static JMenuItem ANCHOR_C_ITEM;
    public static JMenuItem ANCHOR_E_ITEM;
    public static JMenuItem ANCHOR_W_ITEM;
    private static IdeAction ANCHOR_ACTION;
    private static IdeAction ANCHOR_N_ACTION;
    private static IdeAction ANCHOR_W_ACTION;
    private static IdeAction ANCHOR_C_ACTION;
    private static IdeAction ANCHOR_E_ACTION;
    private static IdeAction ANCHOR_S_ACTION;

    static {
        EDGES = new String[]{"North", "South", "East", "West", "Center"};
        EDGE_FIELDS = new String[]{"java.awt.BorderLayout.NORTH", "java.awt.BorderLayout.SOUTH", "java.awt.BorderLayout.EAST", "java.awt.BorderLayout.WEST", "java.awt.BorderLayout.CENTER"};
        ModelFactory factory = UIManager.getFactory(UIModel.class);
        try {
            float weight;
            int parentID = factory.registerSubMenu(0, LayoutConstants.ANCHOR, LayoutConstants.ANCHOR_MNEMONIC, JDeveloperMenuConstants.WEIGHT_JAVA_UI_DESIGN_ANCHOR, JDeveloperMenuConstants.SECTION_DESIGN_LAYOUT);
            float f = weight = 0.0f;
            weight = f + 1.0f;
            ANCHOR_ACTION = factory.registerAction(LayoutConstants.ANCHOR_CMD_ID, LayoutConstants.ANCHOR, LayoutConstants.ANCHOR_MNEMONIC, LayoutConstants.ARB, 159, parentID, f, 1.0f);
            ANCHOR_ACTION.putValue("RadioGroupName", (Object)"LayoutConstants.ANCHOR_GROUP");
            ANCHOR_ACTION.putValue("Radio", (Object)Boolean.TRUE);
            ANCHOR_ACTION.putValue("Hidden", (Object)Boolean.TRUE);
            ANCHOR_N_ACTION = factory.registerAction(LayoutConstants.ANCHOR_N_CMD_ID, LayoutConstants.ANCHOR_N, LayoutConstants.ANCHOR_N_MNEMONIC, LayoutConstants.ARB, 132, parentID, weight += 1.0f, 1.0f);
            ANCHOR_N_ACTION.putValue("ShortDescription", (Object)Res.format(8, new String[]{LayoutConstants.ANCHOR, LayoutConstants.ANCHOR_N}));
            ANCHOR_N_ACTION.putValue("RadioGroupName", (Object)"LayoutConstants.ANCHOR_GROUP");
            ANCHOR_N_ACTION.putValue("Radio", (Object)Boolean.TRUE);
            float f2 = weight = 0.0f;
            weight = f2 + 1.0f;
            ANCHOR_W_ACTION = factory.registerAction(LayoutConstants.ANCHOR_W_CMD_ID, LayoutConstants.ANCHOR_W, LayoutConstants.ANCHOR_W_MNEMONIC, LayoutConstants.ARB, 13, parentID, f2, JDeveloperMenuConstants.SECTION_MIDDLE);
            ANCHOR_W_ACTION.putValue("ShortDescription", (Object)Res.format(8, new String[]{LayoutConstants.ANCHOR, LayoutConstants.ANCHOR_W}));
            ANCHOR_W_ACTION.putValue("RadioGroupName", (Object)"LayoutConstants.ANCHOR_GROUP");
            ANCHOR_W_ACTION.putValue("Radio", (Object)Boolean.TRUE);
            float f3 = weight;
            weight = f3 + 1.0f;
            ANCHOR_C_ACTION = factory.registerAction(LayoutConstants.ANCHOR_C_CMD_ID, LayoutConstants.ANCHOR_C, LayoutConstants.ANCHOR_C_MNEMONIC, LayoutConstants.ARB, 158, parentID, f3, JDeveloperMenuConstants.SECTION_MIDDLE);
            ANCHOR_C_ACTION.putValue("ShortDescription", (Object)Res.format(8, new String[]{LayoutConstants.ANCHOR, LayoutConstants.ANCHOR_C}));
            ANCHOR_C_ACTION.putValue("RadioGroupName", (Object)"LayoutConstants.ANCHOR_GROUP");
            ANCHOR_C_ACTION.putValue("Radio", (Object)Boolean.TRUE);
            ANCHOR_E_ACTION = factory.registerAction(LayoutConstants.ANCHOR_E_CMD_ID, LayoutConstants.ANCHOR_E, LayoutConstants.ANCHOR_E_MNEMONIC, LayoutConstants.ARB, 78, parentID, weight, JDeveloperMenuConstants.SECTION_MIDDLE);
            ANCHOR_E_ACTION.putValue("ShortDescription", (Object)Res.format(8, new String[]{LayoutConstants.ANCHOR, LayoutConstants.ANCHOR_E}));
            ANCHOR_E_ACTION.putValue("RadioGroupName", (Object)"LayoutConstants.ANCHOR_GROUP");
            ANCHOR_E_ACTION.putValue("Radio", (Object)Boolean.TRUE);
            weight = 0.0f;
            ANCHOR_S_ACTION = factory.registerAction(LayoutConstants.ANCHOR_S_CMD_ID, LayoutConstants.ANCHOR_S, LayoutConstants.ANCHOR_S_MNEMONIC, LayoutConstants.ARB, 9, parentID, weight += 1.0f, JDeveloperMenuConstants.SECTION_BOTTOM);
            ANCHOR_S_ACTION.putValue("ShortDescription", (Object)Res.format(8, new String[]{LayoutConstants.ANCHOR, LayoutConstants.ANCHOR_S}));
            ANCHOR_S_ACTION.putValue("RadioGroupName", (Object)"LayoutConstants.ANCHOR_GROUP");
            ANCHOR_S_ACTION.putValue("Radio", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    public final String getConstraintsType() {
        return "java.lang.String";
    }

    public final PropertyEditor getPropertyEditor() {
        return new BorderConstraintsEditor();
    }

    public final Explorer getConstraintsEditor(Context context) {
        Explorer explorer = BorderLayoutAssistant.getExplorer();
        explorer.setContext(context);
        return explorer;
    }

    private static final synchronized Explorer getExplorer() {
        if (EXPLORER == null) {
            EXPLORER = new BorderExplorer();
        }
        return EXPLORER;
    }

    public final void prepareChangeLayout(CmtModelNode parent) {
        LayoutManager layout;
        CmtSubcomponent sub = parent != null ? parent.getSubcomponent() : null;
        Container cont = sub != null ? sub.getAsContainer() : null;
        LayoutManager layoutManager = layout = cont != null ? cont.getLayout() : null;
        if (!(layout instanceof BorderLayout)) {
            return;
        }
        Iterator iter = parent.getChildren();
        if (iter == null) {
            return;
        }
        ArrayList<Rectangle> shapes = new ArrayList<Rectangle>();
        int leftEdge = Integer.MAX_VALUE;
        int rightEdge = Integer.MIN_VALUE;
        int topEdge = Integer.MAX_VALUE;
        int bottomEdge = Integer.MIN_VALUE;
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof CmtModelNode) {
                CmtModelNode child = (CmtModelNode)obj;
                sub = child.getSubcomponent();
                Object e = obj = sub != null ? sub.getLiveInstance() : null;
                if (!(obj instanceof Component)) {
                    shapes.add(null);
                    continue;
                }
                Rectangle bounds = ((Component)obj).getBounds();
                shapes.add(bounds);
                if (bounds.x < leftEdge) {
                    leftEdge = bounds.x;
                }
                if (bounds.x + bounds.width - 1 > rightEdge) {
                    rightEdge = bounds.x + bounds.width - 1;
                }
                if (bounds.y < topEdge) {
                    topEdge = bounds.y;
                }
                if (bounds.y + bounds.height - 1 <= bottomEdge) continue;
                bottomEdge = bounds.y + bounds.height - 1;
                continue;
            }
            shapes.add(null);
        }
        Dimension area = new Dimension(rightEdge - leftEdge + 1, bottomEdge - topEdge + 1);
        int count = shapes.size();
        Point point = new Point();
        Dimension size = new Dimension();
        Insets insets = new Insets(0, 0, 0, 0);
        int i = 0;
        while (i < count) {
            try {
                Rectangle bounds = (Rectangle)shapes.get(i);
                if (bounds != null) {
                    CmtModelNode child = (CmtModelNode)parent.getChildAt(i);
                    point.x = bounds.x - leftEdge;
                    point.y = bounds.y - topEdge;
                    size.width = bounds.width;
                    size.height = bounds.height;
                    int edge = BorderLayoutAssistant.findBest(area, insets, point, size);
                    BorderLayoutAssistant.setConstraints(child, edge);
                    BorderLayoutAssistant.removeBoundsSetting(child);
                }
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
            ++i;
        }
    }

    public final void prepareMoveComponent(CmtModelNode node, CmtModelNode toNode, Point location, Point offset) {
        this.prepareAddComponent(node, toNode, location, offset, null);
    }

    public final void prepareAddComponent(CmtModelNode node, CmtModelNode toNode, Point location, Point offset, Dimension size) {
        if (size != null && location != null) {
            location.x += size.width / 2;
            location.y += size.height / 2;
        }
        int i = BorderLayoutAssistant.findBest(toNode, location, null);
        BorderLayoutAssistant.setToEdge(node, toNode, i);
        BorderLayoutAssistant.removeBoundsSetting(node);
    }

    public final String constrainMove(CmtModelNode node, CmtModelNode toNode, Point mousePos, Point mouseOffset, Point newPos, Dimension newSize) {
        Object obj;
        int edge = BorderLayoutAssistant.findBest(toNode, mousePos, null);
        Container cont = toNode.getSubcomponent().getAsContainer();
        Insets insets = cont.getInsets();
        Dimension parentSize = cont.getSize();
        CmtSubcomponent sub = node != null ? node.getSubcomponent() : null;
        Object object = obj = sub != null ? sub.getLiveInstance() : null;
        if (obj instanceof Component) {
            Dimension childSize = ((Component)obj).getPreferredSize();
            parentSize.width -= insets.left + insets.right;
            parentSize.height -= insets.top + insets.bottom;
            newPos.x = insets.left;
            newPos.y = insets.top;
            newSize.width = childSize.width;
            newSize.height = childSize.height;
            switch (edge) {
                case 3: {
                    newSize.height = parentSize.height;
                    break;
                }
                case 0: {
                    newSize.width = parentSize.width;
                    break;
                }
                case 1: {
                    newSize.width = parentSize.width;
                    newPos.y += parentSize.height - newSize.height;
                    break;
                }
                case 2: {
                    newSize.height = parentSize.height;
                    newPos.x += parentSize.width - newSize.width;
                    break;
                }
                case 4: {
                    newSize.width = parentSize.width / 2;
                    newSize.height = parentSize.height * 3 / 5;
                    newPos.x += parentSize.width / 4;
                    newPos.y += parentSize.height / 5;
                    break;
                }
            }
        }
        return toNode + ": " + BorderLayoutAssistant.getConstraintsString(edge);
    }

    public final String prepareAddStatus(CmtModelNode node, CmtModelNode toNode, Point location, Dimension size) {
        int edge = BorderLayoutAssistant.findBest(toNode, location, null);
        return toNode + ": " + BorderLayoutAssistant.getConstraintsString(edge);
    }

    public final String prepareMouseMoveStatus(CmtModelNode node, CmtModelNode toNode, Point location) {
        return node == null ? toNode.toString() : node + ": " + BorderLayoutAssistant.getConstraintsString(BorderLayoutAssistant.getConstraints(node));
    }

    public final String prepareResizeStatus(CmtModelNode node, Point location, Dimension size) {
        return Res.getString(34);
    }

    public final void prepareResizeComponent(CmtModelNode node, SelectionEffects effects, SelectNib nib) {
    }

    public synchronized JComponent[] getContextMenuItems(Context context) {
        if (ANCHOR_MENU == null) {
            Menubar mgr = Ide.getMenubar();
            ANCHOR_MENU = mgr.createSubMenu(LayoutConstants.ANCHOR, LayoutConstants.ANCHOR_MNEMONIC, JDeveloperMenuConstants.WEIGHT_JAVA_UI_DESIGN_ANCHOR);
            ANCHOR_MENU.putClientProperty("menu-section-id", new Float(JDeveloperMenuConstants.SECTION_DESIGN_LAYOUT));
            ANCHOR_N_ITEM = mgr.createMenuItem((ToggleAction)ANCHOR_N_ACTION);
            ANCHOR_S_ITEM = mgr.createMenuItem((ToggleAction)ANCHOR_S_ACTION);
            ANCHOR_C_ITEM = mgr.createMenuItem((ToggleAction)ANCHOR_C_ACTION);
            ANCHOR_E_ITEM = mgr.createMenuItem((ToggleAction)ANCHOR_E_ACTION);
            ANCHOR_W_ITEM = mgr.createMenuItem((ToggleAction)ANCHOR_W_ACTION);
            float menuSection = 1.0f;
            mgr.add((Component)ANCHOR_N_ITEM, ANCHOR_MENU, menuSection);
            mgr.add((Component)ANCHOR_S_ITEM, ANCHOR_MENU, menuSection);
            mgr.add((Component)ANCHOR_C_ITEM, ANCHOR_MENU, menuSection += 1.0f);
            mgr.add((Component)ANCHOR_E_ITEM, ANCHOR_MENU, menuSection += 1.0f);
            mgr.add((Component)ANCHOR_W_ITEM, ANCHOR_MENU, menuSection);
        }
        JComponent[] superResults = super.getContextMenuItems(context);
        int index = superResults.length;
        JComponent[] results = new JComponent[index + 1];
        if (index > 0) {
            System.arraycopy(superResults, 0, results, 0, index);
        }
        results[index++] = ANCHOR_MENU;
        return results;
    }

    public boolean update(IdeAction action, Context context) {
        int id;
        int n = id = action != null ? action.getCommandId() : -1;
        if (id == LayoutConstants.ANCHOR_CMD_ID || id == LayoutConstants.ANCHOR_N_CMD_ID || id == LayoutConstants.ANCHOR_S_CMD_ID || id == LayoutConstants.ANCHOR_C_CMD_ID || id == LayoutConstants.ANCHOR_E_CMD_ID || id == LayoutConstants.ANCHOR_W_CMD_ID) {
            ArrayList siblings = BorderLayoutAssistant.getSelectedSiblings(context);
            int count = siblings.size();
            if (count > 0) {
                action.setEnabled(true);
                int anchor = BorderLayoutAssistant.getConstraints((CmtModelNode)siblings.get(0));
                boolean same = true;
                int i = 1;
                while (same && i < count) {
                    same = anchor == BorderLayoutAssistant.getConstraints((CmtModelNode)siblings.get(i));
                    ++i;
                }
                if (same) {
                    switch (anchor) {
                        case 0: {
                            action.setState(id == LayoutConstants.ANCHOR_N_CMD_ID);
                            break;
                        }
                        case 3: {
                            action.setState(id == LayoutConstants.ANCHOR_W_CMD_ID);
                            break;
                        }
                        case 4: {
                            action.setState(id == LayoutConstants.ANCHOR_C_CMD_ID);
                            break;
                        }
                        case 2: {
                            action.setState(id == LayoutConstants.ANCHOR_E_CMD_ID);
                            break;
                        }
                        case 1: {
                            action.setState(id == LayoutConstants.ANCHOR_S_CMD_ID);
                            break;
                        }
                        default: {
                            action.setState(id == LayoutConstants.ANCHOR_CMD_ID);
                            break;
                        }
                    }
                } else {
                    action.setState(id == LayoutConstants.ANCHOR_CMD_ID);
                }
            } else {
                action.setEnabled(false);
                action.setState(id == LayoutConstants.ANCHOR_CMD_ID);
            }
            return true;
        }
        return super.update(action, context);
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmd;
        int n = cmd = action != null ? action.getCommandId() : -1;
        if (cmd == LayoutConstants.ANCHOR_CMD_ID) {
            return true;
        }
        if (cmd == LayoutConstants.ANCHOR_N_CMD_ID || cmd == LayoutConstants.ANCHOR_W_CMD_ID || cmd == LayoutConstants.ANCHOR_C_CMD_ID || cmd == LayoutConstants.ANCHOR_E_CMD_ID || cmd == LayoutConstants.ANCHOR_S_CMD_ID) {
            CmtComponentSource src = null;
            try {
                UIEditor view = (UIEditor)context.getView();
                UICanvas canvas = (UICanvas)view.getActiveCanvas();
                ArrayList siblings = BorderLayoutAssistant.getSelectedSiblings(context);
                CmtModelNode anchor = (CmtModelNode)siblings.get(0);
                int length = siblings.size();
                CmtModelNode parent = (CmtModelNode)anchor.getParent();
                Container container = parent.getSubcomponent().getAsContainer();
                BorderLayout layout = (BorderLayout)container.getLayout();
                String undo = (String)action.getValue("Name");
                src = (CmtComponentSource)anchor.getCmtModel().getComponent();
                src.beginTrans();
                int i = 0;
                while (i < length) {
                    BorderLayoutAssistant.changeAnchor(cmd, (CmtModelNode)siblings.get(i), layout);
                    ++i;
                }
                src.commit(undo);
            }
            catch (Exception e) {
                if (src != null) {
                    src.abort();
                }
                Assert.printStackTrace((Throwable)e);
            }
            return true;
        }
        return super.handleEvent(action, context);
    }

    public final String getToolbarPrefix() {
        return "BorderLayoutAssistant.Toolbar";
    }

    private static boolean changeAnchor(int cmd, CmtModelNode node, BorderLayout layout) {
        int anchor = BorderLayoutAssistant.getConstraints(node);
        boolean updated = false;
        if (cmd == LayoutConstants.ANCHOR_N_CMD_ID) {
            if (anchor != 0) {
                anchor = 0;
                updated = true;
            }
        } else if (cmd == LayoutConstants.ANCHOR_W_CMD_ID) {
            if (anchor != 3) {
                anchor = 3;
                updated = true;
            }
        } else if (cmd == LayoutConstants.ANCHOR_C_CMD_ID) {
            if (anchor != 4) {
                anchor = 4;
                updated = true;
            }
        } else if (cmd == LayoutConstants.ANCHOR_E_CMD_ID) {
            if (anchor != 2) {
                anchor = 2;
                updated = true;
            }
        } else if (cmd == LayoutConstants.ANCHOR_S_CMD_ID && anchor != 1) {
            anchor = 1;
            updated = true;
        }
        if (updated) {
            CmtSubcomponent sub = node != null ? node.getSubcomponent() : null;
            ConstraintsPropertyState state = (ConstraintsPropertyState)(sub != null ? sub.getPropertyState("<Bconstraints>") : null);
            state.setValue(BorderLayoutAssistant.getConstraintsString(anchor), false);
        }
        return updated;
    }

    private static final int getConstraints(CmtModelNode node) {
        CmtSubcomponent sub = node != null ? node.getSubcomponent() : null;
        CmtPropertyState state = sub != null ? sub.getPropertyState("<Bconstraints>") : null;
        return BorderLayoutAssistant.getConstraintsInt(state != null ? (String)state.getValue() : null);
    }

    private static final void setConstraints(CmtModelNode node, int edge) {
        CmtPropertyState state;
        CmtSubcomponent sub = node != null ? node.getSubcomponent() : null;
        CmtPropertyState cmtPropertyState = state = sub != null ? sub.getPropertyState("<Bconstraints>") : null;
        if (state != null) {
            state.setValueSource(BorderLayoutAssistant.getConstraintsSource(edge));
        }
    }

    static final String getConstraintsString(int edge) {
        if (edge >= 0 && edge <= 4) {
            return EDGES[edge];
        }
        return null;
    }

    static final String getConstraintsSource(int edge) {
        if (edge >= 0 && edge <= 4) {
            return EDGE_FIELDS[edge];
        }
        return "";
    }

    static final int getConstraintsInt(String edge) {
        if (edge != null) {
            if ("North".equals(edge)) {
                return 0;
            }
            if ("South".equals(edge)) {
                return 1;
            }
            if ("East".equals(edge)) {
                return 2;
            }
            if ("West".equals(edge)) {
                return 3;
            }
            if ("Center".equals(edge)) {
                return 4;
            }
        }
        return -1;
    }

    private static final int findBest(CmtModelNode toNode, Point location, Dimension size) {
        Container container = toNode.getSubcomponent().getAsContainer();
        Dimension area = container.getSize();
        Insets insets = container.getInsets();
        return BorderLayoutAssistant.findBest(area, insets, location, size);
    }

    private static final int findBest(Dimension area, Insets insets, Point location, Dimension size) {
        int cy;
        area.width -= insets.left + insets.right;
        area.height -= insets.top + insets.bottom;
        int x1 = area.width / 4 + insets.left;
        int x2 = area.width * 3 / 4 + insets.left;
        int y1 = area.height / 5 + insets.top;
        int y2 = area.height * 4 / 5 + insets.top;
        int cx = location != null ? location.x : x1;
        int n = cy = location != null ? location.y : y1;
        if (location != null && size != null) {
            cx += size.width / 2;
            cy += size.height / 2;
        }
        if (cy < y1) {
            return 0;
        }
        if (cy > y2) {
            return 1;
        }
        if (cx < x1) {
            return 3;
        }
        if (cx > x2) {
            return 2;
        }
        return 4;
    }

    private static void setToEdge(CmtModelNode node, CmtModelNode toNode, int edge) {
        int[] edges = new int[]{4, 0, 1, 3, 2};
        CmtModelNode[] used = new CmtModelNode[5];
        Iterator i = toNode.getChildren();
        while (i.hasNext()) {
            int c;
            Object obj;
            CmtModelNode sibling = (CmtModelNode)i.next();
            CmtSubcomponent sub = sibling.getSubcomponent();
            Object object = obj = sub != null ? sub.getLiveInstance() : null;
            if (!(obj instanceof Component) || (c = BorderLayoutAssistant.getConstraints(sibling)) < 0 || c >= edges.length || sibling == node) continue;
            used[c] = sibling;
        }
        CmtModelNode user = used[edge];
        if (user != null) {
            used[edge] = node;
            int e = 0;
            while (e < edges.length && used[edges[e]] != null) {
                ++e;
            }
            if (e < edges.length) {
                BorderLayoutAssistant.setConstraints(user, edges[e]);
            }
        }
        BorderLayoutAssistant.setConstraints(node, edge);
    }
}

