/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.assistant;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.explorer.Explorer;
import oracle.ide.util.Assert;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.uieditor.uicanvas.SelectNib;
import oracle.jdeveloper.uieditor.uicanvas.SelectionEffects;
import oracle.jdevimpl.propertyeditor.StringEditor;
import oracle.jdevimpl.uieditor.assistant.BasicLayoutAssistant;
import oracle.jdevimpl.uieditor.assistant.CardExplorer;
import oracle.jdevimpl.uieditor.assistant.Res;

public final class CardLayoutAssistant
extends BasicLayoutAssistant {
    private static Explorer EXPLORER;

    public String getConstraintsType() {
        return "java.lang.String";
    }

    public PropertyEditor getPropertyEditor() {
        return new StringEditor();
    }

    public Explorer getConstraintsEditor(Context context) {
        Explorer explorer = CardLayoutAssistant.getExplorer();
        explorer.setContext(context);
        return explorer;
    }

    private static synchronized Explorer getExplorer() {
        if (EXPLORER == null) {
            EXPLORER = new CardExplorer();
        }
        return EXPLORER;
    }

    private String getConstraints(CmtModelNode child) {
        CmtSubcomponent sub = child != null ? child.getSubcomponent() : null;
        CmtPropertyState state = sub != null ? sub.getPropertyState("<Bconstraints>") : null;
        return state != null ? (String)state.getValue() : null;
    }

    private void setConstraints(CmtModelNode child, String name) {
        try {
            CmtSubcomponent sub = child != null ? child.getSubcomponent() : null;
            CmtPropertyState state = sub != null ? sub.getPropertyState("<Bconstraints>") : null;
            state.setValue(name);
        }
        catch (Exception ex) {
            Assert.printStackTrace((Throwable)ex);
        }
    }

    public void prepareAddComponent(CmtModelNode node, CmtModelNode toNode, Point location, Point offset, Dimension size) {
        Container comp = toNode.getSubcomponent().getAsContainer();
        this.setConstraints(node, node.getName());
        this.changeZ(node, toNode, comp.getComponents().length);
        CardLayoutAssistant.removeBoundsSetting(node);
    }

    public String constrainMove(CmtModelNode node, CmtModelNode toNode, Point mousePos, Point mouseOffset, Point newPos, Dimension newSize) {
        Container cont = toNode.getSubcomponent().getAsContainer();
        Dimension parentSize = cont.getSize();
        Insets insets = cont.getInsets();
        newPos.x = insets.left;
        newPos.y = insets.top;
        newSize.width = parentSize.width - insets.left - insets.right;
        newSize.height = parentSize.height - insets.top - insets.bottom;
        return toNode + " z: " + this.calcBestZ(node, toNode, newPos, newSize, null);
    }

    public String prepareMouseMoveStatus(CmtModelNode node, CmtModelNode toNode, Point location) {
        return node == null ? toNode.toString() : node + ": " + this.getConstraints(node);
    }

    public void prepareResizeComponent(CmtModelNode node, SelectionEffects effects, SelectNib nib) {
    }

    public String prepareResizeStatus(CmtModelNode node, Point location, Dimension size) {
        return Res.getString(10);
    }

    public void cleanupRemovedComponent(CmtModelNode parent) {
        Iterator i = parent.getChildren();
        while (i.hasNext()) {
            String constraint;
            Object obj;
            CmtModelNode child = (CmtModelNode)i.next();
            CmtSubcomponent sub = child.getSubcomponent();
            Object object = obj = sub != null ? sub.getLiveInstance() : null;
            if (!(obj instanceof Component) || (constraint = this.getConstraints(child)) == null) continue;
            Container container = parent.getSubcomponent().getAsContainer();
            LayoutManager layout = container.getLayout();
            ((CardLayout)layout).show(container, constraint);
            break;
        }
    }

    public void raiseChildToView(CmtModelNode parent, CmtModelNode node) {
        String constraint = this.getConstraints(node);
        if (parent != null && constraint != null) {
            Container cont = parent.getSubcomponent().getAsContainer();
            LayoutManager layout = cont.getLayout();
            ((CardLayout)layout).show(cont, constraint);
        }
    }

    public void layoutChanged(CmtModelNode parent) {
        try {
            ArrayList children = this.sortedNodes(parent);
            int i = 0;
            while (i < children.size()) {
                Object obj;
                CmtModelNode sibling = (CmtModelNode)children.get(i);
                CmtSubcomponent sub = sibling.getSubcomponent();
                Object object = obj = sub != null ? sub.getLiveInstance() : null;
                if (obj instanceof Component) {
                    ((Component)obj).setVisible(true);
                }
                ++i;
            }
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }
}

