/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.assistant;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import oracle.ide.util.Assert;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdevimpl.uieditor.assistant.BasicLayoutAssistant;
import oracle.jdevimpl.uieditor.assistant.Res;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowLayoutAssistant
extends BasicLayoutAssistant
implements Comparator {
    @Override
    public final void prepareChangeLayout(CmtModelNode parent) {
        Insets insets = parent.getSubcomponent().getAsContainer().getInsets();
        List children = this.sortNodes(parent);
        int i = 0;
        while (i < children.size()) {
            Pair pair = (Pair)children.get(i);
            CmtModelNode sibling = pair.first;
            Rectangle rClient = pair.second;
            rClient.x -= insets.left;
            rClient.y -= insets.top;
            try {
                this.changeZ(sibling, parent, i);
                FlowLayoutAssistant.removeBoundsSetting(sibling);
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
            ++i;
        }
    }

    private final List sortNodes(CmtModelNode parent) {
        ArrayList<Pair> list = new ArrayList<Pair>();
        Iterator i = parent.getChildren();
        while (i.hasNext()) {
            Object obj;
            CmtModelNode node = (CmtModelNode)i.next();
            CmtSubcomponent sub = node != null ? node.getSubcomponent() : null;
            Object object = obj = sub != null ? sub.getLiveInstance() : null;
            if (!(obj instanceof Component)) continue;
            Rectangle rect = ((Component)obj).getBounds();
            Pair pair = new Pair(node, rect);
            list.add(pair);
        }
        Collections.sort(list, this);
        FlowLayoutAssistant.orderHorizontally(list);
        return list;
    }

    @Override
    public String constrainMove(CmtModelNode node, CmtModelNode toNode, Point mousePos, Point mouseOffset, Point newPos, Dimension newSize) {
        Container cont = toNode.getSubcomponent().getAsContainer();
        Dimension parentSize = cont.getSize();
        Rectangle zBounds = new Rectangle(-1, -1, 1, 1);
        CmtSubcomponent sub = node.getSubcomponent();
        Component obj = (Component)sub.getLiveInstance();
        Dimension childSize = obj.getPreferredSize();
        int z = this.calcBestZ(node, toNode, mousePos, childSize, zBounds);
        if (zBounds.x == -1) {
            FlowLayout layout = (FlowLayout)cont.getLayout();
            Insets insets = cont.getInsets();
            int alignment = layout.getAlignment();
            int x = insets.left + layout.getHgap();
            int y = insets.top + layout.getVgap();
            switch (alignment) {
                case 1: {
                    x = insets.left + (parentSize.width - childSize.width - insets.right - insets.left) / 2;
                    break;
                }
                case 2: {
                    x = parentSize.width - insets.right - childSize.width;
                    break;
                }
            }
            zBounds.x = x;
            zBounds.y = y;
        }
        newPos.x = zBounds.x;
        newPos.y = zBounds.y;
        newSize.width = childSize.width;
        newSize.height = childSize.height;
        return toNode + " z: " + z;
    }

    @Override
    public String prepareResizeStatus(CmtModelNode node, Point location, Dimension size) {
        return Res.getString(47);
    }

    public final int compare(Object obj1, Object obj2) {
        if (obj1 instanceof Pair) {
            if (obj2 instanceof Pair) {
                Pair p1 = (Pair)obj1;
                Pair p2 = (Pair)obj2;
                return Math.abs(p1.second.y) - Math.abs(p2.second.y);
            }
            return 1;
        }
        return obj2 instanceof Pair ? -1 : 0;
    }

    private static final void orderHorizontally(List list) {
        int rowStartingSub = 0;
        int i = 1;
        while (i < list.size()) {
            Pair pair = (Pair)list.get(i);
            Rectangle toSortR = pair.second;
            int j = rowStartingSub;
            while (j < i) {
                Rectangle sortedR = ((Pair)list.get((int)j)).second;
                if (sortedR.x < toSortR.x && toSortR.x < sortedR.x + sortedR.width || sortedR.x < toSortR.x + toSortR.width && toSortR.x + toSortR.width < sortedR.x + sortedR.width) {
                    rowStartingSub = i;
                    break;
                }
                if (toSortR.x < sortedR.x) {
                    list.remove(i);
                    list.add(j, pair);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    private static final class Pair {
        public CmtModelNode first;
        public Rectangle second;

        public Pair(CmtModelNode first, Rectangle second) {
            this.first = first;
            this.second = second;
        }
    }
}

