/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.assistant;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.StringTokenizer;
import oracle.jdevimpl.uieditor.assistant.GridBagConstraintsCustomEditor;

public final class GridBagConstraintsEditor
implements PropertyEditor {
    private PropertyChangeListener listener;
    private GridBagConstraints value;
    private GridBagConstraintsCustomEditor editor;

    public void setValue(Object o) {
        boolean fire = true;
        if (o == this.value) {
            fire = false;
        } else {
            this.value = o == null ? new GridBagConstraints() : (GridBagConstraints)o;
        }
        if (this.editor != null) {
            this.editor.update(this.value);
        }
        if (fire) {
            this.fire();
        }
    }

    public Object getValue() {
        if (this.editor != null && this.editor.isDirty()) {
            this.value = this.editor.getValue();
        }
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }

    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        return "[" + this.value.gridx + ", " + this.value.gridy + ", " + this.value.gridwidth + ", " + this.value.gridheight + ", " + this.value.weightx + ", " + this.value.weighty + ", " + this.value.anchor + ", " + this.value.fill + ", [" + this.value.insets.top + ", " + this.value.insets.left + ", " + this.value.insets.bottom + ", " + this.value.insets.right + "], " + this.value.ipadx + ", " + this.value.ipady + "]";
    }

    public String getJavaInitializationString() {
        String anchor;
        String fill;
        if (this.value == null) {
            return null;
        }
        String gridx = "java.awt.GridBagConstraints.RELATIVE";
        if (this.value.gridx != -1) {
            gridx = String.valueOf(this.value.gridx);
        }
        String gridy = "java.awt.GridBagConstraints.RELATIVE";
        if (this.value.gridy != -1) {
            gridy = String.valueOf(this.value.gridy);
        }
        String gridwidth = "java.awt.GridBagConstraints.REMAINDER";
        if (this.value.gridwidth == -1) {
            gridwidth = "java.awt.GridBagConstraints.RELATIVE";
        } else if (this.value.gridwidth != 0) {
            gridwidth = String.valueOf(this.value.gridwidth);
        }
        String gridheight = "java.awt.GridBagConstraints.REMAINDER";
        if (this.value.gridheight == -1) {
            gridheight = "java.awt.GridBagConstraints.RELATIVE";
        } else if (this.value.gridheight != 0) {
            gridheight = String.valueOf(this.value.gridheight);
        }
        switch (this.value.fill) {
            case 1: {
                fill = "java.awt.GridBagConstraints.BOTH";
                break;
            }
            case 2: {
                fill = "java.awt.GridBagConstraints.HORIZONTAL";
                break;
            }
            case 3: {
                fill = "java.awt.GridBagConstraints.VERTICAL";
                break;
            }
            default: {
                fill = "java.awt.GridBagConstraints.NONE";
                break;
            }
        }
        switch (this.value.anchor) {
            case 13: {
                anchor = "java.awt.GridBagConstraints.EAST";
                break;
            }
            case 11: {
                anchor = "java.awt.GridBagConstraints.NORTH";
                break;
            }
            case 12: {
                anchor = "java.awt.GridBagConstraints.NORTHEAST";
                break;
            }
            case 18: {
                anchor = "java.awt.GridBagConstraints.NORTHWEST";
                break;
            }
            case 15: {
                anchor = "java.awt.GridBagConstraints.SOUTH";
                break;
            }
            case 14: {
                anchor = "java.awt.GridBagConstraints.SOUTHEAST";
                break;
            }
            case 16: {
                anchor = "java.awt.GridBagConstraints.SOUTHWEST";
                break;
            }
            case 17: {
                anchor = "java.awt.GridBagConstraints.WEST";
                break;
            }
            default: {
                anchor = "java.awt.GridBagConstraints.CENTER";
                break;
            }
        }
        return "new java.awt.GridBagConstraints(" + gridx + ", " + gridy + ", " + gridwidth + ", " + gridheight + ", " + this.value.weightx + ", " + this.value.weighty + ",\n            " + anchor + ", " + fill + ", new java.awt.Insets(" + this.value.insets.top + ", " + this.value.insets.left + ", " + this.value.insets.bottom + ", " + this.value.insets.right + "), " + this.value.ipadx + ", " + this.value.ipady + ")";
    }

    public void setAsText(String text) throws IllegalArgumentException {
        StringTokenizer tokenizer = new StringTokenizer(text, ",");
        String[] argv = new String[tokenizer.countTokens()];
        int argc = 0;
        while (tokenizer.hasMoreTokens()) {
            argv[argc++] = tokenizer.nextToken().trim();
        }
        if (argc != 14) {
            throw new IllegalArgumentException();
        }
        try {
            String arg8 = argv[8].substring(argv[8].indexOf("(") + 1);
            String arg11 = argv[11].substring(0, argv[11].indexOf(")"));
            Insets insets = new Insets(Integer.parseInt(arg8), Integer.parseInt(argv[9]), Integer.parseInt(argv[10]), Integer.parseInt(arg11));
            this.value = new GridBagConstraints(Integer.parseInt(argv[0]), Integer.parseInt(argv[1]), Integer.parseInt(argv[2]), Integer.parseInt(argv[3]), Double.valueOf(argv[4]), Double.valueOf(argv[5]), Integer.parseInt(argv[6]), Integer.parseInt(argv[7]), insets, Integer.parseInt(argv[12]), Integer.parseInt(argv[13]));
        }
        catch (NumberFormatException x) {
            throw new IllegalArgumentException(text);
        }
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        if (this.editor == null) {
            this.editor = new GridBagConstraintsCustomEditor(this.value);
        } else {
            this.editor.update(this.value);
        }
        return this.editor;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    private void fire() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "GridBagConstraintsEditor???", null, this.getValue()));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listener = l;
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listener = null;
    }
}

