/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.assistant;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.cmt.CmtComponentSource;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.cmt.CmtPropertySource;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.uieditor.ModelFactory;
import oracle.jdeveloper.uieditor.UIEditor;
import oracle.jdeveloper.uieditor.UIEditorCanvas;
import oracle.jdeveloper.uieditor.UIEditorOptions;
import oracle.jdeveloper.uieditor.UIManager;
import oracle.jdeveloper.uieditor.uicanvas.LayoutConstants;
import oracle.jdeveloper.uieditor.uicanvas.SelectNib;
import oracle.jdeveloper.uieditor.uicanvas.SelectionEffects;
import oracle.jdeveloper.uieditor.uicanvas.UICanvas;
import oracle.jdeveloper.uieditor.uicanvas.UIModel;
import oracle.jdevimpl.uieditor.UIEditorController;
import oracle.jdevimpl.uieditor.assistant.BasicLayoutAssistant;
import oracle.jdevimpl.uieditor.assistant.Res;

public class NullLayoutAssistant
extends BasicLayoutAssistant
implements ChangeListener {
    public static JMenu ALIGN_MENU;
    public static JMenuItem ALIGN_LEFT_ITEM;
    public static JMenuItem ALIGN_CENTER_ITEM;
    public static JMenuItem ALIGN_RIGHT_ITEM;
    public static JSeparator ALIGN_VERT_SEPARATOR;
    public static JMenuItem ALIGN_TOP_ITEM;
    public static JMenuItem ALIGN_MIDDLE_ITEM;
    public static JMenuItem ALIGN_BOTTOM_ITEM;
    public static JMenu SIZE_MENU;
    public static JMenuItem SAME_SIZE_HORIZ_ITEM;
    public static JMenuItem SAME_SIZE_VERT_ITEM;
    public static JMenuItem SAME_SIZE_BOTH_ITEM;
    public static JMenu SPACING_MENU;
    public static JMenuItem EVEN_SPACE_HORIZ_ITEM;
    public static JMenuItem EVEN_SPACE_VERT_ITEM;
    protected static IdeAction ALIGN_LEFT_ACTION;
    protected static IdeAction ALIGN_CENTER_ACTION;
    protected static IdeAction ALIGN_RIGHT_ACTION;
    protected static IdeAction ALIGN_TOP_ACTION;
    protected static IdeAction ALIGN_MIDDLE_ACTION;
    protected static IdeAction ALIGN_BOTTOM_ACTION;
    protected static IdeAction EVEN_SPACE_HORIZ_ACTION;
    protected static IdeAction EVEN_SPACE_VERT_ACTION;
    protected static IdeAction SAME_SIZE_HORIZ_ACTION;
    protected static IdeAction SAME_SIZE_VERT_ACTION;
    protected static IdeAction SAME_SIZE_BOTH_ACTION;
    private static final int MINIMUM_SIZE = 5;
    private static final int DOT_SIZE = 1;
    protected boolean snapToGrid;
    protected boolean gridVisible;
    protected int gridSpacing;
    protected boolean useInsets;

    private void $init$() {
        this.useInsets = false;
    }

    static {
        ModelFactory factory = UIManager.getFactory(UIModel.class);
        try {
            float weight;
            int parentID = factory.registerSubMenu(0, LayoutConstants.ALIGN, LayoutConstants.ALIGN_MNEMONIC, JDeveloperMenuConstants.WEIGHT_JAVA_UI_DESIGN_ALIGN, JDeveloperMenuConstants.SECTION_DESIGN_NO_LAYOUT);
            float f = weight = 0.0f;
            weight = f + 1.0f;
            ALIGN_LEFT_ACTION = factory.registerAction(LayoutConstants.ALIGN_LEFT_CMD_ID, LayoutConstants.ALIGN_LEFT, LayoutConstants.ALIGN_LEFT_MNEMONIC, LayoutConstants.ARB, 49, parentID, f, 1.0f);
            ALIGN_LEFT_ACTION.putValue("ShortDescription", (Object)Res.format(8, new String[]{LayoutConstants.ALIGN, LayoutConstants.ALIGN_LEFT}));
            float f2 = weight;
            weight = f2 + 1.0f;
            ALIGN_CENTER_ACTION = factory.registerAction(LayoutConstants.ALIGN_CENTER_CMD_ID, LayoutConstants.ALIGN_CENTER, LayoutConstants.ALIGN_CENTER_MNEMONIC, LayoutConstants.ARB, 112, parentID, f2, 1.0f);
            ALIGN_CENTER_ACTION.putValue("ShortDescription", (Object)Res.format(8, new String[]{LayoutConstants.ALIGN, LayoutConstants.ALIGN_CENTER}));
            ALIGN_RIGHT_ACTION = factory.registerAction(LayoutConstants.ALIGN_RIGHT_CMD_ID, LayoutConstants.ALIGN_RIGHT, LayoutConstants.ALIGN_RIGHT_MNEMONIC, LayoutConstants.ARB, 58, parentID, weight, 1.0f);
            ALIGN_RIGHT_ACTION.putValue("ShortDescription", (Object)Res.format(8, new String[]{LayoutConstants.ALIGN, LayoutConstants.ALIGN_RIGHT}));
            float f3 = weight = 0.0f;
            weight = f3 + 1.0f;
            ALIGN_TOP_ACTION = factory.registerAction(LayoutConstants.ALIGN_TOP_CMD_ID, LayoutConstants.ALIGN_TOP, LayoutConstants.ALIGN_TOP_MNEMONIC, LayoutConstants.ARB, 109, parentID, f3, JDeveloperMenuConstants.SECTION_BOTTOM);
            ALIGN_TOP_ACTION.putValue("ShortDescription", (Object)Res.format(8, new String[]{LayoutConstants.ALIGN, LayoutConstants.ALIGN_TOP}));
            float f4 = weight;
            weight = f4 + 1.0f;
            ALIGN_MIDDLE_ACTION = factory.registerAction(LayoutConstants.ALIGN_MIDDLE_CMD_ID, LayoutConstants.ALIGN_MIDDLE, LayoutConstants.ALIGN_MIDDLE_MNEMONIC, LayoutConstants.ARB, 47, parentID, f4, JDeveloperMenuConstants.SECTION_BOTTOM);
            ALIGN_MIDDLE_ACTION.putValue("ShortDescription", (Object)Res.format(8, new String[]{LayoutConstants.ALIGN, LayoutConstants.ALIGN_MIDDLE}));
            ALIGN_BOTTOM_ACTION = factory.registerAction(LayoutConstants.ALIGN_BOTTOM_CMD_ID, LayoutConstants.ALIGN_BOTTOM, LayoutConstants.ALIGN_BOTTOM_MNEMONIC, LayoutConstants.ARB, 0, parentID, weight, JDeveloperMenuConstants.SECTION_BOTTOM);
            ALIGN_BOTTOM_ACTION.putValue("ShortDescription", (Object)Res.format(8, new String[]{LayoutConstants.ALIGN, LayoutConstants.ALIGN_BOTTOM}));
            parentID = factory.registerSubMenu(0, LayoutConstants.SAME_SIZE, LayoutConstants.SAME_SIZE_MNEMONIC, JDeveloperMenuConstants.WEIGHT_JAVA_UI_DESIGN_SAME_SIZE, JDeveloperMenuConstants.SECTION_DESIGN_NO_LAYOUT);
            float f5 = weight = 0.0f;
            weight = f5 + 1.0f;
            SAME_SIZE_HORIZ_ACTION = factory.registerAction(LayoutConstants.SAME_SIZE_HORIZ_CMD_ID, LayoutConstants.SAME_SIZE_HORIZONTAL, LayoutConstants.SAME_SIZE_HORIZ_MNEMONIC, LayoutConstants.ARB, 101, parentID, f5, Float.MAX_VALUE);
            SAME_SIZE_HORIZ_ACTION.putValue("ShortDescription", (Object)Res.format(8, new String[]{LayoutConstants.SAME_SIZE, LayoutConstants.SAME_SIZE_HORIZONTAL}));
            float f6 = weight;
            weight = f6 + 1.0f;
            SAME_SIZE_VERT_ACTION = factory.registerAction(LayoutConstants.SAME_SIZE_VERT_CMD_ID, LayoutConstants.SAME_SIZE_VERTICAL, LayoutConstants.SAME_SIZE_VERT_MNEMONIC, LayoutConstants.ARB, 69, parentID, f6, Float.MAX_VALUE);
            SAME_SIZE_VERT_ACTION.putValue("ShortDescription", (Object)Res.format(8, new String[]{LayoutConstants.SAME_SIZE, LayoutConstants.SAME_SIZE_VERTICAL}));
            SAME_SIZE_BOTH_ACTION = factory.registerAction(LayoutConstants.SAME_SIZE_BOTH_CMD_ID, LayoutConstants.SAME_SIZE_BOTH, LayoutConstants.SAME_SIZE_BOTH_MNEMONIC, LayoutConstants.ARB, 142, parentID, weight, Float.MAX_VALUE);
            SAME_SIZE_BOTH_ACTION.putValue("ShortDescription", (Object)Res.format(8, new String[]{LayoutConstants.SAME_SIZE, LayoutConstants.SAME_SIZE_BOTH}));
            parentID = factory.registerSubMenu(0, LayoutConstants.EVEN_SPACING, LayoutConstants.EVEN_SPACING_MNEMONIC, JDeveloperMenuConstants.WEIGHT_JAVA_UI_DESIGN_SPACE, JDeveloperMenuConstants.SECTION_DESIGN_NO_LAYOUT);
            float f7 = weight = 0.0f;
            weight = f7 + 1.0f;
            EVEN_SPACE_HORIZ_ACTION = factory.registerAction(LayoutConstants.EVEN_SPACE_HORIZ_CMD_ID, LayoutConstants.EVEN_SPACE_HORIZONTAL, LayoutConstants.EVEN_SPACE_HORIZ_MNEMONIC, LayoutConstants.ARB, 86, parentID, f7, Float.MAX_VALUE);
            EVEN_SPACE_HORIZ_ACTION.putValue("ShortDescription", (Object)Res.format(8, new String[]{LayoutConstants.EVEN_SPACING, LayoutConstants.EVEN_SPACE_HORIZONTAL}));
            EVEN_SPACE_VERT_ACTION = factory.registerAction(LayoutConstants.EVEN_SPACE_VERT_CMD_ID, LayoutConstants.EVEN_SPACE_VERTICAL, LayoutConstants.EVEN_SPACE_VERT_MNEMONIC, LayoutConstants.ARB, 145, parentID, weight, Float.MAX_VALUE);
            EVEN_SPACE_VERT_ACTION.putValue("ShortDescription", (Object)Res.format(8, new String[]{LayoutConstants.EVEN_SPACING, LayoutConstants.EVEN_SPACE_VERTICAL}));
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    public NullLayoutAssistant() {
        this.$init$();
        IdeSettings settings = Ide.getSettings();
        UIEditorOptions options = (UIEditorOptions)((Object)settings.getData("UIEditorOptions"));
        if (options != null) {
            options.addChangeListener(this);
        }
        this.updateSettings();
    }

    protected void updateSettings() {
        try {
            IdeSettings settings = Ide.getSettings();
            UIEditorOptions options = (UIEditorOptions)((Object)settings.getData("UIEditorOptions"));
            this.snapToGrid = options.isSnapToGrid();
            this.gridVisible = options.isGridVisible();
            this.gridSpacing = options.getGridSpacing();
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    public void prepareAddComponent(CmtModelNode node, CmtModelNode toNode, Point location, Point offset, Dimension size) {
        if (location == null) {
            location = new Point(0, 0);
        }
        if (offset == null) {
            offset = new Point(0, 0);
        }
        Point origin = new Point(location.x - offset.x, location.y - offset.y);
        Point mousePos = new Point(origin);
        Point newPos = new Point(origin);
        Dimension newSize = null;
        boolean usePreferredWidth = false;
        boolean usePreferredHeight = false;
        if (size != null) {
            if (Math.abs(size.width) < 5) {
                usePreferredWidth = true;
            }
            if (Math.abs(size.height) < 5) {
                usePreferredHeight = true;
            }
            newSize = new Dimension(size);
            mousePos.x += newSize.width;
            mousePos.y += newSize.height;
        }
        this.constrainAdd(toNode, origin, mousePos, newPos, newSize);
        if (newSize != null) {
            if (newSize.width == 0) {
                usePreferredWidth = true;
            }
            if (newSize.height == 0) {
                usePreferredHeight = true;
            }
        }
        if (usePreferredWidth || usePreferredHeight) {
            Dimension prefs = this.getPreferredSize(node);
            newSize.width = usePreferredWidth ? prefs.width : newSize.width;
            int n = newSize.height = usePreferredHeight ? prefs.height : newSize.height;
        }
        if (this.useInsets) {
            Insets insets;
            Container container = toNode != null ? toNode.getSubcomponent().getAsContainer() : null;
            Insets insets2 = insets = container != null ? container.getInsets() : null;
            if (insets != null) {
                newPos.x -= insets.left;
                newPos.y -= insets.top;
            }
        }
        this.setConstraints(node, toNode, newPos, newSize);
    }

    public final String prepareAddStatus(CmtModelNode node, CmtModelNode toNode, Point location, Dimension size) {
        String s;
        Container p = toNode.getSubcomponent().getAsContainer();
        Insets insets = p.getInsets();
        location.x = location.x - (this.useInsets ? insets.left : 0);
        location.y = location.y - (this.useInsets ? insets.top : 0);
        String string = s = location != null ? toNode + " x: " + location.x + " y: " + location.y : "";
        if (size != null) {
            s = s + " width: " + (size.width > 5 ? Integer.toString(size.width) : "preferred") + " height: " + (size.height > 5 ? Integer.toString(size.height) : "preferred");
        }
        location.x = location.x + (this.useInsets ? insets.left : 0);
        location.y = location.y + (this.useInsets ? insets.top : 0);
        return s;
    }

    public void prepareMoveComponent(CmtModelNode node, CmtModelNode toNode, Point location, Point offset) {
        Point newPos = new Point();
        CmtSubcomponent sub = node.getSubcomponent();
        Component comp = (Component)sub.getLiveInstance();
        this.constrainMove(node, toNode, location, offset, newPos, null);
        if (this.useInsets) {
            Insets insets;
            Container container = toNode != null ? toNode.getSubcomponent().getAsContainer() : null;
            Insets insets2 = insets = container != null ? container.getInsets() : null;
            if (insets != null) {
                newPos.x -= insets.left;
                newPos.y -= insets.top;
            }
        }
        this.setConstraints(node, toNode, newPos, comp.getSize());
    }

    public final String constrainMove(CmtModelNode node, CmtModelNode toNode, Point mousePos, Point mouseOffset, Point newPos, Dimension newSize) {
        CmtSubcomponent sub = node != null ? node.getSubcomponent() : null;
        Component comp = sub != null ? (Component)sub.getLiveInstance() : null;
        Dimension childSize = comp != null ? comp.getSize() : null;
        newPos.x = mousePos.x - mouseOffset.x;
        newPos.y = mousePos.y - mouseOffset.y;
        Point newPosResult = new Point(newPos);
        if (newSize != null && childSize != null) {
            newSize.width = childSize.width;
            newSize.height = childSize.height;
        }
        if (this.snapToGrid) {
            newPos.x += this.gridSpacing / 2;
            newPos.x = newPos.x / this.gridSpacing * this.gridSpacing;
            newPos.y += this.gridSpacing / 2;
            newPos.y = newPos.y / this.gridSpacing * this.gridSpacing;
            newPosResult.x += this.gridSpacing / 2;
            newPosResult.x = newPosResult.x / this.gridSpacing * this.gridSpacing;
            newPosResult.y += this.gridSpacing / 2;
            newPosResult.y = newPosResult.y / this.gridSpacing * this.gridSpacing;
        }
        if (this.useInsets) {
            Insets insets;
            Container container = toNode != null ? toNode.getSubcomponent().getAsContainer() : null;
            Insets insets2 = insets = container != null ? container.getInsets() : null;
            if (insets != null) {
                newPosResult.x -= insets.left;
                newPosResult.y -= insets.top;
            }
        }
        String result = toNode + " x: " + newPosResult.x + " y: " + newPosResult.y;
        if (childSize != null) {
            result = result + " width: " + childSize.width + " height: " + childSize.height;
        }
        return result;
    }

    public final void constrainAdd(CmtModelNode toNode, Point mouseOrigin, Point mousePos, Point newPos, Dimension newSize) {
        Point mouseOffset = new Point(0, 0);
        Point workingPos = new Point(mouseOrigin);
        this.constrainMove(null, toNode, mouseOrigin, mouseOffset, workingPos, null);
        newPos.x = workingPos.x;
        newPos.y = workingPos.y;
        if (newSize != null) {
            newSize.width = mousePos.x - mouseOrigin.x;
            newSize.height = mousePos.y - mouseOrigin.y;
            newSize.width -= workingPos.x - mouseOrigin.x;
            newSize.height -= workingPos.y - mouseOrigin.y;
            workingPos.x = newPos.x + newSize.width;
            workingPos.y = newPos.y + newSize.height;
            Point endPos = new Point(workingPos);
            this.constrainMove(null, toNode, endPos, mouseOffset, workingPos, null);
            newSize.width = Math.abs(workingPos.x - newPos.x);
            newSize.height = Math.abs(workingPos.y - newPos.y);
            if (workingPos.x < newPos.x) {
                newPos.x = workingPos.x;
            }
            if (workingPos.y < newPos.y) {
                newPos.y = workingPos.y;
            }
        }
    }

    public final String resizeAction(Point newPos, SelectionEffects effects, SelectNib nib) {
        Point mouseOffset = new Point(0, 0);
        Point workingPos = new Point(newPos.x - nib.parentLocation.x, newPos.y - nib.parentLocation.y);
        CmtModelNode node = nib.target;
        CmtModelNode toNode = node != null ? (CmtModelNode)node.getParent() : null;
        this.constrainMove(node, toNode, workingPos, mouseOffset, workingPos, null);
        workingPos.x += nib.parentLocation.x;
        workingPos.y += nib.parentLocation.y;
        Point absolutePos = nib.getRectangleLocation();
        Dimension absoluteSize = nib.getRectangleDimension();
        UICanvas canvas = effects.getUICanvas();
        SelectNib.adjustPositionForNib(absolutePos, absoluteSize, workingPos, nib.type);
        canvas.getBoxEffects().show(0, absolutePos, absoluteSize, 2);
        Rectangle bounds = nib.getNibBounds();
        if (this.useInsets) {
            Insets insets;
            Container container = toNode != null ? toNode.getSubcomponent().getAsContainer() : null;
            Insets insets2 = insets = container != null ? container.getInsets() : null;
            if (insets != null) {
                bounds.x -= insets.left;
                bounds.y -= insets.top;
            }
        }
        return this.prepareResizeStatus(nib.target, new Point(bounds.x, bounds.y), new Dimension(bounds.width, bounds.height));
    }

    public final String prepareResizeStatus(CmtModelNode node, Point location, Dimension size) {
        StringBuffer s = new StringBuffer();
        if (location != null) {
            int x = location.x;
            int y = location.y;
            s.append(node);
            s.append(" x: ");
            s.append(x);
            s.append(" y: ");
            s.append(y);
        }
        if (size != null) {
            s.append(" width: ");
            s.append(size.width > 5 ? Integer.toString(size.width) : "preferred");
            s.append(" height: ");
            s.append(size.height > 5 ? Integer.toString(size.height) : "preferred");
        }
        return s.toString();
    }

    public final String prepareMouseMoveStatus(CmtModelNode node, CmtModelNode toNode, Point location) {
        Container p = toNode.getSubcomponent().getAsContainer();
        Point pt = new Point(location != null ? location : new Point(0, 0));
        if (p != null) {
            Insets insets = p.getInsets();
            pt.x = pt.x - (this.useInsets ? insets.left : 0);
            pt.y = pt.y - (this.useInsets ? insets.top : 0);
        }
        String s = (node == null ? toNode : node).toString() + " ";
        return s + "x: " + pt.x + " y: " + pt.y;
    }

    public final void prepareSelectComponent(CmtModelNode node, SelectionEffects effects) {
        Object obj;
        UICanvas canvas = effects.getUICanvas();
        effects.hideAll();
        CmtSubcomponent sub = node != null ? node.getSubcomponent() : null;
        Object object = obj = sub != null ? sub.getLiveInstance() : null;
        if (!(obj instanceof Component)) {
            return;
        }
        Component component = (Component)obj;
        CmtModelNode parent = (CmtModelNode)node.getParent();
        this.prepareSelectDescendant(parent, node, effects);
        Point parentLocation = null;
        parentLocation = parent == null ? new Point(0, 0) : canvas.getAbsoluteLocation(parent.getSubcomponent().getAsContainer());
        Point p = canvas.getAbsoluteLocation(component);
        Dimension s = component.getSize();
        int xs = p.x;
        int ys = p.y;
        int xe = p.x + s.width - 1;
        int ye = p.y + s.height - 1;
        int xm = (xs + xe) / 2;
        int ym = (ys + ye) / 2;
        int startSub = 0;
        if (node.getAllowsChildren()) {
            startSub = -1;
        }
        SelectNib[] selectNibs = effects.getSelectNibs(8 - startSub);
        int n = 0;
        int j = startSub;
        while (j < 8) {
            int y;
            int x;
            switch (j) {
                case 0: {
                    x = xs;
                    y = ys;
                    break;
                }
                case 1: {
                    x = xe;
                    y = ys;
                    break;
                }
                case 2: {
                    x = xs;
                    y = ye;
                    break;
                }
                case 3: {
                    x = xe;
                    y = ye;
                    break;
                }
                case 4: {
                    x = xm;
                    y = ys;
                    break;
                }
                case 5: {
                    x = xs;
                    y = ym;
                    break;
                }
                case 6: {
                    x = xe;
                    y = ym;
                    break;
                }
                case 7: {
                    x = xm;
                    y = ye;
                    break;
                }
                default: {
                    x = xm;
                    y = ym;
                    break;
                }
            }
            SelectNib nib = selectNibs[n];
            Dimension nibSize = nib.getSize();
            nib.setBackground(Color.black);
            nib.target = node;
            nib.setSelectable(true);
            nib.setRectangleLocation(p);
            nib.setRectangleDimension(s);
            nib.setLayoutAssistant(this);
            nib.parentLocation = parentLocation;
            nib.use = 0;
            nib.type = j == -1 ? 8 : j;
            effects.moveNib(nib, x - nibSize.width / 2, y - nibSize.height / 2);
            nib.setVisible(true);
            ++n;
            ++j;
        }
    }

    public final synchronized JComponent[] getContextMenuItems(Context context) {
        if (ALIGN_MENU == null) {
            Menubar mgr = Ide.getMenubar();
            ALIGN_MENU = mgr.createSubMenu(LayoutConstants.ALIGN, LayoutConstants.ALIGN_MNEMONIC, JDeveloperMenuConstants.WEIGHT_JAVA_UI_DESIGN_ALIGN);
            ALIGN_MENU.putClientProperty("menu-section-id", new Float(JDeveloperMenuConstants.SECTION_DESIGN_NO_LAYOUT));
            ALIGN_LEFT_ITEM = mgr.createMenuItem((ToggleAction)ALIGN_LEFT_ACTION);
            ALIGN_CENTER_ITEM = mgr.createMenuItem((ToggleAction)ALIGN_CENTER_ACTION);
            ALIGN_RIGHT_ITEM = mgr.createMenuItem((ToggleAction)ALIGN_RIGHT_ACTION);
            ALIGN_TOP_ITEM = mgr.createMenuItem((ToggleAction)ALIGN_TOP_ACTION);
            ALIGN_MIDDLE_ITEM = mgr.createMenuItem((ToggleAction)ALIGN_MIDDLE_ACTION);
            ALIGN_BOTTOM_ITEM = mgr.createMenuItem((ToggleAction)ALIGN_BOTTOM_ACTION);
            float menuSection = 1.01f;
            mgr.add((Component)ALIGN_LEFT_ITEM, ALIGN_MENU, menuSection);
            mgr.add((Component)ALIGN_CENTER_ITEM, ALIGN_MENU, menuSection);
            mgr.add((Component)ALIGN_RIGHT_ITEM, ALIGN_MENU, menuSection);
            mgr.add((Component)ALIGN_TOP_ITEM, ALIGN_MENU, menuSection += 1.0f);
            mgr.add((Component)ALIGN_MIDDLE_ITEM, ALIGN_MENU, menuSection);
            mgr.add((Component)ALIGN_BOTTOM_ITEM, ALIGN_MENU, menuSection);
            SIZE_MENU = mgr.createSubMenu(LayoutConstants.SAME_SIZE, LayoutConstants.SAME_SIZE_MNEMONIC, JDeveloperMenuConstants.WEIGHT_JAVA_UI_DESIGN_SAME_SIZE);
            SIZE_MENU.putClientProperty("menu-section-id", new Float(JDeveloperMenuConstants.SECTION_DESIGN_NO_LAYOUT));
            SAME_SIZE_HORIZ_ITEM = mgr.createMenuItem((ToggleAction)SAME_SIZE_HORIZ_ACTION);
            SAME_SIZE_VERT_ITEM = mgr.createMenuItem((ToggleAction)SAME_SIZE_VERT_ACTION);
            SAME_SIZE_BOTH_ITEM = mgr.createMenuItem((ToggleAction)SAME_SIZE_BOTH_ACTION);
            mgr.add((Component)SAME_SIZE_HORIZ_ITEM, SIZE_MENU);
            mgr.add((Component)SAME_SIZE_VERT_ITEM, SIZE_MENU);
            mgr.add((Component)SAME_SIZE_BOTH_ITEM, SIZE_MENU);
            SPACING_MENU = mgr.createSubMenu(LayoutConstants.EVEN_SPACING, LayoutConstants.EVEN_SPACING_MNEMONIC, JDeveloperMenuConstants.WEIGHT_JAVA_UI_DESIGN_SPACE);
            SPACING_MENU.putClientProperty("menu-section-id", new Float(JDeveloperMenuConstants.SECTION_DESIGN_NO_LAYOUT));
            EVEN_SPACE_HORIZ_ITEM = mgr.createMenuItem((ToggleAction)EVEN_SPACE_HORIZ_ACTION);
            EVEN_SPACE_VERT_ITEM = mgr.createMenuItem((ToggleAction)EVEN_SPACE_VERT_ACTION);
            mgr.add((Component)EVEN_SPACE_HORIZ_ITEM, SPACING_MENU);
            mgr.add((Component)EVEN_SPACE_VERT_ITEM, SPACING_MENU);
        }
        JComponent[] superResults = super.getContextMenuItems(context);
        int index = superResults.length;
        JComponent[] results = new JComponent[index + 3];
        if (index > 0) {
            System.arraycopy(superResults, 0, results, 0, index);
        }
        results[index++] = ALIGN_MENU;
        results[index++] = SIZE_MENU;
        results[index++] = SPACING_MENU;
        return results;
    }

    public final boolean update(IdeAction action, Context context) {
        int id;
        int n = id = action != null ? action.getCommandId() : -1;
        if (id == LayoutConstants.MOVE_LEFT_CMD_ID || id == LayoutConstants.BIG_MOVE_LEFT_CMD_ID || id == LayoutConstants.MOVE_RIGHT_CMD_ID || id == LayoutConstants.BIG_MOVE_RIGHT_CMD_ID || id == LayoutConstants.MOVE_UP_CMD_ID || id == LayoutConstants.BIG_MOVE_UP_CMD_ID || id == LayoutConstants.MOVE_DOWN_CMD_ID || id == LayoutConstants.BIG_MOVE_DOWN_CMD_ID) {
            ArrayList siblings = NullLayoutAssistant.getSelectedSiblings(context);
            action.setEnabled(siblings.size() > 0);
            return true;
        }
        if (id == LayoutConstants.ALIGN_LEFT_CMD_ID || id == LayoutConstants.ALIGN_CENTER_CMD_ID || id == LayoutConstants.ALIGN_RIGHT_CMD_ID || id == LayoutConstants.ALIGN_TOP_CMD_ID || id == LayoutConstants.ALIGN_MIDDLE_CMD_ID || id == LayoutConstants.ALIGN_BOTTOM_CMD_ID) {
            ArrayList siblings = NullLayoutAssistant.getSelectedSiblings(context);
            action.setEnabled(siblings.size() > 0);
            return true;
        }
        if (id == LayoutConstants.SAME_SIZE_HORIZ_CMD_ID || id == LayoutConstants.SAME_SIZE_VERT_CMD_ID || id == LayoutConstants.SAME_SIZE_BOTH_CMD_ID) {
            ArrayList siblings = NullLayoutAssistant.getSelectedSiblings(context);
            action.setEnabled(siblings.size() > 1);
            return true;
        }
        if (id == LayoutConstants.EVEN_SPACE_HORIZ_CMD_ID || id == LayoutConstants.EVEN_SPACE_VERT_CMD_ID) {
            ArrayList siblings = NullLayoutAssistant.getSelectedSiblings(context);
            action.setEnabled(siblings.size() > 2);
            return true;
        }
        return super.update(action, context);
    }

    public final boolean handleEvent(IdeAction action, Context context) {
        int cmd = action.getCommandId();
        if (cmd == LayoutConstants.ALIGN_LEFT_CMD_ID || cmd == LayoutConstants.ALIGN_CENTER_CMD_ID || cmd == LayoutConstants.ALIGN_RIGHT_CMD_ID || cmd == LayoutConstants.ALIGN_TOP_CMD_ID || cmd == LayoutConstants.ALIGN_MIDDLE_CMD_ID || cmd == LayoutConstants.ALIGN_BOTTOM_CMD_ID) {
            CmtComponentSource src = null;
            try {
                ArrayList siblings = NullLayoutAssistant.getSelectedSiblings(context);
                CmtModelNode anchor = (CmtModelNode)siblings.get(0);
                String undo = (String)action.getValue("Name");
                src = (CmtComponentSource)anchor.getCmtModel().getComponent();
                src.beginTrans();
                this.align(cmd, siblings);
                src.commit(undo);
            }
            catch (Exception e) {
                if (src != null) {
                    src.abort();
                }
                Assert.printStackTrace((Throwable)e);
            }
            return true;
        }
        if (cmd == LayoutConstants.SAME_SIZE_HORIZ_CMD_ID || cmd == LayoutConstants.SAME_SIZE_VERT_CMD_ID || cmd == LayoutConstants.SAME_SIZE_BOTH_CMD_ID) {
            CmtComponentSource src = null;
            try {
                ArrayList siblings = NullLayoutAssistant.getSelectedSiblings(context);
                CmtModelNode anchor = (CmtModelNode)siblings.get(0);
                String undo = (String)action.getValue("Name");
                src = (CmtComponentSource)anchor.getCmtModel().getComponent();
                src.beginTrans();
                this.sameSize(cmd, siblings);
                src.commit(undo);
            }
            catch (Exception e) {
                if (src != null) {
                    src.abort();
                }
                Assert.printStackTrace((Throwable)e);
            }
            return true;
        }
        if (cmd == LayoutConstants.EVEN_SPACE_HORIZ_CMD_ID || cmd == LayoutConstants.EVEN_SPACE_VERT_CMD_ID) {
            CmtComponentSource src = null;
            try {
                ArrayList siblings = NullLayoutAssistant.getSelectedSiblings(context);
                CmtModelNode anchor = (CmtModelNode)siblings.get(0);
                String undo = (String)action.getValue("Name");
                src = (CmtComponentSource)anchor.getCmtModel().getComponent();
                src.beginTrans();
                this.evenSpace(cmd, siblings);
                src.commit(undo);
            }
            catch (Exception e) {
                if (src != null) {
                    src.abort();
                }
                Assert.printStackTrace((Throwable)e);
            }
            return true;
        }
        return super.handleEvent(action, context);
    }

    public final String getToolbarPrefix() {
        return "NullLayoutAssistant.Toolbar";
    }

    public final boolean usesReverseZOrder() {
        return true;
    }

    protected void move(int id, Context context) {
        UIEditorCanvas canvas;
        View view = context != null ? context.getView() : null;
        UIEditor editor = view instanceof UIEditor ? (UIEditor)view : null;
        UIEditorCanvas uIEditorCanvas = canvas = editor != null ? editor.getActiveCanvas() : null;
        if (!(canvas instanceof UICanvas)) {
            return;
        }
        CmtComponentSource source = editor.getComponentSource();
        if (source == null || source.isReadOnly()) {
            return;
        }
        UICanvas uiCanvas = (UICanvas)canvas;
        ArrayList siblings = NullLayoutAssistant.getSelectedSiblings(context);
        CmtModelNode[] nodes = new CmtModelNode[siblings.size()];
        Point[] locations = new Point[siblings.size()];
        int i = 0;
        while (i < locations.length) {
            CmtModelNode sibling = (CmtModelNode)siblings.get(i);
            CmtSubcomponent sub = sibling.getSubcomponent();
            Component component = (Component)sub.getLiveInstance();
            nodes[i] = sibling;
            locations[i] = uiCanvas.getAbsoluteLocation(component);
            ++i;
        }
        if (locations.length > 0) {
            int deltaX = 0;
            int deltaY = 0;
            if (id == LayoutConstants.MOVE_LEFT_CMD_ID) {
                deltaX = -1;
            } else if (id == LayoutConstants.BIG_MOVE_LEFT_CMD_ID) {
                deltaX = -this.gridSpacing;
            } else if (id == LayoutConstants.MOVE_RIGHT_CMD_ID) {
                deltaX = 1;
            } else if (id == LayoutConstants.BIG_MOVE_RIGHT_CMD_ID) {
                deltaX = this.gridSpacing;
            } else if (id == LayoutConstants.MOVE_UP_CMD_ID) {
                deltaY = -1;
            } else if (id == LayoutConstants.BIG_MOVE_UP_CMD_ID) {
                deltaY = -this.gridSpacing;
            } else if (id == LayoutConstants.MOVE_DOWN_CMD_ID) {
                deltaY = 1;
            } else if (id == LayoutConstants.BIG_MOVE_DOWN_CMD_ID) {
                deltaY = this.gridSpacing;
            }
            Point relLoc = new Point(0, 0);
            Point absLoc = new Point(locations[0].x, locations[0].y);
            CmtModelNode toNode = (CmtModelNode)nodes[0].getParent();
            toNode = uiCanvas.findContainerNode(nodes, absLoc, relLoc, toNode);
            int i2 = 1;
            while (i2 < locations.length) {
                locations[i2] = new Point(locations[i2].x - locations[0].x + relLoc.x + deltaX, locations[i2].y - locations[0].y + relLoc.y + deltaY);
                ++i2;
            }
            locations[0] = new Point(relLoc.x + deltaX, relLoc.y + deltaY);
            try {
                UIEditorController.getInstance().moveNodes(editor, nodes, toNode, locations, new Point(0, 0));
            }
            catch (Exception e) {
                Assert.printStackTrace();
            }
        }
    }

    private boolean align(int cmd, ArrayList selection) {
        boolean anyChanged;
        int length = selection.size();
        boolean bl = anyChanged = length > 0;
        if (anyChanged) {
            int iStart;
            Rectangle rFirst;
            CmtModelNode anchor = (CmtModelNode)selection.get(0);
            CmtModelNode parent = (CmtModelNode)anchor.getParent();
            Container container = parent.getSubcomponent().getAsContainer();
            Insets insets = container.getInsets();
            if (length == 1) {
                rFirst = container.getBounds();
                rFirst.x = 0;
                rFirst.y = 0;
                rFirst.width = rFirst.width - (this.useInsets ? insets.left + insets.right : 0);
                rFirst.height = rFirst.height - (this.useInsets ? insets.top + insets.bottom : 0);
                iStart = 0;
            } else {
                CmtSubcomponent sub = anchor.getSubcomponent();
                Component comp = (Component)sub.getLiveInstance();
                rFirst = comp.getBounds();
                rFirst.x = rFirst.x - (this.useInsets ? insets.left : 0);
                rFirst.y = rFirst.y - (this.useInsets ? insets.top : 0);
                iStart = 1;
            }
            int i = iStart;
            while (i < length) {
                int coord;
                CmtModelNode sibling = (CmtModelNode)selection.get(i);
                CmtSubcomponent sub = sibling.getSubcomponent();
                Component component = (Component)sub.getLiveInstance();
                Rectangle rect = component.getBounds();
                boolean horizAxis = false;
                if (cmd == LayoutConstants.ALIGN_LEFT_CMD_ID) {
                    coord = rFirst.x;
                    horizAxis = true;
                } else if (cmd == LayoutConstants.ALIGN_CENTER_CMD_ID) {
                    coord = rFirst.x + rFirst.width / 2 - rect.width / 2;
                    horizAxis = true;
                } else if (cmd == LayoutConstants.ALIGN_RIGHT_CMD_ID) {
                    coord = rFirst.x + rFirst.width - rect.width;
                    horizAxis = true;
                } else {
                    coord = cmd == LayoutConstants.ALIGN_TOP_CMD_ID ? rFirst.y : (cmd == LayoutConstants.ALIGN_MIDDLE_CMD_ID ? rFirst.y + rFirst.height / 2 - rect.height / 2 : (cmd == LayoutConstants.ALIGN_BOTTOM_CMD_ID ? rFirst.y + rFirst.height - rect.height : 0));
                }
                rect = this.getConstraints(sibling);
                if (horizAxis) {
                    this.setConstraints(sibling, parent, new Point(coord, rect.y), new Dimension(rect.width, rect.height));
                } else {
                    this.setConstraints(sibling, parent, new Point(rect.x, coord), new Dimension(rect.width, rect.height));
                }
                ++i;
            }
        }
        return anyChanged;
    }

    private boolean evenSpace(int cmd, ArrayList siblings) {
        boolean anyChanged;
        int length = siblings.size();
        boolean bl = anyChanged = length > 2;
        if (anyChanged) {
            int space;
            int start;
            boolean horizontal = cmd == LayoutConstants.EVEN_SPACE_HORIZ_CMD_ID;
            CmtModelNode[] selection = new CmtModelNode[length];
            siblings.toArray(selection);
            int i = 0;
            while (i < length - 1) {
                int j = 0;
                while (j < length - 1 - i) {
                    boolean swap;
                    CmtSubcomponent sub = selection[j].getSubcomponent();
                    Component comp1 = (Component)sub.getLiveInstance();
                    sub = selection[j + 1].getSubcomponent();
                    Component comp2 = (Component)sub.getLiveInstance();
                    Rectangle rect1 = comp1.getBounds();
                    Rectangle rect2 = comp2.getBounds();
                    boolean bl2 = horizontal ? rect1.x > rect2.x : (swap = rect1.y > rect2.y);
                    if (swap) {
                        CmtModelNode tmp = selection[j + 1];
                        selection[j + 1] = selection[j];
                        selection[j] = tmp;
                    }
                    ++j;
                }
                ++i;
            }
            int gaps = length - 1;
            CmtModelNode anchor = selection[0];
            CmtSubcomponent sub = anchor.getSubcomponent();
            Rectangle rect1 = ((Component)sub.getLiveInstance()).getBounds();
            CmtModelNode last = selection[gaps];
            sub = last.getSubcomponent();
            Rectangle rect2 = ((Component)sub.getLiveInstance()).getBounds();
            if (horizontal) {
                start = rect1.x + rect1.width;
                space = rect2.x - start;
                if (space < 0) {
                    start = rect1.x;
                    space = rect2.x + rect2.width - start;
                }
            } else {
                start = rect1.y + rect1.height;
                space = rect2.y - start;
                if (space < 0) {
                    start = rect1.y;
                    space = rect2.y + rect2.height - start;
                }
            }
            int i2 = 1;
            while (i2 < gaps) {
                CmtModelNode sibling = selection[i2];
                sub = sibling.getSubcomponent();
                rect1 = ((Component)sub.getLiveInstance()).getBounds();
                space -= horizontal ? rect1.width : rect1.height;
                ++i2;
            }
            CmtModelNode parent = (CmtModelNode)anchor.getParent();
            Container container = parent.getSubcomponent().getAsContainer();
            Insets insets = container.getInsets();
            int insetOffset = this.useInsets ? (horizontal ? insets.left : insets.top) : 0;
            int i3 = 1;
            while (i3 < gaps) {
                int coord;
                CmtModelNode sibling = selection[i3];
                sub = sibling.getSubcomponent();
                rect1 = ((Component)sub.getLiveInstance()).getBounds();
                rect2 = this.getConstraints(sibling);
                int n = coord = space >= 0 ? (i3 * space + gaps / 2) / gaps : (i3 * space - gaps / 2) / gaps;
                if (horizontal) {
                    this.setConstraints(sibling, parent, new Point(start + coord - insetOffset, rect2.y), new Dimension(rect2.width, rect2.height));
                } else {
                    this.setConstraints(sibling, parent, new Point(rect2.x, start + coord - insetOffset), new Dimension(rect2.width, rect2.height));
                }
                start += horizontal ? rect1.width : rect1.height;
                ++i3;
            }
        }
        return anyChanged;
    }

    private void sameSize(int cmd, ArrayList selection) {
        CmtModelNode anchor = (CmtModelNode)selection.get(0);
        CmtModelNode parent = (CmtModelNode)anchor.getParent();
        CmtSubcomponent sub = anchor.getSubcomponent();
        Rectangle rect1 = ((Component)sub.getLiveInstance()).getBounds();
        int i = 1;
        while (i < selection.size()) {
            CmtModelNode sibling = (CmtModelNode)selection.get(i);
            Rectangle rect2 = this.getConstraints(sibling);
            if (cmd == LayoutConstants.SAME_SIZE_BOTH_CMD_ID) {
                this.setConstraints(sibling, parent, new Point(rect2.x, rect2.y), new Dimension(rect1.width, rect1.height));
            } else if (cmd == LayoutConstants.SAME_SIZE_HORIZ_CMD_ID) {
                this.setConstraints(sibling, parent, new Point(rect2.x, rect2.y), new Dimension(rect1.width, rect2.height));
            } else {
                this.setConstraints(sibling, parent, new Point(rect2.x, rect2.y), new Dimension(rect2.width, rect1.height));
            }
            ++i;
        }
    }

    public void layoutChanged(CmtModelNode parent) {
        try {
            ArrayList children = this.sortedNodes(parent);
            int i = 0;
            while (i < children.size()) {
                CmtPropertyState ps;
                Object obj;
                CmtModelNode sibling = (CmtModelNode)children.get(i);
                CmtSubcomponent sub = sibling.getSubcomponent();
                Object object = obj = sub != null ? sub.getLiveInstance() : null;
                if (obj instanceof Component && (ps = sub.getPropertyState("bounds")) != null) {
                    ps.setDefaultValue(ps.getValue());
                    ps.reset();
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void prepareChangeLayout(CmtModelNode parent) {
        super.prepareChangeLayout(parent);
    }

    protected Rectangle getConstraints(CmtModelNode node) {
        CmtSubcomponent sub = node.getSubcomponent();
        Object obj = sub.getLiveInstance();
        return ((Component)obj).getBounds();
    }

    protected Dimension getPreferredSize(CmtModelNode node) {
        CmtSubcomponent sub = node.getSubcomponent();
        Component comp = (Component)sub.getLiveInstance();
        CmtModelNode toNode = (CmtModelNode)node.getParent();
        toNode.getSubcomponent().getAsContainer().add(comp);
        return comp.getPreferredSize();
    }

    protected void setConstraints(CmtModelNode node, CmtModelNode toNode, Point location, Dimension size) {
        try {
            CmtSubcomponent subComp = node.getSubcomponent();
            Component comp = (Component)subComp.getLiveInstance();
            CmtPropertyState ps = subComp.getPropertyState("bounds");
            if (size == null) {
                size = this.getPreferredSize(node);
            }
            if (ps == null) {
                CmtPropertySource prop = ((CmtComponentSource)subComp.getComponent()).addProperty("java.awt.Rectangle", "setBounds");
                ps = subComp.addPropertyState(prop);
            }
            ps.setDefaultValue(null);
            ps.setValue(new Rectangle(location.x, location.y, size.width, size.height));
            comp.setBounds(location.x, location.y, size.width, size.height);
        }
        catch (PropertyVetoException e) {
            Assert.printStackTrace((Throwable)e);
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    public final JComponent getEffects(UICanvas canvas, Container c) {
        return null;
    }

    public void stateChanged(ChangeEvent e) {
        this.updateSettings();
    }

    public void drawGrid(Container host, Graphics g) {
        if (this.gridVisible) {
            Rectangle r = host.getBounds();
            int y = 0;
            while (y < r.height) {
                int x = 0;
                while (x < r.width) {
                    g.fillRect(x, y, 1, 1);
                    x += this.gridSpacing;
                }
                y += this.gridSpacing;
            }
        }
    }
}

