/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.assistant;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.StringTokenizer;
import oracle.jdeveloper.cmt.CmtPropertyEditor;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.layout.PaneConstraints;
import oracle.jdeveloper.layout.PaneLayout;
import oracle.jdevimpl.propertyeditor.PaneConstraintsCustomEditor;

public final class PaneConstraintsEditor
implements CmtPropertyEditor {
    private PropertyChangeListener listener;
    private PaneConstraints value;
    private CmtPropertyState ps;
    private PaneConstraintsCustomEditor editor;

    public void setPropertyState(CmtPropertyState ps) {
        this.ps = ps;
    }

    public void setValue(Object o) {
        PaneConstraints tmp = (PaneConstraints)o;
        try {
            LayoutManager lm;
            Container parent;
            Object component;
            CmtSubcomponent c;
            if (this.ps != null && (tmp == null || tmp.name == null || tmp.splitComponentName == null) && (c = this.ps.getSubcomponent()) != null && (component = c.getLiveInstance()) instanceof Component && (parent = ((Component)component).getParent()) != null && (lm = parent.getLayout()) instanceof PaneLayout) {
                tmp = ((PaneLayout)lm).getConstraints((Component)component);
            }
            if (this.editor != null) {
                this.editor.reset(tmp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.value = tmp;
        this.fire();
    }

    public Object getValue() {
        block5: {
            try {
                if (this.value == null || this.editor == null) break block5;
                String position = (String)this.editor.position.getSelectedItem();
                float proportion = 0.5f;
                try {
                    proportion = Float.valueOf(this.editor.proportion.getText()).floatValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!position.equals(this.value.position) || this.value.proportion != proportion) {
                    this.value = new PaneConstraints(this.editor.nameLabel.getText(), this.editor.splitLabel.getText(), (String)this.editor.position.getSelectedItem(), proportion);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }

    public String getAsText() {
        if (this.value == null) {
            LayoutManager lm;
            Container parent;
            CmtSubcomponent c;
            Object component;
            if (this.ps != null && (component = (c = this.ps.getSubcomponent()).getLiveInstance()) instanceof Component && (parent = ((Component)component).getParent()) != null && (lm = parent.getLayout()) instanceof PaneLayout) {
                this.value = ((PaneLayout)lm).getConstraints((Component)component);
            }
            this.value = new PaneConstraints();
        }
        return String.valueOf(this.value.name + ", " + this.value.splitComponentName + ", " + this.value.position + ", " + this.value.proportion + "f");
    }

    public String getJavaInitializationString() {
        if (this.value == null) {
            this.value = new PaneConstraints();
        }
        String posValue = "null";
        if (this.value.position == "Bottom") {
            posValue = "oracle.jdeveloper.layout.PaneConstraints.BOTTOM";
        } else if (this.value.position == "Top") {
            posValue = "oracle.jdeveloper.layout.PaneConstraints.TOP";
        } else if (this.value.position == "Left") {
            posValue = "oracle.jdeveloper.layout.PaneConstraints.LEFT";
        } else if (this.value.position == "Right") {
            posValue = "oracle.jdeveloper.layout.PaneConstraints.RIGHT";
        } else if (this.value.position == "Root") {
            posValue = "oracle.jdeveloper.layout.PaneConstraints.ROOT";
        }
        String returnName = this.value.name == null ? "null" : "\"" + this.value.name + "\"";
        String splitName = this.value.splitComponentName == null ? "null" : "\"" + this.value.splitComponentName + "\"";
        return "new oracle.jdeveloper.layout.PaneConstraints(" + returnName + ", " + splitName + ", " + posValue + ", " + this.value.proportion + "f)";
    }

    public void setAsText(String text) throws IllegalArgumentException {
        StringTokenizer tokenizer = new StringTokenizer(text, ",");
        String[] argv = new String[tokenizer.countTokens()];
        int argc = 0;
        while (tokenizer.hasMoreTokens()) {
            argv[argc++] = tokenizer.nextToken().trim();
        }
        if (argc != 4) {
            throw new IllegalArgumentException();
        }
        try {
            this.value = new PaneConstraints(argv[0], argv[1], argv[2], Float.valueOf(argv[3]).floatValue());
        }
        catch (NumberFormatException x) {
            throw new IllegalArgumentException(text);
        }
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        if (this.editor == null) {
            LayoutManager lm;
            Container parent;
            CmtSubcomponent c;
            Object component;
            if (this.ps != null && (component = (c = this.ps.getSubcomponent()).getLiveInstance()) instanceof Component && (parent = ((Component)component).getParent()) != null && (lm = parent.getLayout()) instanceof PaneLayout) {
                this.value = ((PaneLayout)lm).getConstraints((Component)component);
            }
            this.editor = new PaneConstraintsCustomEditor(this.value);
        }
        return this.editor;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    private void fire() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "PaneConstraintsEditor???", null, this.getValue()));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listener = l;
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listener = null;
    }
}

