/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.assistant;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.explorer.Explorer;
import oracle.ide.util.Assert;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.layout.PaneConstraints;
import oracle.jdeveloper.layout.PaneLayout;
import oracle.jdeveloper.uieditor.uicanvas.ConstraintsPropertyState;
import oracle.jdeveloper.uieditor.uicanvas.SelectNib;
import oracle.jdeveloper.uieditor.uicanvas.SelectionEffects;
import oracle.jdeveloper.uieditor.uicanvas.UICanvas;
import oracle.jdevimpl.uieditor.assistant.BasicLayoutAssistant;
import oracle.jdevimpl.uieditor.assistant.PaneConstraintsEditor;
import oracle.jdevimpl.uieditor.assistant.PaneExplorer;
import oracle.jdevimpl.uieditor.assistant.PaneLayoutData;
import oracle.jdevimpl.uieditor.assistant.Res;
import oracle.jdevimpl.uieditor.uicanvas.NodeAddCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PaneLayoutAssistant
extends BasicLayoutAssistant
implements Comparator {
    private static Explorer EXPLORER;
    private int newX;
    private int newY;

    @Override
    public String getConstraintsType() {
        return "oracle.jdeveloper.layout.PaneConstraints";
    }

    @Override
    public PropertyEditor getPropertyEditor() {
        return new PaneConstraintsEditor();
    }

    @Override
    public Explorer getConstraintsEditor(Context context) {
        Explorer explorer = PaneLayoutAssistant.getExplorer();
        explorer.setContext(context);
        return explorer;
    }

    private static synchronized Explorer getExplorer() {
        if (EXPLORER == null) {
            EXPLORER = new PaneExplorer();
        }
        return EXPLORER;
    }

    private static PaneConstraints getConstraints(CmtModelNode node) {
        CmtSubcomponent sub = node.getSubcomponent();
        CmtPropertyState state = sub.getPropertyState("<Bconstraints>");
        return (PaneConstraints)state.getValue();
    }

    private static void setConstraints(CmtModelNode node, PaneConstraints c) {
        try {
            CmtSubcomponent sub = node.getSubcomponent();
            CmtPropertyState state = sub.getPropertyState("<Bconstraints>");
            state.setValue(c);
        }
        catch (Exception ex) {
            Assert.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public String resizeAction(Point newNibLocation, SelectionEffects effects, SelectNib nib) {
        UICanvas canvas = effects.getUICanvas();
        Point p = nib.getRectangleLocation();
        Dimension d = nib.getRectangleDimension();
        if (nib.use == 0) {
            canvas.getBoxEffects().show(0, p, d, 2);
            nib.use = 1;
        }
        float value = 0.0f;
        this.newX = newNibLocation.x;
        this.newY = newNibLocation.y;
        if (nib.type == 5 || nib.type == 6) {
            Dimension divider = new Dimension(2, d.height);
            newNibLocation.y = p.y;
            if (newNibLocation.x < p.x) {
                value = 0.0f;
            } else if (newNibLocation.x > p.x + d.width) {
                value = 1.0f;
            } else {
                value = (float)(newNibLocation.x - p.x) / (float)d.width;
                canvas.getBoxEffects().show(1, newNibLocation, divider, 2);
            }
        } else {
            Dimension divider = new Dimension(d.width, 2);
            newNibLocation.x = p.x;
            if (newNibLocation.y < p.y) {
                value = 0.0f;
            } else if (newNibLocation.y > p.y + d.height) {
                value = 1.0f;
            } else {
                value = (float)(newNibLocation.y - p.y) / (float)d.height;
                canvas.getBoxEffects().show(1, newNibLocation, divider, 2);
            }
        }
        return " " + value;
    }

    @Override
    public void prepareSelectComponent(CmtModelNode node, SelectionEffects effects) {
        Object obj;
        UICanvas canvas = effects.getUICanvas();
        effects.hideAll();
        CmtSubcomponent sub = node != null ? node.getSubcomponent() : null;
        Object object = obj = sub != null ? sub.getLiveInstance() : null;
        if (!(obj instanceof Component)) {
            return;
        }
        Component component = (Component)obj;
        CmtModelNode parent = (CmtModelNode)node.getParent();
        Container container = parent.getSubcomponent().getAsContainer();
        LayoutManager layout = container.getLayout();
        Point parentLocation = canvas.getAbsoluteLocation(container);
        this.prepareSelectDescendant(parent, node, effects);
        Point p = canvas.getAbsoluteLocation(component);
        Dimension s = component.getSize();
        int xs = p.x;
        int ys = p.y;
        int xe = p.x + s.width;
        int ye = p.y + s.height;
        int xm = (xs + xe) / 2;
        int ym = (ys + ye) / 2;
        int startSub = 0;
        if (node.getAllowsChildren()) {
            startSub = -1;
        }
        SelectNib[] selectNibs = effects.getSelectNibs(8 - startSub);
        int n = 0;
        int j = startSub;
        while (j < 8) {
            block17: {
                int y;
                int x;
                block16: {
                    switch (j) {
                        case 0: {
                            x = xs;
                            y = ys;
                            break;
                        }
                        case 1: {
                            x = xe - 1;
                            y = ys;
                            break;
                        }
                        case 2: {
                            x = xs;
                            y = ye - 1;
                            break;
                        }
                        case 3: {
                            x = xe - 1;
                            y = ye - 1;
                            break;
                        }
                        case 4: {
                            x = xm;
                            y = ys;
                            break;
                        }
                        case 5: {
                            x = xs;
                            y = ym;
                            break;
                        }
                        case 6: {
                            x = xe;
                            y = ym;
                            break;
                        }
                        case 7: {
                            x = xm;
                            y = ye;
                            break;
                        }
                        default: {
                            x = xm;
                            y = ym;
                            break;
                        }
                    }
                    if (j <= 3) break block16;
                    Rectangle r = ((PaneLayout)layout).getDividerRect(x - parentLocation.x, y - parentLocation.y);
                    if (r == null) break block17;
                    r = ((PaneLayout)layout).getDividerBounds();
                    p = new Point(r.x + parentLocation.x, r.y + parentLocation.y);
                    s = new Dimension(r.width, r.height);
                }
                SelectNib nib = selectNibs[n];
                Dimension nibSize = nib.getSize();
                nib.target = node;
                nib.setRectangleLocation(p);
                nib.setRectangleDimension(s);
                nib.setLayoutAssistant(this);
                nib.parentLocation = parentLocation;
                nib.use = 0;
                nib.type = j == -1 ? 8 : j;
                nib.setBackground(nib.type > 3 ? Color.black : SystemColor.controlShadow);
                nib.setSelectable(nib.type > 3);
                effects.moveNib(nib, x - nibSize.width / 2, y - nibSize.height / 2);
                nib.setVisible(true);
                ++n;
            }
            ++j;
        }
    }

    @Override
    public void prepareResizeComponent(CmtModelNode node, SelectionEffects effects, SelectNib nib) {
        Container container;
        LayoutManager layout;
        CmtModelNode parent = (CmtModelNode)node.getParent();
        Point location = nib.getLocation();
        Dimension size = nib.getSize();
        location.x += size.width / 2;
        location.y += size.height / 2;
        location.x -= nib.parentLocation.x;
        location.y -= nib.parentLocation.y;
        if (parent != null && (layout = (container = parent.getSubcomponent().getAsContainer()).getLayout()) instanceof PaneLayout) {
            if (((PaneLayout)layout).getDividerRect(location.x, location.y) != null) {
                ((PaneLayout)layout).dragDivider(this.newX - nib.parentLocation.x, this.newY - nib.parentLocation.y);
            }
            ((PaneLayout)layout).layoutContainer(container);
            PaneLayoutAssistant.updateConstraints(parent, (PaneLayout)layout, null, null);
        }
    }

    @Override
    public void prepareMoveComponent(CmtModelNode node, CmtModelNode toNode, Point location, Point offset) {
        CmtModelNode parent = (CmtModelNode)node.getParent();
        CmtSubcomponent sub = node.getSubcomponent();
        Component movingComponent = (Component)sub.getLiveInstance();
        PaneConstraints oldConstraints = null;
        if (parent != null) {
            Container container = parent.getSubcomponent().getAsContainer();
            LayoutManager layout = container.getLayout();
            if (layout instanceof PaneLayout) {
                oldConstraints = ((PaneLayout)layout).getConstraints(movingComponent);
                CmtModelNode splitNode = PaneLayoutAssistant.getSplitNode(parent, location);
                if (node == splitNode) {
                    return;
                }
                PaneConstraints newC = PaneLayoutAssistant.getBestConstraints(node, splitNode, location, null);
                if (oldConstraints == null) {
                    ((PaneLayout)layout).removeLayoutComponent(null);
                    ConstraintsPropertyState state = (ConstraintsPropertyState)sub.getPropertyState("<Bconstraints>");
                    state.setValue(newC, false);
                } else {
                    ((PaneLayout)layout).removeLayoutComponent(movingComponent);
                    ((PaneLayout)layout).removeLayoutComponent(null);
                    ((PaneLayout)layout).addLayoutComponent(movingComponent, (Object)newC);
                }
            }
            PaneLayoutAssistant.removeBoundsSetting(node);
        }
    }

    private static void updateConstraints(CmtModelNode parent, PaneLayout layout, Hashtable nameNode, Hashtable splitName) {
        Iterator i = parent.getChildren();
        while (i.hasNext()) {
            PaneConstraints sc;
            Object obj;
            CmtModelNode sibling = (CmtModelNode)i.next();
            CmtSubcomponent sub = sibling.getSubcomponent();
            Object object = obj = sub != null ? sub.getLiveInstance() : null;
            if (!(obj instanceof Component) || (sc = layout.getConstraints((Component)obj)) == null) continue;
            if (nameNode != null) {
                nameNode.put(sc.name, sibling);
                splitName.put(sc.name, sc.splitComponentName);
            }
            ConstraintsPropertyState state = (ConstraintsPropertyState)sub.getPropertyState("<Bconstraints>");
            state.setValue(sc, false);
        }
    }

    @Override
    public void cleanupRemovedComponent(CmtModelNode parent) {
        Container container;
        LayoutManager layout;
        Hashtable nameNode = new Hashtable();
        Hashtable splitName = new Hashtable();
        if (parent != null && (layout = (container = parent.getSubcomponent().getAsContainer()).getLayout()) instanceof PaneLayout) {
            PaneLayoutAssistant.updateConstraints(parent, (PaneLayout)layout, nameNode, splitName);
            String[] constraintName = ((PaneLayout)layout).getAddOrder(container);
            NodeAddCall previousAC = null;
            int i = 0;
            while (i < constraintName.length) {
                CmtModelNode node;
                if (constraintName[i] != null && (node = (CmtModelNode)nameNode.get(constraintName[i])) != null) {
                    CmtSubcomponent sub = node.getSubcomponent();
                    CmtPropertyState state = sub.getPropertyState("<Bconstraints>");
                    NodeAddCall nodeAC = (NodeAddCall)state;
                    nodeAC.setPosition(previousAC, false);
                    previousAC = nodeAC;
                }
                ++i;
            }
        }
    }

    @Override
    public void prepareAddComponent(CmtModelNode node, CmtModelNode toNode, Point location, Point offset, Dimension size) {
        CmtSubcomponent sub = node.getSubcomponent();
        Object obj = sub.getLiveInstance();
        if (!(obj instanceof Component)) {
            return;
        }
        Component comp = (Component)obj;
        if (size == null) {
            size = comp.getPreferredSize();
        }
        CmtModelNode splitNode = PaneLayoutAssistant.getSplitNode(toNode, location);
        PaneConstraints c = PaneLayoutAssistant.getBestConstraints(node, splitNode, location, size);
        ConstraintsPropertyState state = (ConstraintsPropertyState)sub.getPropertyState("<Bconstraints>");
        state.setValue(c, false);
        PaneLayoutAssistant.removeBoundsSetting(node);
    }

    @Override
    public void prepareChangeLayout(CmtModelNode parent) {
        if (parent == null) {
            return;
        }
        Container container = parent.getSubcomponent().getAsContainer();
        LayoutManager layout = container.getLayout();
        if (!(layout instanceof PaneLayout)) {
            return;
        }
        try {
            ArrayList<PaneLayoutData> children = new ArrayList<PaneLayoutData>();
            Iterator iter = parent.getChildren();
            while (iter.hasNext()) {
                Object obj;
                CmtModelNode node = (CmtModelNode)iter.next();
                CmtSubcomponent sub = node.getSubcomponent();
                Object object = obj = sub != null ? sub.getLiveInstance() : null;
                if (!(obj instanceof Component)) continue;
                PaneLayoutData paneData = new PaneLayoutData(node);
                children.add(paneData);
                PaneLayoutAssistant.ensureNoOverlap(paneData, children);
            }
            Collections.sort(children, this);
            boolean orderChanged = true;
            block3: while (orderChanged) {
                orderChanged = false;
                int restart = -1;
                int subscript = 0;
                iter = children.iterator();
                if (iter == null) continue;
                while (iter.hasNext()) {
                    PaneLayoutData data = (PaneLayoutData)iter.next();
                    if (subscript < restart) continue;
                    ++subscript;
                    if (data == null || data.node == null || (restart = PaneLayoutAssistant.findParent(data, children)) == -1) continue;
                    orderChanged = true;
                    continue block3;
                }
            }
            iter = children.iterator();
            if (iter != null) {
                int i = 0;
                while (iter.hasNext()) {
                    PaneLayoutData data = (PaneLayoutData)iter.next();
                    this.changeZ(data.node, parent, i);
                    PaneLayoutAssistant.removeBoundsSetting(data.node);
                    ++i;
                }
            }
            container.removeAll();
            iter = children.iterator();
            if (iter != null) {
                while (iter.hasNext()) {
                    PaneLayoutData data = (PaneLayoutData)iter.next();
                    if (data == null || data.node == null) continue;
                    PaneConstraints constraints = new PaneConstraints(data.node.getName(), data.parent.node.getName(), data.position, data.proportion);
                    CmtSubcomponent sub = data.node.getSubcomponent();
                    ConstraintsPropertyState state = (ConstraintsPropertyState)sub.getPropertyState("<Bconstraints>");
                    state.setValue(constraints, false);
                    container.add(data.component, constraints);
                }
            }
            ((PaneLayout)layout).layoutContainer(container);
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    private static void ensureNoOverlap(PaneLayoutData data, List list) {
        Iterator iter = list.iterator();
        if (iter != null) {
            while (iter.hasNext()) {
                PaneLayoutData candidate = (PaneLayoutData)iter.next();
                if (data == candidate || !data.bounds.intersects(candidate.bounds)) continue;
                data.bounds.x = (candidate.bounds.x + candidate.bounds.width) / 2;
                data.bounds.width = candidate.bounds.width / 2;
                data.bounds.y = candidate.bounds.y;
                data.bounds.height = candidate.bounds.height;
                candidate.bounds.width = data.bounds.width;
            }
        }
    }

    private static int findParent(PaneLayoutData data, ArrayList list) {
        int newpos = 0;
        int i = 0;
        int size = list.size();
        int j = 0;
        while (j < size) {
            PaneLayoutData candidate = (PaneLayoutData)list.get(j);
            if (candidate == data) {
                if (i == 0) {
                    data.determineConstraints(null);
                    return -1;
                }
                list.remove(i);
                list.add(newpos, data);
                return newpos;
            }
            if (candidate.ownedArea.union(data.bounds).equals(candidate.ownedArea)) {
                data.determineConstraints(candidate);
                return -1;
            }
            if (candidate.originalArea.union(data.bounds).equals(candidate.originalArea)) {
                newpos = i;
            }
            ++i;
            ++j;
        }
        return -1;
    }

    private static PaneConstraints getBestConstraints(CmtModelNode node, CmtModelNode splitNode, Point location, Dimension size) {
        if (location == null) {
            return new PaneConstraints(node != null ? node.getName() : "", null, null, 0.5f);
        }
        if (splitNode == null) {
            return new PaneConstraints(node != null ? node.getName() : "", node != null ? node.getName() : "", "Root", 1.0f);
        }
        CmtSubcomponent sub = splitNode.getSubcomponent();
        Component splitComponent = (Component)sub.getLiveInstance();
        Container container = ((CmtModelNode)splitNode.getParent()).getSubcomponent().getAsContainer();
        LayoutManager lm = container.getLayout();
        PaneConstraints splitConstraint = ((PaneLayout)lm).getConstraints(splitComponent);
        String splitName = splitNode.getName();
        if (splitConstraint != null) {
            splitName = splitConstraint.name;
        }
        Rectangle r = splitComponent.getBounds();
        if (size == null) {
            size = new Dimension(0, 0);
        }
        float left = (float)(location.x - r.x) / (float)r.width;
        float top = (float)(location.y - r.y) / (float)r.height;
        float right = (float)(r.x + r.width - location.x - size.width) / (float)r.width;
        float bottom = (float)(r.y + r.height - location.y - size.height) / (float)r.height;
        String position = "Top";
        if (left > top) {
            if (left > right) {
                if (left > bottom) {
                    position = "Right";
                }
            } else if (right > bottom) {
                position = "Left";
            }
        } else if (top > right) {
            if (top > bottom) {
                position = "Bottom";
            }
        } else if (right > bottom) {
            position = "Left";
        }
        float proportion = 0.5f;
        proportion = position.equals("Top") ? (float)(size.height + location.y - r.y) / (float)r.height : (position.equals("Bottom") ? (float)(r.height - location.y + r.y) / (float)r.height : (position.equals("Right") ? (float)(r.width - location.x + r.x) / (float)r.width : (float)(size.width + location.x - r.x) / (float)r.width));
        if (proportion > 1.0f || proportion < 0.0f) {
            proportion = 0.5f;
        }
        return new PaneConstraints(node != null ? node.getName() : "", splitName, position, proportion);
    }

    private static CmtModelNode getSplitNode(CmtModelNode parent, Point location) {
        if (location == null) {
            location = new Point(0, 0);
        }
        int x = location.x;
        int y = location.y;
        Container container = parent.getSubcomponent().getAsContainer();
        LayoutManager lm = container.getLayout();
        int gap = ((PaneLayout)lm).getGap();
        Iterator i = parent.getChildren();
        while (i.hasNext()) {
            Object obj;
            CmtModelNode sibling = (CmtModelNode)i.next();
            CmtSubcomponent sub = sibling.getSubcomponent();
            Object object = obj = sub != null ? sub.getLiveInstance() : null;
            if (!(obj instanceof Component)) continue;
            Rectangle r = ((Component)obj).getBounds();
            if (y < r.y || y > r.y + r.height + gap || x < r.x || x > r.x + r.width + gap) continue;
            return sibling;
        }
        return null;
    }

    @Override
    public String prepareAddStatus(CmtModelNode node, CmtModelNode toNode, Point location, Dimension size) {
        if (node == null) {
            return toNode.getName();
        }
        CmtModelNode splitNode = PaneLayoutAssistant.getSplitNode(toNode, location);
        if (splitNode != node) {
            return PaneLayoutAssistant.getBestConstraints(node, splitNode, location, size).toString();
        }
        return toNode.getName() + ": " + node;
    }

    @Override
    public String constrainMove(CmtModelNode node, CmtModelNode toNode, Point mousePos, Point mouseOffset, Point newPos, Dimension newSize) {
        Container cont = toNode.getSubcomponent().getAsContainer();
        CmtModelNode splitNode = PaneLayoutAssistant.getSplitNode(toNode, mousePos);
        if (splitNode == null) {
            Dimension parentSize = cont.getSize();
            Insets insets = cont.getInsets();
            newPos.x = insets.left;
            newPos.y = insets.right;
            newSize.width = parentSize.width - insets.left - insets.right;
            newSize.height = parentSize.height - insets.top - insets.bottom;
            return toNode.getName() + ": " + node;
        }
        PaneConstraints c = PaneLayoutAssistant.getBestConstraints(node, splitNode, mousePos, null);
        CmtSubcomponent sub = splitNode.getSubcomponent();
        Component comp = (Component)sub.getLiveInstance();
        Rectangle rect = comp.getBounds();
        if (c.position.equals("Top")) {
            newPos.x = rect.x;
            newPos.y = rect.y;
            newSize.width = rect.width;
            newSize.height = (int)((float)rect.height * c.proportion);
        } else if (c.position.equals("Bottom")) {
            int height = rect.height;
            newSize.width = rect.width;
            newSize.height = (int)((float)height * c.proportion);
            newPos.x = rect.x;
            newPos.y = rect.y + height - newSize.height;
        } else if (c.position.equals("Left")) {
            newPos.x = rect.x;
            newPos.y = rect.y;
            newSize.width = (int)((float)rect.width * c.proportion);
            newSize.height = rect.height;
        } else if (c.position.equals("Right")) {
            int width = rect.width;
            newSize.width = (int)((float)rect.width * c.proportion);
            newSize.height = rect.height;
            newPos.x = rect.x + width - newSize.width;
            newPos.y = rect.y;
        }
        return c.toString();
    }

    @Override
    public String prepareResizeStatus(CmtModelNode node, Point location, Dimension size) {
        if (node != null) {
            PaneConstraints c = PaneLayoutAssistant.getConstraints(node);
            return node.toString() + " - " + c.splitComponentName;
        }
        return "";
    }

    @Override
    public String prepareMouseMoveStatus(CmtModelNode node, CmtModelNode toNode, Point location) {
        if (node == null) {
            return toNode.toString() + Res.getString(5);
        }
        PaneConstraints c = PaneLayoutAssistant.getConstraints(node);
        if (c != null) {
            return c.toString();
        }
        return node.getName();
    }

    public int compare(Object first, Object second) {
        if (first instanceof PaneLayoutData) {
            if (second instanceof PaneLayoutData) {
                PaneLayoutData p1 = (PaneLayoutData)first;
                PaneLayoutData p2 = (PaneLayoutData)second;
                return Math.abs(p1.bounds.x) - Math.abs(p2.bounds.x);
            }
            return 1;
        }
        return second instanceof PaneLayoutData ? -1 : 0;
    }
}

