/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.assistant;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.cmt.CmtSubcomponent;

public class PaneLayoutData {
    public CmtModelNode node;
    public Rectangle bounds;
    public Rectangle ownedArea;
    public Rectangle originalArea;
    public Component component;
    public Point location;
    public Dimension size;
    public String position;
    public float proportion;
    PaneLayoutData parent;
    static Rectangle containerBounds;

    private void $init$() {
        this.ownedArea = new Rectangle();
    }

    public PaneLayoutData(CmtModelNode node) {
        this.$init$();
        CmtSubcomponent sub = node.getSubcomponent();
        this.component = (Component)sub.getLiveInstance();
        this.bounds = this.component.getBounds();
        this.location = new Point(this.bounds.x, this.bounds.y);
        this.size = new Dimension(this.bounds.width, this.bounds.height);
        this.node = node;
        if (containerBounds == null) {
            sub = ((CmtModelNode)node.getParent()).getSubcomponent();
            Dimension d = ((Component)sub.getLiveInstance()).getSize();
            containerBounds = new Rectangle(d);
        }
        containerBounds = containerBounds.union(this.bounds);
    }

    public String toString() {
        return this.node.toString() + " " + this.bounds.toString();
    }

    void setOwnedArea(Rectangle area) {
        this.ownedArea = area;
    }

    void determineConstraints(PaneLayoutData parent) {
        this.parent = parent;
        if (parent == null) {
            this.ownedArea = new Rectangle(PaneLayoutData.containerBounds.x, PaneLayoutData.containerBounds.y, PaneLayoutData.containerBounds.width, PaneLayoutData.containerBounds.height);
            this.proportion = 1.0f;
            this.position = "Root";
            this.parent = this;
        } else if (PaneLayoutData.overlapping(this.location.x, this.size.width, parent.location.x, parent.size.width)) {
            this.ownedArea.width = parent.ownedArea.width;
            this.ownedArea.x = parent.ownedArea.x;
            if (this.location.y < parent.location.y) {
                this.proportion = (float)(parent.location.y - parent.ownedArea.y) / (float)parent.ownedArea.height;
                this.position = "Top";
                this.ownedArea.height = parent.location.y - parent.ownedArea.y;
                this.ownedArea.y = parent.ownedArea.y;
                parent.ownedArea.y = this.ownedArea.y + this.ownedArea.height;
                parent.ownedArea.height -= this.ownedArea.height;
            } else {
                this.proportion = (float)(parent.ownedArea.height + parent.ownedArea.y - parent.location.y - parent.size.height) / (float)parent.ownedArea.height;
                this.position = "Bottom";
                this.ownedArea.y = parent.size.height + parent.location.y;
                this.ownedArea.height = parent.ownedArea.y + parent.ownedArea.height - this.ownedArea.y;
                parent.ownedArea.height -= this.ownedArea.height;
            }
        } else {
            this.ownedArea.height = parent.ownedArea.height;
            this.ownedArea.y = parent.ownedArea.y;
            if (this.location.x < parent.location.x) {
                this.proportion = (float)(this.location.x + this.size.width - parent.ownedArea.x) / (float)parent.ownedArea.width;
                this.position = "Left";
                this.ownedArea.width = parent.location.x - parent.ownedArea.x;
                this.ownedArea.x = parent.ownedArea.x;
                parent.ownedArea.x = this.ownedArea.x + this.ownedArea.height;
                parent.ownedArea.width -= this.ownedArea.width;
            } else {
                this.proportion = (float)(parent.ownedArea.width + parent.ownedArea.x - parent.location.x - parent.size.width) / (float)parent.ownedArea.width;
                this.position = "Right";
                this.ownedArea.x = parent.size.width + parent.location.x;
                this.ownedArea.width = parent.ownedArea.x + parent.ownedArea.width - this.ownedArea.x;
                parent.ownedArea.width -= this.ownedArea.width;
            }
        }
        this.originalArea = new Rectangle(this.ownedArea.x, this.ownedArea.y, this.ownedArea.width, this.ownedArea.height);
    }

    static boolean overlapping(int posA, int sizeA, int posB, int sizeB) {
        return posA <= posB && posB < posA + sizeA || posB <= posA && posA < posB + sizeB || posB < posA + sizeA && posA + sizeA <= posB + sizeB;
    }
}

