/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.assistant;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JSplitPane;
import oracle.ide.util.Assert;
import oracle.jdeveloper.cmt.CmtModel;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.uieditor.uicanvas.InnerAssistant;
import oracle.jdeveloper.uieditor.uicanvas.SelectNib;
import oracle.jdeveloper.uieditor.uicanvas.SelectionEffects;
import oracle.jdevimpl.uieditor.assistant.BasicLayoutAssistant;
import oracle.jdevimpl.uieditor.assistant.Res;

public final class SplitPaneLayoutAssistant
extends BasicLayoutAssistant
implements InnerAssistant {
    private static final int TOP = 0;
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private static final int BOTTOM = 3;
    static final String[] EDGES = new String[]{"top", "left", "right", "bottom"};
    private static final String[] EDGE_FIELDS = new String[]{"javax.swing.JSplitPane.TOP", "javax.swing.JSplitPane.LEFT", "javax.swing.JSplitPane.RIGHT", "javax.swing.JSplitPane.BOTTOM"};

    public String getConstraintsType() {
        return "java.lang.String";
    }

    public PropertyEditor getPropertyEditor() {
        return new SplitPaneConstraintsEditor();
    }

    public void prepareAddComponent(CmtModelNode node, CmtModelNode toNode, Point location, Point offset, Dimension size) {
        int i = SplitPaneLayoutAssistant.findBest(node, toNode, location, null);
        SplitPaneLayoutAssistant.setToEdge(node, toNode, i);
        SplitPaneLayoutAssistant.removeBoundsSetting(node);
    }

    public String prepareAddStatus(CmtModelNode node, CmtModelNode toNode, Point location, Dimension size) {
        int edge = SplitPaneLayoutAssistant.findBest(node, toNode, location, null);
        return toNode + ": " + SplitPaneLayoutAssistant.getConstraintsString(edge);
    }

    public String prepareMouseMoveStatus(CmtModelNode node, CmtModelNode toNode, Point location) {
        return node == null ? toNode.toString() : node + ": " + SplitPaneLayoutAssistant.getConstraintsString(SplitPaneLayoutAssistant.getConstraints(node));
    }

    public String prepareResizeStatus(CmtModelNode node, Point location, Dimension size) {
        return Res.getString(34);
    }

    public void prepareResizeComponent(CmtModelNode node, SelectionEffects effects, SelectNib nib) {
    }

    private static int getConstraints(CmtModelNode node) {
        CmtSubcomponent sub = node != null ? node.getSubcomponent() : null;
        CmtPropertyState state = sub != null ? sub.getPropertyState("<Bconstraints>") : null;
        return SplitPaneLayoutAssistant.getConstraintsInt(state != null ? (String)state.getValue() : null);
    }

    private static void setConstraints(CmtModelNode node, int edge) {
        CmtSubcomponent sub = node.getSubcomponent();
        CmtPropertyState state = sub.getPropertyState("<Bconstraints>");
        state.setValueSource(SplitPaneLayoutAssistant.getConstraintsSource(edge));
    }

    public static String getConstraintsString(int edge) {
        if (edge >= 0 && edge <= EDGES.length) {
            return EDGES[edge];
        }
        return null;
    }

    public static String getConstraintsSource(int edge) {
        if (edge >= 0 && edge <= EDGES.length) {
            return EDGE_FIELDS[edge];
        }
        return null;
    }

    public static int getConstraintsInt(String edge) {
        if (edge != null) {
            if ("top".equals(edge)) {
                return 0;
            }
            if ("left".equals(edge)) {
                return 1;
            }
            if ("right".equals(edge)) {
                return 2;
            }
            if ("bottom".equals(edge)) {
                return 3;
            }
        }
        return -1;
    }

    private static int findBest(CmtModelNode node, CmtModelNode toNode, Point location, Dimension size) {
        int yAbsDiff;
        int cy;
        int constraint = -1;
        Iterator iter = toNode.getChildren();
        while (iter.hasNext()) {
            Object obj;
            CmtModelNode sibling = (CmtModelNode)iter.next();
            CmtSubcomponent sub = sibling.getSubcomponent();
            Object object = obj = sub != null ? sub.getLiveInstance() : null;
            if (!(obj instanceof Component)) continue;
            if (constraint == -1) {
                constraint = 3 - SplitPaneLayoutAssistant.getConstraints(sibling);
                continue;
            }
            constraint = -1;
            break;
        }
        if (constraint > -1 && constraint < 4) {
            return constraint;
        }
        Container container = toNode.getSubcomponent().getAsContainer();
        Dimension s = container.getSize();
        Insets i = container.getInsets();
        s.width -= i.left + i.right;
        s.height -= i.top + i.bottom;
        int cx = location != null ? location.x : 0;
        int n = cy = location != null ? location.y : 0;
        if (size != null) {
            cx += size.width / 2;
            cy += size.height / 2;
        }
        int centerX = s.width / 2 + i.left;
        int centerY = s.height / 2 + i.top;
        int xDiff = centerX - cx;
        int yDiff = centerY - cy;
        int xAbsDiff = xDiff > 0 ? xDiff : -xDiff;
        int n2 = yAbsDiff = yDiff > 0 ? yDiff : -yDiff;
        if ((float)yAbsDiff / (float)s.height > (float)xAbsDiff / (float)s.width) {
            if (yAbsDiff == yDiff) {
                return 0;
            }
            return 3;
        }
        if (xAbsDiff == xDiff) {
            return 1;
        }
        return 2;
    }

    public String constrainMove(CmtModelNode node, CmtModelNode toNode, Point mousePos, Point mouseOffset, Point newPos, Dimension newSize) {
        Container cont = toNode.getSubcomponent().getAsContainer();
        Insets insets = cont.getInsets();
        Dimension parentSize = cont.getSize();
        CmtSubcomponent sub = node.getSubcomponent();
        Component comp = (Component)sub.getLiveInstance();
        Dimension childSize = comp.getPreferredSize();
        int constraint = SplitPaneLayoutAssistant.findBest(node, toNode, mousePos, childSize);
        parentSize.width -= insets.left + insets.right;
        parentSize.height -= insets.top + insets.bottom;
        if (constraint == 0) {
            newPos.x = insets.left;
            newPos.y = insets.top;
            newSize.width = parentSize.width;
            newSize.height = (int)((float)parentSize.height / 2.0f);
        } else if (constraint == 3) {
            int height = parentSize.height;
            newSize.width = parentSize.width;
            newSize.height = (int)((float)height / 2.0f);
            newPos.x = insets.left;
            newPos.y = insets.top + height - newSize.height;
        } else if (constraint == 1) {
            newPos.x = insets.left;
            newPos.y = insets.top;
            newSize.width = (int)((float)parentSize.width / 2.0f);
            newSize.height = parentSize.height;
        } else if (constraint == 2) {
            int width = parentSize.width;
            newSize.width = (int)((float)width / 2.0f);
            newSize.height = parentSize.height;
            newPos.x = insets.left + width - newSize.width;
            newPos.y = insets.top;
        }
        return toNode.getName() + ": " + SplitPaneLayoutAssistant.getConstraintsString(constraint);
    }

    public static void setToEdge(CmtModelNode node, CmtModelNode toNode, int edge) {
        JSplitPane split = (JSplitPane)toNode.getSubcomponent().getAsContainer();
        Integer orientation = new Integer(edge == 0 || edge == 3 ? 0 : 1);
        try {
            CmtSubcomponent sub = toNode.getSubcomponent();
            CmtPropertyState ps = sub.getPropertyState("orientation");
            ps.setValue(orientation);
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
        Iterator children = toNode.getChildren();
        ArrayList<CmtModelNode> nodeChildren = new ArrayList<CmtModelNode>();
        int opposite = 3 - edge;
        while (children.hasNext()) {
            Object obj;
            CmtModelNode sibling = (CmtModelNode)children.next();
            CmtSubcomponent sub = sibling.getSubcomponent();
            Object object = obj = sub != null ? sub.getLiveInstance() : null;
            if (sibling == node || !(obj instanceof Component)) continue;
            nodeChildren.add(sibling);
        }
        int count = nodeChildren.size();
        switch (count) {
            case 0: {
                break;
            }
            case 1: {
                SplitPaneLayoutAssistant.setConstraints((CmtModelNode)nodeChildren.get(0), opposite);
                break;
            }
            default: {
                Iterator iter;
                int closeOpposite = edge < 2 ? edge + 2 : edge - 2;
                CmtModelNode candidate = null;
                int i = count - 1;
                while (i >= 0) {
                    CmtModelNode sibling = (CmtModelNode)nodeChildren.get(i);
                    int location = SplitPaneLayoutAssistant.getConstraints(sibling);
                    if (location == opposite) {
                        nodeChildren.remove(i);
                        candidate = null;
                        break;
                    }
                    if (location == closeOpposite) {
                        candidate = sibling;
                    }
                    --i;
                }
                if (candidate != null) {
                    SplitPaneLayoutAssistant.setConstraints(candidate, opposite);
                    nodeChildren.remove(candidate);
                }
                if ((iter = nodeChildren.iterator()) == null) break;
                while (iter.hasNext()) {
                    CmtModelNode sibling = (CmtModelNode)iter.next();
                    CmtModel model = sibling.getCmtModel();
                    CmtModelNode root = model.getRoot();
                    model.move(sibling, null, root, null);
                }
                break block1;
            }
        }
        SplitPaneLayoutAssistant.setConstraints(node, edge);
        split.invalidate();
        split.repaint();
    }

    final class SplitPaneConstraintsEditor
    implements PropertyEditor {
        private PropertyChangeListener listener;
        private String value;

        public void setValue(Object o) {
            String oldValue = this.value;
            this.value = (String)o;
            this.fire(oldValue, this.value);
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isPaintable() {
            return false;
        }

        public void paintValue(Graphics gfx, Rectangle box) {
        }

        public String getAsText() {
            return this.value;
        }

        public String getJavaInitializationString() {
            return SplitPaneLayoutAssistant.getConstraintsSource(SplitPaneLayoutAssistant.getConstraintsInt(this.value));
        }

        public void setAsText(String text) throws IllegalArgumentException {
            if (text != null) {
                String[] tags = this.getTags();
                int i = 0;
                while (i < tags.length) {
                    if (text.equals(tags[i])) {
                        this.value = text;
                        return;
                    }
                    ++i;
                }
            }
            throw new IllegalArgumentException(text);
        }

        public String[] getTags() {
            return EDGES;
        }

        public Component getCustomEditor() {
            return null;
        }

        public boolean supportsCustomEditor() {
            return false;
        }

        private void fire(Object oldValue, Object value) {
            if (this.listener != null) {
                this.listener.propertyChange(new PropertyChangeEvent(this, "<Bconstraints>", oldValue, value));
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.listener = l;
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.listener = null;
        }
    }
}

