/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.assistant;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.beans.PropertyEditor;
import java.util.Iterator;
import javax.swing.JTabbedPane;
import oracle.ide.Context;
import oracle.ide.explorer.Explorer;
import oracle.ide.util.Assert;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.uieditor.uicanvas.ConstraintsPropertyState;
import oracle.jdeveloper.uieditor.uicanvas.InnerAssistant;
import oracle.jdeveloper.uieditor.uicanvas.SelectNib;
import oracle.jdeveloper.uieditor.uicanvas.SelectionEffects;
import oracle.jdevimpl.propertyeditor.StringEditor;
import oracle.jdevimpl.uieditor.assistant.BasicLayoutAssistant;
import oracle.jdevimpl.uieditor.assistant.CardExplorer;
import oracle.jdevimpl.uieditor.assistant.Res;

public final class TabbedPaneLayoutAssistant
extends BasicLayoutAssistant
implements InnerAssistant {
    private static Explorer EXPLORER;

    public String getConstraintsType() {
        return "java.lang.String";
    }

    public PropertyEditor getPropertyEditor() {
        return new StringEditor();
    }

    public Explorer getConstraintsEditor(Context context) {
        Explorer explorer = TabbedPaneLayoutAssistant.getExplorer();
        explorer.setContext(context);
        return explorer;
    }

    private static synchronized Explorer getExplorer() {
        if (EXPLORER == null) {
            EXPLORER = new CardExplorer();
        }
        return EXPLORER;
    }

    private static String getConstraints(CmtModelNode child) {
        CmtSubcomponent sub = child.getSubcomponent();
        CmtPropertyState state = sub.getPropertyState("<Bconstraints>");
        return (String)state.getValue();
    }

    private static void setConstraints(CmtModelNode child, String name) {
        try {
            CmtSubcomponent sub = child.getSubcomponent();
            Object obj = sub.getLiveInstance();
            ConstraintsPropertyState state = (ConstraintsPropertyState)sub.getPropertyState("<Bconstraints>");
            state.setValue(name, false);
            JTabbedPane j = (JTabbedPane)((CmtModelNode)child.getParent()).getSubcomponent().getAsContainer();
            int index = j.indexOfComponent((Component)obj);
            if (index >= 0) {
                j.setTitleAt(index, name);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void prepareAddComponent(CmtModelNode node, CmtModelNode toNode, Point location, Point offset, Dimension size) {
        Container comp = toNode.getSubcomponent().getAsContainer();
        TabbedPaneLayoutAssistant.setConstraints(node, node.getName());
        TabbedPaneLayoutAssistant.removeBoundsSetting(node);
    }

    public String constrainMove(CmtModelNode node, CmtModelNode toNode, Point mousePos, Point mouseOffset, Point newPos, Dimension newSize) {
        Container cont = toNode.getSubcomponent().getAsContainer();
        Dimension parentSize = cont.getSize();
        Insets insets = cont.getInsets();
        newPos.x = insets.left;
        newPos.y = insets.top;
        newSize.width = parentSize.width - insets.left - insets.right;
        newSize.height = parentSize.height - insets.top - insets.bottom;
        return toNode + " z: " + this.calcBestZ(node, toNode, newPos, newSize, null);
    }

    public String prepareMouseMoveStatus(CmtModelNode node, CmtModelNode toNode, Point location) {
        return node == null ? toNode.toString() : node + ": " + TabbedPaneLayoutAssistant.getConstraints(node);
    }

    public void prepareResizeComponent(CmtModelNode node, SelectionEffects effects, SelectNib nib) {
    }

    public String prepareResizeStatus(CmtModelNode node, Point location, Dimension size) {
        return Res.getString(10);
    }

    public void cleanupRemovedComponent(CmtModelNode parent) {
        try {
            JTabbedPane container = (JTabbedPane)parent.getSubcomponent().getAsContainer();
            int index = container.getTabCount();
            Component[] c = new Component[index];
            int i = 0;
            while (i < index) {
                c[i] = container.getComponentAt(i);
                ++i;
            }
            Iterator iter = parent.getChildren();
            while (iter.hasNext()) {
                int i2;
                Object obj;
                CmtModelNode child = (CmtModelNode)iter.next();
                CmtSubcomponent sub = child.getSubcomponent();
                Object object = obj = sub != null ? sub.getLiveInstance() : null;
                if (!(obj instanceof Component) || (i2 = container.indexOfComponent((Component)obj)) < 0) continue;
                c[i2] = null;
            }
            int i3 = 0;
            while (i3 < index) {
                if (c[i3] != null) {
                    container.removeTabAt(i3);
                }
                ++i3;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void raiseChildToView(CmtModelNode parent, CmtModelNode node) {
        if (parent != null) {
            Container comp = parent.getSubcomponent().getAsContainer();
            try {
                CmtSubcomponent sub = node.getSubcomponent();
                Object obj = sub != null ? sub.getLiveInstance() : null;
                ((JTabbedPane)comp).setSelectedComponent((Component)obj);
            }
            catch (Exception e) {
                Assert.println((String)("Caught by TabbedPaneLayoutAssistant: " + e.getLocalizedMessage()));
            }
        }
    }
}

