/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.assistant;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.layout.VerticalFlowLayout;
import oracle.jdevimpl.uieditor.assistant.FlowLayoutAssistant;

public final class VerticalFlowLayoutAssistant
extends FlowLayoutAssistant {
    public String constrainMove(CmtModelNode node, CmtModelNode toNode, Point mousePos, Point mouseOffset, Point newPos, Dimension newSize) {
        Container cont = toNode.getSubcomponent().getAsContainer();
        Dimension parentSize = cont.getSize();
        Rectangle zBounds = new Rectangle(-1, -1, 1, 1);
        CmtSubcomponent sub = node.getSubcomponent();
        Component comp = (Component)sub.getLiveInstance();
        Dimension childSize = comp.getPreferredSize();
        int z = this.calcBestZ(node, toNode, mousePos, childSize, zBounds);
        if (zBounds.x == -1) {
            VerticalFlowLayout layout = (VerticalFlowLayout)cont.getLayout();
            Insets insets = cont.getInsets();
            int alignment = layout.getAlignment();
            int x = insets.left + layout.getHgap();
            int y = insets.top + layout.getVgap();
            switch (alignment) {
                case 1: {
                    y = insets.top + (parentSize.height - childSize.height - insets.top - insets.bottom) / 2;
                    break;
                }
                case 2: {
                    y = parentSize.height - childSize.height - insets.bottom;
                    break;
                }
            }
            zBounds.x = x;
            zBounds.y = y;
        }
        newPos.x = zBounds.x;
        newPos.y = zBounds.y;
        newSize.width = childSize.width;
        newSize.height = childSize.height;
        return toNode + " z: " + z;
    }

    protected int calcBestZ(CmtModelNode node, CmtModelNode toNode, Point location, Dimension size, Rectangle zBounds) {
        if (location == null) {
            location = new Point(Integer.MAX_VALUE, 0x7FFFFFF9);
        }
        int x = location.x;
        int y = location.y;
        int bestZ = 0;
        int myoldZ = -1;
        Iterator i = toNode.getChildren();
        while (i.hasNext()) {
            Object obj;
            CmtModelNode sibling = (CmtModelNode)i.next();
            CmtSubcomponent sub = sibling.getSubcomponent();
            Object object = obj = sub != null ? sub.getLiveInstance() : null;
            if (!(obj instanceof Component)) continue;
            Rectangle r = ((Component)obj).getBounds();
            if (zBounds != null && myoldZ != bestZ) {
                zBounds.x = r.x;
                zBounds.y = r.y + 6;
                zBounds.width = r.width;
                zBounds.height = r.height;
            }
            if (sibling != node) {
                if (x < r.x || x < r.x + r.width && y < r.y) {
                    if (zBounds == null || myoldZ == bestZ) break;
                    zBounds.y -= 12;
                    break;
                }
                if (zBounds != null && myoldZ == bestZ) {
                    zBounds.x = r.x;
                    zBounds.y = r.y + 6;
                    zBounds.width = r.width;
                    zBounds.height = r.height;
                }
                ++bestZ;
                continue;
            }
            if (zBounds != null) {
                zBounds.y -= 6;
            }
            myoldZ = bestZ;
        }
        return bestZ;
    }
}

