/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.assistant;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import oracle.ide.Context;
import oracle.ide.explorer.Explorer;
import oracle.ide.util.Assert;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.layout.XYConstraints;
import oracle.jdeveloper.uieditor.uicanvas.SelectNib;
import oracle.jdeveloper.uieditor.uicanvas.SelectionEffects;
import oracle.jdevimpl.uieditor.assistant.NullLayoutAssistant;
import oracle.jdevimpl.uieditor.assistant.XYConstraintsEditor;
import oracle.jdevimpl.uieditor.assistant.XYExplorer;

public final class XYLayoutAssistant
extends NullLayoutAssistant {
    private static Explorer EXPLORER = null;

    public XYLayoutAssistant() {
        this.useInsets = true;
    }

    public void prepareAddComponent(CmtModelNode node, CmtModelNode toNode, Point location, Point offset, Dimension size) {
        super.prepareAddComponent(node, toNode, location, offset, size);
        XYLayoutAssistant.removeBoundsSetting(node);
    }

    public void prepareMoveComponent(CmtModelNode node, CmtModelNode toNode, Point location, Point offset) {
        super.prepareMoveComponent(node, toNode, location, offset);
        XYLayoutAssistant.removeBoundsSetting(node);
    }

    public void prepareResizeComponent(CmtModelNode node, SelectionEffects effects, SelectNib nib) {
        super.prepareResizeComponent(node, effects, nib);
    }

    protected Dimension getPreferredSize(CmtModelNode node) {
        return new Dimension(-1, -1);
    }

    public void layoutChanged(CmtModelNode container) {
    }

    protected Rectangle getConstraints(CmtModelNode node) {
        CmtSubcomponent sub = node.getSubcomponent();
        CmtPropertyState state = sub.getPropertyState("<Bconstraints>");
        XYConstraints c = (XYConstraints)state.getValue();
        return new Rectangle(c.getX(), c.getY(), c.getWidth(), c.getHeight());
    }

    protected void setConstraints(CmtModelNode node, CmtModelNode toNode, Point pos, Dimension size) {
        try {
            XYConstraints c = size != null ? new XYConstraints(pos.x, pos.y, size.width, size.height) : new XYConstraints(pos.x, pos.y, -1, -1);
            CmtSubcomponent sub = node.getSubcomponent();
            CmtPropertyState state = sub.getPropertyState("<Bconstraints>");
            state.setValue(c);
        }
        catch (Exception ex) {
            Assert.printStackTrace((Throwable)ex);
        }
    }

    public String getConstraintsType() {
        return "oracle.jdeveloper.layout.XYConstraints";
    }

    public PropertyEditor getPropertyEditor() {
        return new XYConstraintsEditor();
    }

    public Explorer getConstraintsEditor(Context context) {
        Explorer explorer = XYLayoutAssistant.getExplorer();
        explorer.setContext(context);
        return explorer;
    }

    private static synchronized Explorer getExplorer() {
        if (EXPLORER == null) {
            EXPLORER = new XYExplorer();
        }
        return EXPLORER;
    }
}

