/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import oracle.ide.palette.PaletteItem;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.TransferDataInfo;
import oracle.jdeveloper.cmt.CmtModel;
import oracle.jdeveloper.uieditor.UIEditor;
import oracle.jdeveloper.uieditor.datatransfer.AbstractSingleFlavorOperation;
import oracle.jdeveloper.uieditor.datatransfer.DataAndPositions;
import oracle.jdeveloper.uieditor.datatransfer.UIPosition;
import oracle.jdevimpl.uieditor.UIEditorController;

public class CreateOperation
extends AbstractSingleFlavorOperation {
    private UIEditor _editor;

    public CreateOperation(UIEditor view) {
        this._editor = view;
    }

    protected List getApplicableDataAndPositionsImpl(CmtModel model, List positions, List dataInfos) {
        if (this._editor == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DataAndPositions> ret = new ArrayList<DataAndPositions>(dataInfos.size());
        for (TransferDataInfo info : dataInfos) {
            HashSet<UIPosition> alreadyUsed = new HashSet<UIPosition>(17);
            ArrayList<UIPosition> validPositions = new ArrayList<UIPosition>(positions.size());
            for (UIPosition pos : positions) {
                if (pos == null || !alreadyUsed.add(pos) || !pos.getModelNode().isContainer()) continue;
                validPositions.add(pos);
            }
            if (validPositions.isEmpty()) continue;
            validPositions.trimToSize();
            ret.add(new DataAndPositions(info, validPositions));
        }
        return ret;
    }

    public String getDisplayName(CmtModel model, TransferDataInfo info) {
        String result;
        String string = result = info == null ? null : (String)info.getMetadata(TransferDataInfo.METADATA_MEDIUM_DESCRIPTION);
        if (result == null) {
            return "Add Child";
        }
        return "Add " + result;
    }

    public float getSuitabilityRank() {
        return 0.9f;
    }

    public int getSupportedActions() {
        return 1;
    }

    public boolean apply(CmtModel model, UIPosition pos, TransferDataInfo data) throws IOException {
        PaletteItem item = (PaletteItem)data.getData(FetchMode.STANDARD, false);
        if (item == null) {
            return false;
        }
        try {
            UIEditorController.getInstance().addNode(this._editor, item.getLongLabel(), item.getInitializer(), item.getLibrary(), item.getTechnologyScope(), pos.getModelNode(), pos.getLocation(), null);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    protected DataFlavor getRequiredDataFlavor() {
        return PaletteItem.PALETTE_ITEM_FLAVOR;
    }
}

