/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultAttributes;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.palette.PaletteItem;

public class Palette1PaletteItem
implements PaletteItem {
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{PaletteItem.PALETTE_ITEM_FLAVOR, DataFlavor.stringFlavor};
    oracle.ide.palette2.PaletteItem palette2Item;
    private String initializer;
    private String shortLabel;
    private String longLabel;
    private Icon icon;

    public Palette1PaletteItem(oracle.ide.palette2.PaletteItem p2Item) {
        this.palette2Item = p2Item;
        this.setShortLabel(p2Item.getName());
        this.setLongLabel(p2Item.getDescription());
        this.setIcon(p2Item.getIcon());
        this.setInitializer((String)this.palette2Item.getData((Object)"info"));
    }

    public String getClassName() {
        String name = (String)this.palette2Item.getData((Object)"className");
        return name;
    }

    public String getClassPath() {
        String path = (String)this.palette2Item.getData((Object)"classPath");
        return path;
    }

    public String getLibrary() {
        String library = (String)this.palette2Item.getData((Object)"library");
        return library;
    }

    public String getInitializer() {
        return this.initializer;
    }

    private void setInitializer(String preInitializer) {
        try {
            if (preInitializer == null) {
                this.initializer = null;
            } else {
                int semiPos = preInitializer.indexOf(";");
                int lastBracket = preInitializer.indexOf("]");
                if (semiPos >= 0) {
                    this.initializer = preInitializer.substring(semiPos + 1, lastBracket);
                }
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }

    public boolean isPointer() {
        return false;
    }

    public boolean canShow() {
        return true;
    }

    public void setCanShow(boolean canShow) {
    }

    public String getEditor() {
        String editor = (String)this.palette2Item.getData((Object)"editor");
        return editor;
    }

    public void setEditor(String editor) {
    }

    public void setTechnologyScope(String techScope) {
    }

    public String getTechnologyScope() {
        String techScopes = null;
        List tscopes = (List)this.palette2Item.getData((Object)"technologyScopes");
        if (tscopes != null) {
            for (String scope : tscopes) {
                if (techScopes != null) {
                    techScopes = techScopes + ";";
                }
                techScopes = techScopes + scope;
            }
        }
        return techScopes;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor == DataFlavor.stringFlavor) {
            Transferable t = null;
            if (t == null) {
                return "";
            }
            return t.getTransferData(flavor);
        }
        if (this.isDataFlavorSupported(flavor)) {
            return this;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return FLAVORS;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (flavor == DataFlavor.stringFlavor) {
            return true;
        }
        return PaletteItem.PALETTE_ITEM_FLAVOR == flavor;
    }

    public boolean isResetItem() {
        return false;
    }

    public boolean hasItem() {
        return false;
    }

    public String getItemIcon() {
        return null;
    }

    public void setItemIcon(String icon) {
    }

    public String getItemShortLabel() {
        return null;
    }

    public void setItemShortLabel(String shortLabel) {
    }

    public String getItemLongLabel() {
        return null;
    }

    public void setItemLongLabel(String longLabel) {
    }

    public String getItemInfo() {
        return null;
    }

    public void setItemInfo(String info) {
    }

    public String getItemType() {
        return null;
    }

    public void setItemType(String type) {
    }

    public float getItemWeight() {
        return 0.0f;
    }

    public void setItemWeight(float weight) {
    }

    public String getItemEditor() {
        return null;
    }

    public void setItemEditor(String editor) {
    }

    public String getItemLibrary() {
        return null;
    }

    public void setItemLibrary(String library) {
    }

    public String getItemBeanInfo() {
        return null;
    }

    public void setItemBeanInfo(String beanInfo) {
    }

    public String getItemCodeSnippet() {
        return null;
    }

    public void setItemCodeSnippet(String s) {
    }

    public boolean getItemIsPersistent() {
        return false;
    }

    public void setItemIsPersistent(boolean persist) {
    }

    public String getItemHelpable() {
        return null;
    }

    public void setItemHelpable(String help) {
    }

    public String getItemProjectConfiguration() {
        return null;
    }

    public void setItemProjectConfiguration(String projectConfiguration) {
    }

    public String getItemTechnologyScope() {
        return null;
    }

    public void setItemTechnologyScope(String techScope) {
    }

    public boolean getItemCanRemove() {
        return false;
    }

    public void setItemCanRemove(boolean cr) {
    }

    public void attach(Observer observer) {
    }

    public void detach(Observer observer) {
    }

    public void notifyObservers(Object object, UpdateMessage change) {
    }

    public boolean mayHaveChildren() {
        return false;
    }

    public Iterator getChildren() {
        return null;
    }

    public Attributes getAttributes() {
        return DefaultAttributes.EMPTY_ATTRIBUTES;
    }

    public Object getData() {
        return null;
    }

    public String getShortLabel() {
        return this.shortLabel;
    }

    public String getLongLabel() {
        return this.longLabel;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setShortLabel(String shortLabel) {
        this.shortLabel = shortLabel;
    }

    public void setLongLabel(String longLabel) {
        this.longLabel = longLabel;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public String getToolTipText() {
        return this.getShortLabel();
    }
}

