/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.menucanvas;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import oracle.ide.util.Assert;
import oracle.jdevimpl.uieditor.menucanvas.EditMenuItem;
import oracle.jdevimpl.uieditor.menucanvas.EditPopupMenu;
import oracle.jdevimpl.uieditor.menucanvas.InsertMenu;
import oracle.jdevimpl.uieditor.menucanvas.Item;
import oracle.jdevimpl.uieditor.menucanvas.MenuDesignerContainer;
import oracle.jdevimpl.uieditor.menucanvas.MenuEvent;
import oracle.jdevimpl.uieditor.menucanvas.MenuNode;
import oracle.jdevimpl.uieditor.menucanvas.MoveItem;
import oracle.jdevimpl.uieditor.menucanvas.PersistentItem;
import oracle.jdevimpl.uieditor.menucanvas.Popup;
import oracle.jdevimpl.uieditor.menucanvas.Res;

final class EditMenuBar
extends JPanel
implements MenuDesignerContainer,
PersistentItem {
    private Vector items;
    private MenuDesignerContainer container;
    private boolean readOnly;
    private MenuNode menuNode;

    private void $init$() {
        this.items = new Vector();
        this.readOnly = false;
    }

    EditMenuBar(MenuDesignerContainer container) {
        Font font;
        this.$init$();
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.container = container;
        if (container != null) {
            this.readOnly = container.isReadOnly();
        }
        this.setLayout(new BoxLayout(this, 2));
        Color color = (Color)UIManager.get("Menubar.background");
        if (color != null) {
            this.setBackground(color);
        }
        if ((font = (Font)UIManager.get("Menubar.font")) != null) {
            this.setFont(font);
        }
    }

    public Item getParentItem() {
        return null;
    }

    private void hideAll() {
        Enumeration e = this.items.elements();
        while (e.hasMoreElements()) {
            EditMenuItem item = (EditMenuItem)e.nextElement();
            if (item.popup == null) continue;
            item.popup.hideAll(true);
        }
    }

    public void bind(PersistentItem parent, MenuDesignerContainer container, boolean toplevel) {
        if (this.container != null) {
            this.container.removeComponent(this);
        }
        this.container = container;
        this.readOnly = container.isReadOnly();
        Enumeration e = this.items.elements();
        while (e.hasMoreElements()) {
            EditMenuItem item = (EditMenuItem)e.nextElement();
            item.bind(null, this, true);
            this.addComponent((Component)((Object)item.getPopup()));
        }
        container.addComponent(this);
    }

    public MenuNode getMenuNode() {
        return this.menuNode;
    }

    public void setSubcomponent(MenuNode menuNode) {
        this.menuNode = menuNode;
    }

    public MenuDesignerContainer getContainer() {
        return this.container;
    }

    public void setPositions() {
    }

    public void select(Item target, boolean setFocus) {
        this.insertBlank();
        this.container.select(target, setFocus);
    }

    public void goUp() {
        Item item = this.getSelectedItem();
        if (item != null && item.getPopup() != null) {
            item.getPopup().setFocus(true);
        }
    }

    public void goDown(boolean wrap) {
        EditMenuItem item = (EditMenuItem)this.getSelectedItem();
        if (item != null) {
            while (item.parent != null) {
                item = item.parent;
            }
            if (item.popup != null) {
                item.popup.setFocus(false);
            }
        }
    }

    public void goLeft() {
        EditMenuItem item = (EditMenuItem)this.getSelectedItem();
        if (item != null) {
            int i;
            while (item.parent != null) {
                item = item.parent;
            }
            if (item != null && this.items.contains(item) && (i = this.items.indexOf(item)) > 0) {
                this.select((Item)this.items.elementAt(i - 1), true);
            }
        }
    }

    public void goRight() {
        EditMenuItem item = (EditMenuItem)this.getSelectedItem();
        if (item != null) {
            int i;
            while (item.parent != null) {
                item = item.parent;
            }
            if (item != null && this.items.contains(item) && (i = this.items.indexOf(item)) < this.items.size() - 1) {
                this.select((Item)this.items.elementAt(i + 1), true);
            }
        }
    }

    public Item getSelectedItem() {
        return this.container.getSelectedItem();
    }

    public void addComponent(Component component) {
        this.container.addComponent(component);
    }

    public void removeComponent(Component component) {
        this.container.removeComponent(component);
    }

    public void addItem(Component component) {
    }

    public void calcSize(Component component) {
    }

    public void endEdit(Item target) {
        this.insertBlank();
    }

    public void insertItem(Item target) {
        int i = this.items.indexOf(target);
        if (i != -1) {
            EditMenuItem item = new EditMenuItem(null, this);
            item.bind(null, this, true);
            this.add(item);
            this.items.insertElementAt(item, i);
            item.popup = new EditPopupMenu(item, this);
            item.popup.insertBlank();
            this.addComponent(item.popup.getComponent());
            this.notify(new InsertMenu(this, item, (EditMenuItem)target));
        }
    }

    public void deleteItem(Item target, boolean focus) {
        int i = this.items.indexOf(target);
        if (i != -1 && this.items.size() > 1 && i != this.items.size() - 1) {
            Component c = target.getComponent();
            focus = focus || c != null && c.hasFocus();
            this.remove(target.getComponent());
            this.items.removeElement(target);
            this.getLayout().layoutContainer(this);
            EditMenuItem item = (EditMenuItem)this.items.elementAt(i);
            this.container.select(item, focus);
        }
    }

    public void blank() {
        this.empty();
        this.insertBlank();
    }

    private void empty() {
        int i = 0;
        while (i < this.items.size()) {
            EditMenuItem item = (EditMenuItem)this.items.elementAt(i);
            item.setVisible(false);
            try {
                item.trash();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        this.items.removeAllElements();
    }

    public Item construct(MenuDesignerContainer hostContainer, MenuNode menuNode) {
        this.menuNode = menuNode;
        this.container.register(this, menuNode);
        this.empty();
        Iterator i = menuNode.getChildren();
        if (i != null) {
            while (i.hasNext()) {
                Object obj = i.next();
                if (!(obj instanceof MenuNode)) continue;
                MenuNode child = (MenuNode)obj;
                EditMenuItem item = new EditMenuItem(null, this);
                item.construct(hostContainer, child);
                item.bind(null, this, true);
                this.items.addElement(item);
                item.popup = new EditPopupMenu(item, this);
                this.add(item);
                item.popup.construct(hostContainer, child);
            }
        }
        return null;
    }

    public Popup createEditPopupMenu(Item parent, MenuDesignerContainer container) {
        return this.container.createEditPopupMenu(parent, container);
    }

    public Item createEditMenuItem(Item parent, MenuDesignerContainer container) {
        return this.container.createEditMenuItem(parent, container);
    }

    public Item createEditMenuItemSeperator(Item parent, MenuDesignerContainer container) {
        return this.container.createEditMenuItemSeperator(parent, container);
    }

    public void insertSeperator(Item target) {
    }

    public void trash() {
        Enumeration en = this.items.elements();
        while (en.hasMoreElements()) {
            EditMenuItem item = (EditMenuItem)en.nextElement();
            item.setVisible(false);
            try {
                item.trash();
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
        this.setVisible(false);
        this.container.removeComponent(this);
    }

    public void setFocus(boolean selectLast) {
        if (this.items.size() != 0) {
            this.container.select((Item)this.items.elementAt(selectLast ? this.items.size() - 1 : 0), true);
        }
    }

    public void removeBlankItems() {
        Enumeration en = this.items.elements();
        while (en.hasMoreElements()) {
            Item item = (Item)en.nextElement();
            if (item.isBlank()) {
                this.remove(item.getComponent());
                this.items.removeElement(item);
                continue;
            }
            item.removeBlankItems();
        }
    }

    public void insertBlank() {
        if (!this.readOnly) {
            boolean needBlank = true;
            if (this.items.size() > 0) {
                Item last = (Item)this.items.elementAt(this.items.size() - 1);
                needBlank = last.isBlank() ^ true;
            }
            if (needBlank) {
                EditMenuItem item = new EditMenuItem(null, this);
                item.bind(null, this, true);
                this.items.addElement(item);
                this.add(item);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void moveItem(Item source, Item destination, boolean notify) {
        block15: {
            block13: {
                block14: {
                    sourceIndex = this.items.indexOf(source);
                    destinationIndex = this.items.indexOf(destination);
                    this.hideAll();
                    this.container.select(null, false);
                    if (sourceIndex == -1) break block13;
                    if (destinationIndex == -1) break block14;
                    if (sourceIndex == destinationIndex) break block15;
                    if (destinationIndex != sourceIndex + 1) ** GOTO lbl22
                    if (destination != null && !destination.isBlank()) {
                        this.remove(source.getComponent());
                        this.add(source.getComponent(), destinationIndex);
                        this.items.removeElement(source);
                        this.items.insertElementAt(source, destinationIndex);
                        tmp = source;
                        source = destination;
                        destination = tmp;
                    } else {
                        this.container.select(source, true);
                        return;
lbl22:
                        // 1 sources

                        if (sourceIndex < destinationIndex) {
                            --destinationIndex;
                        }
                        this.remove(source.getComponent());
                        this.add(source.getComponent(), destinationIndex);
                        this.items.removeElement(source);
                        this.items.insertElementAt(source, destinationIndex);
                    }
                    if (notify) {
                        this.notify(new MoveItem(source, this.menuNode, destination.getMenuNode()));
                    }
                    this.container.select(source, true);
                    break block15;
                }
                if (!destination.isToplevel()) {
                    p = (EditMenuItem)destination;
                    while (p != null && !p.isToplevel()) {
                        p = p.parent;
                    }
                    if (p == source) {
                        this.messageBox(Res.getString(14), Res.getString(7), 0);
                        this.container.select(source, true);
                        return;
                    }
                }
                this.remove(source.getComponent());
                this.items.removeElement(source);
                destination.getContainer().moveItem(source, destination, notify);
                break block15;
            }
            source.bind(null, this, true);
            if (destination == null) {
                this.add(source.getComponent());
                this.items.addElement(source);
            } else {
                this.add(source.getComponent(), destinationIndex);
                this.items.insertElementAt(source, destinationIndex);
            }
            if (source.getPopup() == null) {
                ((EditMenuItem)source).popup = new EditPopupMenu(source, this);
            }
            if (!this.readOnly && source.getPopup() != null) {
                source.getPopup().insertBlank();
            }
            if (source.getPopup() != null) {
                this.validate();
                ((EditPopupMenu)source.getPopup()).setPositions();
                source.getPopup().hideAll(true);
                this.addComponent(source.getPopup().getComponent());
            }
            if (notify) {
                this.notify(new MoveItem(source, this.menuNode, destination != null ? destination.getMenuNode() : null));
            }
        }
    }

    public void deletePopup(Item popup) {
    }

    public Component getComponent() {
        return this;
    }

    public void move(int x, int y) {
        Dimension dim = this.getPreferredSize();
        super.setBounds(x, y, dim.width, dim.height);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public Object clone() {
        return new EditMenuBar(this);
    }

    public void notify(MenuEvent evt) {
        this.container.notify(evt);
    }

    public Item hitTest(int x, int y) {
        return this.container.hitTest(x, y);
    }

    public Item itemAt(int x, int y) {
        Rectangle thisBound = this.getBounds();
        int xAdjusted = x - thisBound.x;
        int yAdjusted = y - thisBound.y;
        int i = 0;
        while (i < this.items.size()) {
            Item item = (Item)this.items.elementAt(i);
            if (((Component)((Object)item)).getBounds().contains(xAdjusted, yAdjusted)) {
                return item;
            }
            Popup p = item.getPopup();
            if (p != null && (item = ((MenuDesignerContainer)((Object)p)).itemAt(x, y)) != null) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public JTextField getTextField(EditMenuItem item) {
        return this.container.getTextField(item);
    }

    public int messageBox(String title, String text, int modifiers) {
        return this.container.messageBox(title, text, modifiers);
    }

    public void register(Object item, MenuNode menuNode) {
        this.container.register(item, menuNode);
    }

    public boolean isDeletable(Item item) {
        return (item.isBlank() && item == this.items.elementAt(this.items.size() - 1)) ^ true;
    }

    public void showContextMenu(MouseEvent e) {
        this.container.showContextMenu(e);
    }
}

