/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.menucanvas;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import javax.swing.UIManager;
import oracle.ide.util.Assert;
import oracle.javatools.util.SwingUtils;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdevimpl.uieditor.menucanvas.CheckMenuNode;
import oracle.jdevimpl.uieditor.menucanvas.CheckedChanged;
import oracle.jdevimpl.uieditor.menucanvas.ConvertToMenu;
import oracle.jdevimpl.uieditor.menucanvas.ConvertToMenuItem;
import oracle.jdevimpl.uieditor.menucanvas.DeleteItem;
import oracle.jdevimpl.uieditor.menucanvas.EditMenuItemImages;
import oracle.jdevimpl.uieditor.menucanvas.EditMenuItemSeperator;
import oracle.jdevimpl.uieditor.menucanvas.EditPopupMenu;
import oracle.jdevimpl.uieditor.menucanvas.EnabledChanged;
import oracle.jdevimpl.uieditor.menucanvas.FocusChange;
import oracle.jdevimpl.uieditor.menucanvas.Item;
import oracle.jdevimpl.uieditor.menucanvas.MenuDesigner;
import oracle.jdevimpl.uieditor.menucanvas.MenuDesignerContainer;
import oracle.jdevimpl.uieditor.menucanvas.MenuEvent;
import oracle.jdevimpl.uieditor.menucanvas.MenuNode;
import oracle.jdevimpl.uieditor.menucanvas.NewItem;
import oracle.jdevimpl.uieditor.menucanvas.NewMenu;
import oracle.jdevimpl.uieditor.menucanvas.NewPopup;
import oracle.jdevimpl.uieditor.menucanvas.PersistentItem;
import oracle.jdevimpl.uieditor.menucanvas.Popup;
import oracle.jdevimpl.uieditor.menucanvas.Res;
import oracle.jdevimpl.uieditor.menucanvas.TextChanged;

class EditMenuItem
extends JComponent
implements Item,
MenuDesignerContainer,
KeyListener,
MouseListener,
MouseMotionListener,
Accessible,
PropertyChangeListener {
    public static final int menuItemHeight = 20;
    public static final int menuItemWidth = 60;
    public static final int menuItemMargin = 4;
    public static final int menuItemSeperatorHeight = 8;
    static Item previousHit = null;
    static FocusChange focusChangeEvent = new FocusChange();
    protected String label;
    protected boolean checked;
    protected boolean disabled;
    protected boolean blank;
    protected boolean dead;
    protected boolean selected;
    protected boolean editing;
    protected boolean ignoreKeyTyped;
    protected boolean toplevel;
    protected Popup popup;
    protected static EditMenuItem dragSource;
    protected EditMenuItem parent;
    protected MenuDesignerContainer container;
    protected boolean readOnly;
    protected JMenuItem insertMenuitem;
    protected JMenuItem insertSeperator;
    protected JMenuItem insertPopup;
    protected JMenuItem enableMenuitem;
    protected JMenuItem checkMenuitem;
    protected MenuNode menuNode;
    protected TextFieldKeyListener keyListener;
    protected boolean deletedFromHere;
    protected JTextField tf;

    private void $init$() {
        this.checked = false;
        this.disabled = false;
        this.blank = true;
        this.dead = false;
        this.selected = false;
        this.editing = false;
        this.ignoreKeyTyped = true;
        this.toplevel = false;
        this.keyListener = new TextFieldKeyListener(this);
        this.deletedFromHere = false;
    }

    EditMenuItem(Item parent, MenuDesignerContainer container) {
        this.$init$();
        Font font = (Font)UIManager.get("MenuItem.font");
        if (font != null) {
            this.setFont(font);
        }
        this.parent = (EditMenuItem)parent;
        this.container = container;
        if (container != null) {
            this.readOnly = container.isReadOnly();
        }
        this.blank = true;
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    EditMenuItem(EditMenuItem copy) {
        this.$init$();
        Font font = (Font)UIManager.get("MenuItem.font");
        if (font != null) {
            this.setFont(font);
        }
        this.parent = null;
        this.container = null;
        if (copy.label != null) {
            this.label = new String(copy.label);
        }
        this.setChecked(copy.checked);
        this.disabled = copy.disabled;
        if (copy.popup != null) {
            this.popup = (Popup)copy.popup.clone();
        }
        this.blank = false;
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public final void setMenuNode(MenuNode menuNode) {
        this.construct(this.getContainer(), menuNode);
    }

    public final MenuNode getMenuNode() {
        return this.menuNode;
    }

    public final MenuDesignerContainer getContainer() {
        return this.container;
    }

    public final void setVisible(boolean visible) {
        if (visible) {
            super.setVisible(visible);
        } else {
            if (this.popup != null) {
                this.popup.setVisible(false);
            }
            boolean needCommit = this.endEdit(true);
            super.setVisible(visible);
            if (needCommit) {
                this.commit();
            }
        }
    }

    public void paintComponent(Graphics g) {
        Color fC;
        Color bC;
        Rectangle b = this.getBounds();
        Insets i = this.getInsets();
        Rectangle r = new Rectangle(b.x + i.left, b.y + i.top, b.width - i.left - i.right, b.height - i.top - i.bottom);
        Color color = (Color)UIManager.get("MenuItem.background");
        if (color == null) {
            color = (Color)UIManager.get("menu");
        }
        if (color == null) {
            color = this.getBackground();
        }
        g.setColor(color);
        g.fillRect(r.x, r.y, r.width, r.height);
        if (this.selected) {
            bC = (Color)UIManager.get("MenuItem.selectionBackground");
            fC = (Color)UIManager.get("MenuItem.selectionForeground");
            if (bC == null || fC == null) {
                bC = (Color)UIManager.get("textHighlight");
                fC = (Color)UIManager.get("textHighlightText");
            }
            if (bC == null || fC == null) {
                bC = SystemColor.textHighlight;
                fC = SystemColor.textHighlightText;
            }
        } else {
            bC = (Color)UIManager.get("MenuItem.background");
            fC = (Color)UIManager.get("MenuItem.foreground");
            if (bC == null || fC == null) {
                bC = (Color)UIManager.get("menu");
                fC = (Color)UIManager.get("menuText");
            }
            if (bC == null || fC == null) {
                bC = this.getBackground();
                fC = this.getForeground();
            }
        }
        g.setColor(bC);
        g.fillRect(0, 0, r.width, r.height);
        if (this.label == null) {
            g.setColor(fC);
            EditMenuItem.drawFocusRect(g, 4, 4, r.width - 8, r.height - 8);
        }
        Image image = EditMenuItemImages.checkImageSelected;
        if (this.checked) {
            image = !this.disabled ? (this.selected ? EditMenuItemImages.checkImageSelected : EditMenuItemImages.checkImageUnselected) : EditMenuItemImages.checkImageDisabled;
            g.drawImage(image, 0, (r.height - image.getHeight(this)) / 2, this);
        }
        if (this.label != null) {
            if (this.disabled) {
                color = (Color)UIManager.get("MenuItem.disabledForeground");
                if (color == null && (color = (Color)UIManager.get("textInactiveText")) == null) {
                    color = SystemColor.textInactiveText;
                }
                fC = this.selected ? color.brighter() : color;
            }
            g.setFont(this.getFont());
            FontMetrics fm = g.getFontMetrics();
            int height = fm.getAscent();
            int x = 4 + (!this.isToplevel() ? image.getWidth(this) : 0);
            int y = height + (this.getBounds().height - height) / 2;
            if (this.disabled && !this.selected) {
                color = (Color)UIManager.get("controlShadow");
                if (color == null) {
                    color = SystemColor.controlShadow;
                }
                g.setColor(color);
                SwingUtils.drawString((Graphics)g, (String)this.label, (int)x, (int)y);
                color = (Color)UIManager.get("controlLtHighlight");
                if (color == null) {
                    color = SystemColor.controlLtHighlight;
                }
                g.setColor(color);
                SwingUtils.drawString((Graphics)g, (String)this.label, (int)(x + 1), (int)(y + 1));
            } else {
                g.setColor(fC);
                SwingUtils.drawString((Graphics)g, (String)this.label, (int)x, (int)y);
            }
        }
        if (!this.isToplevel() && this.popup != null && EditMenuItemImages.popupImageUnselected != null) {
            image = this.selected ? EditMenuItemImages.popupImageSelected : EditMenuItemImages.popupImageUnselected;
            g.drawImage(image, r.width - image.getWidth(this), (r.height - image.getHeight(this)) / 2, this);
        }
    }

    public final void setSelected(boolean selected, Item previous, boolean setFocus) {
        this.selected = selected;
        if (selected) {
            this.closePrevious(previous);
            this.makeVisible(true);
            if (!this.readOnly && this.toplevel && this.popup != null) {
                this.popup.insertBlank();
            }
            if (this.popup != null) {
                this.openPopup(false);
            }
            if (setFocus) {
                this.requestFocus();
            }
        } else if (this.tf != null && this.endEdit(true)) {
            this.commit();
            return;
        }
        this.repaint();
    }

    protected final void makeVisible(boolean visible) {
        EditMenuItem item = this.parent;
        ArrayList<Popup> menuChain = new ArrayList<Popup>();
        while (item != null) {
            if (item != null && item.popup != null) {
                menuChain.add(item.popup);
            }
            item = item.parent;
        }
        int i = menuChain.size() - 1;
        while (i > -1) {
            Popup popup = (Popup)menuChain.get(i);
            item = (EditMenuItem)popup.getParentItem();
            item.adjustPopup();
            popup.setVisible(visible);
            --i;
        }
    }

    protected final void closePrevious(Item previous) {
        ArrayList keepOpen = new ArrayList();
        Item item = previous;
        while (item != null) {
            if (item.getPopup() != null) {
                item.getPopup().setVisible(false);
            }
            item = item.getParentItem();
        }
    }

    public Dimension getPreferredSize() {
        int width = 60;
        int height = 20;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        height = 4 + fm.getHeight() + 1 + 2;
        if (this.label != null) {
            width = 8 + fm.stringWidth(this.label);
            if (!this.isToplevel()) {
                width += EditMenuItemImages.checkImageSelected.getWidth(this);
                if (this.popup != null) {
                    width += EditMenuItemImages.popupImageSelected.getWidth(this) + 4;
                }
            }
        }
        return new Dimension(width, height);
    }

    public final void mouseClicked(MouseEvent e) {
    }

    public final void mousePressed(MouseEvent e) {
        dragSource = null;
        this.container.select(this, true);
        if (this.dead) {
            return;
        }
        this.notifyFocusChange();
        if (this.tryPopup(e)) {
            return;
        }
    }

    private boolean tryPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showContextMenu(e);
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public final void mouseReleased(MouseEvent e) {
        if (this.dead) {
            return;
        }
        if (EditMenuItem.dragSource == null) {
            if (this.tryPopup(e)) {
                return;
            }
            if (!this.readOnly && e.getClickCount() == 2) {
                this.startEdit(false);
            }
            return;
        }
        try {
            block16: {
                x = e.getX();
                y = e.getY();
                r = this.getBounds();
                r.x += (short)x;
                r.y += (short)y;
                this.getContainerRect(r);
                dest = (EditMenuItem)this.hitTest(r.x, r.y);
                if (dest == null || EditMenuItem.dragSource == dest || this.readOnly) break block16;
                if (EditMenuItem.dragSource.isBlank()) {
                    this.messageBox(Res.getString(14), Res.getString(25), 0);
                    this.container.select(EditMenuItem.dragSource, true);
                    return;
                }
                try {
                    if (EditMenuItem.dragSource.getContainer() != dest.getContainer()) {
                        dest.select(EditMenuItem.dragSource, false);
                    }
                    EditMenuItem.dragSource.moveItem(EditMenuItem.dragSource, dest, true);
                    EditMenuItem.dragSource = null;
                    EditMenuItem.previousHit = null;
                    return;
                }
                catch (Exception ex) {
                    Assert.printStackTrace((Throwable)ex);
                    ** break block17
                }
            }
            this.container.select(EditMenuItem.dragSource, true);
lbl-1000:
            // 2 sources

            {
                if (this.readOnly && this.parent == null && this.popup != null) {
                    this.openPopup(false);
                }
                this.notifyFocusChange();
            }
        }
        finally {
            EditMenuItem.dragSource = null;
            EditMenuItem.previousHit = null;
        }
    }

    public final void mouseMoved(MouseEvent e) {
    }

    public final void mouseDragged(MouseEvent e) {
        this.endEdit(false);
        dragSource = this;
        Rectangle r = this.getBounds();
        r.x += (short)e.getX();
        r.y += (short)e.getY();
        this.getContainerRect(r);
        Item hit = this.container.hitTest(r.x, r.y);
        if (hit != null && hit != previousHit) {
            this.container.select(hit, false);
            previousHit = hit;
        }
    }

    public final void mouseEntered(MouseEvent e) {
        if (dragSource != null) {
            this.container.select(this, false);
        }
    }

    public final void mouseExited(MouseEvent e) {
    }

    public final void toggleEnable() {
        this.disabled ^= true;
        this.repaint();
        this.notify(new EnabledChanged(this));
    }

    public final void toggleCheck() {
        if (this.popup == null) {
            this.setChecked(this.checked ^ true);
            this.repaint();
            this.notify(new CheckedChanged(this, this.checked));
        }
    }

    private static void drawDashedLine(Graphics g, int x0, int y0, int x1, int y1) {
        block3: {
            block2: {
                if (x0 != x1) break block2;
                int y = y0;
                while (y < y1) {
                    g.drawLine(x0, y, x0, y);
                    y += 2;
                }
                break block3;
            }
            if (y0 != y1) break block3;
            int x = x0;
            while (x < x1) {
                g.drawLine(x, y0, x, y0);
                x += 2;
            }
        }
    }

    protected static final void drawFocusRect(Graphics g, int x, int y, int w, int h) {
        EditMenuItem.drawDashedLine(g, x, y, x + w, y);
        EditMenuItem.drawDashedLine(g, x + w, y, x + w, y + h);
        EditMenuItem.drawDashedLine(g, x, y + h, x + w, y + h);
        EditMenuItem.drawDashedLine(g, x, y, x, y + h);
    }

    private void startEdit(boolean clear) {
        if (this instanceof EditMenuItemSeperator) {
            return;
        }
        this.tf = this.container.getTextField(this);
        if (!clear && this.label != null) {
            this.tf.setText(this.label);
            this.tf.select(0, this.label.length());
        } else {
            this.tf.setText("");
        }
        Rectangle myBounds = this.getBounds();
        Rectangle containerBounds = ((Component)((Object)this.container)).getBounds();
        this.tf.setLocation(myBounds.x + containerBounds.x - 1, myBounds.y + containerBounds.y - 1);
        this.tf.setPreferredSize(new Dimension(myBounds.width + 2, myBounds.height + 2));
        this.container.addComponent(this.tf);
        this.tf.setVisible(true);
        this.tf.getParent().getLayout().layoutContainer(this.tf.getParent());
        this.tf.addKeyListener(this.keyListener);
        this.tf.requestFocus();
    }

    private void processEdit(char key) {
        if (this instanceof EditMenuItemSeperator) {
            return;
        }
        char[] b = new char[]{key};
        if (this.tf == null) {
            this.tf = this.container.getTextField(this);
            this.tf.setText(key != '\u0000' ? new String(b) : this.label);
            Rectangle myBounds = this.getBounds();
            Rectangle containerBounds = ((Component)((Object)this.container)).getBounds();
            this.tf.setLocation(myBounds.x + containerBounds.x - 1, myBounds.y + containerBounds.y - 1);
            this.tf.setPreferredSize(new Dimension(myBounds.width + 2, myBounds.height + 2));
            this.container.addComponent(this.tf);
            this.tf.setVisible(true);
            this.tf.getParent().getLayout().layoutContainer(this.tf.getParent());
            this.tf.addKeyListener(this.keyListener);
            this.tf.requestFocus();
        } else {
            this.tf.setText(this.tf.getText() + new String(b));
        }
    }

    protected final boolean endEdit(boolean commit) {
        boolean needCommit = false;
        if (this instanceof EditMenuItemSeperator) {
            return needCommit;
        }
        if (this.tf != null) {
            String value = this.tf.getText();
            this.tf.setVisible(false);
            this.tf.removeKeyListener(this.keyListener);
            if (!(!commit || this.readOnly || this.isBlank() && value.length() == 0 || value.equals(this.label))) {
                this.setLabel(this.tf.getText());
                needCommit = true;
                this.editing = true;
            }
            this.tf = null;
        }
        if (!this.readOnly && this.editing) {
            this.container.endEdit(this);
            this.editing = false;
        }
        return needCommit;
    }

    protected final void commit() {
        if (this.parent != null && this.parent.getMenuNode() == null) {
            this.parent.commit();
        }
        if (this.menuNode == null && this.blank) {
            this.blank = false;
            if (this.getContainer() instanceof Popup) {
                this.notify(new NewItem((Popup)((Object)this.getContainer()), this));
            } else {
                this.popup = new EditPopupMenu(this, this.getContainer());
                this.popup.insertBlank();
                this.getContainer().addComponent(this.popup.getComponent());
                this.notify(new NewMenu(this));
            }
        } else {
            this.notify(new TextChanged(this));
        }
        this.invalidate();
        this.validate();
    }

    public final void delete(boolean notify, boolean getFocus) {
        if (notify && this.isBlank() && this.menuNode == null) {
            this.container.deleteItem(this, getFocus);
            return;
        }
        if (notify) {
            if (this.menuNode != null) {
                this.notify(new DeleteItem(this));
            }
        } else {
            this.container.deleteItem(this, this.deletedFromHere);
            this.notifyFocusChange();
        }
    }

    public final void insertItem() {
        this.insertItem(this);
    }

    public final void insertSeperator() {
        this.insertSeperator(this);
    }

    public void keyPressed(KeyEvent e) {
        this.ignoreKeyTyped = false;
        if (e.isConsumed()) {
            return;
        }
        if (e.isAltDown() && e.getKeyCode() == 117) {
            e.consume();
        }
        if (!e.isAltDown()) {
            switch (e.getKeyCode()) {
                case 37: {
                    this.endEdit(false);
                    if (this.parent != null && !this.isToplevel()) {
                        this.container.select(this.parent, true);
                    } else {
                        this.container.goLeft();
                    }
                    e.consume();
                    this.notifyFocusChange();
                    break;
                }
                case 39: {
                    this.endEdit(false);
                    e.consume();
                    if (!this.readOnly && e.getModifiers() == 2 && this.popup == null && !this.isBlank()) {
                        this.insertPopup();
                        return;
                    }
                    if (this.isToplevel()) {
                        this.container.goRight();
                    } else {
                        this.openPopup(true);
                    }
                    this.notifyFocusChange();
                    break;
                }
                case 38: {
                    this.endEdit(false);
                    this.container.goUp();
                    e.consume();
                    this.notifyFocusChange();
                    break;
                }
                case 40: {
                    this.endEdit(false);
                    this.container.goDown(true);
                    e.consume();
                    this.notifyFocusChange();
                    break;
                }
                case 155: {
                    e.consume();
                    if (this.readOnly) break;
                    this.insertItem();
                    return;
                }
                case 127: {
                    if (this.readOnly || this.editing) break;
                    if (!this.container.isDeletable(this)) {
                        return;
                    }
                    if (this.menuNode != null) break;
                    this.deletedFromHere = true;
                    e.consume();
                    this.delete(true, true);
                    return;
                }
                case 229: {
                    e.consume();
                    if (this.readOnly) break;
                    this.startEdit(true);
                    break;
                }
                case 10: {
                    if (!e.isControlDown()) break;
                    e.consume();
                    if (this.readOnly) break;
                    this.startEdit(false);
                    this.ignoreKeyTyped = true;
                    break;
                }
            }
        }
    }

    public final void keyTyped(KeyEvent e) {
        if (this.ignoreKeyTyped) {
            e.consume();
        }
        if (e.isConsumed()) {
            return;
        }
        switch (e.getKeyChar()) {
            case '\u001b': {
                if (this.parent == null || this.isToplevel()) break;
                this.container.select(this.parent, true);
                e.consume();
                this.notifyFocusChange();
                break;
            }
            case '\n': {
                this.container.goDown(false);
                e.consume();
                this.notifyFocusChange();
                break;
            }
            case '\b': {
                e.consume();
                break;
            }
            default: {
                if (!this.readOnly) {
                    this.processEdit(e.getKeyChar());
                }
                e.consume();
                break;
            }
        }
    }

    public final void keyReleased(KeyEvent e) {
        e.consume();
    }

    final void textFieldKeyTyped(KeyEvent e) {
    }

    final void textFieldKeyPressed(KeyEvent e) {
        block15: {
            switch (e.getKeyChar()) {
                case '\u001b': {
                    this.endEdit(false);
                    this.requestFocus();
                    return;
                }
                case '\n': {
                    if (!this.readOnly) {
                        if (this.endEdit(true)) {
                            this.commit();
                        } else {
                            this.container.goDown(false);
                            this.notifyFocusChange();
                        }
                    }
                    return;
                }
            }
            if ((e.getModifiers() & 8) != 0) break block15;
            switch (e.getKeyCode()) {
                case 38: {
                    if (this.endEdit(true)) {
                        this.commit();
                    } else {
                        this.container.goUp();
                        this.notifyFocusChange();
                    }
                    return;
                }
                case 40: {
                    if (this.endEdit(true)) {
                        this.commit();
                    } else {
                        this.container.goDown(false);
                        this.notifyFocusChange();
                    }
                    return;
                }
            }
        }
    }

    final void textFieldKeyReleased(KeyEvent e) {
    }

    protected final void notifyFocusChange() {
        this.notify(focusChangeEvent);
    }

    public final void notify(MenuEvent evt) {
        this.container.notify(evt);
    }

    public final void setPositions() {
        this.container.calcSize(this);
        if (this.popup != null) {
            this.popup.setPositions();
        }
    }

    public String toString() {
        return "EditMenuItem[" + this.label + "]";
    }

    public final void select(Item target, boolean setFocus) {
        this.container.select(target, setFocus);
    }

    public final void goUp() {
    }

    public final void goDown(boolean wrap) {
        if (this.popup != null) {
            this.popup.setFocus(false);
        }
    }

    public final void goLeft() {
        this.container.select(this, true);
    }

    public final void goRight() {
    }

    public final Item getSelectedItem() {
        return this.container.getSelectedItem();
    }

    public final void addComponent(Component component) {
        this.container.addComponent(component);
    }

    public final void removeComponent(Component component) {
        this.container.removeComponent(component);
    }

    public final void addItem(Component component) {
    }

    public final void calcSize(Component component) {
    }

    public final void insertItem(Item item) {
        this.container.insertItem(this);
    }

    public final void endEdit(Item item) {
        this.container.endEdit(item);
    }

    public final void deleteItem(Item item, boolean focus) {
    }

    public final void insertPopupItem(Item item) {
    }

    public final void register(Object menuObject, MenuNode menuNode) {
        this.container.register(menuObject, menuNode);
    }

    public final Item hitTest(int x, int y) {
        return this.container.hitTest(x, y);
    }

    public final Item itemAt(int x, int y) {
        return null;
    }

    public final int messageBox(String title, String text, int modifiers) {
        return this.container.messageBox(title, text, modifiers);
    }

    public final boolean isDeletable(Item item) {
        return this.container.isDeletable(item);
    }

    public final Item construct(MenuDesignerContainer hostContainer, MenuNode menuNode) {
        CmtPropertyState enabledPS;
        CmtPropertyState labelPS;
        this.menuNode = menuNode;
        this.setChecked(menuNode instanceof CheckMenuNode);
        CmtSubcomponent sub = menuNode != null ? menuNode.getSubcomponent() : null;
        Object live = sub != null ? sub.getLiveInstance() : null;
        CmtPropertyState cmtPropertyState = labelPS = sub != null ? sub.getPropertyState("text") : null;
        if (labelPS == null) {
            CmtPropertyState cmtPropertyState2 = labelPS = sub != null ? sub.getPropertyState("label") : null;
        }
        if (labelPS != null) {
            this.label = (String)labelPS.getValue();
        }
        CmtPropertyState cmtPropertyState3 = enabledPS = sub != null ? sub.getPropertyState("enabled") : null;
        if (enabledPS != null && enabledPS.getValue() != null) {
            this.disabled = (Boolean)enabledPS.getValue() ^ true;
        }
        this.container.register(this, menuNode);
        if (live instanceof Component) {
            ((Component)live).addPropertyChangeListener(this);
        }
        return this;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        CmtPropertyState labelPS;
        CmtSubcomponent sub = this.menuNode != null ? this.menuNode.getSubcomponent() : null;
        Object live = sub != null ? sub.getLiveInstance() : null;
        CmtPropertyState cmtPropertyState = labelPS = sub != null ? sub.getPropertyState("text") : null;
        if (labelPS == null) {
            CmtPropertyState cmtPropertyState2 = labelPS = sub != null ? sub.getPropertyState("label") : null;
        }
        if (labelPS != null) {
            this.setLabel((String)labelPS.getValue());
        }
    }

    public final void setChecked(boolean checked) {
        this.checked = checked;
    }

    public final boolean isChecked() {
        return this.checked;
    }

    public final boolean isItemEnabled() {
        return this.disabled ^ true;
    }

    public final JTextField getTextField(EditMenuItem item) {
        return this.container.getTextField(item);
    }

    public final Popup createEditPopupMenu(Item parent, MenuDesignerContainer container) {
        return this.container.createEditPopupMenu(parent, container);
    }

    public final Item createEditMenuItem(Item parent, MenuDesignerContainer container) {
        return this.container.createEditMenuItem(parent, container);
    }

    public final Item createEditMenuItemSeperator(Item parent, MenuDesignerContainer container) {
        return this.container.createEditMenuItemSeperator(parent, container);
    }

    public final Popup getPopup() {
        return this.popup;
    }

    public final Component getComponent() {
        return this;
    }

    public void setLabel(String label) {
        String oldAccessibleName = null;
        if (this.accessibleContext != null) {
            oldAccessibleName = this.accessibleContext.getAccessibleName();
        }
        String oldValue = this.label;
        this.label = label;
        this.firePropertyChange("label", oldValue, label);
        if (this.accessibleContext != null && this.accessibleContext.getAccessibleName() != oldAccessibleName) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", oldAccessibleName, this.accessibleContext.getAccessibleName());
        }
        if (this.container != null) {
            this.container.calcSize(this);
        }
        this.adjustPopup();
        this.repaint();
    }

    public Popup addPopup(boolean notify) {
        if (this.popup == null) {
            this.popup = this.container.createEditPopupMenu(this, this);
            this.setChecked(false);
            if (notify) {
                if (this.menuNode == null) {
                    this.label = "";
                    this.notify(new NewPopup((Popup)((Object)this.getContainer()), this));
                } else {
                    this.notify(new ConvertToMenu(this, this.menuNode));
                }
            }
        }
        return this.popup;
    }

    final void adjustPopup() {
        if (this.popup != null && !this.popup.getComponent().isVisible()) {
            Rectangle itemBounds = this.getBounds();
            if (this.getParent() instanceof Popup) {
                Rectangle popupBounds = this.getParent().getBounds();
                this.popup.move(popupBounds.x + popupBounds.width - 1, popupBounds.y + itemBounds.y + 1);
            } else {
                this.popup.move(itemBounds.x + 10, itemBounds.y + 10 + itemBounds.height - 1);
            }
            this.container.addComponent(this.popup.getComponent());
        }
    }

    public void openPopup(boolean focus) {
        if (this.popup != null) {
            Item parent = this.getParentItem();
            if (parent == null) {
                parent = this;
            }
            parent.setPositions();
            this.adjustPopup();
            this.popup.setVisible(true);
            if (focus) {
                this.popup.setFocus(false);
            }
        }
    }

    public final void trash() {
        if (this.popup != null) {
            this.popup.trash();
        }
        this.setVisible(false);
        this.container.removeComponent(this);
        this.dead = true;
    }

    public final void insertSeperator(Item item) {
        this.container.insertSeperator(item);
    }

    public final void blank() {
    }

    public final void removeBlankItems() {
        if (this.popup != null) {
            this.popup.removeBlankItems();
        }
    }

    public final void insertBlank() {
        if (this.popup != null) {
            this.popup.insertBlank();
        }
    }

    public final void setFocus(boolean selectLast) {
    }

    public final void moveItem(Item source, Item destination, boolean notify) {
        if (!(source instanceof EditMenuItemSeperator) || !destination.isToplevel()) {
            this.container.moveItem(source, destination, notify);
        }
    }

    public final void bind(PersistentItem parent, MenuDesignerContainer container, boolean toplevel) {
        this.parent = (EditMenuItem)parent;
        if (this.container != null) {
            container.removeComponent(this);
            if (this.popup != null) {
                container.removeComponent(this.popup.getComponent());
            }
        }
        this.container = container;
        this.toplevel = toplevel;
        if (container != null) {
            this.readOnly = container.isReadOnly();
        }
        if (toplevel) {
            this.setChecked(false);
        }
        if (this.popup != null) {
            this.popup.bind(this, container, false);
            container.addComponent(this.popup.getComponent());
        }
    }

    public final boolean isToplevel() {
        return this.toplevel;
    }

    public final void deletePopup(Item popup) {
        this.container.deletePopup(popup);
        this.notify(new ConvertToMenuItem(this, this.menuNode));
    }

    public final void removePopup() {
        if (this.popup != null) {
            this.container.removeComponent(this.popup.getComponent());
            this.container.calcSize(this);
            this.invalidate();
            this.popup = null;
        }
    }

    public Object clone() {
        return new EditMenuItem(this);
    }

    public String getLabel() {
        return this.label;
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isBlank() {
        return this.menuNode == null;
    }

    public final Item getParentItem() {
        return this.parent;
    }

    final void getContainerRect(Rectangle rect) {
        Container c = this.getParent();
        while (c != null) {
            if (c instanceof MenuDesigner) break;
            rect.x += c.getBounds().x;
            rect.y += c.getBounds().y;
            c = c.getParent();
        }
    }

    final void insertPopup() {
        this.addPopup(true);
    }

    final boolean canMoveTo(EditMenuItem target) {
        while (target != null && target.parent != this) {
            target = target.parent;
        }
        return target == null;
    }

    public final void showContextMenu(MouseEvent e) {
        this.container.showContextMenu(e);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleEditMenuItem(null);
        }
        return this.accessibleContext;
    }

    private final class AccessibleEditMenuItem
    extends JComponent.AccessibleJComponent {
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (EditMenuItem.this.getMenuNode() != null) {
                return EditMenuItem.this.getMenuNode().getName();
            }
            if (EditMenuItem.this.getLabel() == null) {
                return super.getAccessibleName();
            }
            return EditMenuItem.this.getLabel();
        }

        private AccessibleEditMenuItem() {
            super(EditMenuItem.this);
        }

        AccessibleEditMenuItem(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class TextFieldKeyListener
    implements KeyListener {
        private EditMenuItem editMenuItem;

        TextFieldKeyListener(EditMenuItem editMenuItem) {
            this.editMenuItem = editMenuItem;
        }

        public void keyPressed(KeyEvent e) {
            this.editMenuItem.textFieldKeyPressed(e);
        }

        public void keyTyped(KeyEvent e) {
            this.editMenuItem.textFieldKeyTyped(e);
        }

        public void keyReleased(KeyEvent e) {
            this.editMenuItem.textFieldKeyReleased(e);
        }
    }
}

