/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.menucanvas;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.KeyEvent;
import java.io.StreamTokenizer;
import javax.swing.UIManager;
import oracle.jdevimpl.uieditor.menucanvas.EditMenuItem;
import oracle.jdevimpl.uieditor.menucanvas.Item;
import oracle.jdevimpl.uieditor.menucanvas.MenuDesignerContainer;
import oracle.jdevimpl.uieditor.menucanvas.Popup;

final class EditMenuItemSeperator
extends EditMenuItem {
    EditMenuItemSeperator(Item parent, MenuDesignerContainer container) {
        super(parent, container);
    }

    EditMenuItemSeperator(EditMenuItemSeperator copy) {
        super(copy.parent, copy.container);
    }

    public String getLabel() {
        return "-";
    }

    public void paintComponent(Graphics g) {
        Color fC;
        Color bC;
        Rectangle b = this.getBounds();
        Insets i = this.getInsets();
        Rectangle r = new Rectangle(b.x + i.left, b.y + i.top, b.width - i.left - i.right, b.height - i.top - i.bottom);
        if (this.selected) {
            bC = (Color)UIManager.get("MenuItem.selectionBackground");
            fC = (Color)UIManager.get("MenuItem.selectionForeground");
            if (bC == null || fC == null) {
                bC = (Color)UIManager.get("textHighlight");
                fC = (Color)UIManager.get("textHighlightText");
            }
            if (bC == null || fC == null) {
                bC = SystemColor.textHighlight;
                fC = SystemColor.textHighlightText;
            }
        } else {
            bC = (Color)UIManager.get("MenuItem.background");
            fC = (Color)UIManager.get("MenuItem.foreground");
            if (bC == null || fC == null) {
                bC = (Color)UIManager.get("menu");
                fC = (Color)UIManager.get("menuText");
            }
            if (bC == null || fC == null) {
                bC = this.getBackground();
                fC = this.getForeground();
            }
        }
        Color shadow = (Color)UIManager.get("Separator.shadow");
        Color highlight = (Color)UIManager.get("Separator.highlight");
        if (shadow == null || highlight == null) {
            shadow = (Color)UIManager.get("controlShadow");
            highlight = (Color)UIManager.get("controlLtHighlight");
            if (shadow == null || highlight == null) {
                shadow = SystemColor.controlShadow;
                highlight = SystemColor.controlLtHighlight;
            }
        }
        g.setColor(bC);
        g.fillRect(0, 0, r.width, r.height);
        g.setColor(shadow);
        g.drawLine(0, r.height / 2, r.width, r.height / 2);
        g.setColor(highlight);
        g.drawLine(0, r.height / 2 + 1, r.width, r.height / 2 + 1);
        if (this.selected && !this.readOnly) {
            g.setColor(fC);
            EditMenuItemSeperator.drawFocusRect(g, 4, 1, r.width - 8, r.height - 2);
        }
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.repaint(100);
    }

    public Dimension getPreferredSize() {
        return new Dimension(60, 8);
    }

    public void keyPressed(KeyEvent e) {
        if (!e.isAltDown()) {
            switch (e.getKeyCode()) {
                case 39: {
                    this.endEdit(false);
                    e.consume();
                    this.notifyFocusChange();
                    break;
                }
                case 10: 
                case 229: {
                    break;
                }
                default: {
                    super.keyPressed(e);
                }
            }
        }
    }

    public String toString() {
        return "EditMenuItemSeperator[]";
    }

    public Item load(StreamTokenizer token, MenuDesignerContainer hostContainer) throws Exception {
        return this;
    }

    public void setLabel(String label) {
    }

    public Popup addPopup(boolean insertBlank, boolean show) {
        return null;
    }

    public void openPopup(boolean focus) {
    }

    public Object clone() {
        return new EditMenuItemSeperator(this);
    }

    public boolean isBlank() {
        return false;
    }
}

