/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.menucanvas;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import oracle.jdeveloper.cmt.CmtComponent;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdevimpl.uieditor.menucanvas.EditMenuItem;
import oracle.jdevimpl.uieditor.menucanvas.InsertItem;
import oracle.jdevimpl.uieditor.menucanvas.InsertSeparator;
import oracle.jdevimpl.uieditor.menucanvas.Item;
import oracle.jdevimpl.uieditor.menucanvas.MenuDesignerContainer;
import oracle.jdevimpl.uieditor.menucanvas.MenuEvent;
import oracle.jdevimpl.uieditor.menucanvas.MenuNode;
import oracle.jdevimpl.uieditor.menucanvas.MoveItem;
import oracle.jdevimpl.uieditor.menucanvas.PersistentItem;
import oracle.jdevimpl.uieditor.menucanvas.Popup;
import oracle.jdevimpl.uieditor.menucanvas.Res;
import oracle.jdevimpl.uieditor.uicanvas.NodeMemento;

final class EditPopupMenu
extends JPanel
implements Popup,
MenuDesignerContainer {
    private MenuDesignerContainer container;
    private Item parent;
    private Vector items;
    private boolean readOnly;
    private MenuNode menuNode;

    private void $init$() {
        this.items = new Vector();
    }

    EditPopupMenu(Item parent, MenuDesignerContainer container) {
        this.$init$();
        Color color = (Color)UIManager.get("Menu.background");
        Font font = (Font)UIManager.get("Menu.font");
        if (color == null) {
            color = (Color)UIManager.get("menu");
        }
        if (color != null) {
            this.setBackground(color);
        }
        if (font != null) {
            this.setFont(font);
        }
        this.setVisible(false);
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.parent = parent;
        this.container = container;
        if (container != null) {
            this.readOnly = container.isReadOnly();
        }
        this.setLayout(null);
    }

    public EditPopupMenu(EditPopupMenu copy) {
        this.$init$();
        Color color = (Color)UIManager.get("Menu.background");
        Font font = (Font)UIManager.get("Menu.font");
        if (color == null) {
            color = (Color)UIManager.get("menu");
        }
        if (color != null) {
            this.setBackground(color);
        }
        if (font != null) {
            this.setFont(font);
        }
        this.setVisible(false);
        this.parent = copy.parent;
        this.container = copy.container;
        this.setLayout(null);
        Enumeration en = copy.items.elements();
        while (en.hasMoreElements()) {
            Item item = (Item)en.nextElement();
            item = (Item)item.clone();
            this.items.addElement(item);
            item.bind(this.parent, this, false);
            this.add(item.getComponent());
        }
        this.setPositions();
        this.setVisible(false);
        if (this.container != null) {
            this.readOnly = this.container.isReadOnly();
            this.container.addComponent(this);
        }
    }

    public void setMenuNode(MenuNode menuNode) {
        this.menuNode = menuNode;
    }

    public MenuNode getMenuNode() {
        return this.menuNode;
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            this.hideAll(false);
        }
        super.setVisible(visible);
    }

    public MenuDesignerContainer getContainer() {
        return this.container;
    }

    public void setPositions() {
        Dimension d = this.getPreferredSize();
        this.setSize(d.width, d.height);
        int y = 0;
        int i = 0;
        while (i < this.items.size()) {
            Item item = (Item)this.items.elementAt(i);
            Dimension b = item.getPreferredSize();
            Rectangle b0 = item.getBounds();
            if (b0.x != 1 || b0.y != 1 + y || b0.width != d.width - 2 || b0.height != b.height) {
                item.reshape(2, 2 + y, d.width - 4, b.height);
            }
            y += b.height;
            ++i;
        }
    }

    public void hideAll(boolean hideHimself) {
        if (!this.isVisible()) {
            return;
        }
        int i = 0;
        while (i < this.items.size()) {
            Item item = (Item)this.items.elementAt(i);
            if (item.getPopup() != null) {
                item.getPopup().hideAll(true);
            }
            ++i;
        }
        if (hideHimself) {
            this.setVisible(false);
        }
    }

    public Dimension getPreferredSize() {
        int maxWidth = 0;
        int height = 2;
        int i = 0;
        while (i < this.items.size()) {
            Item item = (Item)this.items.elementAt(i);
            Dimension d = item.getPreferredSize();
            height += d.height;
            if (d.width > maxWidth) {
                maxWidth = d.width;
            }
            ++i;
        }
        return new Dimension(2 + maxWidth, 2 + height);
    }

    private Item where(int x, int y) {
        int i = 0;
        while (i < this.items.size()) {
            Item item = (Item)this.items.elementAt(i);
            if (item.getBounds().contains(x, y)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public boolean isRootContainer() {
        return false;
    }

    public void select(Item target, boolean setFocus) {
        this.insertBlank();
        this.container.select(target, setFocus);
    }

    public void goUp() {
        Item item = this.getSelectedItem();
        if (item != null && this.items.contains(item)) {
            int i = this.items.indexOf(item);
            if (i > 0) {
                this.select((Item)this.items.elementAt(i - 1), true);
            } else if (this.parent != null && this.parent.isToplevel()) {
                this.container.select(this.parent, true);
            } else {
                this.container.select((Item)this.items.elementAt(this.items.size() - 1), true);
            }
        }
    }

    public void goDown(boolean wrap) {
        Item item = this.getSelectedItem();
        if (item != null && this.items.contains(item)) {
            int i = this.items.indexOf(item);
            if (i < this.items.size() - 1) {
                this.select((Item)this.items.elementAt(i + 1), true);
            } else if (this.parent != null && this.parent.isToplevel()) {
                if (wrap) {
                    this.container.select(this.parent, true);
                }
            } else if (wrap) {
                this.select((Item)this.items.elementAt(0), true);
            }
        }
    }

    public void goLeft() {
        this.container.goLeft();
    }

    public void goRight() {
        this.container.goRight();
    }

    public Item getSelectedItem() {
        return this.container.getSelectedItem();
    }

    public void addComponent(Component component) {
        if (this.container != null) {
            this.container.addComponent(component);
        }
    }

    public void removeComponent(Component component) {
        if (this.container != null) {
            this.container.removeComponent(component);
        }
    }

    public void addItem(Component component) {
        Item item = this.container.createEditMenuItem(this.parent, this);
        this.items.addElement(item);
        this.add(item.getComponent());
        Dimension dim = this.getPreferredSize();
        this.setPositions();
        this.setSize(dim.width, dim.height);
        this.container.select(item, true);
    }

    public void calcSize(Component component) {
        this.setPositions();
        this.invalidate();
    }

    public String toString() {
        if (this.parent != null) {
            return "EditPopupMenu[" + this.parent.getLabel() + "]";
        }
        return "EditPopupMenu[]";
    }

    public void insertItem(Item target) {
        int i = this.items.indexOf(target);
        if (i != -1) {
            Item item = this.container.createEditMenuItem(this.parent, this);
            this.add(item.getComponent(), i);
            this.items.insertElementAt(item, i);
            this.notify(new InsertItem(this, item, target));
            this.setPositions();
        }
    }

    public void endEdit(Item target) {
        this.insertBlank();
    }

    public void deleteItem(Item target, boolean focus) {
        int i = this.items.indexOf(target);
        if (i != -1 && this.items.size() > 1) {
            Component c = target.getComponent();
            focus = focus || c != null && c.hasFocus();
            this.remove(target.getComponent());
            this.items.removeElement(target.getComponent());
            int next = i <= this.items.size() - 1 ? i : this.items.size() - 1;
            this.setPositions();
            Item item = (Item)this.items.elementAt(next);
            if (!this.isDeletable(item) && next != 0) {
                item = (Item)this.items.elementAt(next - 1);
            }
            this.container.select(item, focus);
            this.repaint();
        } else if (this.parent != null && !this.parent.isToplevel()) {
            this.parent.deletePopup(this.parent);
        }
    }

    private void removePopup() {
        int i = 0;
        while (i < this.items.size()) {
            Item item = (Item)this.items.elementAt(i);
            this.remove((Component)((Object)item));
            item.trash();
            ++i;
        }
        this.items.removeAllElements();
    }

    public boolean isDeletable(Item item) {
        return (item.isBlank() && this.items.size() != 1 && item == this.items.elementAt(this.items.size() - 1)) ^ true;
    }

    public void trash() {
        this.removePopup();
        this.remove(this);
        this.setVisible(false);
    }

    public Item construct(MenuDesignerContainer hostContainer, MenuNode menuNode) {
        this.menuNode = menuNode;
        Item rootItem = null;
        Iterator i = menuNode.getChildren();
        if (i != null) {
            while (i.hasNext()) {
                CmtComponent outerComponent;
                boolean isSeparator;
                Object obj = i.next();
                if (!(obj instanceof MenuNode)) continue;
                MenuNode child = (MenuNode)obj;
                CmtSubcomponent sub = child.getSubcomponent();
                boolean bl = isSeparator = sub == null;
                if (!isSeparator && (outerComponent = sub.getOuterComponent()) != null && NodeMemento.getType(sub, outerComponent.getComponents()) == 1) {
                    isSeparator = true;
                }
                if (!isSeparator) {
                    CmtPropertyState labelPS = child.getSubcomponent().getPropertyState("text");
                    if (labelPS == null) {
                        labelPS = child.getSubcomponent().getPropertyState("label");
                    }
                    String label = "";
                    if (labelPS != null) {
                        label = (String)labelPS.getValue();
                    }
                    if (!child.isContainer()) {
                        Item item = label.equals("-") ? this.container.createEditMenuItemSeperator(this.parent, this) : this.container.createEditMenuItem(this.parent, this);
                        this.items.addElement(item);
                        this.add(item.getComponent());
                        item.construct(hostContainer, child);
                        if (rootItem != null) continue;
                        rootItem = item;
                        continue;
                    }
                    Item item = this.container.createEditMenuItem(this.parent, this);
                    item.construct(hostContainer, child);
                    this.items.addElement(item);
                    this.add(item.getComponent());
                    item.addPopup(false);
                    item.setLabel(label);
                    item.getPopup().construct(hostContainer, child);
                    item.getPopup().setVisible(false);
                    continue;
                }
                Item item = this.container.createEditMenuItemSeperator(this.parent, this);
                item.setMenuNode(child);
                this.container.register(item, child);
                this.items.addElement(item);
                this.add(item.getComponent());
            }
        }
        this.container.register(this, menuNode);
        return rootItem;
    }

    public Popup createEditPopupMenu(Item parent, MenuDesignerContainer container) {
        return this.container.createEditPopupMenu(parent, container);
    }

    public Item createEditMenuItem(Item parent, MenuDesignerContainer container) {
        return this.container.createEditMenuItem(parent, container);
    }

    public Item createEditMenuItemSeperator(Item parent, MenuDesignerContainer container) {
        return this.container.createEditMenuItemSeperator(parent, container);
    }

    public void insertSeperator(Item target) {
        int i = this.items.indexOf(target);
        if (i != -1) {
            Item item = this.container.createEditMenuItemSeperator(this.parent, this);
            this.add(item.getComponent(), i);
            this.items.insertElementAt(item, i);
            this.notify(new InsertSeparator(this, item, target));
            this.setPositions();
        }
    }

    public void blank() {
        int i = 0;
        while (i < this.items.size()) {
            this.remove(((Item)this.items.elementAt(i)).getComponent());
            ++i;
        }
        this.items.removeAllElements();
    }

    public void setFocus(boolean selectLast) {
        if (this.items.size() != 0) {
            this.container.select((Item)this.items.elementAt(selectLast ? this.items.size() - 1 : 0), true);
        }
    }

    public void insertBlank() {
        if (!this.readOnly) {
            boolean needBlank = true;
            Enumeration en = this.items.elements();
            while (en.hasMoreElements()) {
                Item item = (Item)en.nextElement();
                if (item.getPopup() == null) continue;
                item.getPopup().insertBlank();
            }
            if (this.items.size() > 0) {
                Item last = (Item)this.items.elementAt(this.items.size() - 1);
                needBlank = last.isBlank() ^ true;
            }
            if (needBlank && this.container != null) {
                Item item = this.container.createEditMenuItem(this.parent, this);
                this.items.addElement(item);
                this.add(item.getComponent());
                this.setPositions();
            }
        }
    }

    public void removeBlankItems() {
        Enumeration en = this.items.elements();
        while (en.hasMoreElements()) {
            Item item = (Item)en.nextElement();
            if (item.isBlank()) {
                this.remove(item.getComponent());
                this.items.removeElement(item);
                continue;
            }
            item.removeBlankItems();
        }
        this.setPositions();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void moveItem(Item source, Item destination, boolean notify) {
        int sourceIndex = this.items.indexOf(source);
        int destinationIndex = this.items.indexOf(destination);
        if (sourceIndex != -1) {
            if (destinationIndex != -1) {
                block10: {
                    if (sourceIndex == destinationIndex) return;
                    if (destinationIndex == sourceIndex + 1) {
                        if (destination != null && !destination.isBlank()) {
                            this.items.removeElement(source);
                            this.items.insertElementAt(source, destinationIndex);
                            this.setPositions();
                            this.container.select(source, true);
                            Item tmp = source;
                            source = destination;
                            destination = tmp;
                            break block10;
                        } else {
                            this.container.select(source, true);
                            return;
                        }
                    }
                    if (sourceIndex < destinationIndex) {
                        --destinationIndex;
                    }
                    this.items.removeElement(source);
                    this.items.insertElementAt(source, destinationIndex);
                    this.setPositions();
                    this.container.select(source, true);
                }
                if (!notify) return;
                this.notify(new MoveItem(source, this.menuNode, destination.getMenuNode()));
                return;
            }
            if (!((EditMenuItem)source).canMoveTo((EditMenuItem)destination)) {
                this.messageBox(Res.getString(14), Res.getString(7), 0);
                this.container.select(source, true);
                return;
            }
            this.remove(source.getComponent());
            this.items.removeElement(source);
            this.setPositions();
            destination.getContainer().moveItem(source, destination, notify);
            return;
        }
        this.add(source.getComponent());
        source.bind(this.parent, this, false);
        if (destination == null) {
            this.items.addElement(source);
        } else {
            this.items.insertElementAt(source, destinationIndex);
        }
        this.setPositions();
        if (source.getPopup() != null) {
            ((EditPopupMenu)source.getPopup()).setPositions();
            source.getPopup().hideAll(true);
        }
        if (!notify) return;
        this.notify(new MoveItem(source, this.menuNode, destination != null ? destination.getMenuNode() : null));
    }

    public void deletePopup(Item item) {
        if (this.items.contains(item) && item.getPopup() != null) {
            item.removePopup();
            this.setPositions();
            this.container.select(item, true);
            this.invalidate();
        }
    }

    public Component getComponent() {
        return this;
    }

    public Object clone() {
        return new EditPopupMenu(this);
    }

    public void bind(PersistentItem parent, MenuDesignerContainer container, boolean toplevel) {
        if (this.container != null) {
            this.container.removeComponent(this);
        }
        this.container = container;
        this.parent = (Item)parent;
        if (container != null) {
            this.readOnly = container.isReadOnly();
            container.addComponent(this);
        }
        Enumeration en = this.items.elements();
        while (en.hasMoreElements()) {
            Item item = (Item)en.nextElement();
            item.bind(parent, this, false);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void notify(MenuEvent evt) {
        this.container.notify(evt);
    }

    public int messageBox(String title, String text, int modifiers) {
        return this.container.messageBox(title, text, modifiers);
    }

    public void register(Object menuObject, MenuNode menuNode) {
        this.container.register(menuObject, menuNode);
    }

    public Item getParentItem() {
        return this.parent;
    }

    public Item hitTest(int x, int y) {
        return this.container.hitTest(x, y);
    }

    public JTextField getTextField(EditMenuItem item) {
        return this.container.getTextField(item);
    }

    public void setSelected(boolean selected, Item previous, boolean setFocus) {
    }

    public Item itemAt(int x, int y) {
        if (!this.isVisible()) {
            return null;
        }
        Rectangle thisBounds = this.getBounds();
        int xAdjusted = x - thisBounds.x;
        int yAdjusted = y - thisBounds.y;
        int i = 0;
        while (i < this.items.size()) {
            Item item = (Item)this.items.elementAt(i);
            if (((Component)((Object)item)).getBounds().contains(xAdjusted, yAdjusted)) {
                return item;
            }
            Popup p = item.getPopup();
            if (p != null && (item = ((MenuDesignerContainer)((Object)p)).itemAt(x, y)) != null) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public void showContextMenu(MouseEvent e) {
        this.container.showContextMenu(e);
    }
}

