/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.menucanvas;

import java.awt.Component;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpInfo;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.cmt.CmtModel;
import oracle.jdeveloper.uieditor.AbstractCanvas;
import oracle.jdeveloper.uieditor.ModelFactory;
import oracle.jdeveloper.uieditor.UIManager;
import oracle.jdevimpl.uieditor.menucanvas.EditMenuItemSeperator;
import oracle.jdevimpl.uieditor.menucanvas.Item;
import oracle.jdevimpl.uieditor.menucanvas.MenuController;
import oracle.jdevimpl.uieditor.menucanvas.MenuDesigner;
import oracle.jdevimpl.uieditor.menucanvas.MenuDesignerModel;
import oracle.jdevimpl.uieditor.menucanvas.Res;

public final class MenuCanvas
extends AbstractCanvas {
    public static final int INSERT_ITEM_CMD_ID = Ide.findOrCreateCmdID((String)"MenuCanvas.INSERT_ITEM_CMD_ID");
    public static final int INSERT_POPUP_CMD_ID = Ide.findOrCreateCmdID((String)"MenuCanvas.INSERT_POPUP_CMD_ID");
    public static final int INSERT_SEPARATOR_CMD_ID = Ide.findOrCreateCmdID((String)"MenuCanvas.INSERT_SEPARATOR_CMD_ID");
    public static final int TOGGLE_CHECKED_CMD_ID = Ide.findOrCreateCmdID((String)"MenuCanvas.TOGGLE_CHECKED_CMD_ID");
    public static final int TOGGLE_ENABLED_CMD_ID = Ide.findOrCreateCmdID((String)"MenuCanvas.TOGGLE_ENABLED_CMD_ID");
    public static JMenuItem INSERT_ITEM_ITEM;
    public static JMenuItem INSERT_POPUP_ITEM;
    public static JMenuItem INSERT_SEPARATOR_ITEM;
    public static JMenuItem TOGGLE_CHECKED_ITEM;
    public static JMenuItem TOGGLE_ENABLED_ITEM;
    static IdeAction INSERT_ITEM_ACTION;
    static IdeAction INSERT_POPUP_ACTION;
    static IdeAction INSERT_SEPARATOR_ACTION;
    static IdeAction TOGGLE_CHECKED_ACTION;
    static IdeAction TOGGLE_ENABLED_ACTION;
    private static final String TOOLBAR_ID = "MenuCanvas.Toolbar";
    private MenuDesigner gui;
    private Toolbar toolbar;

    private void $init$() {
        this.toolbar = null;
    }

    static {
        ModelFactory factory = UIManager.getFactory(MenuDesignerModel.class);
        try {
            INSERT_ITEM_ACTION = factory.registerAction(INSERT_ITEM_CMD_ID, Res.getString(17), Res.getInteger(49), Res.getIcon(8), 0, JDeveloperMenuConstants.WEIGHT_JAVA_UI_DESIGN_INSERT_MENU, Float.MAX_VALUE);
            INSERT_POPUP_ACTION = factory.registerAction(INSERT_POPUP_CMD_ID, Res.getString(3), Res.getInteger(46), Res.getIcon(13), 0, JDeveloperMenuConstants.WEIGHT_JAVA_UI_DESIGN_INSERT_SUBMENU, Float.MAX_VALUE);
            INSERT_SEPARATOR_ACTION = factory.registerAction(INSERT_SEPARATOR_CMD_ID, Res.getString(43), Res.getInteger(56), Res.getIcon(6), 0, JDeveloperMenuConstants.WEIGHT_JAVA_UI_DESIGN_INSERT_SEPARATOR, Float.MAX_VALUE);
            TOGGLE_CHECKED_ACTION = factory.registerAction(TOGGLE_CHECKED_CMD_ID, Res.getString(15), Res.getInteger(24), Res.getIcon(18), 0, JDeveloperMenuConstants.WEIGHT_JAVA_UI_DESIGN_CHECKABLE, Float.MAX_VALUE);
            TOGGLE_CHECKED_ACTION.putValue("Check", (Object)Boolean.TRUE);
            TOGGLE_ENABLED_ACTION = factory.registerAction(TOGGLE_ENABLED_CMD_ID, Res.getString(61), Res.getInteger(19), Res.getIcon(39), 0, JDeveloperMenuConstants.WEIGHT_JAVA_UI_DESIGN_ENABLED, Float.MAX_VALUE);
            TOGGLE_ENABLED_ACTION.putValue("Check", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    public MenuCanvas() {
        this.$init$();
    }

    public void setContext(Context context) {
        super.setContext(context);
        if (this.gui == null && this.editor != null) {
            this.gui = new MenuDesigner(this);
        }
    }

    public HelpInfo getHelpInfo() {
        HelpInfo info = new HelpInfo("f1_ideuieditormenu_html");
        info.setContext(this.getContext());
        return info;
    }

    public Controller getController() {
        return MenuController.getInstance();
    }

    public void viewSelectionChanged(ViewSelectionEvent e) {
        if (this.gui != null) {
            View view;
            Context context;
            this.gui.changeSelection(e.getSelection());
            if (Ide.getMainWindow().getLastActiveView() != this.getUIEditor() && (context = this.getContext()) != null && (view = context.getView()) != null) {
                MenuCanvas.updateToolbarActions((Toolbar)view.getToolbar());
            }
        }
        super.viewSelectionChanged(e);
    }

    public void setModel(CmtModel model) {
        if (this.gui != null) {
            this.gui.setTarget(model != null ? model.getRoot() : null);
        }
    }

    public CmtModel getModel() {
        return this.gui != null ? this.gui.getModel() : null;
    }

    public Component getGUI() {
        return this.gui;
    }

    public synchronized Toolbar getToolbar() {
        if (this.toolbar == null && this.editor != null) {
            this.toolbar = new Toolbar();
            MenuCanvas.loadManifestToolbar((String)TOOLBAR_ID, (Toolbar)this.toolbar, (View)this.editor);
        }
        return this.toolbar;
    }

    public void menuWillShow(ContextMenu cMenu) {
        View view;
        Context context = cMenu.getContext();
        View view2 = view = context != null ? context.getView() : null;
        if (view != this.editor) {
            return;
        }
        Item item = this.gui.getSelectedItem();
        if (item == null) {
            return;
        }
        if (INSERT_ITEM_ITEM == null) {
            INSERT_ITEM_ITEM = cMenu.createMenuItem((ToggleAction)INSERT_ITEM_ACTION, JDeveloperMenuConstants.WEIGHT_JAVA_UI_DESIGN_INSERT_MENU);
            INSERT_SEPARATOR_ITEM = cMenu.createMenuItem((ToggleAction)INSERT_SEPARATOR_ACTION, JDeveloperMenuConstants.WEIGHT_JAVA_UI_DESIGN_INSERT_SEPARATOR);
            INSERT_POPUP_ITEM = cMenu.createMenuItem((ToggleAction)INSERT_POPUP_ACTION, JDeveloperMenuConstants.WEIGHT_JAVA_UI_DESIGN_INSERT_SUBMENU);
            TOGGLE_CHECKED_ITEM = cMenu.createMenuItem((ToggleAction)TOGGLE_CHECKED_ACTION, JDeveloperMenuConstants.WEIGHT_JAVA_UI_DESIGN_CHECKABLE);
            TOGGLE_ENABLED_ITEM = cMenu.createMenuItem((ToggleAction)TOGGLE_ENABLED_ACTION, JDeveloperMenuConstants.WEIGHT_JAVA_UI_DESIGN_ENABLED);
        }
        float menuSection = JDeveloperMenuConstants.SECTION_DYNAMIC_CTXT_MENU + 0.001f;
        cMenu.add((Component)INSERT_ITEM_ITEM, JDeveloperMenuConstants.SECTION_DYNAMIC_CTXT_MENU);
        if (!item.isToplevel()) {
            cMenu.add((Component)INSERT_SEPARATOR_ITEM, JDeveloperMenuConstants.SECTION_DYNAMIC_CTXT_MENU);
            if (!(item instanceof EditMenuItemSeperator) && !item.isBlank()) {
                if (item.getPopup() == null) {
                    cMenu.add((Component)INSERT_POPUP_ITEM, JDeveloperMenuConstants.SECTION_DYNAMIC_CTXT_MENU);
                    cMenu.add((Component)TOGGLE_CHECKED_ITEM, menuSection);
                }
                cMenu.add((Component)TOGGLE_ENABLED_ITEM, menuSection);
            }
        }
    }
}

