/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.menucanvas;

import java.awt.Component;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.jdeveloper.uieditor.AbstractCanvasController;
import oracle.jdeveloper.uieditor.ModelFactory;
import oracle.jdeveloper.uieditor.UIEditor;
import oracle.jdeveloper.uieditor.UIEditorCanvas;
import oracle.jdeveloper.uieditor.UIManager;
import oracle.jdevimpl.uieditor.menucanvas.EditMenuItem;
import oracle.jdevimpl.uieditor.menucanvas.EditMenuItemSeperator;
import oracle.jdevimpl.uieditor.menucanvas.MenuCanvas;
import oracle.jdevimpl.uieditor.menucanvas.MenuDesigner;
import oracle.jdevimpl.uieditor.menucanvas.MenuDesignerModel;
import oracle.jdevimpl.uieditor.menucanvas.Res;

final class MenuController
extends AbstractCanvasController {
    private static MenuController INSTANCE;
    private static final String INSERT_ITEM_NAME;
    private static final String INSERT_MENU_NAME;
    private static final Integer INSERT_ITEM_MNEMONIC;
    private static final Integer INSERT_MENU_MNEMONIC;

    private MenuController() {
    }

    static synchronized MenuController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MenuController();
        }
        return INSTANCE;
    }

    protected ModelFactory getModelFactory() {
        return UIManager.getFactory(MenuDesignerModel.class);
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int id;
        int n = id = action != null ? action.getCommandId() : -1;
        if (id == MenuCanvas.INSERT_ITEM_CMD_ID) {
            try {
                EditMenuItem item = MenuController.getItem(context);
                if (item != null) {
                    item.insertItem();
                }
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
            return true;
        }
        if (id == MenuCanvas.INSERT_SEPARATOR_CMD_ID) {
            try {
                EditMenuItem item = MenuController.getItem(context);
                if (item != null) {
                    item.insertSeperator();
                }
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
            return true;
        }
        if (id == MenuCanvas.INSERT_POPUP_CMD_ID) {
            try {
                EditMenuItem item = MenuController.getItem(context);
                if (item != null) {
                    item.insertPopup();
                }
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
            return true;
        }
        if (id == MenuCanvas.TOGGLE_CHECKED_CMD_ID) {
            try {
                EditMenuItem item = MenuController.getItem(context);
                if (item != null) {
                    item.toggleCheck();
                }
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
            return true;
        }
        if (id == MenuCanvas.TOGGLE_ENABLED_CMD_ID) {
            try {
                EditMenuItem item = MenuController.getItem(context);
                if (item != null) {
                    item.toggleEnable();
                }
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int id;
        int n = id = action != null ? action.getCommandId() : -1;
        if (id == MenuCanvas.INSERT_ITEM_CMD_ID) {
            EditMenuItem item = MenuController.getItem(context);
            if (item != null) {
                if (item.isToplevel()) {
                    action.putValue("Name", (Object)INSERT_MENU_NAME);
                    action.putValue("MnemonicKey", (Object)INSERT_MENU_MNEMONIC);
                } else {
                    action.putValue("Name", (Object)INSERT_ITEM_NAME);
                    action.putValue("MnemonicKey", (Object)INSERT_ITEM_MNEMONIC);
                }
                action.setEnabled(true);
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (id == MenuCanvas.INSERT_SEPARATOR_CMD_ID) {
            EditMenuItem item = MenuController.getItem(context);
            if (item != null) {
                action.setEnabled(item.isToplevel() ^ true);
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (id == MenuCanvas.INSERT_POPUP_CMD_ID) {
            EditMenuItem item = MenuController.getItem(context);
            if (item != null) {
                action.setEnabled(!item.isToplevel() && !(item instanceof EditMenuItemSeperator) && !item.isBlank() && item.getPopup() == null);
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (id == MenuCanvas.TOGGLE_CHECKED_CMD_ID) {
            EditMenuItem item = MenuController.getItem(context);
            if (item != null) {
                action.setEnabled(!item.isToplevel() && !(item instanceof EditMenuItemSeperator) && !item.isBlank() && item.getPopup() == null);
                boolean state = action.isEnabled() ? item.isChecked() : false;
                action.putValue("State", (Object)(state ? Boolean.TRUE : Boolean.FALSE));
            } else {
                action.setEnabled(false);
                action.putValue("State", (Object)Boolean.FALSE);
            }
            return true;
        }
        if (id == MenuCanvas.TOGGLE_ENABLED_CMD_ID) {
            EditMenuItem item = MenuController.getItem(context);
            if (item != null) {
                action.setEnabled(!item.isToplevel() && !(item instanceof EditMenuItemSeperator) && !item.isBlank());
                boolean state = action.isEnabled() ? item.isItemEnabled() : false;
                action.putValue("State", (Object)(state ? Boolean.TRUE : Boolean.FALSE));
            } else {
                action.setEnabled(false);
                action.putValue("State", (Object)Boolean.FALSE);
            }
            return true;
        }
        return false;
    }

    private static EditMenuItem getItem(Context context) {
        View view = context != null ? context.getView() : null;
        UIEditor editor = view instanceof UIEditor ? (UIEditor)view : null;
        UIEditorCanvas canvas = editor != null ? editor.getActiveCanvas() : null;
        Component gui = canvas != null ? canvas.getGUI() : null;
        return gui instanceof MenuDesigner ? (EditMenuItem)((MenuDesigner)gui).getSelectedItem() : null;
    }

    static {
        INSERT_ITEM_NAME = Res.getString(17);
        INSERT_MENU_NAME = Res.getString(51);
        INSERT_ITEM_MNEMONIC = Res.getInteger(49);
        INSERT_MENU_MNEMONIC = Res.getInteger(55);
    }
}

