/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.menucanvas;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.awt.MenuBar;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.DefaultCaret;
import oracle.ide.Ide;
import oracle.ide.controls.FocusableLabel;
import oracle.ide.model.Element;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.jdeveloper.cmt.CmtComponentSource;
import oracle.jdeveloper.cmt.CmtModel;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSelectionModel;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.layout.XYConstraints;
import oracle.jdeveloper.layout.XYLayout;
import oracle.jdeveloper.uieditor.UIEditor;
import oracle.jdevimpl.uieditor.menucanvas.CheckedChanged;
import oracle.jdevimpl.uieditor.menucanvas.ConvertToMenu;
import oracle.jdevimpl.uieditor.menucanvas.ConvertToMenuItem;
import oracle.jdevimpl.uieditor.menucanvas.DeleteItem;
import oracle.jdevimpl.uieditor.menucanvas.EditMenuBar;
import oracle.jdevimpl.uieditor.menucanvas.EditMenuItem;
import oracle.jdevimpl.uieditor.menucanvas.EditMenuItemSeperator;
import oracle.jdevimpl.uieditor.menucanvas.EditPopupMenu;
import oracle.jdevimpl.uieditor.menucanvas.EnabledChanged;
import oracle.jdevimpl.uieditor.menucanvas.FocusChange;
import oracle.jdevimpl.uieditor.menucanvas.InsertItem;
import oracle.jdevimpl.uieditor.menucanvas.InsertMenu;
import oracle.jdevimpl.uieditor.menucanvas.InsertSeparator;
import oracle.jdevimpl.uieditor.menucanvas.Item;
import oracle.jdevimpl.uieditor.menucanvas.MenuCanvas;
import oracle.jdevimpl.uieditor.menucanvas.MenuDesignerCommands;
import oracle.jdevimpl.uieditor.menucanvas.MenuDesignerContainer;
import oracle.jdevimpl.uieditor.menucanvas.MenuDesignerModel;
import oracle.jdevimpl.uieditor.menucanvas.MenuEvent;
import oracle.jdevimpl.uieditor.menucanvas.MenuNode;
import oracle.jdevimpl.uieditor.menucanvas.MoveItem;
import oracle.jdevimpl.uieditor.menucanvas.NewItem;
import oracle.jdevimpl.uieditor.menucanvas.NewMenu;
import oracle.jdevimpl.uieditor.menucanvas.NewPopup;
import oracle.jdevimpl.uieditor.menucanvas.PersistentItem;
import oracle.jdevimpl.uieditor.menucanvas.Popup;
import oracle.jdevimpl.uieditor.menucanvas.Res;
import oracle.jdevimpl.uieditor.menucanvas.TextChanged;

final class MenuDesigner
extends JPanel
implements MenuDesignerCommands {
    static final String LABEL_PROP = "label";
    static final String ENABLED_PROP = "enabled";
    HashMap cmtSubcomponents;
    private FocusTraversalPolicy dummyPolicy;
    private MouseAdapter mouseAdapter;
    private MenuNode rootNode;
    private CmtSubcomponent rootSubcomponent;
    private MenuCanvas explorer;
    private FocusableLabel placeHolder;
    private PersistentItem rootItem;
    private EditMenuItem current;
    private boolean moveDown;
    private EditMenuItem lastUpdated;
    private JTextField textField;
    private MenuDesignerModel model;
    private XYLayout workingLayout;
    private BorderLayout placeHolderLayout;

    private void $init$() {
        this.cmtSubcomponents = new HashMap();
        this.dummyPolicy = new 1();
        this.mouseAdapter = new 2();
    }

    MenuDesigner(MenuCanvas explorer) {
        this.$init$();
        this.explorer = explorer;
        this.init(Ide.getProductHomeDirectory());
        this.enableEvents(8);
        this.addMouseListener(this.mouseAdapter);
        this.placeHolder = new FocusableLabel();
        this.placeHolder.setText(Res.getString(28));
        this.placeHolder.addMouseListener((MouseListener)this.mouseAdapter);
    }

    UIEditor getUIEditor() {
        return this.explorer.getUIEditor();
    }

    private void init(String ideRoot) {
        this.workingLayout = new XYLayout();
        this.placeHolderLayout = new BorderLayout();
        this.setLayout(this.placeHolderLayout);
        Color color = (Color)UIManager.get("window");
        if (color == null) {
            color = SystemColor.window;
        }
        this.setBackground(color);
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (constraints == null) {
            Rectangle r = comp.getBounds();
            constraints = new XYConstraints(r.x, r.y, -1, -1);
        }
        super.addImpl(comp, constraints, index);
    }

    public PersistentItem newPopup() {
        this.rootItem = this.createPopup();
        this.rootItem.insertBlank();
        this.rootItem.setVisible(true);
        this.rootItem.setFocus(true);
        return this.rootItem;
    }

    public void toggleEnable() {
        if (this.current != null) {
            this.current.toggleEnable();
        }
    }

    public void toggleCheck() {
        if (this.current != null) {
            this.current.toggleCheck();
        }
    }

    public void insertItem() {
        if (this.current != null) {
            this.current.insertItem();
        }
    }

    public void insertSeperator() {
        if (this.current != null) {
            this.current.insertSeperator();
        }
    }

    public void addPopup() {
        if (this.current != null) {
            Popup popup = this.current.addPopup(true);
        }
    }

    public void deleteItem() {
        if (this.current != null) {
            this.current.delete(true, true);
        }
    }

    public void select(Item target, boolean setFocus) {
        if (target == null && this.current != null && this.current.isBlank()) {
            target = this.current;
        }
        if (target != this.current) {
            EditMenuItem previouslySelected = this.current;
            if (this.current != null) {
                this.current.setSelected(false, target, false);
            }
            this.current = (EditMenuItem)target;
            if (this.current != null) {
                this.current.setSelected(true, previouslySelected, setFocus);
            }
        }
        this.revalidate();
        this.repaint();
    }

    public int messageBox(String title, String text, int modifiers) {
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), text, title, 0);
        return 0;
    }

    public void goUp() {
    }

    public void goDown(boolean wrap) {
    }

    public void goLeft() {
    }

    public void goRight() {
    }

    public void addComponent(Component component) {
        if (this.getLayout() != this.workingLayout) {
            this.setLayout((LayoutManager)this.workingLayout);
        }
        this.add(component, 0);
    }

    public void removeComponent(Component component) {
        this.remove(component);
    }

    public Item getSelectedItem() {
        return this.current;
    }

    public void addItem(Component component) {
    }

    public void calcSize(Component component) {
    }

    public void endEdit(Item target) {
    }

    public void insertItem(Item target) {
    }

    public void deleteItem(Item target, boolean focus) {
    }

    public Popup createEditPopupMenu(Item parent, MenuDesignerContainer container) {
        return new EditPopupMenu(parent, container);
    }

    public Item createEditMenuItem(Item parent, MenuDesignerContainer container) {
        return new EditMenuItem(parent, container);
    }

    public Item createEditMenuItemSeperator(Item parent, MenuDesignerContainer container) {
        return new EditMenuItemSeperator(parent, container);
    }

    public void insertSeperator(Item target) {
    }

    public void moveItem(Item source, Item destination, boolean notify) {
    }

    public void deletePopup(Item popup) {
    }

    public boolean isReadOnly() {
        return this.explorer.getUIEditor().getComponentSource().isReadOnly();
    }

    public void notify(MenuEvent evt) {
        this.moveDown = false;
        if (this.model != null) {
            if (evt instanceof FocusChange) {
                this.performFocusChange((FocusChange)evt);
            }
            if (evt instanceof NewItem) {
                this.performNewItem((NewItem)evt, true);
            } else if (evt instanceof NewMenu) {
                this.performNewMenu((NewMenu)evt);
            } else if (evt instanceof NewPopup) {
                this.performNewPopup((NewPopup)evt);
            } else if (evt instanceof TextChanged) {
                this.performTextChanged((TextChanged)evt, true);
            } else if (evt instanceof EnabledChanged) {
                this.performEnabledChanged((EnabledChanged)evt);
            } else if (evt instanceof DeleteItem) {
                this.performDeleteItem((DeleteItem)evt);
            } else if (evt instanceof ConvertToMenu) {
                this.performConvertToMenu((ConvertToMenu)evt);
            } else if (evt instanceof ConvertToMenuItem) {
                this.performConvertToMenuItem((ConvertToMenuItem)evt);
            } else if (evt instanceof InsertSeparator) {
                this.performInsertSeparator((InsertItem)evt);
            } else if (evt instanceof InsertMenu) {
                this.performInsertMenu((InsertMenu)evt);
            } else if (evt instanceof InsertItem) {
                this.performInsertItem((InsertItem)evt);
            } else if (evt instanceof MoveItem) {
                this.performMoveItem((MoveItem)evt);
            } else if (evt instanceof CheckedChanged) {
                this.performCheckChanged((CheckedChanged)evt);
            } else if (evt instanceof EnabledChanged) {
                this.performEnabledChanged((EnabledChanged)evt);
            }
        }
    }

    public void register(Object item, MenuNode menuNode) {
        this.cmtSubcomponents.put(menuNode, item);
    }

    public boolean isDeletable(Item item) {
        return false;
    }

    public Item hitTest(int x, int y) {
        return this.itemAt(x, y);
    }

    public Item itemAt(int x, int y) {
        return ((MenuDesignerContainer)((Object)this.rootItem)).itemAt(x, y);
    }

    public JTextField getTextField(EditMenuItem item) {
        if (this.textField == null) {
            this.textField = new JTextField();
            this.textField.setVisible(false);
            this.textField.setFont(item.getFont());
            this.textField.setCaret(new DefaultCaret());
            int rate = UIManager.getInt("TextField.caretBlinkRate");
            this.textField.getCaret().setBlinkRate(rate);
        }
        Rectangle r = item.getBounds();
        Component c = item.getComponent();
        while (c.getParent() != this) {
            Container parent = c.getParent();
            r.x += parent.getBounds().x;
            r.y += parent.getBounds().y;
            c = parent;
        }
        this.textField.setVisible(false);
        return this.textField;
    }

    public void processKeyEvent(KeyEvent e) {
        try {
            if (this.current != null) {
                ((Component)this.current).dispatchEvent(e);
            }
        }
        catch (Exception exp) {
            this.getParent().dispatchEvent(e);
        }
    }

    private PersistentItem createMenu() {
        if (this.rootItem != null) {
            try {
                this.rootItem.setVisible(false);
                this.rootItem.trash();
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
        this.removeAll();
        this.current = null;
        this.rootItem = new EditMenuBar(this);
        this.rootItem.setVisible(false);
        this.rootItem.move(10, 10);
        this.addComponent(this.rootItem.getComponent());
        return this.rootItem;
    }

    private PersistentItem createPopup() {
        if (this.rootItem != null) {
            try {
                this.rootItem.setVisible(false);
                this.rootItem.trash();
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
        this.removeAll();
        this.current = null;
        this.rootItem = new EditPopupMenu(null, this);
        this.rootItem.setVisible(false);
        this.rootItem.move(10, 10);
        this.addComponent(this.rootItem.getComponent());
        return this.rootItem;
    }

    public void changeSelection(Element[] selections) {
        if (selections != null && selections.length > 0) {
            this.setTarget((CmtModelNode)selections[0]);
        } else {
            this.setTarget(null);
        }
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.current != null) {
            this.current.setSelected(true, null, true);
            this.current.getComponent().requestFocus();
        }
    }

    private void reset() {
        this.cmtSubcomponents.clear();
        if (this.rootItem != null) {
            try {
                this.rootItem.setVisible(false);
                this.rootItem.trash();
                this.rootItem = null;
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
        this.removeAll();
        this.current = null;
        this.model = null;
        this.rootNode = null;
        Dimension size = this.getSize();
        this.setLayout(this.placeHolderLayout);
        this.add((Component)this.placeHolder, "Center");
        this.repaint();
    }

    CmtModel getModel() {
        return this.model;
    }

    void setTarget(CmtModelNode target) {
        CmtModel targetModel;
        View activeView = Ide.getMainWindow().getLastActiveView();
        boolean setFocus = true;
        setFocus = activeView == this.explorer.getUIEditor();
        CmtModel cmtModel = targetModel = target != null ? target.getCmtModel() : null;
        if (!(targetModel instanceof MenuDesignerModel)) {
            if (target == null && this.current != null && this.current.isBlank()) {
                this.current.select(this.current, setFocus);
            } else {
                this.select(null, setFocus);
            }
            return;
        }
        Object hit = null;
        if (target.getSubcomponent() != null && (this.rootNode == null || this.rootNode != targetModel.getRoot())) {
            if (this.model != null) {
                this.model.removeDesigner(this);
            }
            this.rootNode = (MenuNode)targetModel.getRoot();
            this.rootSubcomponent = this.rootNode.getSubcomponent();
            this.model = (MenuDesignerModel)targetModel;
            this.model.addDesigner(this);
            Object live = this.rootNode.getSubcomponent().getLiveInstance();
            if (live instanceof MenuBar || live instanceof JMenuBar) {
                this.setVisible(false);
                this.cmtSubcomponents.clear();
                this.rootItem = this.createMenu();
                this.rootItem.construct(this, this.rootNode);
                this.rootItem.insertBlank();
                this.rootItem.setVisible(true);
                this.setVisible(true);
                this.validate();
            } else if (live instanceof PopupMenu || live instanceof JPopupMenu) {
                this.setVisible(false);
                this.cmtSubcomponents.clear();
                this.rootItem = this.createPopup();
                this.rootItem.construct(this, this.rootNode);
                this.rootItem.insertBlank();
                this.rootItem.setVisible(true);
                this.setVisible(true);
                this.validate();
            } else {
                this.reset();
                return;
            }
            this.register(this.rootItem, this.rootNode);
            hit = this.cmtSubcomponents.get(target);
        } else {
            hit = this.cmtSubcomponents.get(target);
        }
        if (hit instanceof EditMenuBar) {
            if (setFocus) {
                ((EditMenuBar)hit).setFocus(true);
            } else {
                this.select(null, setFocus);
            }
        } else if (hit instanceof EditPopupMenu) {
            EditPopupMenu popup = hit;
            popup.select(popup.getParentItem(), setFocus);
            if (this.moveDown) {
                popup.getContainer().goDown(false);
            }
        } else if (hit instanceof EditMenuItem) {
            EditMenuItem item = hit;
            item.select(item, setFocus);
            if (this.moveDown) {
                item.getContainer().goDown(false);
                item.notifyFocusChange();
            }
        } else {
            this.reset();
            this.select(null, setFocus);
        }
    }

    private void performFocusChange(FocusChange focusChange) {
        MenuNode selected;
        UIEditor editor = this.explorer.getUIEditor();
        CmtComponentSource source = editor.getComponentSource();
        CmtSelectionModel selModel = source.getSelectionModel();
        MenuNode menuNode = selected = this.current != null && this.current.menuNode != null ? this.current.menuNode : null;
        if (selected != null) {
            selModel.setSelection(new CmtModelNode[]{selected});
        } else if (selModel.getSelectionCount() > 0) {
            selModel.clearSelection();
        } else {
            this.explorer.viewSelectionChanged(new ViewSelectionEvent((View)this.explorer.getUIEditor()));
        }
    }

    private void performNewItem(NewItem newItem, boolean doCommit) {
        MenuNode parent = newItem.menu.getMenuNode();
        CmtComponentSource src = null;
        try {
            if (doCommit) {
                src = this.explorer.getUIEditor().getComponentSource();
                src.beginTrans();
            }
            if (parent != null && this.model != null) {
                CmtComponentSource comp;
                String menuClass = "java.awt.MenuItem";
                if (parent.isSwing()) {
                    menuClass = "javax.swing.JMenuItem";
                }
                String label = newItem.item.getLabel();
                MenuNode node = (MenuNode)this.model.add(newItem.menu.getMenuNode(), menuClass, null, null);
                this.register(newItem.item, node);
                newItem.item.setMenuNode(node);
                newItem.item.setLabel(label != null ? label : "");
                CmtComponentSource cmtComponentSource = comp = node != null ? this.explorer.getUIEditor().getComponentSource() : null;
                if (comp != null) {
                    comp.getSelectionModel().setSelection(new CmtModelNode[]{node});
                }
            }
            this.performTextChanged(new TextChanged(newItem.item), false);
            if (doCommit) {
                this.moveDown = true;
                src.commit(Res.getString(59));
                src = null;
            }
        }
        finally {
            if (src != null) {
                src.abort();
            }
        }
    }

    private void performNewMenu(NewMenu newMenu) {
        CmtComponentSource src = null;
        try {
            src = this.explorer.getUIEditor().getComponentSource();
            src.beginTrans();
            if (this.model != null) {
                CmtComponentSource comp;
                EditMenuBar menuBar = (EditMenuBar)newMenu.item.getContainer();
                String label = newMenu.item.getLabel();
                String menuClass = "java.awt.Menu";
                if (menuBar.getMenuNode().isSwing()) {
                    menuClass = "javax.swing.JMenu";
                }
                MenuNode node = (MenuNode)this.model.add(menuBar.getMenuNode(), menuClass, null, null);
                this.register(newMenu.item.getPopup(), node);
                newMenu.item.setMenuNode(node);
                newMenu.item.getPopup().setMenuNode(node);
                newMenu.item.setLabel(label != null ? label : "");
                CmtComponentSource cmtComponentSource = comp = node != null ? this.explorer.getUIEditor().getComponentSource() : null;
                if (comp != null) {
                    comp.getSelectionModel().setSelection(new CmtModelNode[]{node});
                }
            }
            this.performTextChanged(new TextChanged(newMenu.item), false);
            this.moveDown = true;
            src.commit(Res.getString(59));
            src = null;
        }
        finally {
            if (src != null) {
                src.abort();
            }
        }
    }

    private void performNewPopup(NewPopup newPopup) {
        this.performNewItem(newPopup, false);
        this.performConvertToMenu(new ConvertToMenu(newPopup.item, newPopup.item.getMenuNode()));
    }

    private void performTextChanged(TextChanged textChanged, boolean doCommit) {
        if (textChanged.item instanceof EditMenuItem) {
            CmtComponentSource src = null;
            try {
                CmtPropertyState label1;
                MenuNode node;
                CmtPropertyState label;
                if (doCommit) {
                    src = this.explorer.getUIEditor().getComponentSource();
                    src.beginTrans();
                }
                if ((label = (node = textChanged.item.getMenuNode()).getSubcomponent().getPropertyState("text")) != null && label.getPropertySetting() == null && (label1 = node.getSubcomponent().getPropertyState(LABEL_PROP)) != null && label1.getPropertySetting() != null) {
                    label = label1;
                }
                if (label == null) {
                    label = node.getSubcomponent().getPropertyState(LABEL_PROP);
                }
                if (label != null) {
                    try {
                        label.setValue(textChanged.item.getLabel());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (doCommit) {
                    this.moveDown = true;
                    src.commit(Res.getString(59));
                    src = null;
                }
            }
            finally {
                if (src != null) {
                    src.abort();
                }
            }
        }
    }

    private void performEnabledChanged(EnabledChanged enabledChanged) {
        if (enabledChanged.item instanceof EditMenuItem) {
            CmtComponentSource src = null;
            try {
                src = this.explorer.getUIEditor().getComponentSource();
                src.beginTrans();
                MenuNode node = enabledChanged.item.getMenuNode();
                CmtPropertyState enabled = node.getSubcomponent().getPropertyState(ENABLED_PROP);
                if (enabled != null) {
                    try {
                        enabled.setValue(new Boolean(enabledChanged.item.isItemEnabled()));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                src.commit(Res.getString(59));
                src = null;
            }
            finally {
                if (src != null) {
                    src.abort();
                }
            }
        }
    }

    private void performDeleteItem(DeleteItem deleteItem) {
        MenuNode node = deleteItem.item.getMenuNode();
        CmtComponentSource src = null;
        try {
            src = this.explorer.getUIEditor().getComponentSource();
            src.beginTrans();
            this.model.getComponentSource().getStructure().removeNodeFromParent(node);
            src.commit(Res.getString(59));
            src = null;
        }
        finally {
            if (src != null) {
                src.abort();
            }
        }
    }

    private void performConvertToMenu(ConvertToMenu convertToMenu) {
        if (this.model != null) {
            CmtComponentSource src = null;
            try {
                CmtComponentSource comp;
                src = this.explorer.getUIEditor().getComponentSource();
                src.beginTrans();
                MenuNode node = (MenuNode)this.model.convertToMenu(convertToMenu.component);
                this.register(convertToMenu.item, node);
                convertToMenu.item.setMenuNode(node);
                convertToMenu.item.getPopup().setMenuNode(node);
                CmtComponentSource cmtComponentSource = comp = node != null ? this.explorer.getUIEditor().getComponentSource() : null;
                if (comp != null) {
                    comp.getSelectionModel().setSelection(new CmtModelNode[]{node});
                }
                this.moveDown = true;
                src.commit(Res.getString(59));
                src = null;
            }
            finally {
                if (src != null) {
                    src.abort();
                }
            }
        }
    }

    private void performConvertToMenuItem(ConvertToMenuItem convertToMenuItem) {
        if (this.model != null) {
            boolean wasFocusCycleRoot = this.isFocusCycleRoot();
            CmtComponentSource src = null;
            try {
                CmtComponentSource comp;
                CmtPropertyState label1;
                src = this.explorer.getUIEditor().getComponentSource();
                src.beginTrans();
                FocusTraversalPolicy focusPolicy = this.getFocusTraversalPolicy();
                this.setFocusCycleRoot(true);
                this.setFocusTraversalPolicy(this.dummyPolicy);
                MenuNode node = (MenuNode)this.model.convertToMenuItem(convertToMenuItem.component);
                this.register(convertToMenuItem.item, node);
                convertToMenuItem.item.setMenuNode(node);
                this.setFocusCycleRoot(wasFocusCycleRoot);
                this.setFocusTraversalPolicy(focusPolicy);
                CmtPropertyState label = node.getSubcomponent().getPropertyState("text");
                if (label != null && label.getPropertySetting() == null && (label1 = node.getSubcomponent().getPropertyState(LABEL_PROP)) != null && label1.getPropertySetting() != null) {
                    label = label1;
                }
                if (label != null) {
                    try {
                        label.setDefaultValue(null);
                        label.setValue(convertToMenuItem.item.getLabel());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                CmtComponentSource cmtComponentSource = comp = node != null ? this.explorer.getUIEditor().getComponentSource() : null;
                if (comp != null) {
                    comp.getSelectionModel().setSelection(new CmtModelNode[]{node});
                }
                src.commit(Res.getString(59));
                src = null;
            }
            finally {
                if (src != null) {
                    src.abort();
                }
            }
        }
    }

    private void performInsertMenu(InsertMenu insertMenu) {
        EditMenuBar menuBar = insertMenu.menuBar;
        MenuNode aheadOf = insertMenu.aheadOf.getMenuNode();
        String menuClass = "java.awt.Menu";
        if (menuBar.getMenuNode().isSwing()) {
            menuClass = "javax.swing.JMenu";
        }
        CmtComponentSource src = null;
        try {
            CmtComponentSource comp;
            src = this.explorer.getUIEditor().getComponentSource();
            src.beginTrans();
            MenuNode node = (MenuNode)this.model.add(menuBar.getMenuNode(), menuClass, aheadOf, null);
            this.register(insertMenu.menuItem.getPopup(), node);
            insertMenu.menuItem.setMenuNode(node);
            insertMenu.menuItem.getPopup().setMenuNode(node);
            CmtComponentSource cmtComponentSource = comp = node != null ? this.explorer.getUIEditor().getComponentSource() : null;
            if (comp != null) {
                comp.getSelectionModel().setSelection(new CmtModelNode[]{node});
            }
            src.commit(Res.getString(59));
            src = null;
        }
        finally {
            if (src != null) {
                src.abort();
            }
        }
    }

    private void performInsertItem(InsertItem insertItem) {
        MenuNode parent = insertItem.parent.getMenuNode();
        String menuClass = "java.awt.MenuItem";
        if (parent.isSwing()) {
            menuClass = "javax.swing.JMenuItem";
        }
        CmtComponentSource src = null;
        try {
            CmtComponentSource comp;
            src = this.explorer.getUIEditor().getComponentSource();
            src.beginTrans();
            MenuNode aheadOf = insertItem.aheadOf.getMenuNode();
            MenuNode node = (MenuNode)this.model.add(parent, menuClass, aheadOf, null);
            insertItem.item.setMenuNode(node);
            this.register(insertItem.item, node);
            CmtComponentSource cmtComponentSource = comp = node != null ? this.explorer.getUIEditor().getComponentSource() : null;
            if (comp != null) {
                comp.getSelectionModel().setSelection(new CmtModelNode[]{node});
            }
            src.commit(Res.getString(59));
            src = null;
        }
        finally {
            if (src != null) {
                src.abort();
            }
        }
    }

    private void performInsertSeparator(InsertItem insertItem) {
        MenuNode parent = insertItem.parent.getMenuNode();
        MenuNode aheadOf = insertItem.aheadOf.getMenuNode();
        CmtComponentSource src = null;
        try {
            CmtComponentSource comp;
            src = this.explorer.getUIEditor().getComponentSource();
            src.beginTrans();
            MenuNode node = (MenuNode)this.model.insertSeparator(parent, aheadOf);
            insertItem.item.setMenuNode(node);
            this.register(insertItem.item, node);
            CmtComponentSource cmtComponentSource = comp = node != null ? this.explorer.getUIEditor().getComponentSource() : null;
            if (comp != null) {
                comp.getSelectionModel().setSelection(new CmtModelNode[]{node});
            }
            src.commit(Res.getString(59));
            src = null;
        }
        finally {
            if (src != null) {
                src.abort();
            }
        }
    }

    private void performMoveItem(MoveItem moveItem) {
        CmtComponentSource src = null;
        try {
            CmtComponentSource comp;
            src = this.explorer.getUIEditor().getComponentSource();
            src.beginTrans();
            MenuNode node = (MenuNode)this.model.move(moveItem.src, moveItem.dstParent, moveItem.aheadOf);
            this.register(moveItem.item, node);
            moveItem.item.setMenuNode(node);
            CmtComponentSource cmtComponentSource = comp = this.explorer != null ? this.explorer.getUIEditor().getComponentSource() : null;
            if (comp != null) {
                comp.getSelectionModel().setSelection(new CmtModelNode[]{node});
            }
            src.commit(Res.getString(59));
            src = null;
        }
        finally {
            if (src != null) {
                src.abort();
            }
        }
    }

    private void performCheckChanged(CheckedChanged checkChanged) {
        CmtComponentSource src = null;
        try {
            CmtComponentSource comp;
            CmtPropertyState label1;
            src = this.explorer.getUIEditor().getComponentSource();
            src.beginTrans();
            MenuNode node = (MenuNode)this.model.checkChanged(checkChanged.item.getMenuNode(), checkChanged.checked);
            this.register(checkChanged.item, node);
            checkChanged.item.setMenuNode(node);
            CmtPropertyState label = node.getSubcomponent().getPropertyState("text");
            if (label != null && label.getPropertySetting() == null && (label1 = node.getSubcomponent().getPropertyState(LABEL_PROP)) != null && label1.getPropertySetting() != null) {
                label = label1;
            }
            String newLabel = checkChanged.item.getLabel();
            if (label != null) {
                if (newLabel == null || newLabel.length() <= 0) {
                    newLabel = (String)label.getValue();
                }
                try {
                    label.setDefaultValue(null);
                    label.setValue(newLabel);
                    checkChanged.item.setLabel(newLabel);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            CmtComponentSource cmtComponentSource = comp = node != null ? this.explorer.getUIEditor().getComponentSource() : null;
            if (comp != null) {
                comp.getSelectionModel().setSelection(new CmtModelNode[]{node});
            }
            src.commit(Res.getString(59));
            src = null;
        }
        finally {
            if (src != null) {
                src.abort();
            }
        }
    }

    void removeFromDesigner(MenuNode node) {
        Object hit = this.cmtSubcomponents.get(node);
        if (hit instanceof EditMenuItem) {
            EditMenuItem item = (EditMenuItem)hit;
            item.delete(false, false);
        } else if (hit instanceof Popup) {
            EditPopupMenu item = (EditPopupMenu)hit;
            Item parent = item.getParentItem();
            if (parent != null) {
                ((EditMenuItem)parent).delete(false, false);
            } else {
                this.reset();
            }
        } else if (hit != null) {
            this.reset();
        }
    }

    public void showContextMenu(MouseEvent e) {
        this.explorer.getContextMenu().show(this.explorer.owner().getContext((EventObject)e));
    }

    final class 1
    extends FocusTraversalPolicy {
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            return MenuDesigner.this;
        }

        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            return MenuDesigner.this;
        }

        public Component getDefaultComponent(Container focusCycleRoot) {
            return MenuDesigner.this;
        }

        public Component getFirstComponent(Container focusCycleRoot) {
            return MenuDesigner.this;
        }

        public Component getInitialComponent(Window window) {
            return MenuDesigner.this;
        }

        public Component getLastComponent(Container focusCycleRoot) {
            return MenuDesigner.this;
        }
    }

    final class 2
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            this.tryPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.tryPopup(e);
        }

        private void tryPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                MenuDesigner.this.showContextMenu(e);
            }
        }
    }
}

