/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.menucanvas;

import java.awt.Component;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.jdeveloper.cmt.CmtComponent;
import oracle.jdeveloper.cmt.CmtComponentSource;
import oracle.jdeveloper.cmt.CmtComponents;
import oracle.jdeveloper.cmt.CmtMethodCall;
import oracle.jdeveloper.cmt.CmtMethodSource;
import oracle.jdeveloper.cmt.CmtModel;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.cmt.CmtPropertySetting;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdevimpl.uieditor.menucanvas.CheckMenuNode;
import oracle.jdevimpl.uieditor.menucanvas.MenuDesigner;
import oracle.jdevimpl.uieditor.menucanvas.MenuNode;
import oracle.jdevimpl.uieditor.menucanvas.Res;
import oracle.jdevimpl.uieditor.menucanvas.SeparatorMenuNode;
import oracle.jdevimpl.uieditor.uicanvas.Model;
import oracle.jdevimpl.uieditor.uicanvas.ModelNode;
import oracle.jdevimpl.uieditor.uicanvas.NodeMemento;

public final class MenuDesignerModel
extends Model {
    static final String MENUBAR_CLASS = "java.awt.MenuBar";
    static final String MENU_CLASS = "java.awt.Menu";
    static final String MENUITEM_CLASS = "java.awt.MenuItem";
    static final String CHECKMENUITEM_CLASS = "java.awt.CheckboxMenuItem";
    static final String POPUPMENU_CLASS = "java.awt.PopupMenu";
    static final String SWING_MENUBAR_CLASS = "javax.swing.JMenuBar";
    static final String SWING_MENU_CLASS = "javax.swing.JMenu";
    static final String SWING_MENUITEM_CLASS = "javax.swing.JMenuItem";
    static final String SWING_CHECKMENUITEM_CLASS = "javax.swing.JCheckBoxMenuItem";
    static final String SWING_POPUPMENU_CLASS = "javax.swing.JPopupMenu";
    private MenuDesigner designer;
    private Component view;

    public MenuDesignerModel(CmtComponents mgr, CmtComponent component, NodeMemento memento) {
        super(mgr, component, memento);
    }

    public void setView(Component view) {
        this.view = view;
    }

    public Component getView() {
        return this.view;
    }

    public String getName() {
        return Res.getString(26);
    }

    public boolean isSubcomponentOwned(CmtSubcomponent subcomponent) {
        int menuType = NodeMemento.getType(subcomponent, this.manager);
        return menuType == -5 || menuType == -3 || menuType == -4 || menuType == -2 || menuType == -1;
    }

    public CmtModelNode add(CmtModelNode parent, String type, CmtModelNode aheadOf, String initializer) {
        MenuDesignerModel childModel;
        CmtModelNode child = super.add(parent, type, aheadOf, initializer);
        if (child != null && (childModel = (MenuDesignerModel)child.getCmtModel()) != this && NodeMemento.getType(type, this.manager) == -2) {
            childModel.assertSetMenuBar((MenuNode)child);
        }
        return child;
    }

    public CmtModelNode move(CmtModelNode component, CmtModelNode newParent, CmtModelNode aheadOf) {
        boolean isToplevel;
        MenuNode node = (MenuNode)component;
        boolean wasToplevel = node.getParentNode() == this.root;
        boolean bl = isToplevel = newParent == this.root;
        if (!wasToplevel && isToplevel && !node.isContainer()) {
            String type = node.isSwing() ? SWING_MENU_CLASS : MENU_CLASS;
            component = this.changeType(node, type, newParent, aheadOf);
        } else {
            int index;
            ModelNode oldParent = (ModelNode)node.getParent();
            int oldIndex = oldParent.getIndex(node);
            int n = index = aheadOf != null ? newParent.getIndex(aheadOf) : -1;
            if (index == -1) {
                index = newParent.getChildCount();
                if (newParent == oldParent) {
                    --index;
                }
            } else {
                int currentIndex = newParent.getIndex(node);
                if (currentIndex > -1 && currentIndex < index) {
                    --index;
                }
            }
            newParent.insert(node, index);
            ((ModelNode)newParent).moveChild(oldParent, node, null, null, newParent != oldParent, null);
            DefaultTreeModel treeModel = this.componentSource.getStructure();
            if (oldParent != newParent) {
                treeModel.nodesWereRemoved(oldParent, new int[]{oldIndex}, new Object[]{node});
                treeModel.nodesWereInserted(newParent, new int[]{index});
            } else {
                this.componentSource.getStructure().nodeStructureChanged(newParent);
            }
        }
        return component;
    }

    protected CmtModelNode buildModelNode(NodeMemento memento) {
        if (memento == null || memento.type >= 0 && memento.type != 1) {
            return null;
        }
        switch (memento.type) {
            case -5: {
                return new CheckMenuNode(this, memento, null);
            }
            case -6: 
            case 1: {
                return new SeparatorMenuNode(this, memento, null);
            }
        }
        return new MenuNode(this, memento, null);
    }

    protected CmtModelNode buildModelNode(String typeName, String name, String initializer) {
        int type = NodeMemento.getType(typeName, this.manager);
        if (type >= 0 && type != 1) {
            return null;
        }
        switch (type) {
            case -5: {
                return new CheckMenuNode(this, typeName, name, initializer);
            }
            case 1: {
                return new SeparatorMenuNode(this, typeName, name, initializer);
            }
        }
        return new MenuNode(this, typeName, name, initializer);
    }

    protected CmtModelNode buildModelNode(CmtSubcomponent subcomponent) {
        JavaClass jClass = subcomponent.getDeclaredClass();
        String typeName = jClass.getName();
        int type = NodeMemento.getType(typeName, this.manager);
        if (type >= 0 && type != 1) {
            return null;
        }
        switch (type) {
            case -5: {
                return new CheckMenuNode(this, subcomponent);
            }
            case 1: {
                return new SeparatorMenuNode((Model)this, subcomponent);
            }
        }
        return new MenuNode(this, subcomponent);
    }

    protected Model buildModel() {
        return new MenuDesignerModel(this.manager, this.componentSource, null);
    }

    protected boolean isValidParent(CmtModelNode parent, Class childCls) {
        if (super.isValidParent(parent, childCls)) {
            int type = NodeMemento.getType(childCls.getName(), this.manager);
            return type != -2 && type != -1;
        }
        return false;
    }

    void assertSetMenuBar(MenuNode node) {
        CmtPropertyState menuBar = this.getMenubar(node);
        if (menuBar != null && menuBar.getValue() == null) {
            try {
                menuBar.setValue(node.getSubcomponent().getLiveInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void assertSetMenuBarRemoved(MenuNode node) {
        CmtPropertyState menuBar = this.getMenubar(node);
        if (menuBar != null && menuBar.getValue() == node.getSubcomponent().getLiveInstance()) {
            menuBar.reset();
        }
    }

    private CmtPropertyState getMenubar(MenuNode node) {
        CmtSubcomponent parent;
        CmtComponent outer = node.getSubcomponent().getOuterComponent();
        if (outer != null && (parent = outer.getSubcomponent(null)) != null) {
            return parent.getPropertyState(node.isSwing() ? "JMenuBar" : "menuBar");
        }
        return null;
    }

    private static void copyPropertySettings(CmtSubcomponent fromSubcomponent, CmtSubcomponent toSubcomponent) {
        if (fromSubcomponent == null || toSubcomponent == null) {
            return;
        }
        List propSettings = ((CmtComponentSource)fromSubcomponent.getOuterComponent()).getInitMethod().getPropertySettings(fromSubcomponent, true);
        int size = propSettings != null ? propSettings.size() : -1;
        int i = 0;
        while (i < size) {
            CmtPropertySetting setting = (CmtPropertySetting)propSettings.get(i);
            CmtPropertyState ps = toSubcomponent.getPropertyState(setting.getProperty().getName());
            if (ps != null) {
                try {
                    ps.setDefaultValue(null);
                    ps.setValue(setting.getLiveValue());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    private CmtModelNode changeType(ModelNode node, String type, CmtModelNode newParent, CmtModelNode aheadOf) {
        CmtModelNode newNode = this.add(newParent, type, aheadOf, null);
        MenuDesignerModel.copyPropertySettings(node.getSubcomponent(), newNode.getSubcomponent());
        this.componentSource.removeSubcomponent(node.getSubcomponent());
        this.componentSource.getStructure().removeNodeFromParent(node);
        return newNode;
    }

    CmtModelNode convertToMenu(MenuNode node) {
        MenuNode parent = (MenuNode)node.getParentNode();
        MenuNode aheadOf = parent.getNextSibling(node);
        String type = node.isSwing() ? SWING_MENU_CLASS : MENU_CLASS;
        CmtModelNode newNode = this.changeType(node, type, parent, aheadOf);
        return newNode;
    }

    CmtModelNode convertToMenuItem(MenuNode node) {
        MenuNode parent = (MenuNode)node.getParentNode();
        MenuNode aheadOf = parent.getNextSibling(node);
        boolean isSwing = node.isSwing();
        String type = isSwing ? SWING_MENUITEM_CLASS : MENUITEM_CLASS;
        CmtModelNode newNode = this.changeType(node, type, parent, aheadOf);
        return newNode;
    }

    CmtModelNode insertSeparator(CmtModelNode parent, CmtModelNode aheadOf) {
        if (parent == null) {
            return null;
        }
        if (aheadOf != null) {
            CmtModel siblingModel = aheadOf.getCmtModel();
            if (parent.getCmtModel() != siblingModel) {
                if (siblingModel instanceof Model) {
                    return null;
                }
                aheadOf = null;
            }
        }
        CmtMethodSource method = this.componentSource.getInitMethod();
        CmtSubcomponent comp = parent.getSubcomponent();
        CmtMethodCall call = method.addMethodCall(comp, "addSeparator");
        SeparatorMenuNode child = new SeparatorMenuNode((Model)this, call);
        DefaultTreeModel structure = this.componentSource.getStructure();
        int index = aheadOf != null ? parent.getIndex(aheadOf) : parent.getChildCount();
        structure.insertNodeInto(child, parent, index);
        ((ModelNode)parent).moveChild(null, child, null, null, true, null);
        return child;
    }

    CmtModelNode checkChanged(MenuNode node, boolean checked) {
        String type;
        MenuNode parent = (MenuNode)node.getParentNode();
        MenuNode aheadOf = parent.getNextSibling(node);
        String string = type = checked ? CHECKMENUITEM_CLASS : MENUITEM_CLASS;
        if (node.isSwing()) {
            type = checked ? SWING_CHECKMENUITEM_CLASS : SWING_MENUITEM_CLASS;
        }
        CmtModelNode newNode = this.changeType(node, type, parent, aheadOf);
        return newNode;
    }

    void addDesigner(MenuDesigner designer) {
        this.designer = designer;
    }

    void removeDesigner(MenuDesigner designer) {
        this.designer = null;
    }

    void removeFromDesigners(MenuNode node) {
        if (this.designer != null) {
            this.designer.removeFromDesigner(node);
        }
    }

    MenuNode getMenuNode(CmtSubcomponent component, boolean byName) {
        return this.root != null ? ((MenuNode)this.root).find(component, byName) : null;
    }

    protected boolean isRecognized(Class cls) {
        if (NodeMemento.swingMenuBarClass != null && NodeMemento.swingMenuBarClass.isAssignableFrom(cls)) {
            return true;
        }
        if (NodeMemento.swingPopupMenuClass != null && NodeMemento.swingPopupMenuClass.isAssignableFrom(cls)) {
            return true;
        }
        if (NodeMemento.swingMenuItemClass != null && NodeMemento.swingMenuItemClass.isAssignableFrom(cls)) {
            return true;
        }
        if (NodeMemento.swingSeparatorClass != null && NodeMemento.swingSeparatorClass.isAssignableFrom(cls)) {
            return true;
        }
        if (NodeMemento.awtMenuBarClass != null && NodeMemento.awtMenuBarClass.isAssignableFrom(cls)) {
            return true;
        }
        if (NodeMemento.awtPopupMenuClass != null && NodeMemento.awtPopupMenuClass.isAssignableFrom(cls)) {
            return true;
        }
        return NodeMemento.awtMenuItemClass != null && NodeMemento.awtMenuItemClass.isAssignableFrom(cls);
    }
}

