/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.menucanvas;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.MenuBar;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JMenuBar;
import javax.swing.tree.TreeNode;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.java.legacy.JotNames;
import oracle.jdevimpl.uieditor.menucanvas.MenuDesignerModel;
import oracle.jdevimpl.uieditor.menucanvas.Res;
import oracle.jdevimpl.uieditor.uicanvas.Model;
import oracle.jdevimpl.uieditor.uicanvas.ModelNode;
import oracle.jdevimpl.uieditor.uicanvas.NodeAddCall;
import oracle.jdevimpl.uieditor.uicanvas.NodeMemento;

public class MenuNode
extends ModelNode {
    private static final String JAVA_PACKAGE = "javax.swing";

    public MenuNode(Model model, NodeMemento memento, ModelNode parent) {
        super(model, memento, parent);
    }

    public MenuNode(Model model, String type, String name, String initializer) {
        super(model, type, name, initializer);
    }

    public MenuNode(Model model, CmtSubcomponent subcomponent) {
        super(model, subcomponent);
    }

    final boolean isSwing() {
        String clsName = this.getSubcomponent().getDeclaredClass().getQualifiedName();
        String pkgName = JotNames.getPackageFromFullClassName(clsName);
        return JAVA_PACKAGE.equals(pkgName);
    }

    public final void moveChild(ModelNode oldParent, ModelNode child, Point location, Dimension size, boolean isAdd, Point mouseOffset) {
        if (isAdd) {
            child.setConstraintsType(this.getLayoutAssistant(), true);
            ((NodeAddCall)child.getConstraints()).setContainer(this.subcomponent);
        }
        child.adjustPosition(false);
    }

    final MenuNode getNextSibling(CmtModelNode node) {
        int i;
        if (this.children != null && (i = this.getIndex(node)) >= 0 && i < this.getChildCount() - 1) {
            return (MenuNode)this.getChildAt(++i);
        }
        return null;
    }

    final MenuNode getPrevSibling(CmtModelNode node) {
        int i;
        if (this.children != null && (i = this.getIndex(node)) > 0) {
            return (MenuNode)this.getChildAt(--i);
        }
        return null;
    }

    final MenuNode find(CmtSubcomponent component, boolean byName) {
        if (byName ? this.subcomponent != null && component != null && this.subcomponent.getName().equals(component.getName()) : component == this.getSubcomponent()) {
            return this;
        }
        Iterator i = this.getChildren();
        if (i != null) {
            while (i.hasNext()) {
                MenuNode result;
                Object child = i.next();
                if (!(child instanceof MenuNode) || (result = ((MenuNode)child).find(component, byName)) == null) continue;
                return result;
            }
        }
        return null;
    }

    final String getLabel() {
        CmtPropertyState labelPS;
        if (this.subcomponent != null && (labelPS = this.subcomponent.getPropertyState("label")) != null) {
            return (String)labelPS.getValue();
        }
        return Res.getString(32);
    }

    protected final void removeFromLiveContainer() {
        ((MenuDesignerModel)this.getCmtModel()).removeFromDesigners(this);
    }

    public final void removeSourceRepresentation() {
        Object liveInstance;
        Object object = liveInstance = this.subcomponent != null ? this.subcomponent.getLiveInstance() : null;
        if (liveInstance instanceof MenuBar || liveInstance instanceof JMenuBar) {
            ((MenuDesignerModel)this.getCmtModel()).assertSetMenuBarRemoved(this);
        }
        super.removeSourceRepresentation();
    }

    public final void createLiveComponent() {
        if (this.liveSubcomponent == null && this.subcomponent != null) {
            Object liveObject = this.subcomponent.getLiveInstance();
            Component component = this.liveSubcomponent = liveObject instanceof Component ? (Component)liveObject : null;
            if (this.isContainer() && this.realLayoutState != null) {
                Container container = this.subcomponent.getAsContainer();
                this.realLayoutState.setDefaultValue(container.getLayout());
            }
            if (this.liveSubcomponent != null) {
                this.liveSubcomponent.addComponentListener(null);
            }
        }
        Enumeration<TreeNode> en = this.children();
        while (en.hasMoreElements()) {
            CmtModelNode child = (CmtModelNode)en.nextElement();
            if (!(child instanceof ModelNode)) continue;
            ((ModelNode)child).createLiveComponent();
        }
    }

    public final String getShortLabel() {
        String base = super.getShortLabel();
        String suffix = null;
        if (this.subcomponent != null) {
            CmtPropertyState ps = this.subcomponent.getPropertyState("label");
            if (ps != null) {
                suffix = (String)ps.getValue();
            }
            if (suffix == null && (ps = this.subcomponent.getPropertyState("text")) != null) {
                suffix = (String)ps.getValue();
            }
        }
        if (suffix == null || suffix.length() == 0) {
            return base;
        }
        return base + " \"" + suffix + "\"";
    }
}

