/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.uicanvas;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.jdeveloper.cmt.CmtComponent;
import oracle.jdeveloper.cmt.CmtPropertyEditor;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.java.legacy.JotNames;
import oracle.jdeveloper.uieditor.uicanvas.InnerAssistant;
import oracle.jdeveloper.uieditor.uicanvas.LayoutAssistant;
import oracle.jdevimpl.uieditor.UIEditorAddin;
import oracle.jdevimpl.uieditor.uicanvas.Res;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LayoutManagerEditor
implements CmtPropertyEditor,
Comparator {
    public static final Object DEFAULT_LAYOUT = new 1();
    private List<String> layouts;
    private List<String> layoutTags;
    private Object value;
    private PropertyChangeListener listener;
    private CmtPropertyState ps;

    private void $init$() {
        this.value = DEFAULT_LAYOUT;
    }

    private void loadLayouts() {
        if (this.layouts != null) {
            return;
        }
        List assistedLayouts = UIEditorAddin.getAssistedLayouts();
        this.createLists();
        for (Object layout : assistedLayouts) {
            try {
                Class<?> assistantType;
                String layoutName = layout.toString();
                LayoutAssistant assistant = UIEditorAddin.getLayoutAssistant(layoutName);
                Class<?> clazz = assistantType = assistant != null ? assistant.getClass() : null;
                if (InnerAssistant.class.isAssignableFrom(assistantType)) continue;
                this.layouts.add(layoutName);
                this.layoutTags.add(JotNames.getShortClassName(layoutName));
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
    }

    private void createLists() {
        this.layouts = new ArrayList<String>();
        this.layouts.add("");
        this.layoutTags = new ArrayList<String>();
        this.layoutTags.add(DEFAULT_LAYOUT.toString());
    }

    public LayoutManagerEditor() {
        this.$init$();
    }

    @Override
    public void setPropertyState(CmtPropertyState ps) {
        this.ps = ps;
    }

    @Override
    public void setValue(Object o) {
        if (o == this.value || o == null && "null".equals(this.value)) {
            return;
        }
        this.value = o == null ? "null" : (o == DEFAULT_LAYOUT ? o : o);
        this.firePropertyChange();
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public String getAsText() {
        if (this.value == DEFAULT_LAYOUT) {
            return this.value.toString();
        }
        String type = this.value.getClass().getName();
        if (type.equals("java.lang.String")) {
            if (this.value.equals("null")) {
                return (String)this.value;
            }
            type = (String)this.value;
        }
        return JotNames.getShortClassName(type);
    }

    @Override
    public String getJavaInitializationString() {
        if (this.value != DEFAULT_LAYOUT) {
            CmtSubcomponent[] subcomponents;
            CmtComponent comp = this.ps.getSubcomponent().getOuterComponent();
            CmtSubcomponent[] cmtSubcomponentArray = subcomponents = comp.getSubcomponents();
            int n = 0;
            while (n < cmtSubcomponentArray.length) {
                CmtSubcomponent subcomponent = cmtSubcomponentArray[n];
                if (subcomponent.getLiveInstance() == this.value) {
                    return subcomponent.getName();
                }
                ++n;
            }
        }
        return "";
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.loadLayouts();
        if (text != null) {
            if (text.equals(this.getAsText())) {
                return;
            }
            int i = this.layoutTags.size() - 1;
            while (i >= 0) {
                if (this.layoutTags.get(i).equals(text)) {
                    try {
                        if (i == 0) {
                            this.value = DEFAULT_LAYOUT;
                        } else if (text.equals("null")) {
                            this.value = text;
                        } else if (this.ps != null) {
                            this.value = this.layouts.get(i);
                        }
                        this.firePropertyChange();
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(e.getLocalizedMessage());
                    }
                    return;
                }
                --i;
            }
        }
        throw new IllegalArgumentException(text);
    }

    @Override
    public String[] getTags() {
        this.loadLayouts();
        ArrayList<String> sortedTags = new ArrayList<String>(this.layoutTags);
        Collections.sort(sortedTags, this);
        return sortedTags.toArray(new String[sortedTags.size()]);
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    private void firePropertyChange() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "layout", null, this.value));
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listener = l;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listener = null;
    }

    public int compare(Object first, Object second) {
        if (first != null) {
            if (second != null) {
                return first.toString().compareToIgnoreCase(second.toString());
            }
            return 1;
        }
        return second != null ? -1 : 0;
    }

    static final class 1 {
        public String toString() {
            return Res.getString(12);
        }
    }
}

