/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.uicanvas;

import java.awt.LayoutManager;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.net.URL;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.cmt.CmtComponent;
import oracle.jdeveloper.cmt.CmtComponents;
import oracle.jdeveloper.cmt.CmtMethodCall;
import oracle.jdeveloper.cmt.CmtPackages;
import oracle.jdeveloper.cmt.CmtProperty;
import oracle.jdeveloper.cmt.CmtPropertyEditor;
import oracle.jdeveloper.cmt.CmtPropertySetting;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.java.legacy.JotNames;
import oracle.jdevimpl.uieditor.UIEditorAddin;
import oracle.jdevimpl.uieditor.UIEditorController;
import oracle.jdevimpl.uieditor.assistant.NullLayoutAssistant;
import oracle.jdevimpl.uieditor.uicanvas.LayoutManagerEditor;
import oracle.jdevimpl.uieditor.uicanvas.Model;
import oracle.jdevimpl.uieditor.uicanvas.ModelNode;
import oracle.jdevimpl.uieditor.uicanvas.Res;

final class LayoutPropertyState
implements CmtPropertyState,
CmtProperty,
CmtPropertySetting {
    ModelNode modelNode;
    CmtPropertyEditor editor;

    LayoutPropertyState(ModelNode modelNode) {
        this.modelNode = modelNode;
    }

    public CmtComponent getComponent() {
        CmtSubcomponent layout = this.modelNode.getLayout();
        return layout != null ? layout.getComponent() : null;
    }

    public String getName() {
        return "layout";
    }

    public void setName(String name) {
    }

    public String getDisplayName() {
        return Res.getString(30);
    }

    public String getShortDescription() {
        return Res.getString(5);
    }

    public boolean isExpert() {
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public PropertyDescriptor getDescriptor() {
        return null;
    }

    public Class getPropertyType() {
        try {
            Class clazz = this.modelNode.model.manager.getPackages().loadClass(this.getType().getQualifiedName(), true);
            return clazz;
        }
        catch (Exception e) {
            try {
                Class<?> clazz = this.getValue().getClass();
                return clazz;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public JavaType getType() {
        CmtSubcomponent layout = this.modelNode.getLayout();
        JavaClass type = null;
        type = layout != null ? layout.getComponent().getType() : ((Model)this.modelNode.getCmtModel()).getComponents().getPackages().getClass("java.awt.LayoutManager");
        return type != null ? type.getResolvedType() : null;
    }

    public boolean isReadable() {
        return true;
    }

    public void setReadable(boolean readable) {
    }

    public JavaMethod getReadMethod() {
        return null;
    }

    public String getReadMethodName() {
        return "getLayout";
    }

    public boolean isWritable() {
        return true;
    }

    public void setWritable(boolean writable) {
    }

    public JavaMethod getWriteMethod() {
        return null;
    }

    public String getWriteMethodName() {
        return "setLayout";
    }

    public boolean isEventRegistration() {
        return false;
    }

    public boolean isBound() {
        return false;
    }

    public boolean isConstrained() {
        return false;
    }

    public PropertyEditor getEditor() {
        return new LayoutManagerEditor();
    }

    public Object getObject() {
        return this.getSubcomponent();
    }

    public CmtSubcomponent getSubcomponent() {
        return this.modelNode.subcomponent;
    }

    public CmtProperty getProperty() {
        return this.provideFakeProperty();
    }

    private LayoutPropertyState provideFakeProperty() {
        return this;
    }

    public boolean isEvent() {
        return false;
    }

    public boolean isEventSetting() {
        return false;
    }

    public CmtPropertySetting getPropertySetting() {
        return this.provideFakeProperty();
    }

    public void refresh(CmtPropertySetting setting) {
    }

    public CmtMethodCall getMethodCall() {
        return null;
    }

    public Object getLiveValue() {
        return this.getValue();
    }

    public Object getValue() {
        return this.modelNode.getLiveLayout();
    }

    private String layoutTypeFrom(Object value) {
        String layoutType = value.getClass().getName();
        if (value instanceof String && !value.equals("null")) {
            layoutType = (String)value;
        } else if (value == LayoutManagerEditor.DEFAULT_LAYOUT) {
            layoutType = null;
        }
        return layoutType;
    }

    private void layoutToNullIfApplicable(Object value, Object oldValue) {
        boolean isNullLayout;
        boolean bl = isNullLayout = value == LayoutManagerEditor.DEFAULT_LAYOUT || value.equals("null");
        if (isNullLayout && oldValue != null && this.modelNode.getLayoutAssistant() instanceof NullLayoutAssistant) {
            this.modelNode.getSubcomponent().getAsContainer().setLayout(null);
        }
    }

    private void loadProjectPathsToIncludeNecessaryLibraries(String layoutType) {
        CmtComponent outer = this.modelNode.getSubcomponent().getOuterComponent();
        CmtComponents cmtMgr = outer != null ? outer.getComponents() : null;
        CmtPackages jotMgr = cmtMgr != null ? cmtMgr.getPackages() : null;
        Project prj = jotMgr != null ? jotMgr.getProject() : null;
        Context ctx = Context.newIdeContext();
        ctx.setProject(prj);
        UIEditorController.updateProjectProperties(ctx, UIEditorAddin.getLibraryForLayout(layoutType), null);
    }

    public void setValue(Object value) {
        try {
            LayoutManager oldValue = this.modelNode.getLiveLayout();
            String layoutType = this.layoutTypeFrom(value);
            this.modelNode.setLayoutType(layoutType);
            if (layoutType != null) {
                this.loadProjectPathsToIncludeNecessaryLibraries(layoutType);
            }
            this.layoutToNullIfApplicable(value, oldValue);
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    public String getValueText() {
        CmtSubcomponent layout = this.modelNode.getLayout();
        if (layout != null) {
            String type = layout.getComponent().getType().getQualifiedName();
            return JotNames.getShortClassName(type);
        }
        if (this.modelNode.realLayoutState != null && this.modelNode.realLayoutState.getPropertySetting() != null) {
            return "null";
        }
        return LayoutManagerEditor.DEFAULT_LAYOUT.toString();
    }

    public void setValueText(String text) {
        if (text != null && text.equals(this.getValueText())) {
            return;
        }
        this.modelNode.setLayoutType(text);
    }

    public String getValueSource() {
        CmtSubcomponent layout = this.modelNode.getLayout();
        return layout != null ? layout.getName() : "";
    }

    public void setValueSource(String text) {
    }

    public boolean isDefault() {
        return false;
    }

    public void setDefaultValue(Object value) {
    }

    public void reset() {
    }

    public void release() {
        this.modelNode = null;
        this.editorAttached(null);
    }

    public void editorAttached(CmtPropertyEditor editor) {
        if (this.editor != null && this.editor != editor) {
            this.editor.setPropertyState(null);
        }
        this.editor = editor;
    }

    public boolean isReadOnly() {
        SourceFile file;
        CmtComponent cmt;
        CmtSubcomponent sub = this.getSubcomponent();
        CmtComponent cmtComponent = cmt = sub == null ? null : sub.getOuterComponent();
        if (cmt != null && (file = (SourceFile)cmt.getFile()) != null) {
            return URLFileSystem.isReadOnly((URL)file.getURL());
        }
        return true;
    }

    public boolean isPseudoPropertyState() {
        return true;
    }
}

