/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.uicanvas;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.TextComponent;
import java.net.URL;
import java.util.Iterator;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeModel;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.jdeveloper.cmt.CmtComponent;
import oracle.jdeveloper.cmt.CmtComponentManager;
import oracle.jdeveloper.cmt.CmtComponentSource;
import oracle.jdeveloper.cmt.CmtComponents;
import oracle.jdeveloper.cmt.CmtModel;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.uieditor.uicanvas.LayoutAssistant;
import oracle.jdeveloper.uieditor.uicanvas.UIModel;
import oracle.jdevimpl.uieditor.uicanvas.LayoutModelNode;
import oracle.jdevimpl.uieditor.uicanvas.ModelNode;
import oracle.jdevimpl.uieditor.uicanvas.NodeMemento;
import oracle.jdevimpl.uieditor.uicanvas.Res;

public class Model
implements UIModel {
    protected CmtComponents manager;
    protected CmtComponent component;
    protected CmtComponentSource componentSource;
    protected CmtModelNode root;

    private void $init$() {
        this.manager = null;
        this.component = null;
        this.componentSource = null;
        this.root = null;
    }

    public Model(CmtComponents mgr, CmtComponent component, NodeMemento memento) {
        this.$init$();
        this.manager = mgr;
        this.component = component;
        if (component instanceof CmtComponentSource) {
            this.componentSource = (CmtComponentSource)component;
        }
        this.root = this.buildModelNode(memento);
    }

    protected CmtModelNode buildModelNode(NodeMemento memento) {
        if (memento == null || memento.type <= 0) {
            return null;
        }
        return new ModelNode(this, memento, null);
    }

    protected CmtModelNode buildModelNode(String typeName, String name, String initializer) {
        int type = NodeMemento.getType(typeName, this.manager);
        if (type <= 0) {
            return null;
        }
        return new ModelNode(this, typeName, name, initializer);
    }

    protected CmtModelNode buildModelNode(CmtSubcomponent subcomponent) {
        JavaClass jClass = subcomponent.getDeclaredClass();
        String typeName = jClass.getQualifiedName();
        int type = NodeMemento.getType(typeName, this.manager);
        if (type <= 0) {
            return null;
        }
        return new ModelNode(this, subcomponent);
    }

    protected Model buildModel() {
        return new Model(this.manager, this.componentSource, null);
    }

    protected boolean isValidParent(CmtModelNode parent, Class childCls) {
        return parent instanceof ModelNode;
    }

    public final CmtComponent getComponent() {
        return this.component;
    }

    public final CmtComponents getComponents() {
        return this.manager;
    }

    public final CmtComponentSource getComponentSource() {
        return this.componentSource;
    }

    public String getName() {
        return Res.getString(0);
    }

    public boolean isSubcomponentOwned(CmtSubcomponent subcomponent) {
        return this.root != null && this.isSubcomponentOwned(this.root, subcomponent);
    }

    private boolean isSubcomponentOwned(CmtModelNode node, CmtSubcomponent subcomponent) {
        if (node instanceof LayoutModelNode) {
            if (((LayoutModelNode)node).getSubcomponent() == subcomponent) {
                return true;
            }
        } else if (node instanceof ModelNode) {
            if (((ModelNode)node).getSubcomponent() == subcomponent) {
                return true;
            }
            Iterator iter = node.getChildren();
            if (iter != null) {
                while (iter.hasNext()) {
                    CmtModelNode child = (CmtModelNode)iter.next();
                    if (!this.isSubcomponentOwned(child, subcomponent)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public final CmtModelNode getRoot() {
        return this.root;
    }

    private CmtModelNode treeAdd(CmtModelNode parent, CmtSubcomponent subcomponent, String type, String initializer) {
        CmtModelNode node;
        JavaFile jFile;
        JavaFile javaFile = jFile = this.componentSource != null ? this.componentSource.getFile() : null;
        if (jFile == null || URLFileSystem.isReadOnly((URL)jFile.getURL())) {
            Ide.getStatusBar().setText(Res.getString(6));
            return null;
        }
        Class cls = null;
        try {
            if (parent instanceof ModelNode && !((ModelNode)parent).isContainer()) {
                CmtModelNode cmtModelNode = null;
                return cmtModelNode;
            }
            int i = 0;
            while (i <= 1) {
                try {
                    if (subcomponent == null) {
                        cls = this.manager.getPackages().loadClass(type, false);
                    } else {
                        JavaClass jCls = subcomponent.getDeclaredClass();
                        cls = this.manager.getPackages().loadClass(jCls.getQualifiedName(), false);
                    }
                }
                catch (ClassNotFoundException e) {
                }
                catch (NoClassDefFoundError e) {
                    // empty catch block
                }
                if (cls != null) break;
                if (i == 0) {
                    this.manager.getPackages().flushCache();
                }
                ++i;
            }
            if (cls == null) {
                CmtModelNode cmtModelNode = null;
                return cmtModelNode;
            }
            if (!this.isRecognized(cls)) {
                CmtModelNode cmtModelNode = null;
                return cmtModelNode;
            }
        }
        catch (SecurityException e) {
            CmtModelNode cmtModelNode = null;
            return cmtModelNode;
        }
        Model targetModel = this;
        if (this.root == null || !this.isValidParent(parent, cls)) {
            targetModel = this.buildModel();
        }
        CmtModelNode cmtModelNode = node = subcomponent == null ? targetModel.buildModelNode(type, null, initializer) : targetModel.buildModelNode(subcomponent);
        if (node.getSubcomponent() == null) {
            return null;
        }
        if (targetModel.root == null) {
            targetModel.root = node;
        }
        Object live = node.getSubcomponent().getLiveInstance();
        if (subcomponent == null && !(live instanceof JTextComponent) && !(live instanceof TextComponent)) {
            CmtPropertyState psl = node.getSubcomponent().getPropertyState("label");
            CmtPropertyState pst = node.getSubcomponent().getPropertyState("text");
            if (pst != null && psl != null) {
                psl = pst;
            } else if (psl == null && pst != null) {
                psl = pst;
            }
            if (psl != null) {
                try {
                    String oldLabel = (String)psl.getValue();
                    if (oldLabel == null || oldLabel.trim().length() == 0) {
                        psl.setValue(node.getName());
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        return node;
    }

    public CmtModelNode add(CmtModelNode parent, String type, CmtModelNode aheadOf, String initializer) {
        CmtModelNode child;
        if (aheadOf != null) {
            CmtModel siblingModel = aheadOf.getCmtModel();
            if (parent == null || parent.getCmtModel() != siblingModel) {
                if (siblingModel instanceof Model) {
                    return null;
                }
                aheadOf = null;
            }
        }
        if ((child = this.treeAdd(parent, null, type, initializer)) != null) {
            if (child.getCmtModel() != this) {
                this.componentSource.addModel(child.getCmtModel(), null);
            } else {
                this.addChild(child, parent, aheadOf, null, null);
            }
        }
        return child;
    }

    public final CmtModelNode add(CmtModelNode parent, String type, Point location, Dimension size, String initializer) {
        CmtModelNode child = this.treeAdd(parent, null, type, initializer);
        if (child != null) {
            if (child.getCmtModel() != this) {
                this.componentSource.addModel(child.getCmtModel(), null);
            } else {
                this.addChild(child, parent, null, location, size);
            }
        }
        return child;
    }

    public final CmtModelNode add(CmtModelNode parent, CmtSubcomponent subcomponent) {
        CmtModelNode child = this.treeAdd(parent, subcomponent, null, null);
        if (child != null) {
            if (child.getCmtModel() != this) {
                this.componentSource.addModel(child.getCmtModel(), null);
            } else {
                this.addChild(child, parent, null, null, null);
            }
        }
        return child;
    }

    protected void addChild(CmtModelNode child, CmtModelNode parent, CmtModelNode aheadOf, Point location, Dimension size) {
        if (!this.componentSource.hasTrans()) {
            this.componentSource.beginTrans();
        }
        try {
            if (child != null) {
                LayoutAssistant assistant;
                int position;
                DefaultTreeModel structure = this.componentSource.getStructure();
                int n = position = aheadOf != null ? parent.getIndex(aheadOf) : parent.getChildCount();
                if (parent instanceof ModelNode && (assistant = ((ModelNode)parent).getLayoutAssistant()) != null && assistant.usesReverseZOrder()) {
                    position = aheadOf != null ? position + 1 : 1;
                }
                structure.insertNodeInto(child, parent, position);
                ((ModelNode)parent).moveChild(null, (ModelNode)child, location, size, true, null);
            }
        }
        finally {
            if (this.componentSource.hasTrans()) {
                this.componentSource.commit("Add child");
            }
        }
    }

    public CmtModelNode move(CmtModelNode component, CmtModelNode newParent, CmtModelNode aheadOf) {
        return null;
    }

    public final void move(CmtModelNode child, Point location, CmtModelNode newParent, Point mouseOffset) {
        ModelNode node = (ModelNode)child;
        ModelNode oldParent = node.getParentNode();
        boolean isAdd = oldParent != newParent;
        Dimension size = node.getLiveComponent().getSize();
        if (isAdd) {
            this.componentSource.getStructure().removeNodeFromParent(node);
            this.componentSource.getStructure().insertNodeInto(node, newParent, newParent.getChildCount());
        }
        ((ModelNode)newParent).moveChild(oldParent, node, location, size, isAdd, mouseOffset);
    }

    public final void open(CmtComponentSource source, Project project) {
        this.componentSource = source;
        this.component = source;
        this.manager = CmtComponentManager.getCmtComponents(project);
    }

    public final void close() {
        this.componentSource = null;
        this.component = null;
        this.manager = null;
    }

    protected boolean isRecognized(Class cls) {
        if (!NodeMemento.componentClass.isAssignableFrom(cls)) {
            return false;
        }
        if (NodeMemento.swingMenuClass != null && NodeMemento.swingMenuClass.isAssignableFrom(cls)) {
            return false;
        }
        if (NodeMemento.swingPopupMenuClass != null && NodeMemento.swingPopupMenuClass.isAssignableFrom(cls)) {
            return false;
        }
        if (NodeMemento.swingMenuBarClass != null && NodeMemento.swingMenuBarClass.isAssignableFrom(cls)) {
            return false;
        }
        return this.root == null || !NodeMemento.windowClass.isAssignableFrom(cls);
    }
}

