/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.uicanvas;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.ide.help.JavadocHelpKey;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultAttributes;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.cmt.CmtComponent;
import oracle.jdeveloper.cmt.CmtComponentSource;
import oracle.jdeveloper.cmt.CmtComponents;
import oracle.jdeveloper.cmt.CmtMethodCall;
import oracle.jdeveloper.cmt.CmtMethodSource;
import oracle.jdeveloper.cmt.CmtModel;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.cmt.CmtPackages;
import oracle.jdeveloper.cmt.CmtProperty;
import oracle.jdeveloper.cmt.CmtPropertySource;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.cmt.CmtValue;
import oracle.jdeveloper.java.legacy.JotNames;
import oracle.jdeveloper.uieditor.uicanvas.LayoutAssistant;
import oracle.jdeveloper.uieditor.uicanvas.SelectNib;
import oracle.jdeveloper.uieditor.uicanvas.SelectionEffects;
import oracle.jdeveloper.uieditor.uicanvas.UICanvas;
import oracle.jdevimpl.cmtimpl.JbComponent;
import oracle.jdevimpl.uieditor.UIEditorAddin;
import oracle.jdevimpl.uieditor.assistant.BasicLayoutAssistant;
import oracle.jdevimpl.uieditor.uicanvas.LayoutModelNode;
import oracle.jdevimpl.uieditor.uicanvas.LayoutPropertyState;
import oracle.jdevimpl.uieditor.uicanvas.Model;
import oracle.jdevimpl.uieditor.uicanvas.NodeAddCall;
import oracle.jdevimpl.uieditor.uicanvas.NodeMemento;
import oracle.jdevimpl.uieditor.uicanvas.Res;

public class ModelNode
extends DefaultMutableTreeNode
implements CmtModelNode,
JavadocHelpKey {
    public static final String LAYOUT_PROPERTY_NAME = "layout";
    private static Icon CONTAINER_ICON;
    private static Icon COMPONENT_ICON;
    protected Model model;
    protected CmtSubcomponent subcomponent;
    protected Component liveSubcomponent;
    protected LayoutPropertyState layoutState;
    protected CmtPropertyState realLayoutState;
    protected NodeAddCall addCall;
    private boolean isContainer;
    private boolean isWindow;
    private LayoutModelNode layoutModelNode;
    private LayoutAssistant layoutAssistant;
    private CmtSubcomponent layout;

    protected ModelNode() {
    }

    public ModelNode(Model model, NodeMemento memento, ModelNode parent) {
        this();
        this.setParent(parent);
        this.model = model;
        this.subcomponent = memento.subcomponent;
        this.addCall = memento.addCall;
        if (this.addCall != null && this.subcomponent != null) {
            CmtPropertyState ps = this.subcomponent.getPropertyState("<Bconstraints>");
            this.subcomponent.removePropertyState(ps);
            this.subcomponent.addPropertyState(this.addCall);
        }
        this.layout = memento.layout;
        this.setupContainership();
        if (this.layout != null) {
            this.createLayoutAssistant(this.layout.getComponent().getType().getQualifiedName());
        }
        Enumeration<TreeNode> en = memento.children();
        while (en.hasMoreElements()) {
            NodeMemento childMemento = (NodeMemento)en.nextElement();
            CmtModelNode modelNode = model.buildModelNode(childMemento);
            if (modelNode == null) continue;
            this.add(modelNode);
        }
    }

    public ModelNode(Model model, String type, String name, String initializer) {
        this();
        this.model = model;
        this.subcomponent = model.componentSource.addSubcomponent(type, name, initializer, 2);
        this.setupContainership();
    }

    public ModelNode(Model model, CmtSubcomponent subcomponent) {
        this();
        this.model = model;
        this.subcomponent = subcomponent;
        if (subcomponent != null) {
            CmtMethodSource init = (CmtMethodSource)subcomponent.getInitMethod();
            List calls = init.getMethodCalls(subcomponent, "setLayout", true);
            int size = calls.size();
            int i = 0;
            if (i < size) {
                CmtValue[] args = ((CmtMethodCall)calls.get(i)).getArguments();
                if (args.length == 1) {
                    this.layout = args[0].getSubcomponent();
                }
            }
            if (this.layout != null) {
                this.createLayoutAssistant(this.layout.getComponent().getType().getQualifiedName());
            }
        }
        this.setupContainership();
    }

    private void setupContainership() {
        int type = NodeMemento.getType(this.subcomponent, this.model.manager);
        switch (type) {
            case -4: 
            case -2: 
            case -1: 
            case 3: 
            case 4: {
                this.isContainer = true;
                break;
            }
            default: {
                this.isContainer = false;
                break;
            }
        }
        if (this.isContainer) {
            CmtProperty layoutProperty = this.subcomponent.getComponent().getProperty(LAYOUT_PROPERTY_NAME);
            if (layoutProperty != null && layoutProperty.getPropertyType().getName().equals("java.awt.LayoutManager")) {
                this.layoutState = new LayoutPropertyState(this);
                this.realLayoutState = this.subcomponent.getPropertyState(LAYOUT_PROPERTY_NAME);
                this.subcomponent.removePropertyState(this.realLayoutState);
                this.subcomponent.addPropertyState(this.layoutState);
                if (type > 0) {
                    this.layoutModelNode = new LayoutModelNode(this);
                    this.insert(this.layoutModelNode, 0);
                }
            }
            if (this.layout == null) {
                this.createLiveComponent();
            }
        }
    }

    public final CmtModel getCmtModel() {
        return this.model;
    }

    public final void setCmtModel(CmtModel model) {
        this.model = (Model)model;
        Enumeration<TreeNode> en = this.children();
        while (en.hasMoreElements()) {
            CmtModelNode child = (CmtModelNode)en.nextElement();
            child.setCmtModel(model);
        }
    }

    public final String getName() {
        if (this.subcomponent == null) {
            return Res.getString(10);
        }
        return this.subcomponent.getName();
    }

    public final boolean isContainer() {
        return this.isContainer;
    }

    public final boolean isWindow() {
        return this.isWindow;
    }

    public final ModelNode getParentNode() {
        return this.parent != null && this.parent instanceof ModelNode ? (ModelNode)this.parent : null;
    }

    public boolean isComponent() {
        return true;
    }

    public final CmtSubcomponent getLayout() {
        return this.layout;
    }

    public final LayoutManager getLiveLayout() {
        if (this.layout != null) {
            return (LayoutManager)this.layout.getLiveInstance();
        }
        if (this.subcomponent == null) {
            return null;
        }
        Container ctn = this.subcomponent.getAsContainer();
        return ctn != null ? ctn.getLayout() : null;
    }

    public final CmtPropertyState getConstraints() {
        return this.addCall;
    }

    public final Object getLiveConstraints() {
        return this.addCall != null ? this.addCall.getValue() : null;
    }

    public final LayoutAssistant getLayoutAssistant() {
        return this.layoutAssistant;
    }

    public void moveChild(ModelNode oldParent, ModelNode child, Point location, Dimension size, boolean isAdd, Point mouseOffset) {
        if (isAdd) {
            child.setConstraintsType(this.layoutAssistant, true);
            child.addCall.setContainer(this.subcomponent);
        }
        if (isAdd) {
            if (this.layoutAssistant != null) {
                if (location != null || child.getLiveConstraints() == null) {
                    this.layoutAssistant.prepareAddComponent(child, this, location, mouseOffset, size);
                } else {
                    this.addLiveComponent(child);
                }
            }
        } else {
            if (this.layoutAssistant != null) {
                this.layoutAssistant.prepareMoveComponent(child, this, location, mouseOffset);
            }
            if (oldParent != this && oldParent != null && oldParent.layoutAssistant != null) {
                oldParent.layoutAssistant.cleanupRemovedComponent(oldParent);
            }
        }
        child.adjustPosition(true);
        if (!isAdd && this.layoutAssistant != null) {
            this.layoutAssistant.cleanupRemovedComponent(this);
        }
    }

    public final int getPosition(ModelNode node) {
        int position = 0;
        Enumeration<TreeNode> en = this.children();
        while (en.hasMoreElements()) {
            TreeNode child = en.nextElement();
            if (child == node) {
                return position;
            }
            if (!(child instanceof ModelNode)) continue;
            ++position;
        }
        return -1;
    }

    public final void adjustPosition(boolean doLive) {
        ModelNode parent = this.getParentNode();
        int count = parent.getChildCount();
        int i = 0;
        while (i < count) {
            TreeNode sibling = parent.getChildAt(i);
            if (sibling == this) {
                int layoutNode = parent.getChildAt(0) instanceof LayoutModelNode ? 1 : 0;
                int liveIndex = i - layoutNode;
                if (liveIndex == 0) {
                    NodeAddCall nac = null;
                    boolean before = false;
                    if (count - layoutNode > 1) {
                        nac = ((ModelNode)parent.getChildAt((int)(i + 1))).addCall;
                    }
                    if (nac != null) {
                        before = true;
                    } else if (parent.addCall != null) {
                        nac = parent.addCall;
                        before = true;
                    }
                    this.addCall.setPosition(nac, before);
                } else {
                    this.addCall.setPosition(((ModelNode)parent.getChildAt((int)(i - 1))).addCall, false);
                }
                if (!doLive) break;
                this.addCall.setPosition(liveIndex);
                break;
            }
            ++i;
        }
        Enumeration<TreeNode> en = this.children();
        while (en.hasMoreElements()) {
            CmtModelNode child = (CmtModelNode)en.nextElement();
            if (!(child instanceof ModelNode)) continue;
            ((ModelNode)child).adjustPosition(false);
        }
    }

    private ModelNode getLastDescendent() {
        if (this.children == null || this.children.size() == 1) {
            return this;
        }
        return ((ModelNode)this.children.get(this.children.size() - 1)).getLastDescendent();
    }

    public final void resize(SelectionEffects effects, SelectNib nib) {
        ModelNode tparent = this.getParentNode();
        Dimension size = nib.rectangleDimension;
        if (tparent != null && tparent.layoutAssistant != null) {
            tparent.layoutAssistant.prepareResizeComponent(this, effects, nib);
        } else if (tparent == null) {
            UICanvas canvas;
            boolean resized = false;
            if (this.layout != null) {
                resized = this.resize(this.layout, size);
            }
            if (resized) {
                CmtPropertyState propState = this.subcomponent.getPropertyState("size");
                if (propState != null) {
                    propState.reset();
                }
                if ((propState = this.subcomponent.getPropertyState("width")) != null) {
                    propState.reset();
                }
                if ((propState = this.subcomponent.getPropertyState("height")) != null) {
                    propState.reset();
                }
            } else if (this.subcomponent != null) {
                resized = this.resize(this.subcomponent, size);
            }
            if (!resized) {
                this.writePreferredRootSize(size);
            }
            UICanvas uICanvas = canvas = effects != null ? effects.getUICanvas() : null;
            if (canvas != null) {
                canvas.setModel(canvas.getModel());
            }
        }
    }

    private boolean resize(CmtSubcomponent sub, Dimension size) {
        CmtPropertyState sizeState = sub.getPropertyState("size");
        if (sizeState == null && sub.getLiveInstance() instanceof Component) {
            CmtPropertySource prop = ((CmtComponentSource)sub.getComponent()).addProperty("java.awt.Dimension", "setSize");
            sizeState = sub.addPropertyState(prop);
        }
        if (sizeState != null) {
            try {
                sizeState.setValue(size);
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                Assert.println((String)"ModelNode.resize: failed setting size");
            }
        }
        CmtPropertyState widthState = sub.getPropertyState("width");
        CmtPropertyState heightState = sub.getPropertyState("height");
        if (widthState != null && heightState != null) {
            try {
                Integer width = (Integer)widthState.getValue();
                Integer height = (Integer)heightState.getValue();
                if (width == null || width != size.width || height == null || height != size.height) {
                    widthState.setValue(new Integer(size.width));
                    heightState.setValue(new Integer(size.height));
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception ex) {
                Assert.println((String)"ModelNode.resize: failed seting width,height");
            }
        }
        return false;
    }

    private void writePreferredRootSize(Dimension size) {
        Project prj;
        if (size == null || this.subcomponent == null) {
            return;
        }
        CmtComponent outer = this.subcomponent.getOuterComponent();
        CmtComponents cmtMgr = outer != null ? outer.getComponents() : null;
        CmtPackages jotMgr = cmtMgr != null ? cmtMgr.getPackages() : null;
        Project project = prj = jotMgr != null ? jotMgr.getProject() : null;
        if (prj != null) {
            prj.setProperty("uidesign.size." + outer.getType().getQualifiedName(), "" + size.width + "," + size.height);
        }
    }

    public final boolean setLayoutType(String type) {
        if (type != null && type.length() == 0) {
            type = null;
        }
        boolean doChange = this.isContainer();
        if (type != null) {
            String source;
            if (this.layout != null) {
                if (type.equals(this.layout.getComponent().getType().getQualifiedName())) {
                    doChange = false;
                }
            } else if (type.equals("java.lang.String") && (source = this.realLayoutState.getValueSource()) != null && source.equals("null")) {
                doChange = false;
            }
        }
        if (doChange) {
            CmtSubcomponent oldLayout = this.layout;
            LayoutAssistant oldLayoutAssistant = this.layoutAssistant;
            if (type != null && !type.equals("java.lang.String")) {
                LayoutAssistant tmp = UIEditorAddin.getLayoutAssistant(type);
                this.layout = this.model.componentSource.addSubcomponent(type, null, tmp != null ? tmp.getInitializer() : null, 2);
            } else {
                this.layout = null;
            }
            if (this.layout != null) {
                this.realLayoutState.setValueSource(this.layout.getName());
            } else if (type != null) {
                String variableName = this.generateName(type);
                if (variableName == null) {
                    variableName = "null";
                }
                this.realLayoutState.setValueSource(variableName);
            } else if (type == null) {
                this.realLayoutState.reset();
            } else {
                this.realLayoutState.setValueSource("null");
            }
            this.createLayoutAssistant(type);
            Enumeration<TreeNode> en = this.children();
            while (en.hasMoreElements()) {
                CmtModelNode child = (CmtModelNode)en.nextElement();
                if (!(child instanceof ModelNode)) continue;
                ((ModelNode)child).setConstraintsType(this.layoutAssistant, false);
            }
            if (this.layoutAssistant != null) {
                this.layoutAssistant.prepareChangeLayout(this);
            }
            if (oldLayoutAssistant != null) {
                oldLayoutAssistant.layoutChanged(this);
                if (oldLayout != null) {
                    this.model.componentSource.removeSubcomponent(oldLayout);
                    oldLayout.release();
                }
            }
            this.refreshLiveChildren();
            return true;
        }
        return false;
    }

    private String generateName(String type) {
        String namebase = JotNames.getShortClassName(type);
        String nameTemplate = namebase.substring(0, 1).toLowerCase() + namebase.substring(1, namebase.length());
        if (!(this.model.componentSource instanceof JbComponent)) {
            return null;
        }
        JbComponent c = (JbComponent)this.model.componentSource;
        JavaClass clazz = c.getClazz();
        String last = null;
        int i = 1;
        while (i <= 9999) {
            String attemptedName = nameTemplate + i;
            if (clazz.getDeclaredField(attemptedName) == null) {
                return last;
            }
            last = attemptedName;
            ++i;
        }
        return last;
    }

    public final void setConstraintsType(LayoutAssistant assistant, boolean update) {
        if (this.addCall == null) {
            this.addCall = new NodeAddCall(this.getParentNode().subcomponent, this.subcomponent, this.model.manager);
            CmtPropertyState ps = this.subcomponent.getPropertyState("<Bconstraints>");
            this.subcomponent.removePropertyState(ps);
            this.subcomponent.addPropertyState(this.addCall);
        }
        if (assistant != null) {
            String type = assistant.getConstraintsType();
            if (type != null) {
                JavaClass jotClass = this.model.manager.getPackages().getClass(type);
                this.addCall.setType(jotClass.getResolvedType(), update);
            } else {
                this.addCall.setType(null, update);
            }
            this.addCall.setPropertyEditor(assistant.getPropertyEditor());
        } else {
            this.addCall.setType(null, update);
            this.addCall.setPropertyEditor(null);
        }
    }

    public final Component getLiveComponent() {
        if (this.liveSubcomponent == null && this.subcomponent != null) {
            this.createLiveComponent();
        }
        return this.liveSubcomponent;
    }

    public final void addLiveComponent() {
        ModelNode tparent;
        if (this.liveSubcomponent == null) {
            this.createLiveComponent();
        }
        if ((tparent = this.getParentNode()) != null && !(this.liveSubcomponent instanceof Window)) {
            tparent.addLiveComponent(this);
        }
        Enumeration<TreeNode> en = this.children();
        while (en.hasMoreElements()) {
            CmtModelNode child = (CmtModelNode)en.nextElement();
            if (!(child instanceof ModelNode)) continue;
            ((ModelNode)child).addLiveComponent();
        }
    }

    public void createLiveComponent() {
        Enumeration<TreeNode> en;
        if (this.liveSubcomponent == null && this.subcomponent != null) {
            Object liveObject = this.subcomponent.getLiveInstance();
            Component component = this.liveSubcomponent = liveObject instanceof Component ? (Component)liveObject : null;
            if (this.liveSubcomponent != null) {
                if (this.isContainer && this.realLayoutState != null) {
                    Container container = this.subcomponent.getAsContainer();
                    this.realLayoutState.setDefaultValue(container.getLayout());
                }
                this.liveSubcomponent.addComponentListener(null);
            }
        }
        if (this.isContainer && this.layoutAssistant == null) {
            LayoutManager layoutManager = this.getLiveLayout();
            if (layoutManager != null) {
                this.createLayoutAssistant(layoutManager.getClass().getName());
            } else {
                this.createLayoutAssistant("null");
            }
        }
        if ((en = this.children()) != null) {
            while (en.hasMoreElements()) {
                CmtModelNode child = (CmtModelNode)en.nextElement();
                if (!(child instanceof ModelNode)) continue;
                ((ModelNode)child).createLiveComponent();
            }
        }
    }

    private void addLiveComponent(ModelNode child) {
        block11: {
            this.createLiveComponent();
            Container container = this.subcomponent.getAsContainer();
            if (container != null && container != child.liveSubcomponent) {
                try {
                    LayoutManager layoutManager = this.getLiveLayout();
                    if (layoutManager == null) {
                        int pos = ((ModelNode)child.getParent()).getPosition(child);
                        container.add(child.getLiveComponent(), pos);
                        break block11;
                    }
                    child.setConstraintsType(this.layoutAssistant, true);
                    if (container instanceof JTabbedPane) {
                        String constraintsValue = "";
                        JTabbedPane tabbedPane = (JTabbedPane)container;
                        Component comp = child.getLiveComponent();
                        if (child.getConstraints() != null) {
                            try {
                                constraintsValue = (String)child.getConstraints().getValue();
                            }
                            catch (Exception e) {
                                constraintsValue = child.getName();
                                child.getConstraints().setValue(constraintsValue);
                            }
                        }
                        tabbedPane.remove(comp);
                        tabbedPane.addTab(constraintsValue, comp);
                        break block11;
                    }
                    if (child.getConstraints() != null) {
                        int pos = ((ModelNode)child.getParent()).getPosition(child);
                        container.add(child.getLiveComponent(), child.getConstraints().getValue(), pos);
                    } else {
                        int pos = ((ModelNode)child.getParent()).getPosition(child);
                        container.add(child.getLiveComponent(), pos);
                    }
                }
                catch (Exception e) {
                    Assert.println((String)("ModelNode.addLiveComponent: failed " + e.getLocalizedMessage()));
                }
                catch (Error e) {
                    Assert.println((String)("ModelNode.addLiveComponent: failed " + e.getLocalizedMessage()));
                }
            }
        }
    }

    private void refreshLiveChildren() {
        Enumeration<TreeNode> en = this.children();
        while (en.hasMoreElements()) {
            CmtModelNode child = (CmtModelNode)en.nextElement();
            if (!(child instanceof ModelNode)) continue;
            ((ModelNode)child).addCall.updateLayoutManager();
        }
    }

    protected void removeFromLiveContainer() {
        Container container;
        ModelNode curparent = this.getParentNode();
        if (curparent != null && curparent.subcomponent != null && (container = curparent.subcomponent.getAsContainer()) != null && this.getLiveComponent() != null) {
            container.remove(this.getLiveComponent());
            if (curparent.layoutAssistant != null) {
                curparent.layoutAssistant.cleanupRemovedComponent(curparent);
            }
        }
    }

    public final void releaseLiveComponent() {
        Enumeration<TreeNode> en = this.children();
        while (en.hasMoreElements()) {
            CmtModelNode child = (CmtModelNode)en.nextElement();
            if (!(child instanceof ModelNode)) continue;
            ((ModelNode)child).releaseLiveComponent();
        }
        if (this.liveSubcomponent != null) {
            this.liveSubcomponent = null;
        }
    }

    public void removeSourceRepresentation() {
        Enumeration<TreeNode> en = this.children();
        while (en.hasMoreElements()) {
            TreeNode child = en.nextElement();
            if (!(child instanceof ModelNode)) continue;
            ((ModelNode)child).removeSourceRepresentation();
        }
        if (this.addCall != null) {
            this.addCall.removeSourceRepresentation();
            this.addCall = null;
        }
        if (this.subcomponent != null) {
            this.model.componentSource.removeSubcomponent(this.subcomponent);
            this.subcomponent = null;
        }
        if (this.layout != null) {
            this.model.componentSource.removeSubcomponent(this.layout);
            this.layout = null;
        }
    }

    private void createLayoutAssistant(String type) {
        Object o;
        if (type == null && (o = this.realLayoutState.getValue()) != null) {
            type = o.getClass().getName();
        }
        if (type == null) {
            this.layoutAssistant = null;
        } else {
            try {
                if (type.equals("java.lang.String")) {
                    type = "null";
                }
                this.layoutAssistant = UIEditorAddin.getLayoutAssistant(type);
                return;
            }
            catch (Exception e) {
                Assert.println((String)"Failed trying to fetch LayoutAssistant");
                this.layoutAssistant = new BasicLayoutAssistant();
            }
        }
    }

    public final String toString() {
        return this.getShortLabel();
    }

    public final CmtSubcomponent getSubcomponent() {
        return this.subcomponent;
    }

    public String getShortLabel() {
        StringBuffer buffer = new StringBuffer(15);
        CmtSubcomponent sub = this.getSubcomponent();
        if (sub != null) {
            if (sub.getScope() == 2) {
                buffer.append(this.getName());
            } else {
                buffer.append("(");
                buffer.append(this.getName());
                buffer.append(")");
            }
        } else {
            buffer.append(this.getName());
        }
        if (this.isContainer && this.layout != null) {
            String layoutName;
            CmtComponent layoutComp = this.layout.getComponent();
            JavaClass layoutType = layoutComp != null ? layoutComp.getType() : null;
            String string = layoutName = layoutType != null ? layoutType.getName() : null;
            if (layoutName != null) {
                buffer.append(" (");
                buffer.append(layoutName);
                buffer.append(")");
            }
        }
        return buffer.toString();
    }

    public final String getLongLabel() {
        return this.getShortLabel();
    }

    public final Object getData() {
        return this.getSubcomponent();
    }

    public final Icon getIcon() {
        if (CONTAINER_ICON == null) {
            CONTAINER_ICON = Res.getIcon(24);
            COMPONENT_ICON = Res.getIcon(33);
        }
        return this.isContainer() ? CONTAINER_ICON : COMPONENT_ICON;
    }

    public final String getToolTipText() {
        JavaClass type;
        StringBuffer result = new StringBuffer(this.getName());
        JavaClass javaClass = type = this.subcomponent != null ? this.subcomponent.getRepresentedType() : null;
        if (type != null) {
            result.append(": ");
            result.append(type.getQualifiedName());
        }
        return result.toString();
    }

    public final boolean mayHaveChildren() {
        return this.getAllowsChildren();
    }

    public final Iterator getChildren() {
        return this.children != null ? this.children.iterator() : null;
    }

    public final Attributes getAttributes() {
        return DefaultAttributes.EMPTY_ATTRIBUTES;
    }

    public final boolean add(Element element) {
        if (this.canAdd(element)) {
            this.add((MutableTreeNode)element);
            return true;
        }
        return false;
    }

    public final boolean remove(Element element) {
        if (this.canRemove(element)) {
            this.remove((MutableTreeNode)element);
            return true;
        }
        return false;
    }

    public final void release() {
        this.removeFromLiveContainer();
        this.releaseLiveComponent();
        this.removeSourceRepresentation();
    }

    public final boolean canRemove(Element element) {
        CmtComponentSource source = this.model != null ? this.model.getComponentSource() : null;
        JavaFile jFile = source != null ? source.getFile() : null;
        return jFile != null && !URLFileSystem.isReadOnly((URL)jFile.getURL());
    }

    public final boolean canAdd(Element element) {
        if (element == null || !(element instanceof ModelNode)) {
            return false;
        }
        CmtComponentSource source = this.model != null ? this.model.getComponentSource() : null;
        SourceFile jFile = source != null ? (SourceFile)source.getFile() : null;
        return jFile != null && !URLFileSystem.isReadOnly((URL)jFile.getURL());
    }

    public final boolean containsChild(Element child) {
        return this.children != null && this.children.contains(child);
    }

    public final int size() {
        return this.children != null ? this.children.size() : 0;
    }

    public final void removeAll() {
        this.removeAllChildren();
    }

    public final void removeAllChildren() {
        SourceFile jFile;
        CmtComponentSource source = this.model != null ? this.model.getComponentSource() : null;
        SourceFile sourceFile = jFile = source != null ? (SourceFile)source.getFile() : null;
        if (jFile != null && !URLFileSystem.isReadOnly((URL)jFile.getURL())) {
            super.removeAllChildren();
        }
    }

    public final boolean getAllowsChildren() {
        return this.isContainer();
    }

    public final Object getUserObject() {
        return this;
    }

    public URL getURL() {
        URL srcURL;
        if (this.subcomponent == null) {
            return null;
        }
        CmtComponent outer = this.subcomponent.getOuterComponent();
        CmtComponents cmtMgr = outer != null ? outer.getComponents() : null;
        CmtPackages jotMgr = cmtMgr != null ? cmtMgr.getPackages() : null;
        Project prj = jotMgr != null ? jotMgr.getProject() : null;
        URL prjURL = prj != null ? prj.getURL() : null;
        SourceFile jFile = outer != null ? (SourceFile)outer.getFile() : null;
        URL uRL = srcURL = jFile != null ? jFile.getURL() : null;
        if (srcURL != null && prjURL != null) {
            String query = prjURL.toString() + "&" + this.subcomponent.getName();
            return URLFactory.newURL((String)"jdev.cmt", null, null, (int)-1, (String)srcURL.toString(), (String)query, null);
        }
        return null;
    }

    public void setURL(URL url) {
    }

    public String getJavadocHelpKey() {
        return this.getLiveComponent().getClass().getName();
    }
}

