/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.uicanvas;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeUIManager;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.FocusableLabel;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpInfo;
import oracle.ide.inspector.InspectorManager;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.MultiInputMap;
import oracle.ide.keyboard.MultiMapAdapter;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.javatools.datatransfer.DataTransferPluginFactory;
import oracle.javatools.util.PlatformUtils;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.cmt.CmtComponent;
import oracle.jdeveloper.cmt.CmtComponentSource;
import oracle.jdeveloper.cmt.CmtModel;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSelectionModel;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.layout.XYConstraints;
import oracle.jdeveloper.layout.XYLayout;
import oracle.jdeveloper.uieditor.ModelFactory;
import oracle.jdeveloper.uieditor.UIEditor;
import oracle.jdeveloper.uieditor.UIEditorLogPage;
import oracle.jdeveloper.uieditor.UIManager;
import oracle.jdeveloper.uieditor.uicanvas.BoxEffects;
import oracle.jdeveloper.uieditor.uicanvas.LayoutAssistant;
import oracle.jdeveloper.uieditor.uicanvas.LayoutConstants;
import oracle.jdeveloper.uieditor.uicanvas.SelectNib;
import oracle.jdeveloper.uieditor.uicanvas.SelectionEffects;
import oracle.jdeveloper.uieditor.uicanvas.UIModel;
import oracle.jdevimpl.uieditor.CursorManager;
import oracle.jdevimpl.uieditor.UIEditorArb;
import oracle.jdevimpl.uieditor.UIEditorController;
import oracle.jdevimpl.uieditor.UIUtils;
import oracle.jdevimpl.uieditor.constraints.ConstraintsDockableFactory;
import oracle.jdevimpl.uieditor.datatransfer.CreateOperationFactory;
import oracle.jdevimpl.uieditor.datatransfer.Palette2DataTransferPluginFactory;
import oracle.jdevimpl.uieditor.uicanvas.LayoutModelNode;
import oracle.jdevimpl.uieditor.uicanvas.Model;
import oracle.jdevimpl.uieditor.uicanvas.ModelNode;
import oracle.jdevimpl.uieditor.uicanvas.Res;
import oracle.jdevimpl.uieditor.uicanvas.UIController;
import oracle.jdevimpl.uieditor.uicanvas.UISelectionEffects;
import oracle.jdevimpl.uieditor.uicanvas.dnd.ModelDropHandler;

public final class UICanvas
extends oracle.jdeveloper.uieditor.uicanvas.UICanvas {
    public static IdeAction INSPECTOR_ACTION;
    public static IdeAction CONSTRAINTS_ACTION;
    public static IdeAction NEXT_ACTION;
    public static IdeAction PREV_ACTION;
    public static IdeAction BUILD_ACTION;
    public static IdeAction DRILL_ACTION;
    public static JMenuItem INSPECTOR_ITEM;
    public static JMenuItem CONSTRAINTS_ITEM;
    public static JMenuItem BUILD_ITEM;
    public static JMenuItem DRILL_ITEM;
    public static final String JDEVELOPER_DESIGNER = "JDeveloperDesigner";
    public static final String SIZE_PREFIX = "uidesign.size.";
    static final int INITIAL_NIBS = 1;
    static final int DRAGSIZE = 4;
    static final int NONE = 0;
    static final int SELECTING = 1;
    static final int MOVING = 2;
    static final int RESIZING = 3;
    static final int ADDING = 4;
    static final int ADDINGWITHSIZE = 5;
    static final int SELECTINGWITHSIZE = 6;
    static final int DBLCLICKING = 7;
    private static final Dimension SCREEN_SIZE;
    private static int MIN_TOOLBAR_HEIGHT;
    private static int PREF_TOOLBAR_HEIGHT;
    private static int MAX_TOOLBAR_HEIGHT;
    private ModelNode rootNode;
    private ModelNode hitNode;
    private Point hitNodeMouseOffset;
    private Dimension hitNodeSize;
    private SelectNib hitNodeNib;
    private ModelNode[] moveNodes;
    private Point[] moveLocations;
    private int mouseMode;
    private Point mouseDown;
    private BoxEffects boxEffects;
    private SelectionEffects selectionEffects;
    private ModelDropHandler dropHandler;
    private GridBagLayout mainLayout;
    private JPanel gui;
    private FocusableLabel defaultPane;
    private JComponent contentPane;
    private GlassPane glassPane;
    private Content lightWeightContent;
    private Window heavyWeightContent;
    private Image heavyWeightImage;
    private Toolbar toolbar;
    private LayoutAssistant toolbarProvider;
    private HashMap assistantClsToItemsMap;
    private ArrayList localActions;
    private static final Point RELATIVE_POS;
    private static final Point WORKING_POS;
    private static final Dimension WORKING_SIZE;

    private void $init$() {
        this.hitNodeMouseOffset = new Point();
        this.mouseMode = 0;
        this.mouseDown = new Point(0, 0);
        this.selectionEffects = new UISelectionEffects(this);
        this.mainLayout = new GridBagLayout();
        this.gui = new PaintTolerantPanel(null);
        this.defaultPane = new FocusableLabel();
        this.contentPane = new JPanel();
        this.glassPane = new GlassPane();
        this.lightWeightContent = new Content(null);
        this.assistantClsToItemsMap = new HashMap();
        this.localActions = new ArrayList();
    }

    static {
        SCREEN_SIZE = Toolkit.getDefaultToolkit().getScreenSize();
        MIN_TOOLBAR_HEIGHT = 0;
        PREF_TOOLBAR_HEIGHT = 0;
        MAX_TOOLBAR_HEIGHT = 0;
        CreateOperationFactory opFactory = new CreateOperationFactory();
        UIManager.registerOperationFactory(opFactory);
        UIManager.getDataTransferPluginRegistry().registerFactory((DataTransferPluginFactory)new Palette2DataTransferPluginFactory());
        ModelFactory factory = UIManager.getFactory(UIModel.class);
        try {
            NEXT_ACTION = factory.registerAction(LayoutConstants.NEXT_CMD_ID, Res.getString(11), Res.getInteger(29), Res.getInstance(), 28, 0, Float.MAX_VALUE, Float.MAX_VALUE);
            NEXT_ACTION.putValue("Hidden", (Object)Boolean.TRUE);
            PREV_ACTION = factory.registerAction(LayoutConstants.PREV_CMD_ID, Res.getString(35), Res.getInteger(9), Res.getInstance(), 22, 0, Float.MAX_VALUE, Float.MAX_VALUE);
            PREV_ACTION.putValue("Hidden", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
        Icon icon = IdeIcons.getIcon((int)23);
        DummyAction dummyAction = new DummyAction(icon);
        ToolButton dummyButton = new ToolButton((Action)((Object)dummyAction));
        Insets insets = dummyButton.getMargin();
        Dimension size = dummyButton.getMinimumSize();
        MIN_TOOLBAR_HEIGHT = size.height + insets.top + insets.bottom;
        size = dummyButton.getPreferredSize();
        PREF_TOOLBAR_HEIGHT = size.height + insets.top + insets.bottom;
        size = dummyButton.getMaximumSize();
        MAX_TOOLBAR_HEIGHT = size.height + insets.top + insets.bottom;
        RELATIVE_POS = new Point(0, 0);
        WORKING_POS = new Point(0, 0);
        WORKING_SIZE = new Dimension(0, 0);
    }

    public UICanvas() {
        this.$init$();
        CursorManager.getInstance().registerView((View)this);
        this.dropHandler = new ModelDropHandler(this, 1);
        new DropTarget(this.glassPane, 1, this.dropHandler);
    }

    public Component getGUI() {
        return this.gui;
    }

    public Component getDefaultFocusComponent() {
        return this.glassPane;
    }

    public synchronized Toolbar getToolbar() {
        if (this.toolbar == null && this.editor != null) {
            this.toolbar = new CustomToolbar(null);
        }
        return this.toolbar;
    }

    public void menuWillShow(ContextMenu cMenu) {
        CmtComponent comp;
        Controller controller;
        ModelNode parent;
        Element[] selection;
        View view;
        if (cMenu == null) {
            return;
        }
        Context context = cMenu.getContext();
        View view2 = view = context != null ? context.getView() : null;
        if (view != this.editor) {
            return;
        }
        super.menuWillShow(cMenu);
        CmtModelNode anchor = null;
        Element[] elementArray = selection = context != null ? context.getSelection() : null;
        if (selection != null && selection.length > 0 && selection[0] instanceof CmtModelNode) {
            anchor = (CmtModelNode)selection[0];
        }
        if (anchor instanceof ModelNode && (parent = ((ModelNode)anchor).getParentNode()) != null) {
            JComponent[] items;
            LayoutAssistant assistant;
            boolean areSiblings = true;
            int i = 0;
            while (i < selection.length) {
                if (!parent.containsChild(selection[i]) && selection[i] instanceof ModelNode) {
                    areSiblings = false;
                    break;
                }
                ++i;
            }
            LayoutAssistant layoutAssistant = assistant = areSiblings ? parent.getLayoutAssistant() : null;
            if (assistant != null && (items = assistant.getContextMenuItems(context)).length > 0) {
                cMenu.add((Component)items[0], JDeveloperMenuConstants.SECTION_DESIGN_LAYOUT);
                int i2 = 1;
                while (i2 < items.length) {
                    cMenu.add((Component)items[i2], JDeveloperMenuConstants.SECTION_DESIGN_LAYOUT);
                    ++i2;
                }
            }
        }
        if (CONSTRAINTS_ACTION == null) {
            InspectorManager iMgr;
            ConstraintsDockableFactory addin = (ConstraintsDockableFactory)AddinManager.getAddinManager().getAddin(ConstraintsDockableFactory.class);
            Menubar menubar = Ide.getMenubar();
            if (addin instanceof ConstraintsDockableFactory) {
                CONSTRAINTS_ACTION = addin.getAction();
            }
            if (CONSTRAINTS_ACTION != null) {
                CONSTRAINTS_ITEM = menubar.createMenuItem((ToggleAction)CONSTRAINTS_ACTION, JDeveloperMenuConstants.WEIGHT_VIEW_CONSTRAINTS);
            }
            INSPECTOR_ACTION = (iMgr = InspectorManager.getInspectorManager()) != null ? iMgr.getShowAction() : null;
            INSPECTOR_ITEM = menubar.createMenuItem((ToggleAction)INSPECTOR_ACTION, JDeveloperMenuConstants.WEIGHT_VIEW_PROPERTY_INSPECTOR);
            BUILD_ITEM = menubar.createMenuItem((ToggleAction)BUILD_ACTION);
            DRILL_ITEM = menubar.createMenuItem((ToggleAction)DRILL_ACTION);
        }
        Controller controller2 = controller = view != null ? view.getController() : null;
        if (controller != null && INSPECTOR_ACTION != null) {
            INSPECTOR_ACTION.updateAction(context);
            cMenu.add((Component)INSPECTOR_ITEM, JDeveloperMenuConstants.SECTION_VIEW_CTXT_MENU);
        }
        if (CONSTRAINTS_ACTION != null) {
            CONSTRAINTS_ACTION.updateAction(context);
            cMenu.add((Component)CONSTRAINTS_ITEM, JDeveloperMenuConstants.SECTION_VIEW_CTXT_MENU);
        }
        CmtSubcomponent sub = anchor != null ? anchor.getSubcomponent() : null;
        CmtComponent cmtComponent = comp = sub != null ? sub.getOuterComponent() : null;
        if (BUILD_ITEM != null && comp instanceof CmtComponentSource && ((CmtComponentSource)comp).hasDependencies()) {
            cMenu.add((Component)BUILD_ITEM);
            if (((CmtComponentSource)comp).isDependency(sub)) {
                cMenu.add((Component)DRILL_ITEM);
            }
        }
    }

    public HelpInfo getHelpInfo() {
        HelpInfo info = new HelpInfo("f1_ideuieditor_html");
        info.setContext(this.getContext());
        return info;
    }

    public Controller getController() {
        return UIController.getInstance();
    }

    public void setOwner(View owner) {
        super.setOwner(owner);
        View view = this.owner();
        if (view != null) {
            this.defaultPane.setText(Res.getString(14));
            this.glassPane.setName(this.getId() + ".glassPane");
            this.glassPane.setOpaque(false);
            this.glassPane.addMouseListener(new 1());
            this.contentPane.setName(JDEVELOPER_DESIGNER);
            this.contentPane.setLayout((LayoutManager)((Object)new CustomLayout(null)));
            this.contentPane.setOpaque(false);
            this.boxEffects = new BoxEffects(this.contentPane);
            this.gui.setLayout(this.mainLayout);
            this.gui.add((Component)this.glassPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.gui.add((Component)this.contentPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    public void stateChanged(int state) {
        switch (state) {
            case 0: {
                CursorManager.getInstance().registerView((View)this);
                break;
            }
            case 1: {
                CursorManager.getInstance().unregisterView((View)this);
                break;
            }
            case 2: {
                CursorManager.getInstance().unregisterView((View)this);
                this.releaseToolbarItems();
                break;
            }
        }
        super.stateChanged(state);
    }

    public BoxEffects getBoxEffects() {
        return this.boxEffects;
    }

    public SelectionEffects getSelectionEffects() {
        return this.selectionEffects;
    }

    private Dimension readPreferredRootSize() {
        Dimension size = new Dimension(400, 300);
        if (this.rootNode != null) {
            Project jpr = this.editor.getContext().getProject();
            String dstr = jpr.getProperty(SIZE_PREFIX + this.editor.getComponentSource().getType().getQualifiedName(), "400,300");
            try {
                int comma = dstr.indexOf(44);
                size.width = Integer.parseInt(dstr.substring(0, comma));
                size.height = Integer.parseInt(dstr.substring(comma + 1));
            }
            catch (Exception e) {
                size.width = 400;
                size.height = 300;
            }
        }
        return size;
    }

    private Dimension getPreferredRootSize() {
        Dimension result = null;
        if (this.rootNode != null) {
            CmtSubcomponent sub = this.rootNode.getLayout();
            if (sub != null) {
                result = this.getPreferredRootSize(sub);
            }
            if (result == null && (sub = this.rootNode.getSubcomponent()) != null) {
                result = this.getPreferredRootSize(sub);
            }
        }
        return result != null ? result : this.readPreferredRootSize();
    }

    private Dimension getPreferredRootSize(CmtSubcomponent sub) {
        Object obj;
        Object obj2;
        CmtPropertyState sizeState = sub.getPropertyState("size");
        if (sizeState != null && (obj2 = sizeState.getValue()) instanceof Dimension) {
            Dimension size = (Dimension)obj2;
            if (size.width > 0 && size.height > 0) {
                return size;
            }
        }
        CmtPropertyState widthState = sub.getPropertyState("width");
        CmtPropertyState heightState = sub.getPropertyState("height");
        if (widthState != null && heightState != null && (obj = widthState.getValue()) instanceof Integer) {
            int width = (Integer)obj;
            obj = heightState.getValue();
            if (obj instanceof Integer) {
                int height = (Integer)obj;
                if (width > 0 && height > 0) {
                    return new Dimension(width, height);
                }
            }
        }
        return null;
    }

    public LayoutAssistant getLayoutAssistant(CmtModelNode node) {
        return node instanceof ModelNode ? ((ModelNode)node).getLayoutAssistant() : null;
    }

    public Point getAbsoluteLocation(Component component) {
        Point absLocation = component.getLocation();
        Container parent = component.getParent();
        while (parent != null && !JDEVELOPER_DESIGNER.equals(parent.getName())) {
            Point location = parent.getLocation();
            absLocation.translate(location.x, location.y);
            parent = parent.getParent();
        }
        if (parent == null) {
            absLocation.x -= UICanvas.SCREEN_SIZE.width;
            absLocation.y -= UICanvas.SCREEN_SIZE.height;
        }
        return absLocation;
    }

    private ModelNode[] filterNodes(Element[] nodes) {
        if (nodes == null) {
            return new ModelNode[0];
        }
        CmtModel model = this.getModel();
        if (model == null) {
            return new ModelNode[0];
        }
        ArrayList<Element> validNodes = new ArrayList<Element>();
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i] instanceof ModelNode && ((ModelNode)nodes[i]).getCmtModel() == model && ((ModelNode)nodes[i]).getSubcomponent() != null) {
                validNodes.add(nodes[i]);
            }
            ++i;
        }
        ModelNode[] filteredNodes = new ModelNode[validNodes.size()];
        validNodes.toArray(filteredNodes);
        return filteredNodes;
    }

    public void setSelectionNibs(Element[] rawSelection) {
        block24: {
            block22: {
                ModelNode[] selection;
                block23: {
                    LayoutAssistant assistant;
                    this.boxEffects.hideAll();
                    if (this.rootNode == null) break block22;
                    selection = this.filterNodes(rawSelection);
                    if (selection.length != 1 || !(selection[0] instanceof ModelNode) || selection[0] == this.rootNode) break block23;
                    ModelNode tparent = selection[0].getParentNode();
                    LayoutAssistant layoutAssistant = assistant = tparent != null ? tparent.getLayoutAssistant() : null;
                    if (assistant != null) {
                        assistant.prepareSelectComponent(selection[0], this.selectionEffects);
                    } else {
                        this.selectionEffects.hideAll();
                    }
                    break block24;
                }
                this.selectionEffects.hideAll();
                int nSelected = selection.length;
                int containerCount = 0;
                int i = 0;
                while (i < nSelected) {
                    if (selection[i].isContainer() && selection[i] != this.rootNode) {
                        ++containerCount;
                    }
                    ++i;
                }
                int jMax = nSelected > 1 ? 4 : 8;
                int numNibs = nSelected > 1 ? jMax * nSelected : jMax;
                SelectNib[] selectNibs = this.selectionEffects.getSelectNibs(numNibs += containerCount);
                int n = 0;
                Point parentLocation = new Point(0, 0);
                int i2 = 0;
                while (i2 < nSelected) {
                    block25: {
                        Component component = selection[i2].getLiveComponent();
                        int n2 = jMax = nSelected > 1 ? 4 : 8;
                        if (selection[i2].isContainer() && selection[i2] != this.rootNode) {
                            ++jMax;
                        }
                        if (component == null) break block25;
                        Point p = this.getAbsoluteLocation(component);
                        Dimension s = component.getSize();
                        int xs = p.x;
                        int ys = p.y;
                        int xe = p.x + s.width - 1;
                        int ye = p.y + s.height - 1;
                        int xm = (xs + xe) / 2;
                        int ym = (ys + ye) / 2;
                        int j = 0;
                        while (j < jMax) {
                            block27: {
                                int y;
                                int x;
                                block26: {
                                    switch (j) {
                                        case 0: {
                                            x = xs;
                                            y = ys;
                                            break;
                                        }
                                        case 1: {
                                            x = xe;
                                            y = ys;
                                            break;
                                        }
                                        case 2: {
                                            x = xs;
                                            y = ye;
                                            break;
                                        }
                                        case 3: {
                                            x = xe;
                                            y = ye;
                                            break;
                                        }
                                        case 4: {
                                            x = xm;
                                            y = ys;
                                            break;
                                        }
                                        case 5: {
                                            x = xs;
                                            y = ym;
                                            break;
                                        }
                                        case 6: {
                                            x = xe;
                                            y = ym;
                                            break;
                                        }
                                        case 7: {
                                            x = xm;
                                            y = ye;
                                            break;
                                        }
                                        default: {
                                            x = xm;
                                            y = ym;
                                            break;
                                        }
                                    }
                                    if (j != 4) break block26;
                                    if (nSelected == 1) break block27;
                                    y = ym;
                                }
                                if (j != 5) {
                                    SelectNib nib = selectNibs[n];
                                    Dimension nibSize = nib.getSize();
                                    if (i2 == 0 && nSelected > 1) {
                                        nib.anchor = true;
                                    }
                                    boolean isActive = j == 4 || j == 6 || j == 3 && nSelected == 1 || j == 7;
                                    nib.setBackground(isActive ? Color.black : SystemColor.controlShadow);
                                    nib.setSelectable(isActive);
                                    nib.target = selection[i2];
                                    nib.type = j == 4 ? 8 : j;
                                    nib.setRectangleLocation(p);
                                    nib.setRectangleDimension(s);
                                    nib.setLayoutAssistant(null);
                                    nib.parentLocation = parentLocation;
                                    this.selectionEffects.moveNib(nib, x - nibSize.width / 2, y - nibSize.height / 2);
                                    nib.setVisible(true);
                                    ++n;
                                }
                            }
                            ++j;
                        }
                    }
                    ++i2;
                }
                break block24;
            }
            this.selectionEffects.hideAll();
        }
        this.gui.revalidate();
    }

    public ModelNode findNode(ModelNode node, Point p, Point relPoint, ModelNode preferredNode) {
        boolean inside;
        Component component;
        Component component2 = component = node != null ? node.getLiveComponent() : null;
        if (component == null) {
            return null;
        }
        Point location = component.getLocation();
        Dimension size = component.getSize();
        boolean isVisible = component.isVisible();
        if (this.heavyWeightContent != null && node == this.rootNode) {
            location.x -= UICanvas.SCREEN_SIZE.width;
            location.y -= UICanvas.SCREEN_SIZE.height;
        }
        if (isVisible && component.getParent() == null && node.getParentNode() != null) {
            isVisible = false;
        }
        boolean bl = inside = p.x >= location.x && p.x < location.x + size.width && p.y >= location.y && p.y < location.y + size.height && isVisible;
        if (inside) {
            relPoint.x = p.x - location.x;
            relPoint.y = p.y - location.y;
            CmtSubcomponent sub = node.getSubcomponent();
            Container delegate = sub != null ? sub.getAsContainer() : null;
            while (delegate != component && delegate != null) {
                location = delegate.getLocation();
                relPoint.x -= location.x;
                relPoint.y -= location.y;
                delegate = delegate.getParent();
            }
            if (node == preferredNode) {
                return node;
            }
            Iterator children = node.getChildren();
            if (children != null) {
                while (children.hasNext()) {
                    ModelNode childNode;
                    CmtModelNode child = (CmtModelNode)children.next();
                    if (!child.isComponent() || (childNode = this.findNode((ModelNode)child, new Point(relPoint.x, relPoint.y), relPoint, preferredNode)) == null) continue;
                    return childNode;
                }
            }
            if (this.mouseMode == 1 && component instanceof JTabbedPane) {
                JTabbedPane tabbedPane = (JTabbedPane)component;
                TabbedPaneUI ui = tabbedPane.getUI();
                int index = -1;
                if (ui != null) {
                    try {
                        index = ui.tabForCoordinate(tabbedPane, relPoint.x, relPoint.y);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (index >= 0) {
                    try {
                        int layoutOffset = node.getChildAt(0) instanceof LayoutModelNode ? 1 : 0;
                        node = (ModelNode)node.getChildAt(index + layoutOffset);
                        relPoint.x = 0;
                        relPoint.y = 0;
                    }
                    catch (Exception e) {
                        Assert.printStackTrace((Throwable)e);
                    }
                }
            }
            return node;
        }
        return null;
    }

    public CmtModelNode findContainerNode(CmtModelNode[] excludeNodes, Point p, Point relativeLocation) {
        return this.findContainerNode(excludeNodes, p, relativeLocation, null);
    }

    /*
     * Unable to fully structure code
     */
    public CmtModelNode findContainerNode(CmtModelNode[] excludeNodes, Point p, Point relativeLocation, CmtModelNode preferredNode) {
        toNode = null;
        if (preferredNode == null || preferredNode instanceof ModelNode) {
            toNode = this.findNode(this.rootNode, p, relativeLocation, (ModelNode)preferredNode);
        }
        if (toNode == null || toNode == this.rootNode && toNode.isContainer()) {
            return this.rootNode;
        }
        component = toNode.getLiveComponent();
        if (!toNode.isContainer() || !component.isVisible() || excludeNodes != null && UICanvas.contains(excludeNodes, toNode)) ** GOTO lbl27
        return toNode;
lbl-1000:
        // 1 sources

        {
            location = component.getLocation();
            relativeLocation.x += location.x;
            relativeLocation.y += location.y;
            sub = toNode.getSubcomponent();
            delegate = sub != null ? sub.getAsContainer() : null;
            delegateX = 0;
            delegateY = 0;
            while (delegate != component && delegate != null) {
                location = delegate.getLocation();
                delegateX += location.x;
                delegateY += location.y;
                delegate = delegate.getParent();
            }
            relativeLocation.x += delegateX;
            relativeLocation.y += delegateY;
            if ((toNode = toNode.getParentNode()) == null) {
                return null;
            }
            component = toNode.getLiveComponent();
lbl27:
            // 2 sources

            ** while (!toNode.isContainer() || excludeNodes != null && UICanvas.contains((CmtModelNode[])excludeNodes, (CmtModelNode)toNode) || !component.isVisible())
        }
lbl28:
        // 1 sources

        return toNode;
    }

    private static boolean contains(CmtModelNode[] nodes, CmtModelNode node) {
        int i = 0;
        while (i < nodes.length) {
            CmtModelNode n = node;
            while (n != null) {
                if (nodes[i] == n) {
                    return true;
                }
                n = (CmtModelNode)n.getParent();
            }
            ++i;
        }
        return false;
    }

    private boolean warnReadOnly() {
        if (URLFileSystem.isReadOnly((URL)this.editor.getComponentSource().getFile().getURL())) {
            Ide.getStatusBar().setText(Res.getString(6));
            return true;
        }
        return false;
    }

    private void setMultipleMoveNodesInfo() {
        if (this.hitNode == null) {
            this.moveNodes = new ModelNode[0];
            this.moveLocations = new Point[0];
            return;
        }
        ArrayList<ModelNode> nodes = new ArrayList<ModelNode>();
        ModelNode parent = this.hitNode.getParentNode();
        Element[] selection = this.editor.getSelection();
        nodes.add(this.hitNode);
        int i = 0;
        while (i < selection.length) {
            ModelNode node;
            if (selection[i] instanceof ModelNode && (node = (ModelNode)selection[i]) != this.hitNode && node.getParentNode() == parent) {
                nodes.add(node);
            }
            ++i;
        }
        int n = nodes.size();
        this.moveNodes = new ModelNode[n];
        this.moveLocations = new Point[n];
        n = 0;
        for (ModelNode node : nodes) {
            Component component = node.getLiveComponent();
            this.moveNodes[n] = node;
            this.moveLocations[n++] = this.getAbsoluteLocation(component);
        }
    }

    private static void adjustPositionForDrag(Point location, Dimension size) {
        if (size.width < 0) {
            size.width = -size.width;
            location.x -= size.width;
        }
        if (size.height < 0) {
            size.height = -size.height;
            location.y -= size.height;
        }
    }

    public static void adjustPositionForNib(Point location, Dimension size, Point p, int nibType) {
        int xs = location.x;
        int ys = location.y;
        int xe = location.x + size.width;
        int ye = location.y + size.height;
        switch (nibType) {
            case 0: {
                xs = p.x;
                ys = p.y;
                break;
            }
            case 1: {
                xe = p.x;
                ys = p.y;
                break;
            }
            case 2: {
                xs = p.x;
                ye = p.y;
                break;
            }
            case 3: {
                xe = p.x;
                ye = p.y;
                break;
            }
            case 4: {
                ys = p.y;
                break;
            }
            case 5: {
                xs = p.x;
                break;
            }
            case 6: {
                xe = p.x;
                break;
            }
            case 7: {
                ye = p.y;
                break;
            }
        }
        location.x = xs;
        location.y = ys;
        size.width = xe - xs;
        size.height = ye - ys;
    }

    public void setModel(CmtModel model) {
        Component rootComponent = null;
        try {
            try {
                this.heavyWeightImage = null;
                if (this.rootNode != null) {
                    this.boxEffects.hideAll();
                    this.selectionEffects.hideAll();
                    this.contentPane.removeAll();
                    this.rootNode = null;
                    this.hitNode = null;
                    this.setMultipleMoveNodesInfo();
                    if (this.heavyWeightContent != null) {
                        this.heavyWeightContent.setVisible(false);
                        this.heavyWeightContent = null;
                    }
                }
                if (model != null) {
                    CmtComponentSource source = this.editor.getComponentSource();
                    if (source != null && source instanceof CmtComponentSource) {
                        ((Model)model).open(source, this.editor.getContext().getProject());
                    } else {
                        model = null;
                    }
                }
                CmtModelNode cmtRoot = model != null ? model.getRoot() : null;
                this.rootNode = cmtRoot instanceof ModelNode ? (ModelNode)cmtRoot : null;
                if (this.rootNode != null && (rootComponent = this.rootNode.getLiveComponent()) == null) {
                    this.rootNode = null;
                }
                if (this.rootNode != null) {
                    this.rootNode.addLiveComponent();
                    this.addContent();
                }
            }
            catch (Exception e) {
                this.heavyWeightImage = null;
                this.boxEffects.hideAll();
                this.selectionEffects.hideAll();
                this.contentPane.removeAll();
                this.heavyWeightContent = null;
                this.rootNode = null;
                Assert.printStackTrace((Throwable)e);
            }
        }
        finally {
            if (rootComponent != null) {
                if (this.heavyWeightContent == null) {
                    rootComponent.invalidate();
                }
                CursorManager.getInstance().registerView((View)this);
                this.gui.remove((Component)this.defaultPane);
                this.gui.add((Component)this.contentPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                CursorManager.getInstance().unregisterView((View)this);
                this.gui.remove(this.contentPane);
                this.gui.add((Component)this.defaultPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            this.gui.validate();
            this.gui.repaint();
            View view = Ide.getMainWindow().getLastActiveView();
            if (view == this.getUIEditor()) {
                this.glassPane.requestFocus();
            }
        }
    }

    private void addContent() {
        Component rootComponent;
        Component child = rootComponent = this.rootNode.getLiveComponent();
        Dimension size = this.getPreferredRootSize();
        if (rootComponent instanceof Window) {
            this.heavyWeightContent = (Window)rootComponent;
            if (this.heavyWeightContent instanceof Dialog) {
                ((Dialog)this.heavyWeightContent).setModal(false);
            }
            this.heavyWeightContent.setLocation(UICanvas.SCREEN_SIZE.width + 10, UICanvas.SCREEN_SIZE.height + 10);
            this.heavyWeightContent.setVisible(true);
            this.heavyWeightContent.setSize(size);
            SwingUtilities.invokeLater(new 2());
            this.heavyWeightImage = rootComponent.createImage(size.width, size.height);
            Graphics graphics = this.heavyWeightImage.getGraphics();
            Insets i = this.heavyWeightContent.getInsets();
            rootComponent.paintAll(graphics);
            graphics.setColor(this.heavyWeightContent.getBackground());
            graphics.fill3DRect(0, 0, i.left, size.height, true);
            graphics.fill3DRect(size.width - i.right, 0, i.right, size.height, true);
            graphics.fill3DRect(0, size.height - i.bottom, size.width, i.bottom, true);
            graphics.fill3DRect(0, 0, size.width, i.top, true);
            child = this.lightWeightContent;
        } else {
            rootComponent.setBounds(10, 10, size.width, size.height);
        }
        this.contentPane.add(child, new XYConstraints(10, 10, size.width, size.height), -1);
        if (this.heavyWeightContent == null) {
            rootComponent.setVisible(true);
        }
    }

    public void close() {
        IdeSettings settings = Ide.getSettings();
        KeyStrokeOptions options = settings.getKeyStrokeOptions();
        options.removeChangeListener(this.glassPane.changeListener);
        this.glassPane.removeAll();
        this.gui.removeAll();
        this.gui = null;
        this.mainLayout = null;
        this.glassPane = null;
        this.contentPane = null;
        if (this.heavyWeightContent != null) {
            this.heavyWeightContent.removeAll();
            this.heavyWeightContent = null;
        }
        this.hitNode = null;
        this.moveNodes = null;
        this.boxEffects.hideAll();
        this.selectionEffects.hideAll();
        this.editor.removeViewSelectionListener(this);
        super.close();
    }

    public CmtModel getModel() {
        return this.rootNode != null ? this.rootNode.getCmtModel() : null;
    }

    public void viewSelectionChanged(ViewSelectionEvent e) {
        Element[] selection = e.getSelection();
        boolean hitNodeSelected = false;
        int i = 0;
        while (i < selection.length) {
            if (selection[i] == this.hitNode) {
                hitNodeSelected = true;
                break;
            }
            ++i;
        }
        if (!hitNodeSelected) {
            this.hitNode = selection.length > 0 && selection[0] instanceof ModelNode ? (ModelNode)selection[0] : null;
        }
        this.setSelectionNibs(selection);
        this.updateToolbarForNode(selection.length > 0 ? selection[0] : null);
        super.viewSelectionChanged(e);
    }

    private void updateToolbarForNode(Element node) {
        Toolbar container = this.getToolbar();
        if (container != null) {
            View view;
            Context context;
            if (node instanceof ModelNode) {
                LayoutAssistant assistant;
                ModelNode parent = ((ModelNode)node).getParentNode();
                LayoutAssistant layoutAssistant = assistant = parent != null ? parent.getLayoutAssistant() : null;
                if (assistant != this.toolbarProvider) {
                    container.removeAll();
                    this.toolbarProvider = assistant;
                    Component[] components = this.getToolbarItems();
                    if (components != null) {
                        int i = 0;
                        while (i < components.length) {
                            container.add(components[i]);
                            ++i;
                        }
                    }
                }
            } else {
                container.removeAll();
                this.toolbarProvider = null;
            }
            if (Ide.getMainWindow().getLastActiveView() != this.getUIEditor() && (context = this.getContext()) != null && (view = context.getView()) != null) {
                UICanvas.updateToolbarActions((Toolbar)view.getToolbar());
            }
            container.repaint();
        }
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    private Component[] getToolbarItems() {
        if (this.toolbarProvider == null) {
            return null;
        }
        Class<?> cls = this.toolbarProvider.getClass();
        Component[] items = (Component[])this.assistantClsToItemsMap.get(cls);
        if (items == null) {
            String prefix = this.toolbarProvider.getToolbarPrefix();
            if (prefix == null) {
                items = new Component[]{};
            } else {
                Toolbar container = new Toolbar();
                UICanvas.loadManifestToolbar((String)prefix, (Toolbar)container, (View)this.editor);
                items = container.getComponents();
                if (items == null) {
                    items = new Component[]{};
                } else {
                    Action[] actions = container.getActions();
                    if (actions != null) {
                        int i = 0;
                        while (i < actions.length) {
                            this.localActions.add(actions[i]);
                            ++i;
                        }
                    }
                }
            }
            this.assistantClsToItemsMap.put(cls, items);
        }
        return items;
    }

    private void releaseToolbarItems() {
        Iterator i = this.assistantClsToItemsMap.values().iterator();
        if (i != null) {
            while (i.hasNext()) {
                Component[] items = (Component[])i.next();
                int j = 0;
                while (j < items.length) {
                    UICanvas.releaseToolbarItem(items[j]);
                    ++j;
                }
            }
        }
        this.localActions.clear();
        this.assistantClsToItemsMap.clear();
    }

    private static void releaseToolbarItem(Component component) {
        if (component instanceof AbstractButton) {
            ((AbstractButton)component).setAction(null);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int count = container.getComponentCount();
            int i = 0;
            while (i < count) {
                UICanvas.releaseToolbarItem(container.getComponent(i));
                ++i;
            }
        }
    }

    static int ra$MAX_TOOLBAR_HEIGHT() {
        return MAX_TOOLBAR_HEIGHT;
    }

    static int ra$PREF_TOOLBAR_HEIGHT() {
        return PREF_TOOLBAR_HEIGHT;
    }

    static int ra$MIN_TOOLBAR_HEIGHT() {
        return MIN_TOOLBAR_HEIGHT;
    }

    static Image ra$heavyWeightImage(UICanvas uICanvas) {
        return uICanvas.heavyWeightImage;
    }

    static ModelNode ra$rootNode(UICanvas uICanvas) {
        return uICanvas.rootNode;
    }

    static int ra$mouseMode(UICanvas uICanvas) {
        return uICanvas.mouseMode;
    }

    static Point[] ra$moveLocations(UICanvas uICanvas) {
        return uICanvas.moveLocations;
    }

    static Point ra$RELATIVE_POS() {
        return RELATIVE_POS;
    }

    static ModelNode[] ra$moveNodes(UICanvas uICanvas) {
        return uICanvas.moveNodes;
    }

    static Point ra$hitNodeMouseOffset(UICanvas uICanvas) {
        return uICanvas.hitNodeMouseOffset;
    }

    static SelectNib ra$hitNodeNib(UICanvas uICanvas) {
        return uICanvas.hitNodeNib;
    }

    static Point ra$mouseDown(UICanvas uICanvas) {
        return uICanvas.mouseDown;
    }

    static void wa$hitNode(UICanvas uICanvas, ModelNode modelNode) {
        uICanvas.hitNode = modelNode;
    }

    static ModelNode ra$hitNode(UICanvas uICanvas) {
        return uICanvas.hitNode;
    }

    static UIEditor ra$editor(UICanvas uICanvas) {
        return uICanvas.editor;
    }

    static Point ra$WORKING_POS() {
        return WORKING_POS;
    }

    static Dimension ra$WORKING_SIZE() {
        return WORKING_SIZE;
    }

    static void maS$adjustPositionForDrag(Point point, Dimension dimension) {
        UICanvas.adjustPositionForDrag(point, dimension);
    }

    static void wa$mouseMode(UICanvas uICanvas, int n) {
        uICanvas.mouseMode = n;
    }

    static SelectionEffects ra$selectionEffects(UICanvas uICanvas) {
        return uICanvas.selectionEffects;
    }

    static JPanel ra$gui(UICanvas uICanvas) {
        return uICanvas.gui;
    }

    static BoxEffects ra$boxEffects(UICanvas uICanvas) {
        return uICanvas.boxEffects;
    }

    static boolean mav$warnReadOnly(UICanvas uICanvas) {
        return uICanvas.warnReadOnly();
    }

    static void mav$setMultipleMoveNodesInfo(UICanvas uICanvas) {
        uICanvas.setMultipleMoveNodesInfo();
    }

    static void wa$hitNodeNib(UICanvas uICanvas, SelectNib selectNib) {
        uICanvas.hitNodeNib = selectNib;
    }

    static void wa$hitNodeSize(UICanvas uICanvas, Dimension dimension) {
        uICanvas.hitNodeSize = dimension;
    }

    static JComponent ra$contentPane(UICanvas uICanvas) {
        return uICanvas.contentPane;
    }

    static Content ra$lightWeightContent(UICanvas uICanvas) {
        return uICanvas.lightWeightContent;
    }

    private static final class DummyAction
    extends ToggleAction {
        public DummyAction(Icon icon) {
            super(null, icon);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    final class 1
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            this.tryPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.tryPopup(e);
        }

        private void tryPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                UICanvas.this.getContextMenu().show(UICanvas.this.owner().getContext((EventObject)e));
            }
        }
    }

    final class 2
    implements Runnable {
        public void run() {
            Ide.getMainWindow().requestFocus();
        }
    }

    private final class CustomToolbar
    extends Toolbar {
        public Dimension getMinimumSize() {
            Dimension minSize = super.getMinimumSize();
            if (this.getComponentCount() == 0 && minSize.height < UICanvas.ra$MIN_TOOLBAR_HEIGHT()) {
                minSize.height = UICanvas.ra$MIN_TOOLBAR_HEIGHT();
            }
            return minSize;
        }

        public Dimension getPreferredSize() {
            Dimension prefSize = super.getPreferredSize();
            if (this.getComponentCount() == 0 && prefSize.height < UICanvas.ra$PREF_TOOLBAR_HEIGHT()) {
                prefSize.height = UICanvas.ra$PREF_TOOLBAR_HEIGHT();
            }
            return prefSize;
        }

        public Dimension getMaximumSize() {
            Dimension maxSize = super.getMaximumSize();
            if (this.getComponentCount() == 0 && maxSize.height < UICanvas.ra$MAX_TOOLBAR_HEIGHT()) {
                maxSize.height = UICanvas.ra$MAX_TOOLBAR_HEIGHT();
            }
            return maxSize;
        }

        private CustomToolbar() {
        }

        CustomToolbar(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class Content
    extends JPanel {
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (UICanvas.ra$heavyWeightImage(UICanvas.this) != null) {
                g.drawImage(UICanvas.ra$heavyWeightImage(UICanvas.this), 0, 0, this);
            }
        }

        private Content() {
        }

        Content(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class GlassPane
    extends JPanel {
        private ModelNode effectsTarget;
        private LayoutAssistant effectsAssistant;
        MultiInputMap multiMap;
        KeyStrokeContext keyStrokeContext;
        ChangeListener changeListener;

        private void $init$() {
            this.effectsTarget = null;
            this.effectsAssistant = null;
            this.changeListener = new 1();
        }

        GlassPane() {
            this.$init$();
            AccessibleContext ac = this.getAccessibleContext();
            if (ac != null) {
                ac.setAccessibleName(UIEditorArb.getString(22));
            }
            this.setFocusTraversalKeysEnabled(false);
            this.setFocusable(true);
            ModelFactory factory = UIManager.getFactory(Model.class);
            KeyStrokeOptions options = Ide.getSettings().getKeyStrokeOptions();
            ActionMap actionMap = this.getActionMap();
            InputMap inputMap = this.getInputMap();
            this.keyStrokeContext = factory.getKeyStrokeContext();
            this.multiMap = MultiMapAdapter.getLocalMap((KeyStrokeOptions)options, (KeyStrokeContext)this.keyStrokeContext);
            options.addChangeListener(this.changeListener);
            actionMap.setParent(Ide.getIdeActionMap());
            this.multiMap.setParent(inputMap);
            this.setInputMap(0, (InputMap)this.multiMap);
            this.enableEvents(52);
        }

        public boolean isManagingFocus() {
            return true;
        }

        protected void processMouseEvent(MouseEvent e) {
            switch (e.getID()) {
                case 501: {
                    this.processMousePressed(e);
                    break;
                }
                case 502: {
                    this.processMouseReleased(e);
                    break;
                }
                case 500: {
                    this.processMouseClicked(e);
                    break;
                }
                case 504: {
                    this.processMouseEntered(e);
                    break;
                }
                case 505: {
                    this.processMouseExited(e);
                    break;
                }
            }
            super.processMouseEvent(e);
        }

        protected void processMouseMotionEvent(MouseEvent e) {
            switch (e.getID()) {
                case 503: {
                    this.processMouseMoved(e);
                    break;
                }
                case 506: {
                    this.processMouseDragged(e);
                    break;
                }
            }
            super.processMouseMotionEvent(e);
        }

        public void processMousePressed(MouseEvent e) {
            this.requestFocus();
            if (UICanvas.ra$rootNode(UICanvas.this) == null) {
                return;
            }
            if (UICanvas.ra$mouseMode(UICanvas.this) == 0) {
                if (e.isMetaDown() && !PlatformUtils.isMac() && UICanvas.this.getUIEditor().getSelection().length > 1) {
                    return;
                }
                UICanvas.ra$mouseDown((UICanvas)UICanvas.this).x = e.getX();
                UICanvas.ra$mouseDown((UICanvas)UICanvas.this).y = e.getY();
                UICanvas.wa$hitNodeNib(UICanvas.this, UICanvas.ra$selectionEffects(UICanvas.this).hitTest(UICanvas.ra$mouseDown(UICanvas.this)));
                if (UICanvas.ra$hitNodeNib(UICanvas.this) != null && UICanvas.ra$hitNodeNib((UICanvas)UICanvas.this).type != 8) {
                    if (UICanvas.mav$warnReadOnly(UICanvas.this)) {
                        return;
                    }
                    UICanvas.wa$hitNode(UICanvas.this, (ModelNode)UICanvas.ra$hitNodeNib((UICanvas)UICanvas.this).target);
                    UICanvas.wa$mouseMode(UICanvas.this, 3);
                    this.updateEffects(UICanvas.ra$hitNode(UICanvas.this) != null ? UICanvas.ra$hitNode(UICanvas.this).getParentNode() : null);
                } else if (UIUtils.getMode() == 2 || e.isMetaDown() && !PlatformUtils.isMac()) {
                    UIEditor editor;
                    CmtComponentSource source;
                    CmtSelectionModel selModel;
                    boolean isSelected;
                    boolean isAltDown;
                    UICanvas.wa$mouseMode(UICanvas.this, 1);
                    boolean isControlDown = PlatformUtils.isMac() ? e.isMetaDown() && !e.isPopupTrigger() : e.isControlDown();
                    boolean isShiftDown = e.isShiftDown();
                    boolean bl = isAltDown = isControlDown && isShiftDown;
                    if (isAltDown) {
                        isControlDown = false;
                        isShiftDown = false;
                    }
                    if (e.isAltDown()) {
                        isAltDown = true;
                    }
                    UICanvas.ra$RELATIVE_POS().x = 0;
                    UICanvas.ra$RELATIVE_POS().y = 0;
                    if (UICanvas.ra$hitNodeNib(UICanvas.this) == null) {
                        ModelNode parentNode;
                        UICanvas.wa$hitNode(UICanvas.this, UICanvas.this.findNode(UICanvas.ra$rootNode(UICanvas.this), UICanvas.ra$mouseDown(UICanvas.this), UICanvas.ra$RELATIVE_POS(), null));
                        if (UICanvas.ra$hitNode(UICanvas.this) == null) {
                            UICanvas.wa$mouseMode(UICanvas.this, 0);
                            return;
                        }
                        if (isAltDown && (parentNode = UICanvas.ra$hitNode(UICanvas.this).getParentNode()) != null) {
                            UICanvas.wa$hitNode(UICanvas.this, parentNode);
                        }
                    } else {
                        UICanvas.wa$hitNode(UICanvas.this, (ModelNode)UICanvas.this.getUIEditor().getSelection()[0]);
                    }
                    if (isSelected = (selModel = (source = (editor = UICanvas.this.getUIEditor()).getComponentSource()).getSelectionModel()).isSelected(UICanvas.ra$hitNode(UICanvas.this))) {
                        if (isShiftDown) {
                            CmtModelNode[] sel = selModel.getSelection();
                            int i = 0;
                            while (i < sel.length) {
                                if (sel[i] == UICanvas.ra$hitNode(UICanvas.this)) break;
                                ++i;
                            }
                            if (i > 0) {
                                System.arraycopy(sel, 0, sel, 1, i);
                                sel[0] = UICanvas.ra$hitNode(UICanvas.this);
                                selModel.setSelection(sel);
                            }
                        } else if (isControlDown) {
                            CmtModelNode[] sel = selModel.getSelection();
                            CmtModelNode[] newSel = new CmtModelNode[sel.length - 1];
                            int i = 0;
                            while (i < sel.length) {
                                if (sel[i] == UICanvas.ra$hitNode(UICanvas.this)) break;
                                ++i;
                            }
                            if (i == 0) {
                                System.arraycopy(sel, 1, newSel, 0, sel.length - 1);
                            } else if (i == sel.length - 1) {
                                System.arraycopy(sel, 0, newSel, 0, sel.length - 1);
                            } else {
                                System.arraycopy(sel, 0, newSel, 0, i);
                                System.arraycopy(sel, i + 1, newSel, i, sel.length - 1 - i);
                            }
                            selModel.setSelection(newSel);
                        }
                    } else if (UICanvas.ra$hitNode(UICanvas.this) != null) {
                        if (isShiftDown || isControlDown) {
                            CmtModelNode[] sel = selModel.getSelection();
                            CmtModelNode[] newSel = new CmtModelNode[sel.length + 1];
                            newSel[0] = UICanvas.ra$hitNode(UICanvas.this);
                            System.arraycopy(sel, 0, newSel, 1, sel.length);
                            selModel.setSelection(newSel);
                        } else {
                            selModel.setSelection(new CmtModelNode[]{UICanvas.ra$hitNode(UICanvas.this)});
                        }
                    } else {
                        selModel.clearSelection();
                    }
                } else if (UIUtils.getMode() == 3) {
                    Element[] selection;
                    UICanvas.wa$mouseMode(UICanvas.this, 4);
                    UICanvas.ra$RELATIVE_POS().x = 0;
                    UICanvas.ra$RELATIVE_POS().y = 0;
                    ModelNode preferredNode = null;
                    if (e.isAltDown() && (selection = UICanvas.this.getUIEditor().getSelection()).length == 1 && selection[0] instanceof ModelNode) {
                        preferredNode = (ModelNode)selection[0];
                    }
                    UICanvas.wa$hitNode(UICanvas.this, (ModelNode)UICanvas.this.findContainerNode(null, UICanvas.ra$mouseDown(UICanvas.this), UICanvas.ra$RELATIVE_POS(), preferredNode));
                    if (e.isAltDown() && UICanvas.ra$hitNode(UICanvas.this) != preferredNode) {
                        preferredNode = UICanvas.ra$hitNode(UICanvas.this).getParentNode();
                        UICanvas.ra$RELATIVE_POS().x = 0;
                        UICanvas.ra$RELATIVE_POS().y = 0;
                        UICanvas.wa$hitNode(UICanvas.this, (ModelNode)UICanvas.this.findContainerNode(null, UICanvas.ra$mouseDown(UICanvas.this), UICanvas.ra$RELATIVE_POS(), preferredNode));
                    }
                    this.updateEffects(UICanvas.ra$hitNode(UICanvas.this));
                }
                if (UICanvas.ra$mouseMode(UICanvas.this) == 3) {
                    Component component = UICanvas.ra$hitNode(UICanvas.this).getLiveComponent();
                    UICanvas.wa$hitNodeSize(UICanvas.this, UICanvas.ra$hitNodeNib(UICanvas.this).getRectangleDimension());
                } else if (UICanvas.ra$mouseMode(UICanvas.this) == 1 && UICanvas.ra$hitNode(UICanvas.this) != null) {
                    Component component = UICanvas.ra$hitNode(UICanvas.this).getLiveComponent();
                    UICanvas.wa$hitNodeSize(UICanvas.this, component.getSize());
                }
            }
        }

        public void processMouseDragged(MouseEvent e) {
            if (UICanvas.ra$rootNode(UICanvas.this) == null) {
                return;
            }
            if (UICanvas.ra$mouseMode(UICanvas.this) != 0) {
                Point delta = new Point(e.getX() - UICanvas.ra$mouseDown((UICanvas)UICanvas.this).x, e.getY() - UICanvas.ra$mouseDown((UICanvas)UICanvas.this).y);
                if (UICanvas.ra$selectionEffects(UICanvas.this).areVisible()) {
                    boolean bigDrag;
                    boolean isControlDown = PlatformUtils.isMac() ? e.isMetaDown() && !e.isPopupTrigger() : e.isControlDown();
                    boolean isShiftDown = e.isShiftDown();
                    boolean isAltDown = isControlDown && isShiftDown;
                    boolean bl = bigDrag = Math.abs(delta.x) > 4 || Math.abs(delta.y) > 4;
                    if (isAltDown) {
                        isControlDown = false;
                        isShiftDown = false;
                    }
                    if (UICanvas.ra$mouseMode(UICanvas.this) == 1 && bigDrag && UICanvas.ra$hitNode(UICanvas.this) != UICanvas.ra$rootNode(UICanvas.this) && !e.isShiftDown()) {
                        UICanvas.wa$mouseMode(UICanvas.this, 2);
                        if (UICanvas.mav$warnReadOnly(UICanvas.this)) {
                            UICanvas.wa$mouseMode(UICanvas.this, 0);
                            return;
                        }
                        this.updateEffects(UICanvas.ra$hitNode(UICanvas.this) != null ? UICanvas.ra$hitNode(UICanvas.this).getParentNode() : null);
                    }
                    if (UICanvas.ra$mouseMode(UICanvas.this) == 1 && (bigDrag && UICanvas.ra$hitNode(UICanvas.this) == UICanvas.ra$rootNode(UICanvas.this) || isShiftDown)) {
                        UICanvas.wa$mouseMode(UICanvas.this, 6);
                        UICanvas.ra$selectionEffects(UICanvas.this).hideAll();
                        UICanvas.ra$WORKING_POS().x = UICanvas.ra$mouseDown((UICanvas)UICanvas.this).x;
                        UICanvas.ra$WORKING_POS().y = UICanvas.ra$mouseDown((UICanvas)UICanvas.this).y;
                        UICanvas.ra$WORKING_SIZE().width = delta.x;
                        UICanvas.ra$WORKING_SIZE().height = delta.y;
                        UICanvas.maS$adjustPositionForDrag(UICanvas.ra$WORKING_POS(), UICanvas.ra$WORKING_SIZE());
                        UICanvas.ra$boxEffects(UICanvas.this).show(0, UICanvas.ra$WORKING_POS(), UICanvas.ra$WORKING_SIZE(), 1);
                    }
                    if (UICanvas.ra$mouseMode(UICanvas.this) == 2) {
                        UICanvas.ra$selectionEffects(UICanvas.this).hideAll();
                        UICanvas.mav$setMultipleMoveNodesInfo(UICanvas.this);
                        if (UICanvas.ra$moveLocations(UICanvas.this).length > 0) {
                            UICanvas.ra$hitNodeMouseOffset((UICanvas)UICanvas.this).x = UICanvas.ra$mouseDown((UICanvas)UICanvas.this).x - UICanvas.ra$moveLocations((UICanvas)UICanvas.this)[0].x;
                            UICanvas.ra$hitNodeMouseOffset((UICanvas)UICanvas.this).y = UICanvas.ra$mouseDown((UICanvas)UICanvas.this).y - UICanvas.ra$moveLocations((UICanvas)UICanvas.this)[0].y;
                            UICanvas.ra$RELATIVE_POS().x = 0;
                            UICanvas.ra$RELATIVE_POS().y = 0;
                            CmtModelNode toNode = UICanvas.this.findContainerNode(UICanvas.ra$moveNodes(UICanvas.this), e.getPoint(), UICanvas.ra$RELATIVE_POS());
                            if (e.isAltDown()) {
                                CmtModelNode preferredNode = (CmtModelNode)toNode.getParent();
                                UICanvas.ra$RELATIVE_POS().x = 0;
                                UICanvas.ra$RELATIVE_POS().y = 0;
                                toNode = UICanvas.this.findContainerNode(UICanvas.ra$moveNodes(UICanvas.this), e.getPoint(), UICanvas.ra$RELATIVE_POS(), preferredNode);
                            }
                            if (toNode != this.effectsTarget && this.effectsTarget != null) {
                                this.updateEffects(toNode);
                            }
                            Component comp = UICanvas.ra$moveNodes(UICanvas.this)[0].getLiveComponent();
                            Dimension size = comp.getSize();
                            Container cont = toNode.getSubcomponent().getAsContainer();
                            Point parentPos = UICanvas.this.getAbsoluteLocation(cont);
                            UICanvas.ra$WORKING_POS().x = UICanvas.ra$RELATIVE_POS().x - UICanvas.ra$hitNodeMouseOffset((UICanvas)UICanvas.this).x;
                            UICanvas.ra$WORKING_POS().y = UICanvas.ra$RELATIVE_POS().y - UICanvas.ra$hitNodeMouseOffset((UICanvas)UICanvas.this).y;
                            UICanvas.ra$WORKING_SIZE().width = size.width;
                            UICanvas.ra$WORKING_SIZE().height = size.height;
                            if (this.effectsAssistant != null) {
                                Ide.getStatusBar().setText(this.effectsAssistant.constrainMove(UICanvas.ra$moveNodes(UICanvas.this)[0], toNode, UICanvas.ra$RELATIVE_POS(), UICanvas.ra$hitNodeMouseOffset(UICanvas.this), UICanvas.ra$WORKING_POS(), UICanvas.ra$WORKING_SIZE()));
                            }
                            UICanvas.ra$WORKING_POS().x += parentPos.x;
                            UICanvas.ra$WORKING_POS().y += parentPos.y;
                            UICanvas.ra$boxEffects(UICanvas.this).show(0, UICanvas.ra$WORKING_POS(), UICanvas.ra$WORKING_SIZE(), 2);
                            int i = 1;
                            while (i < UICanvas.ra$moveNodes(UICanvas.this).length) {
                                comp = UICanvas.ra$moveNodes(UICanvas.this)[i].getLiveComponent();
                                size = comp.getSize();
                                UICanvas.ra$WORKING_POS().x = UICanvas.ra$moveLocations((UICanvas)UICanvas.this)[i].x - UICanvas.ra$moveLocations((UICanvas)UICanvas.this)[0].x + UICanvas.ra$RELATIVE_POS().x - UICanvas.ra$hitNodeMouseOffset((UICanvas)UICanvas.this).x;
                                UICanvas.ra$WORKING_POS().y = UICanvas.ra$moveLocations((UICanvas)UICanvas.this)[i].y - UICanvas.ra$moveLocations((UICanvas)UICanvas.this)[0].y + UICanvas.ra$RELATIVE_POS().y - UICanvas.ra$hitNodeMouseOffset((UICanvas)UICanvas.this).y;
                                UICanvas.ra$WORKING_SIZE().width = size.width;
                                UICanvas.ra$WORKING_SIZE().height = size.height;
                                if (this.effectsAssistant != null) {
                                    this.effectsAssistant.constrainMove(UICanvas.ra$moveNodes(UICanvas.this)[i], toNode, UICanvas.ra$RELATIVE_POS(), UICanvas.ra$hitNodeMouseOffset(UICanvas.this), UICanvas.ra$WORKING_POS(), UICanvas.ra$WORKING_SIZE());
                                }
                                UICanvas.ra$WORKING_POS().x += parentPos.x;
                                UICanvas.ra$WORKING_POS().y += parentPos.y;
                                UICanvas.ra$boxEffects(UICanvas.this).show(i, UICanvas.ra$WORKING_POS(), UICanvas.ra$WORKING_SIZE(), 2);
                                ++i;
                            }
                        }
                    } else if (UICanvas.ra$mouseMode(UICanvas.this) == 3) {
                        UICanvas.ra$selectionEffects(UICanvas.this).hideAll();
                        UICanvas.ra$WORKING_POS().x = e.getX();
                        UICanvas.ra$WORKING_POS().y = e.getY();
                        Ide.getStatusBar().setText(UICanvas.ra$hitNodeNib(UICanvas.this).resizeAction(UICanvas.ra$WORKING_POS(), UICanvas.this));
                    } else if (UICanvas.ra$mouseMode(UICanvas.this) == 4 && bigDrag) {
                        Element[] selection;
                        UICanvas.wa$mouseMode(UICanvas.this, 5);
                        UICanvas.ra$selectionEffects(UICanvas.this).hideAll();
                        UICanvas.ra$RELATIVE_POS().x = 0;
                        UICanvas.ra$RELATIVE_POS().y = 0;
                        ModelNode preferredNode = null;
                        if (e.isAltDown() && (selection = UICanvas.this.getUIEditor().getSelection()).length == 1 && selection[0] instanceof ModelNode) {
                            preferredNode = (ModelNode)selection[0];
                        }
                        UICanvas.wa$hitNode(UICanvas.this, (ModelNode)UICanvas.this.findContainerNode(null, UICanvas.ra$mouseDown(UICanvas.this), UICanvas.ra$RELATIVE_POS(), preferredNode));
                        if (e.isAltDown() && UICanvas.ra$hitNode(UICanvas.this) != preferredNode) {
                            preferredNode = UICanvas.ra$hitNode(UICanvas.this).getParentNode();
                            UICanvas.ra$RELATIVE_POS().x = 0;
                            UICanvas.ra$RELATIVE_POS().y = 0;
                            UICanvas.wa$hitNode(UICanvas.this, (ModelNode)UICanvas.this.findContainerNode(null, UICanvas.ra$mouseDown(UICanvas.this), UICanvas.ra$RELATIVE_POS(), preferredNode));
                        }
                        if (UICanvas.ra$hitNode(UICanvas.this) != this.effectsTarget && this.effectsTarget != null) {
                            this.updateEffects(UICanvas.ra$hitNode(UICanvas.this));
                        }
                        UICanvas.ra$WORKING_POS().x = UICanvas.ra$RELATIVE_POS().x;
                        UICanvas.ra$WORKING_POS().y = UICanvas.ra$RELATIVE_POS().y;
                        UICanvas.ra$WORKING_SIZE().width = delta.x;
                        UICanvas.ra$WORKING_SIZE().height = delta.y;
                        if (this.effectsAssistant != null) {
                            Point currentPos = new Point(UICanvas.ra$RELATIVE_POS().x + delta.x, UICanvas.ra$RELATIVE_POS().y + delta.y);
                            this.effectsAssistant.constrainAdd(UICanvas.ra$hitNode(UICanvas.this), UICanvas.ra$RELATIVE_POS(), currentPos, UICanvas.ra$WORKING_POS(), UICanvas.ra$WORKING_SIZE());
                        }
                        UIEditorController.mouseAddingNode(null, UICanvas.ra$hitNode(UICanvas.this), UICanvas.ra$WORKING_POS(), UICanvas.ra$WORKING_SIZE());
                        if (UICanvas.ra$hitNode(UICanvas.this) != null) {
                            Container cont = UICanvas.ra$hitNode(UICanvas.this).getSubcomponent().getAsContainer();
                            Point parentPos = UICanvas.this.getAbsoluteLocation(cont);
                            UICanvas.ra$WORKING_POS().x += parentPos.x;
                            UICanvas.ra$WORKING_POS().y += parentPos.y;
                            UICanvas.ra$boxEffects(UICanvas.this).show(0, UICanvas.ra$WORKING_POS(), UICanvas.ra$WORKING_SIZE(), 2);
                        }
                    }
                } else if (UICanvas.ra$mouseMode(UICanvas.this) == 2) {
                    if (UICanvas.ra$moveLocations(UICanvas.this).length > 0) {
                        UICanvas.ra$RELATIVE_POS().x = 0;
                        UICanvas.ra$RELATIVE_POS().y = 0;
                        CmtModelNode toNode = UICanvas.this.findContainerNode(UICanvas.ra$moveNodes(UICanvas.this), e.getPoint(), UICanvas.ra$RELATIVE_POS());
                        if (e.isAltDown()) {
                            CmtModelNode preferredNode = (CmtModelNode)toNode.getParent();
                            UICanvas.ra$RELATIVE_POS().x = 0;
                            UICanvas.ra$RELATIVE_POS().y = 0;
                            toNode = UICanvas.this.findContainerNode(UICanvas.ra$moveNodes(UICanvas.this), e.getPoint(), UICanvas.ra$RELATIVE_POS(), preferredNode);
                        }
                        if (toNode != this.effectsTarget && this.effectsTarget != null) {
                            this.updateEffects(toNode);
                        }
                        Component comp = UICanvas.ra$moveNodes(UICanvas.this)[0].getLiveComponent();
                        Dimension size = comp.getSize();
                        Container cont = toNode.getSubcomponent().getAsContainer();
                        Point parentPos = UICanvas.this.getAbsoluteLocation(cont);
                        UICanvas.ra$WORKING_POS().x = UICanvas.ra$RELATIVE_POS().x - UICanvas.ra$hitNodeMouseOffset((UICanvas)UICanvas.this).x;
                        UICanvas.ra$WORKING_POS().y = UICanvas.ra$RELATIVE_POS().y - UICanvas.ra$hitNodeMouseOffset((UICanvas)UICanvas.this).y;
                        UICanvas.ra$WORKING_SIZE().width = size.width;
                        UICanvas.ra$WORKING_SIZE().height = size.height;
                        if (this.effectsAssistant != null) {
                            Ide.getStatusBar().setText(this.effectsAssistant.constrainMove(UICanvas.ra$moveNodes(UICanvas.this)[0], toNode, UICanvas.ra$RELATIVE_POS(), UICanvas.ra$hitNodeMouseOffset(UICanvas.this), UICanvas.ra$WORKING_POS(), UICanvas.ra$WORKING_SIZE()));
                        }
                        UICanvas.ra$WORKING_POS().x += parentPos.x;
                        UICanvas.ra$WORKING_POS().y += parentPos.y;
                        UICanvas.ra$boxEffects(UICanvas.this).show(0, UICanvas.ra$WORKING_POS(), UICanvas.ra$WORKING_SIZE(), 2);
                        Point origin = new Point(UICanvas.ra$RELATIVE_POS());
                        int i = 1;
                        while (i < UICanvas.ra$moveNodes(UICanvas.this).length) {
                            comp = UICanvas.ra$moveNodes(UICanvas.this)[i].getLiveComponent();
                            size = comp.getSize();
                            UICanvas.ra$RELATIVE_POS().x = UICanvas.ra$moveLocations((UICanvas)UICanvas.this)[i].x - UICanvas.ra$moveLocations((UICanvas)UICanvas.this)[0].x + origin.x;
                            UICanvas.ra$RELATIVE_POS().y = UICanvas.ra$moveLocations((UICanvas)UICanvas.this)[i].y - UICanvas.ra$moveLocations((UICanvas)UICanvas.this)[0].y + origin.y;
                            UICanvas.ra$WORKING_POS().x = UICanvas.ra$RELATIVE_POS().x - UICanvas.ra$hitNodeMouseOffset((UICanvas)UICanvas.this).x;
                            UICanvas.ra$WORKING_POS().y = UICanvas.ra$RELATIVE_POS().y - UICanvas.ra$hitNodeMouseOffset((UICanvas)UICanvas.this).y;
                            UICanvas.ra$WORKING_SIZE().width = size.width;
                            UICanvas.ra$WORKING_SIZE().height = size.height;
                            if (this.effectsAssistant != null) {
                                this.effectsAssistant.constrainMove(UICanvas.ra$moveNodes(UICanvas.this)[i], toNode, UICanvas.ra$RELATIVE_POS(), UICanvas.ra$hitNodeMouseOffset(UICanvas.this), UICanvas.ra$WORKING_POS(), UICanvas.ra$WORKING_SIZE());
                            }
                            UICanvas.ra$WORKING_POS().x += parentPos.x;
                            UICanvas.ra$WORKING_POS().y += parentPos.y;
                            UICanvas.ra$boxEffects(UICanvas.this).show(i, UICanvas.ra$WORKING_POS(), UICanvas.ra$WORKING_SIZE(), 2);
                            ++i;
                        }
                        UICanvas.ra$gui(UICanvas.this).repaint();
                    }
                } else if (UICanvas.ra$mouseMode(UICanvas.this) == 3) {
                    UICanvas.ra$WORKING_POS().x = e.getX();
                    UICanvas.ra$WORKING_POS().y = e.getY();
                    Ide.getStatusBar().setText(UICanvas.ra$hitNodeNib(UICanvas.this).resizeAction(UICanvas.ra$WORKING_POS(), UICanvas.this));
                    UICanvas.ra$gui(UICanvas.this).repaint();
                } else if (UICanvas.ra$mouseMode(UICanvas.this) == 4) {
                    boolean bigDrag;
                    boolean bl = bigDrag = Math.abs(delta.x) > 4 || Math.abs(delta.y) > 4;
                    if (bigDrag) {
                        UICanvas.wa$mouseMode(UICanvas.this, 5);
                    }
                } else if (UICanvas.ra$mouseMode(UICanvas.this) == 1) {
                    boolean bigDrag;
                    boolean bl = bigDrag = Math.abs(delta.x) > 4 || Math.abs(delta.y) > 4;
                    if (bigDrag) {
                        UICanvas.wa$mouseMode(UICanvas.this, 6);
                    }
                } else if (UICanvas.ra$mouseMode(UICanvas.this) == 5) {
                    Element[] selection;
                    UICanvas.ra$RELATIVE_POS().x = 0;
                    UICanvas.ra$RELATIVE_POS().y = 0;
                    ModelNode preferredNode = null;
                    if (e.isAltDown() && (selection = UICanvas.this.getUIEditor().getSelection()).length == 1 && selection[0] instanceof ModelNode) {
                        preferredNode = (ModelNode)selection[0];
                    }
                    UICanvas.wa$hitNode(UICanvas.this, (ModelNode)UICanvas.this.findContainerNode(null, UICanvas.ra$mouseDown(UICanvas.this), UICanvas.ra$RELATIVE_POS(), preferredNode));
                    if (e.isAltDown() && UICanvas.ra$hitNode(UICanvas.this) != preferredNode) {
                        preferredNode = UICanvas.ra$hitNode(UICanvas.this).getParentNode();
                        UICanvas.ra$RELATIVE_POS().x = 0;
                        UICanvas.ra$RELATIVE_POS().y = 0;
                        UICanvas.wa$hitNode(UICanvas.this, (ModelNode)UICanvas.this.findContainerNode(null, UICanvas.ra$mouseDown(UICanvas.this), UICanvas.ra$RELATIVE_POS(), preferredNode));
                    }
                    if (UICanvas.ra$hitNode(UICanvas.this) != this.effectsTarget && this.effectsTarget != null) {
                        this.updateEffects(UICanvas.ra$hitNode(UICanvas.this));
                    }
                    UICanvas.ra$WORKING_POS().x = UICanvas.ra$RELATIVE_POS().x;
                    UICanvas.ra$WORKING_POS().y = UICanvas.ra$RELATIVE_POS().y;
                    UICanvas.ra$WORKING_SIZE().width = delta.x;
                    UICanvas.ra$WORKING_SIZE().height = delta.y;
                    if (this.effectsAssistant != null) {
                        Point currentPos = new Point(UICanvas.ra$RELATIVE_POS().x + delta.x, UICanvas.ra$RELATIVE_POS().y + delta.y);
                        this.effectsAssistant.constrainAdd(UICanvas.ra$hitNode(UICanvas.this), UICanvas.ra$RELATIVE_POS(), currentPos, UICanvas.ra$WORKING_POS(), UICanvas.ra$WORKING_SIZE());
                    }
                    UIEditorController.mouseAddingNode(null, UICanvas.ra$hitNode(UICanvas.this), UICanvas.ra$WORKING_POS(), UICanvas.ra$WORKING_SIZE());
                    if (UICanvas.ra$hitNode(UICanvas.this) != null) {
                        Container cont = UICanvas.ra$hitNode(UICanvas.this).getSubcomponent().getAsContainer();
                        Point parentPos = UICanvas.this.getAbsoluteLocation(cont);
                        UICanvas.ra$WORKING_POS().x += parentPos.x;
                        UICanvas.ra$WORKING_POS().y += parentPos.y;
                        UICanvas.ra$boxEffects(UICanvas.this).show(0, UICanvas.ra$WORKING_POS(), UICanvas.ra$WORKING_SIZE(), 2);
                        UICanvas.ra$gui(UICanvas.this).repaint();
                    }
                } else if (UICanvas.ra$mouseMode(UICanvas.this) == 6) {
                    UICanvas.ra$WORKING_POS().x = UICanvas.ra$mouseDown((UICanvas)UICanvas.this).x;
                    UICanvas.ra$WORKING_POS().y = UICanvas.ra$mouseDown((UICanvas)UICanvas.this).y;
                    UICanvas.ra$WORKING_SIZE().width = delta.x;
                    UICanvas.ra$WORKING_SIZE().height = delta.y;
                    UICanvas.maS$adjustPositionForDrag(UICanvas.ra$WORKING_POS(), UICanvas.ra$WORKING_SIZE());
                    UICanvas.ra$boxEffects(UICanvas.this).show(0, UICanvas.ra$WORKING_POS(), UICanvas.ra$WORKING_SIZE(), 1);
                }
            }
        }

        public void processMouseReleased(MouseEvent e) {
            if (UICanvas.ra$rootNode(UICanvas.this) == null) {
                return;
            }
            try {
                if ((UICanvas.ra$mouseMode(UICanvas.this) == 0 || UICanvas.ra$mouseMode(UICanvas.this) == 1) && e.isPopupTrigger()) {
                    return;
                }
                if (UICanvas.ra$mouseMode(UICanvas.this) != 0) {
                    if (UICanvas.ra$mouseMode(UICanvas.this) != 1) {
                        UICanvas.ra$boxEffects(UICanvas.this).hideAll();
                    }
                    this.executeCommand(e);
                    if (UICanvas.ra$mouseMode(UICanvas.this) == 4 || UICanvas.ra$mouseMode(UICanvas.this) == 5) {
                        UIUtils.toolUsed();
                    }
                    UICanvas.wa$mouseMode(UICanvas.this, 0);
                }
            }
            finally {
                this.updateEffects(null);
            }
        }

        public void processMouseMoved(MouseEvent e) {
            if (UICanvas.ra$rootNode(UICanvas.this) == null) {
                return;
            }
            Cursor cursor = CursorManager.getInstance().getCursor();
            SelectNib nib = UICanvas.ra$selectionEffects(UICanvas.this).hitTest(e.getPoint());
            if (nib != null) {
                int cursorType = 0;
                switch (nib.type) {
                    case 0: {
                        cursorType = 6;
                        break;
                    }
                    case 1: {
                        cursorType = 7;
                        break;
                    }
                    case 2: {
                        cursorType = 4;
                        break;
                    }
                    case 3: {
                        cursorType = 5;
                        break;
                    }
                    case 4: {
                        cursorType = 8;
                        break;
                    }
                    case 5: {
                        cursorType = 10;
                        break;
                    }
                    case 6: {
                        cursorType = 11;
                        break;
                    }
                    case 7: {
                        cursorType = 9;
                        break;
                    }
                    default: {
                        cursorType = 13;
                        break;
                    }
                }
                cursor = Cursor.getPredefinedCursor(cursorType);
            }
            UICanvas.ra$gui(UICanvas.this).setCursor(cursor);
            UICanvas.ra$RELATIVE_POS().x = 0;
            UICanvas.ra$RELATIVE_POS().y = 0;
            ModelNode node = UICanvas.this.findNode(UICanvas.ra$rootNode(UICanvas.this), e.getPoint(), UICanvas.ra$RELATIVE_POS(), null);
            if (node != null) {
                UICanvas.ra$RELATIVE_POS().x = 0;
                UICanvas.ra$RELATIVE_POS().y = 0;
                if (UIUtils.getMode() == 3) {
                    Element[] selection;
                    CmtModelNode preferredNode = null;
                    if (e.isAltDown() && (selection = UICanvas.this.getUIEditor().getSelection()).length == 1 && selection[0] instanceof ModelNode) {
                        preferredNode = (CmtModelNode)selection[0];
                    }
                    CmtModelNode toNode = UICanvas.this.findContainerNode(null, e.getPoint(), UICanvas.ra$RELATIVE_POS(), preferredNode);
                    if (e.isAltDown() && toNode != preferredNode) {
                        preferredNode = (CmtModelNode)toNode.getParent();
                        UICanvas.ra$RELATIVE_POS().x = 0;
                        UICanvas.ra$RELATIVE_POS().y = 0;
                        toNode = UICanvas.this.findContainerNode(null, e.getPoint(), UICanvas.ra$RELATIVE_POS(), preferredNode);
                    }
                    UIEditorController.mouseAddingNode(null, (ModelNode)toNode, UICanvas.ra$RELATIVE_POS(), null);
                } else {
                    CmtModelNode toNode = UICanvas.this.findContainerNode(new ModelNode[]{node}, e.getPoint(), UICanvas.ra$RELATIVE_POS(), null);
                    UIEditorController.mouseMoveNode(e.isAltDown(), node == toNode ? null : node, (ModelNode)toNode, UICanvas.ra$RELATIVE_POS());
                }
            }
        }

        public void processMouseClicked(MouseEvent e) {
            if (UICanvas.ra$rootNode(UICanvas.this) == null) {
                return;
            }
            if (e.getClickCount() == 2 && !e.isMetaDown()) {
                UICanvas.wa$mouseMode(UICanvas.this, 7);
                this.executeCommand(e);
                UICanvas.wa$mouseMode(UICanvas.this, 0);
            }
        }

        protected void processMouseEntered(MouseEvent e) {
        }

        protected void processMouseExited(MouseEvent e) {
        }

        private void executeCommand(MouseEvent e) {
            if (UICanvas.ra$rootNode(UICanvas.this) == null) {
                return;
            }
            try {
                if (UICanvas.ra$mouseMode(UICanvas.this) == 2) {
                    if (UICanvas.ra$moveLocations(UICanvas.this).length > 0) {
                        UICanvas.ra$RELATIVE_POS().x = 0;
                        UICanvas.ra$RELATIVE_POS().y = 0;
                        CmtModelNode toNode = UICanvas.this.findContainerNode(UICanvas.ra$moveNodes(UICanvas.this), e.getPoint(), UICanvas.ra$RELATIVE_POS());
                        if (e.isAltDown()) {
                            CmtModelNode preferredNode = (CmtModelNode)toNode.getParent();
                            UICanvas.ra$RELATIVE_POS().x = 0;
                            UICanvas.ra$RELATIVE_POS().y = 0;
                            toNode = UICanvas.this.findContainerNode(UICanvas.ra$moveNodes(UICanvas.this), e.getPoint(), UICanvas.ra$RELATIVE_POS(), preferredNode);
                        }
                        if (toNode != this.effectsTarget && this.effectsTarget != null) {
                            this.updateEffects(toNode);
                        }
                        int i = 1;
                        while (i < UICanvas.ra$moveNodes(UICanvas.this).length) {
                            UICanvas.ra$moveLocations((UICanvas)UICanvas.this)[i].x = UICanvas.ra$moveLocations((UICanvas)UICanvas.this)[i].x - UICanvas.ra$moveLocations((UICanvas)UICanvas.this)[0].x + UICanvas.ra$RELATIVE_POS().x;
                            UICanvas.ra$moveLocations((UICanvas)UICanvas.this)[i].y = UICanvas.ra$moveLocations((UICanvas)UICanvas.this)[i].y - UICanvas.ra$moveLocations((UICanvas)UICanvas.this)[0].y + UICanvas.ra$RELATIVE_POS().y;
                            ++i;
                        }
                        UICanvas.ra$moveLocations((UICanvas)UICanvas.this)[0].x = UICanvas.ra$RELATIVE_POS().x;
                        UICanvas.ra$moveLocations((UICanvas)UICanvas.this)[0].y = UICanvas.ra$RELATIVE_POS().y;
                        UIEditorController.getInstance().moveNodes(UICanvas.this.getUIEditor(), UICanvas.ra$moveNodes(UICanvas.this), (ModelNode)toNode, UICanvas.ra$moveLocations(UICanvas.this), UICanvas.ra$hitNodeMouseOffset(UICanvas.this));
                    }
                } else if (UICanvas.ra$mouseMode(UICanvas.this) == 3) {
                    UIEditorController.getInstance().resizeNode(UICanvas.this.getUIEditor(), UICanvas.ra$hitNodeNib(UICanvas.this));
                } else if (UICanvas.ra$mouseMode(UICanvas.this) == 4 || UICanvas.ra$mouseMode(UICanvas.this) == 5) {
                    Element[] selection;
                    UICanvas.ra$RELATIVE_POS().x = 0;
                    UICanvas.ra$RELATIVE_POS().y = 0;
                    ModelNode preferredNode = null;
                    if (e.isAltDown() && (selection = UICanvas.this.getUIEditor().getSelection()).length == 1 && selection[0] instanceof ModelNode) {
                        preferredNode = (ModelNode)selection[0];
                    }
                    UICanvas.wa$hitNode(UICanvas.this, (ModelNode)UICanvas.this.findContainerNode(null, UICanvas.ra$mouseDown(UICanvas.this), UICanvas.ra$RELATIVE_POS(), preferredNode));
                    if (e.isAltDown() && UICanvas.ra$hitNode(UICanvas.this) != preferredNode) {
                        preferredNode = UICanvas.ra$hitNode(UICanvas.this).getParentNode();
                        UICanvas.ra$RELATIVE_POS().x = 0;
                        UICanvas.ra$RELATIVE_POS().y = 0;
                        UICanvas.wa$hitNode(UICanvas.this, (ModelNode)UICanvas.this.findContainerNode(null, UICanvas.ra$mouseDown(UICanvas.this), UICanvas.ra$RELATIVE_POS(), preferredNode));
                    }
                    if (UICanvas.ra$hitNode(UICanvas.this) != this.effectsTarget && this.effectsTarget != null) {
                        this.updateEffects(UICanvas.ra$hitNode(UICanvas.this));
                    }
                    Dimension delta = new Dimension(e.getX() - UICanvas.ra$mouseDown((UICanvas)UICanvas.this).x, e.getY() - UICanvas.ra$mouseDown((UICanvas)UICanvas.this).y);
                    if (UICanvas.ra$hitNode(UICanvas.this) == null) {
                        JOptionPane.showMessageDialog(this, Res.getString(18));
                        UICanvas.this.setSelectionNibs(new Element[]{UICanvas.ra$rootNode(UICanvas.this)});
                    } else {
                        UIEditorController.getInstance().addNode(UICanvas.this.getUIEditor(), UIUtils.getToolName(), UIUtils.getToolInitializer(), UIUtils.getLibraryName(), UIUtils.getTechnologyScope(), UICanvas.ra$hitNode(UICanvas.this), UICanvas.ra$RELATIVE_POS(), delta);
                    }
                } else if (UICanvas.ra$mouseMode(UICanvas.this) == 6) {
                    Element[] selection;
                    UICanvas.ra$RELATIVE_POS().x = 0;
                    UICanvas.ra$RELATIVE_POS().y = 0;
                    CmtModelNode preferredNode = null;
                    if (e.isAltDown() && (selection = UICanvas.ra$editor(UICanvas.this).getSelection()).length == 1 && selection[0] instanceof ModelNode) {
                        preferredNode = (ModelNode)selection[0];
                    }
                    ModelNode toNode = (ModelNode)UICanvas.this.findContainerNode(null, UICanvas.ra$mouseDown(UICanvas.this), UICanvas.ra$RELATIVE_POS(), preferredNode);
                    if (e.isAltDown() && toNode != preferredNode) {
                        preferredNode = (CmtModelNode)toNode.getParent();
                        UICanvas.ra$RELATIVE_POS().x = 0;
                        UICanvas.ra$RELATIVE_POS().y = 0;
                        toNode = (ModelNode)UICanvas.this.findContainerNode(null, UICanvas.ra$mouseDown(UICanvas.this), UICanvas.ra$RELATIVE_POS(), preferredNode);
                    }
                    UICanvas.ra$WORKING_POS().x = UICanvas.ra$RELATIVE_POS().x;
                    UICanvas.ra$WORKING_POS().y = UICanvas.ra$RELATIVE_POS().y;
                    UICanvas.ra$WORKING_SIZE().width = e.getX() - UICanvas.ra$mouseDown((UICanvas)UICanvas.this).x;
                    UICanvas.ra$WORKING_SIZE().height = e.getY() - UICanvas.ra$mouseDown((UICanvas)UICanvas.this).y;
                    UICanvas.maS$adjustPositionForDrag(UICanvas.ra$WORKING_POS(), UICanvas.ra$WORKING_SIZE());
                    if (toNode != null && toNode.getLiveComponent() != null) {
                        ArrayList<ModelNode> selection2 = new ArrayList<ModelNode>();
                        Rectangle rect = new Rectangle(UICanvas.ra$WORKING_POS(), UICanvas.ra$WORKING_SIZE());
                        Iterator iter = toNode.getChildren();
                        while (iter.hasNext()) {
                            Rectangle rectComponent;
                            ModelNode node;
                            Component component;
                            Object child = iter.next();
                            if (!(child instanceof ModelNode) || (component = (node = (ModelNode)child).getLiveComponent()) == null || !(rectComponent = component.getBounds()).intersects(rect) && !rect.contains(rectComponent.x, rectComponent.y)) continue;
                            selection2.add(node);
                        }
                        if (selection2.size() == 0) {
                            selection2.add(toNode);
                        }
                        UIEditor editor = UICanvas.this.getUIEditor();
                        CmtComponentSource source = editor.getComponentSource();
                        CmtSelectionModel selModel = source.getSelectionModel();
                        Object[] oldSel = selModel.getSelection();
                        Object[] result = new CmtModelNode[selection2.size()];
                        selection2.toArray(result);
                        if (Arrays.equals(oldSel, result)) {
                            UICanvas.this.setSelectionNibs((Element[])oldSel);
                        } else {
                            selModel.setSelection((CmtModelNode[])result);
                        }
                    }
                } else if (UICanvas.ra$mouseMode(UICanvas.this) == 7) {
                    UIEditorController.getInstance().generateDefaultEvent(UICanvas.this.getUIEditor());
                }
            }
            catch (Exception ex) {
                Assert.printStackTrace((Throwable)ex);
            }
        }

        private void updateEffects(CmtModelNode target) {
            this.effectsTarget = null;
            LayoutAssistant layoutAssistant = this.effectsAssistant = target != null ? UICanvas.this.getLayoutAssistant(target) : null;
            if (this.effectsAssistant != null) {
                this.effectsTarget = (ModelNode)target;
            }
        }

        final class 1
        implements ChangeListener {
            public void stateChanged(ChangeEvent e) {
                IdeSettings settings = Ide.getSettings();
                KeyStrokeOptions options = settings.getKeyStrokeOptions();
                MultiMapAdapter.fillLocalMap((MultiInputMap)GlassPane.this.multiMap, (KeyStrokeOptions)options, (KeyStrokeContext)GlassPane.this.keyStrokeContext);
            }
        }
    }

    private final class PaintTolerantPanel
    extends JPanel {
        private static final int SPACING = 25;
        private static final int SIZE = 10;
        private static final int DOUBLE_SIZE = 20;
        private static final int QUADRUPLE_SIZE = 40;

        protected void paintComponent(Graphics g) {
            if (this.isOpaque()) {
                Color user;
                Component rootComponent;
                Rectangle r = this.getBounds();
                Color color = IdeUIManager.getSelectedFocusedTabColor();
                Component component = rootComponent = UICanvas.ra$rootNode(UICanvas.this) != null ? UICanvas.ra$rootNode(UICanvas.this).getLiveComponent() : null;
                if (rootComponent != null && ((user = rootComponent.getBackground()) == color || user.equals(color))) {
                    color = SystemColor.desktop;
                }
                g.setColor(color);
                g.fillRect(0, 0, r.width, r.height);
            }
        }

        protected void paintChildren(Graphics g) {
            block3: {
                try {
                    super.paintChildren(g);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    UIEditorLogPage log = UIEditor.getErrorLog();
                    if (log == null) break block3;
                    log.clearAll();
                    log.log(Res.getString(38));
                    t.printStackTrace();
                }
            }
        }

        private PaintTolerantPanel() {
        }

        PaintTolerantPanel(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class CustomLayout
    extends XYLayout {
        public void invalidateLayout(Container container) {
            Component child;
            Component component = child = UICanvas.ra$rootNode(UICanvas.this) != null ? UICanvas.ra$rootNode(UICanvas.this).getLiveComponent() : null;
            if (child == null || child.getParent() != UICanvas.ra$contentPane(UICanvas.this)) {
                child = UICanvas.ra$lightWeightContent(UICanvas.this);
            }
            if (child != null && child.getParent() == UICanvas.ra$contentPane(UICanvas.this)) {
                this.removeLayoutComponent(child);
                this.addLayoutComponent(child, new XYConstraints(10, 10, child.getWidth(), child.getHeight()));
            }
        }

        private CustomLayout() {
        }

        CustomLayout(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

