/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.uicanvas;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.cmt.CmtComponent;
import oracle.jdeveloper.cmt.CmtComponentSource;
import oracle.jdeveloper.cmt.CmtModel;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.cmt.CmtPackages;
import oracle.jdeveloper.cmt.CmtSelectionModel;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.uieditor.AbstractCanvasController;
import oracle.jdeveloper.uieditor.ModelFactory;
import oracle.jdeveloper.uieditor.UIEditor;
import oracle.jdeveloper.uieditor.UIEditorCanvas;
import oracle.jdeveloper.uieditor.UIManager;
import oracle.jdeveloper.uieditor.uicanvas.LayoutAssistant;
import oracle.jdeveloper.uieditor.uicanvas.LayoutConstants;
import oracle.jdevimpl.uieditor.UIEditorImpl;
import oracle.jdevimpl.uieditor.uicanvas.Model;
import oracle.jdevimpl.uieditor.uicanvas.ModelNode;
import oracle.jdevimpl.uieditor.uicanvas.Res;
import oracle.jdevimpl.uieditor.uicanvas.UICanvas;

final class UIController
extends AbstractCanvasController {
    private static UIController INSTANCE;

    private UIController() {
    }

    static synchronized UIController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UIController();
        }
        return INSTANCE;
    }

    protected ModelFactory getModelFactory() {
        return UIManager.getFactory(Model.class);
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmd;
        Element[] selection;
        View view = context.getView();
        UIEditorCanvas canvas = null;
        LayoutAssistant assistant = null;
        if (view instanceof UIEditor && (canvas = ((UIEditor)view).getActiveCanvas()) instanceof UICanvas && (selection = context.getSelection()) != null && selection.length > 0 && selection[0] instanceof CmtModelNode) {
            assistant = ((UICanvas)canvas).getLayoutAssistant((CmtModelNode)((CmtModelNode)selection[0]).getParent());
        }
        int n = cmd = action != null ? action.getCommandId() : -1;
        if (assistant != null && assistant.handleEvent(action, context)) {
            return true;
        }
        if (cmd == LayoutConstants.NEXT_CMD_ID) {
            this.selectNext(context, false);
            return true;
        }
        if (cmd == LayoutConstants.PREV_CMD_ID) {
            this.selectNext(context, true);
            return true;
        }
        if (cmd == LayoutConstants.BUILD_CMD_ID) {
            try {
                CmtComponentSource comp = ((UIEditor)view).getComponentSource();
                if (comp != null) {
                    comp.buildDependencies();
                }
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
            return true;
        }
        if (cmd == LayoutConstants.DRILL_CMD_ID) {
            try {
                URL url;
                CmtModelNode node = (CmtModelNode)context.getSelection()[0];
                CmtSubcomponent sub = node.getSubcomponent();
                CmtComponent comp = sub != null ? sub.getComponent() : null;
                CmtPackages mgr = comp.getComponents().getPackages();
                SourceClass clazz = mgr.getSourceClass(sub.getComponentType().getQualifiedName());
                SourceFile jFile = clazz != null ? clazz.getOwningSourceFile() : null;
                URL uRL = url = jFile != null ? jFile.getURL() : null;
                if (url != null) {
                    Context drillContext = Context.newIdeContext((Node)NodeFactory.find((URL)url));
                    drillContext.setProject(mgr.getProject());
                    EditorUtil.openExplicitEditorInFrame(UIEditorImpl.class, (Context)drillContext);
                }
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmd;
        Element[] selection;
        View view = context.getView();
        UIEditorCanvas canvas = null;
        LayoutAssistant assistant = null;
        if (view instanceof UIEditor) {
            canvas = ((UIEditor)view).getActiveCanvas();
        } else if (view instanceof UIEditorCanvas) {
            canvas = (UIEditorCanvas)view;
        }
        if (canvas instanceof UICanvas && (selection = context.getSelection()) != null && selection.length > 0 && selection[0] instanceof CmtModelNode) {
            assistant = ((UICanvas)canvas).getLayoutAssistant((CmtModelNode)((CmtModelNode)selection[0]).getParent());
        }
        int n = cmd = action != null ? action.getCommandId() : -1;
        if (assistant != null && assistant.update(action, context)) {
            return true;
        }
        if (cmd == LayoutConstants.NEXT_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmd == LayoutConstants.PREV_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmd == LayoutConstants.BUILD_CMD_ID) {
            Element[] selection2 = context != null ? context.getSelection() : null;
            ModelNode anchor = null;
            if (selection2 != null && selection2.length > 0 && selection2[0] instanceof ModelNode) {
                anchor = (ModelNode)selection2[0];
            }
            CmtSubcomponent sub = anchor != null ? anchor.getSubcomponent() : null;
            CmtComponent comp = sub != null ? sub.getOuterComponent() : null;
            action.setEnabled(comp instanceof CmtComponentSource && ((CmtComponentSource)comp).hasDependencies());
            return true;
        }
        if (cmd == LayoutConstants.DRILL_CMD_ID) {
            SourceClass srcCls;
            Element[] selection3 = context != null ? context.getSelection() : null;
            ModelNode anchor = null;
            if (selection3 != null && selection3.length > 0 && selection3[0] instanceof ModelNode) {
                anchor = (ModelNode)selection3[0];
            }
            CmtSubcomponent sub = anchor != null ? anchor.getSubcomponent() : null;
            JavaClass cls = sub != null ? sub.getComponentType() : null;
            String name = cls != null ? cls.getQualifiedName() : null;
            CmtPackages pkgs = name != null ? sub.getOuterComponent().getComponents().getPackages() : null;
            SourceClass sourceClass = srcCls = pkgs != null ? pkgs.getSourceClass(name) : null;
            if (srcCls != null) {
                SourceFile jFile = srcCls.getOwningSourceFile();
                URL url = jFile != null ? jFile.getURL() : null;
                Node node = url != null ? NodeFactory.find((URL)url) : null;
                String caption = Res.format(40, node != null ? node.getShortLabel() : "---");
                action.putValue("Name", (Object)caption);
            }
            CmtComponent comp = sub != null ? sub.getOuterComponent() : null;
            action.setEnabled(comp instanceof CmtComponentSource && ((CmtComponentSource)comp).isDependency(sub));
            return true;
        }
        return false;
    }

    private void selectNext(Context context, boolean isReverse) {
        UIEditor editor;
        View view = context != null ? context.getView() : null;
        UIEditor uIEditor = editor = view instanceof UIEditor ? (UIEditor)view : null;
        if (editor == null) {
            return;
        }
        UICanvas canvas = (UICanvas)editor.getActiveCanvas();
        CmtModel model = canvas != null ? canvas.getModel() : null;
        CmtModelNode node = model != null ? model.getRoot() : null;
        Element[] selection = editor.getSelection();
        int i = 0;
        while (i < selection.length) {
            if (selection[i] instanceof ModelNode) {
                node = (CmtModelNode)selection[i];
                break;
            }
            ++i;
        }
        int index = -1;
        ArrayList list = new ArrayList();
        UIController.flatList(model != null ? model.getRoot() : null, list);
        index = node != null ? list.indexOf(node) : -1;
        int size = list.size();
        if (!isReverse) {
            if (++index >= size) {
                index = size > 0 ? 0 : -1;
            }
        } else if (--index < 0) {
            index = size > 0 ? list.size() - 1 : -1;
        }
        CmtModelNode cmtModelNode = node = index >= 0 ? (CmtModelNode)list.get(index) : null;
        if (node != null) {
            CmtComponentSource source = editor.getComponentSource();
            CmtSelectionModel selModel = source.getSelectionModel();
            selModel.setSelection(new CmtModelNode[]{node});
        }
    }

    private static void flatList(CmtModelNode node, ArrayList nodes) {
        if (node instanceof ModelNode) {
            nodes.add(node);
            Iterator i = node.getChildren();
            if (i != null) {
                while (i.hasNext()) {
                    Object child = i.next();
                    if (!(child instanceof ModelNode)) continue;
                    UIController.flatList((CmtModelNode)child, nodes);
                }
            }
        }
    }
}

