/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.uicanvas;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import oracle.jdeveloper.layout.XYConstraints;
import oracle.jdeveloper.uieditor.uicanvas.SelectNib;
import oracle.jdeveloper.uieditor.uicanvas.SelectionEffects;
import oracle.jdevimpl.uieditor.uicanvas.UICanvas;

public final class UISelectionEffects
implements SelectionEffects {
    private UICanvas canvas;
    private ArrayList selectNibs;

    private void $init$() {
        this.selectNibs = new ArrayList();
    }

    UISelectionEffects(UICanvas canvas) {
        this.$init$();
        this.canvas = canvas;
    }

    public SelectNib[] getSelectNibs(int count) {
        int size = this.selectNibs.size();
        if (count > size) {
            XYConstraints constraints = new XYConstraints();
            Container contentPane = this.canvas.getContentPane();
            int i = count - size;
            while (i > 0) {
                SelectNib nib = new SelectNib();
                contentPane.add(nib, constraints, 0);
                this.selectNibs.add(nib);
                --i;
            }
        }
        SelectNib[] nibs = new SelectNib[count];
        int i = 0;
        while (i < count) {
            nibs[i] = (SelectNib)this.selectNibs.get(i);
            nibs[i].initialize();
            ++i;
        }
        return nibs;
    }

    public void moveNib(SelectNib nib, int x, int y) {
        if (nib != null) {
            this.canvas.getContentPane().add(nib, new XYConstraints(x, y, -1, -1), 0);
        }
    }

    public boolean areVisible() {
        int i = this.selectNibs.size() - 1;
        while (i >= 0) {
            if (((SelectNib)this.selectNibs.get(i)).isVisible()) {
                return true;
            }
            --i;
        }
        return false;
    }

    public void hideAll() {
        int i = this.selectNibs.size() - 1;
        while (i >= 0) {
            ((SelectNib)this.selectNibs.get(i)).setVisible(false);
            --i;
        }
    }

    public oracle.jdeveloper.uieditor.uicanvas.UICanvas getUICanvas() {
        return this.canvas;
    }

    public SelectNib hitTest(Point test) {
        int i = this.selectNibs.size() - 1;
        while (i >= 0) {
            SelectNib nib = (SelectNib)this.selectNibs.get(i);
            if (nib != null && nib.isVisible()) {
                Point hit = nib.getLocation();
                if (test.x >= hit.x && test.y >= hit.y) {
                    Dimension size = nib.getSize();
                    if (test.x < hit.x + size.width && test.y < hit.y + size.height) {
                        if (nib.isSelectable()) {
                            return nib;
                        }
                        return null;
                    }
                }
            }
            --i;
        }
        return null;
    }
}

