/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.uicanvas.dnd;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.view.View;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.ExtendedTransferable;
import oracle.javatools.datatransfer.TransferUtils;
import oracle.javatools.dnd.DndUtils;
import oracle.jdeveloper.cmt.CmtModel;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.uieditor.UIEditor;
import oracle.jdeveloper.uieditor.UIManager;
import oracle.jdeveloper.uieditor.datatransfer.DataAndPositions;
import oracle.jdeveloper.uieditor.datatransfer.Operation;
import oracle.jdeveloper.uieditor.datatransfer.OperationProcessor;
import oracle.jdeveloper.uieditor.datatransfer.UIPosition;
import oracle.jdeveloper.uieditor.dnd.DropMenuInvoker;
import oracle.jdevimpl.uieditor.uicanvas.ModelNode;
import oracle.jdevimpl.uieditor.uicanvas.UICanvas;

public class ModelDropHandler
implements DropTargetListener {
    private transient OperationProcessor _processor;
    private transient Component _dropComponent;
    private transient Point _dropPoint;
    private final int _actionsSupported;
    private final UICanvas _gui;
    private transient Boolean _isPopupDrop;
    private static final Logger _LOGGER = Logger.getLogger(ModelDropHandler.class.getName());

    public ModelDropHandler(UICanvas gui, int actionsSupported) {
        if (gui == null) {
            throw new IllegalArgumentException("No UICanvas specified");
        }
        this._gui = gui;
        this._actionsSupported = actionsSupported;
    }

    public final UICanvas getGui() {
        return this._gui;
    }

    public final UIEditor getView() {
        return this._gui.getUIEditor();
    }

    public final CmtModel getModel() {
        return this.getGui().getModel();
    }

    public void dragEnter(DropTargetDragEvent event) {
        this._considerPossibilitiesAndAcceptOrReject(event);
    }

    public void dragOver(DropTargetDragEvent event) {
        this.dropStartedHook();
        this._considerPossibilitiesAndAcceptOrReject(event);
    }

    public void dropActionChanged(DropTargetDragEvent event) {
        this._considerPossibilitiesAndAcceptOrReject(event);
    }

    public void dragExit(DropTargetEvent event) {
        this._cleanupDrop();
    }

    public void drop(DropTargetDropEvent dropEvent) {
        Context ctx = this.getGui().getContext();
        Project prj = ctx.getProject();
        1 task = new 1(this, dropEvent);
        prj.applyBatchChanges((Runnable)task);
    }

    protected void findOtherClosePositions(Component dropComponent, Point location, UIPosition closestPosition, List out) {
        Point relative = new Point(0, 0);
        CmtModelNode node = this.getGui().findContainerNode(null, location, relative, null);
        if (node != null) {
            UIPosition pos = new UIPosition(relative, node);
            if (out != null && !out.contains(pos)) {
                out.add(pos);
            }
        }
    }

    protected UIPosition getClosestDropPosition(Component dropComponent, Point location) {
        Point relative = new Point(0, 0);
        ModelNode node = null;
        if (this.getModel() != null) {
            node = (ModelNode)this.getModel().getRoot();
        }
        return (node = this.getGui().findNode(node, location, relative, null)) != null ? new UIPosition(relative, node) : null;
    }

    public int getActionsSupported() {
        return this._actionsSupported;
    }

    protected void dropStartedHook() {
    }

    protected void dropStoppedHook() {
    }

    private void _doPopupDrop(DropTargetDropEvent dropEvent) {
        int action = this._considerPossibilities(dropEvent);
        if (action > 0) {
            dropEvent.rejectDrop();
            this._cleanupDrop();
        } else {
            this._showPopupMenu(dropEvent);
        }
    }

    private void _showPopupMenu(DropTargetDropEvent dropEvent) {
        dropEvent.acceptDrop(1);
        if (!dropEvent.isLocalTransfer()) {
            _LOGGER.fine("Prefetching before popup drop since it's ! local");
            Transferable nowTrans = dropEvent.getTransferable();
            AugmentableTransferable prefetched = TransferUtils.prefetchTransferableContents((Transferable)nowTrans);
            UIManager.setDropTransferable((Transferable)prefetched);
            this._processor.setTransferable(this._currentTransferable());
            int action = this._considerPossibilities(dropEvent);
            if (action <= 0) {
                _LOGGER.log(Level.FINE, "Odd, action<=0 after prefetching for popup drop; action was > 0 before! prefetched={0}", prefetched);
            }
        }
        new DropMenuInvoker(dropEvent, this.getModel(), this._processor, new 2(this, dropEvent)).invoke();
    }

    private void _doRegularDrop(DropTargetDropEvent dropEvent) {
        block16: {
            try {
                int dropAction = dropEvent.getDropAction();
                int action = this._considerPossibilities(dropEvent);
                if (_LOGGER.isLoggable(Level.FINE)) {
                    _LOGGER.log(Level.FINE, "non-popup drop: proposed action={0} action={1} options={2}", new Object[]{this._getActionText(action), this._getActionText(dropAction), this._processor});
                }
                if (action <= 0) {
                    dropEvent.rejectDrop();
                    break block16;
                }
                boolean showMenu = false;
                Iterator itor = this._processor.getSupportedOperations();
                Operation firstOp = (Operation)itor.next();
                if (itor.hasNext()) {
                    Operation nextOp = (Operation)itor.next();
                    if (firstOp.getSuitabilityRank() == nextOp.getSuitabilityRank()) {
                        showMenu = true;
                    }
                }
                if (!showMenu) {
                    List dataAndPosList = this._processor.getListOfDataAndPositions(firstOp);
                    DataAndPositions firstDataAndPos = (DataAndPositions)dataAndPosList.get(0);
                    if (dataAndPosList.size() > 1) {
                        DataAndPositions secondDataAndPos = (DataAndPositions)dataAndPosList.get(0);
                        boolean bl = showMenu = firstDataAndPos.getData().getSuitabilityRank() == secondDataAndPos.getData().getSuitabilityRank();
                    }
                    if (!showMenu) {
                        dropEvent.acceptDrop(action);
                        boolean dropOK = false;
                        try {
                            try {
                                dropOK = this._processor.forceSimpleApply();
                            }
                            catch (IOException e) {
                                _LOGGER.log(Level.WARNING, "exception in drop", e);
                            }
                        }
                        finally {
                            dropEvent.dropComplete(dropOK);
                            this._cleanupDrop();
                        }
                    }
                }
                if (showMenu) {
                    this._showPopupMenu(dropEvent);
                }
            }
            finally {
                this._cleanupDrop();
            }
        }
    }

    private String _getActionText(int dropAction) {
        if (dropAction == 1) {
            return "COPY";
        }
        if (dropAction == 2) {
            return "MOVE";
        }
        if (dropAction == 0x40000000) {
            return "LINK";
        }
        if (dropAction == 0) {
            return "NONE";
        }
        return "?" + dropAction + "?";
    }

    private void _considerPossibilitiesAndAcceptOrReject(DropTargetDragEvent event) {
        int action = this._considerPossibilities(event, event.getLocation(), event.getSourceActions(), event.getDropAction());
        UIPosition dropPos = this._processor.getRepresentativeOperationPosition();
        if (action > 0) {
            if (_LOGGER.isLoggable(Level.FINER)) {
                _LOGGER.log(Level.FINER, "Accepting drag with action {0}; pos={1}", new Object[]{this._getActionText(action), dropPos});
            }
            event.acceptDrag(event.getDropAction());
        } else {
            _LOGGER.finer("Rejecting drag!");
            event.rejectDrag();
        }
    }

    private int _considerPossibilities(DropTargetDropEvent event) {
        return this._considerPossibilities(event, event.getLocation(), event.getSourceActions(), event.getDropAction());
    }

    private int _considerPossibilities(DropTargetEvent event, Point location, int sourceActions, int proposedDropAction) {
        this._setCurrentTransferableIfNeeded(event);
        ExtendedTransferable transferable = this._currentTransferable();
        if (this._processor == null) {
            this._processor = new OperationProcessor((View)this.getView());
        }
        this._processor.setTransferable(transferable);
        this._processor.setEditable(this.getView().getComponentSource().isReadOnly() ^ true);
        Component dropComponent = event.getDropTargetContext().getComponent();
        Point adjustedLocation = SwingUtilities.convertPoint(dropComponent, location.x, location.y, this._gui.getContentPane());
        UIPosition initialPosition = this.getClosestDropPosition(dropComponent, location);
        LinkedList<UIPosition> closePositions = new LinkedList<UIPosition>();
        if (initialPosition != null) {
            closePositions.add(initialPosition);
        }
        this.findOtherClosePositions(dropComponent, location, initialPosition, closePositions);
        if (this._isPopupDrop(event)) {
            this._updateProcessor(-1, closePositions);
            if (this._processor.hasSupportedOperation()) {
                int n = 1;
                return n;
            }
            int n = 0;
            return n;
        }
        int x = this._updateProcessor(proposedDropAction, closePositions);
        if (x > 0) {
            int n = x;
            return n;
        }
        sourceActions &= ~proposedDropAction;
        int[] tries = new int[]{2, 1, 0x40000000};
        int i = 0;
        while (i < tries.length) {
            int curTry = tries[i];
            if ((sourceActions & curTry) > 0 && (x = this._updateProcessor(curTry, closePositions)) > 0) {
                int n = x;
                return n;
            }
            ++i;
        }
        int n = 0;
        return n;
    }

    private int _updateProcessor(int actionMask, List positions) {
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "UpdateProcessor: positions={0} actionMask={1}", new Object[]{positions, String.valueOf(actionMask)});
        }
        this._processor.setActionMask(actionMask);
        this._processor.update(positions);
        if (this._processor.hasSupportedOperation()) {
            return actionMask;
        }
        return 0;
    }

    private ExtendedTransferable _currentTransferable() {
        return UIManager.getDropTransferable();
    }

    private void _cleanupDrop() {
        UIManager.setDropTransferable(null);
        this._dropComponent = null;
        this._dropPoint = null;
        this._isPopupDrop = null;
        this._processor = null;
        this.dropStoppedHook();
    }

    private void _setCurrentTransferableIfNeeded(DropTargetEvent event) {
        if (this._currentTransferable() == null) {
            UIManager.setDropTransferable(DndUtils.getTransferable((DropTargetEvent)event));
        }
    }

    private boolean _isPopupDrop(DropTargetEvent dropEvent) {
        if (this._isPopupDrop == null) {
            InputEvent triggerEvent = DndUtils.getTriggerEvent((Transferable)this._currentTransferable());
            if (triggerEvent instanceof MouseEvent) {
                JComponent dropComponent = (JComponent)dropEvent.getDropTargetContext().getComponent();
                Point dropPoint = null;
                if (dropEvent instanceof DropTargetDragEvent) {
                    dropPoint = ((DropTargetDragEvent)dropEvent).getLocation();
                } else if (dropEvent instanceof DropTargetDropEvent) {
                    dropPoint = ((DropTargetDropEvent)dropEvent).getLocation();
                }
                JPopupMenu dummyMenu = new JPopupMenu();
                MouseEvent convertedTrigger = (MouseEvent)triggerEvent;
                convertedTrigger = new MouseEvent(dropComponent, 502, System.currentTimeMillis(), convertedTrigger.getModifiers(), dropPoint.x, dropPoint.y, convertedTrigger.getClickCount(), convertedTrigger.isPopupTrigger(), convertedTrigger.getButton());
                this._isPopupDrop = dummyMenu.isPopupTrigger(convertedTrigger) ? Boolean.TRUE : Boolean.FALSE;
            } else {
                this._isPopupDrop = Boolean.FALSE;
            }
        }
        return this._isPopupDrop;
    }

    static void mav$_cleanupDrop(ModelDropHandler modelDropHandler) {
        modelDropHandler._cleanupDrop();
    }

    static boolean mav$_isPopupDrop(ModelDropHandler modelDropHandler, DropTargetEvent dropTargetEvent) {
        return modelDropHandler._isPopupDrop(dropTargetEvent);
    }

    static void mav$_doPopupDrop(ModelDropHandler modelDropHandler, DropTargetDropEvent dropTargetDropEvent) {
        modelDropHandler._doPopupDrop(dropTargetDropEvent);
    }

    static void mav$_doRegularDrop(ModelDropHandler modelDropHandler, DropTargetDropEvent dropTargetDropEvent) {
        modelDropHandler._doRegularDrop(dropTargetDropEvent);
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ DropTargetDropEvent v$dropEvent;
        final /* synthetic */ ModelDropHandler this$0;

        public void run() {
            if (ModelDropHandler.mav$_isPopupDrop(this.this$0, this.v$dropEvent)) {
                ModelDropHandler.mav$_doPopupDrop(this.this$0, this.v$dropEvent);
            } else {
                ModelDropHandler.mav$_doRegularDrop(this.this$0, this.v$dropEvent);
            }
        }

        public 1(ModelDropHandler modelDropHandler, DropTargetDropEvent dropTargetDropEvent) {
            this.v$dropEvent = dropTargetDropEvent;
            this.this$0 = modelDropHandler;
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ DropTargetDropEvent v$dropEvent;
        final /* synthetic */ ModelDropHandler this$0;

        public void run() {
            this.v$dropEvent.dropComplete(true);
            ModelDropHandler.mav$_cleanupDrop(this.this$0);
        }

        public 2(ModelDropHandler modelDropHandler, DropTargetDropEvent dropTargetDropEvent) {
            this.v$dropEvent = dropTargetDropEvent;
            this.this$0 = modelDropHandler;
        }
    }
}

