/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.javabean;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLComparator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLPath;
import oracle.javatools.util.Copyable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanPath
extends URLPath
implements Copyable {
    public static int NO_FILTER = 0;
    public static int USE_MANIFEST = 1;
    public static int USE_BEANINFO = 2;
    private int _filter;

    public JavaBeanPath(URLPath urlPath) {
        super(urlPath);
    }

    public Object copyTo(Object target) {
        return super.copyTo(target);
    }

    public List getFiles(String relPath) {
        ArrayList<URL> fileList = new ArrayList<URL>();
        URL[] entries = this.getEntries();
        int i = 0;
        while (i < entries.length) {
            URL entry = URLFactory.newURL((URL)entries[i], (String)relPath);
            URLFileSystemHelper helper = URLFileSystem.findHelper((URL)entry);
            URL[] urls = helper.list(entry);
            if (urls != null) {
                int j = 0;
                while (j < urls.length) {
                    URL newURL = urls[j];
                    if (helper.isRegularFile(newURL)) {
                        try {
                            if (this.getFilter() == USE_MANIFEST) {
                                this._useManifest(newURL, fileList);
                            } else if (this.getFilter() == USE_BEANINFO) {
                                this._useBeanInfo(entries[i], newURL, fileList);
                            } else {
                                fileList.add(newURL);
                            }
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        Collections.sort(fileList, new URLComparator());
        return fileList;
    }

    private List _useManifest(URL newURL, ArrayList fileList) throws Exception {
        Manifest manifest;
        Attributes attributes;
        URL manifestURL;
        if (JarUtil.isJarURL((URL)newURL) && URLFileSystem.exists((URL)(manifestURL = URLFactory.newJarURL((URL)JarUtil.getJarFileURL((URL)newURL), (String)"META-INF/MANIFEST.MF"))) && (attributes = (manifest = new Manifest(manifestURL.openStream())).getAttributes(JarUtil.getJarEntry((URL)newURL))) != null && attributes.containsKey("Java-Bean") && attributes.getValue("Java-Bean").equals("True")) {
            fileList.add(newURL);
        }
        return fileList;
    }

    private List _useBeanInfo(URL entry, URL newURL, ArrayList fileList) throws Exception {
        String fullName = "";
        fullName = JarUtil.isJarURL((URL)newURL) ? JarUtil.getJarEntry((URL)newURL) : newURL.toString().substring(entry.toString().length());
        fullName = fullName.substring(0, fullName.length() - 6);
        String beanInfo = fullName + "BeanInfo.class";
        URL[] entries = this.getEntries();
        int i = 0;
        while (i < entries.length) {
            URL url = entries[i];
            URL u = URLFactory.newURL((URL)url, (String)beanInfo);
            boolean exists = URLFileSystem.isBound((URL)u);
            if (exists) {
                fileList.add(newURL);
            }
            ++i;
        }
        return fileList;
    }

    public void setFilter(int filter) {
        this._filter = filter;
    }

    public int getFilter() {
        return this._filter;
    }
}

