/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.javabean;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.PackageClassChooser;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.palette.Palette;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PaletteManager;
import oracle.ide.palette.PalettePage;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.palette.wizard.PaletteWizard;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdevimpl.resource.WizardsArb;
import oracle.jdevimpl.wizard.javabean.JavaBeanPath;

public class JavaBeanWizardPanel
extends JPanel
implements PaletteWizard,
ActionListener,
TreeSelectionListener {
    private JEWTDialog _dlg;
    private final ButtonGroup _buttonGroup;
    private PaletteManager pm;
    private Palette palette;
    private Vector _libraryModel;
    private String[] _filters;
    private JLabel _selectLbl;
    private JLabel _libraryLbl;
    private JComboBox _libraryBox;
    private JLabel _filterLbl;
    private JComboBox _filterBox;
    private JPanel _panel;
    private JButton _selectImageBtn;
    private JButton _defaultBtn;
    private JLabel _previewLbl;
    private JTextField _iconFld;
    private JLabel _iconLbl;
    private String _defaultIcon;
    private String _iconStr;
    private URLChooser _urlChooser;
    JLabel _previewFld;
    private JTree _tree;
    private String[] _selection;
    private PackageClassChooser _componentPanel;
    GridBagLayout gridBagLayout1;
    private ImageIcon _defaultImageIcon;

    private void $init$() {
        this._buttonGroup = new ButtonGroup();
        this.pm = PaletteManager.getPaletteManager();
        this.palette = this.pm.getPalette();
        this._libraryModel = new Vector();
        this._filters = new String[]{WizardsArb.getString(105), WizardsArb.getString(183), WizardsArb.getString(411)};
        this._selectLbl = new JLabel();
        this._libraryLbl = new JLabel();
        this._libraryBox = new JComboBox(this._libraryModel);
        this._filterLbl = new JLabel();
        this._filterBox = new JComboBox<String>(this._filters);
        this._panel = new JPanel();
        this._selectImageBtn = new JButton();
        this._defaultBtn = new JButton();
        this._previewLbl = new JLabel();
        this._iconFld = new JTextField();
        this._iconLbl = new JLabel();
        this._defaultIcon = "/oracle/ideimpl/icons/images/palette/appwr.gif";
        this._iconStr = "oracle/ideimpl/icons/images/palette/appwr.gif";
        this._previewFld = new JLabel();
        this.gridBagLayout1 = new GridBagLayout();
    }

    public JavaBeanWizardPanel(Context context) {
        this.$init$();
        try {
            this.jbInit();
            this._urlChooser = DialogUtil.newURLChooser((Context)context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        ClassLoader cl = this.getClass().getClassLoader();
        this._defaultImageIcon = new ImageIcon(cl.getResource(this._iconStr));
        JLabel comp = new JLabel(WizardsArb.getString(10));
        ResourceUtils.resButton((AbstractButton)this._selectImageBtn, (String)WizardsArb.getString(95));
        ResourceUtils.resButton((AbstractButton)this._defaultBtn, (String)WizardsArb.getString(444));
        ResourceUtils.resLabel((JLabel)this._iconLbl, (Component)this._iconFld, (String)WizardsArb.getString(295));
        ResourceUtils.resLabel((JLabel)this._libraryLbl, (Component)this._libraryBox, (String)WizardsArb.getString(225));
        ResourceUtils.resLabel((JLabel)this._filterLbl, (Component)this._filterBox, (String)WizardsArb.getString(147));
        ResourceUtils.resLabel((JLabel)comp, (Component)this._componentPanel, (String)WizardsArb.getString(10));
        this.setLayout(this.gridBagLayout1);
        this.setPreferredSize(new Dimension(450, 400));
        this._panel.setLayout(new BorderLayout());
        this._selectImageBtn.addActionListener(this);
        this._defaultBtn.addActionListener(this);
        this._previewLbl.setText(WizardsArb.getString(383));
        this.add((Component)this._selectLbl, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 8, 8), 0, 0));
        this.add((Component)this._libraryLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 8, 8), 0, 0));
        this.add((Component)this._libraryBox, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 8, 0), 0, 0));
        this.add((Component)comp, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 8), 0, 0));
        this.add((Component)this._panel, new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 8, 0), 0, 0));
        this.add((Component)this._filterLbl, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 8, 8), 0, 0));
        this.add((Component)this._filterBox, new GridBagConstraints(1, 4, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 8, 0), 0, 0));
        this.add((Component)this._iconLbl, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 8), 0, 0));
        this.add((Component)this._iconFld, new GridBagConstraints(1, 5, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 8, 0), 0, 0));
        this.add((Component)this._previewLbl, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 8), 0, 0));
        this.add((Component)this._previewFld, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._defaultBtn, new GridBagConstraints(2, 6, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 8), 0, 0));
        this.add((Component)this._selectImageBtn, new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.populateLibraryList();
        this._defaultBtn.addActionListener(this);
        this._iconFld.setEditable(false);
    }

    private void populateLibraryList() {
        Iterator iter = JLibraryManager.getLibraries().iterator();
        ArrayList<String> stringNames = new ArrayList<String>();
        while (iter.hasNext()) {
            String libraryName = ((JLibrary)iter.next()).getName();
            stringNames.add(libraryName);
        }
        stringNames.add("Swing and AWT");
        Collections.sort(stringNames);
        Iterator libIter = stringNames.iterator();
        while (libIter.hasNext()) {
            this._libraryModel.add((String)libIter.next());
        }
        this._libraryBox.addActionListener(this);
        this._filterBox.addActionListener(this);
        this._libraryBox.setSelectedIndex(0);
        this._defaultBtn.setEnabled(false);
        this._selectImageBtn.setEnabled(false);
    }

    public Component getGUI() {
        return this;
    }

    public Icon getIcon() {
        return null;
    }

    public String getType() {
        return "java";
    }

    public String getTitle() {
        return WizardsArb.getString(283);
    }

    public String getSelectedLibrary() {
        return (String)this._libraryBox.getSelectedItem();
    }

    private void addItem(String libraryName, String selection) {
        int period;
        PalettePage page = this.palette.getEditPage();
        String beanInfo = "";
        try {
            Class<?> newClass = Class.forName(selection);
            BeanInfo info = Introspector.getBeanInfo(newClass);
            ImageIcon icon = new ImageIcon(info.getIcon(1));
            if (icon != null) {
                beanInfo = "1";
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        String shortLabel = (period = selection.lastIndexOf(".")) > 0 ? selection.substring(period + 1) : selection;
        page.addPaletteItem("/oracle/ideimpl/icons/images/palette/appwr.gif", "", true, selection, shortLabel, "JavaBean", "", libraryName);
        PaletteItem pi = page.getPaletteItem(shortLabel);
        pi.setItemBeanInfo(beanInfo);
    }

    public void actionPerformed(ActionEvent e) {
        JComponent comp = (JComponent)e.getSource();
        if (comp == this._libraryBox || comp == this._filterBox) {
            this.showClassPanel();
        } else if (comp == this._defaultBtn) {
            this._iconFld.setText(this._defaultIcon);
            this._previewFld.setIcon(this._defaultImageIcon);
        } else if (comp == this._selectImageBtn) {
            this.changeImage();
        }
    }

    private void showClassPanel() {
        URLPath urlPath = null;
        JLibrary library = null;
        if (this.getSelectedLibrary().equals("Swing and AWT")) {
            urlPath = JLibraryManager.getDefaultJDK().getClassPath();
            URL binDir = URLFileSystem.getParent((URL)JLibraryManager.getDefaultJDK().getSDKBinDir());
            URL url = URLFactory.newURL((URL)binDir, (String)"lib/dt.jar");
            URL dtURL = URLFactory.newJarURL((URL)url, (String)"");
            urlPath.add(dtURL);
        } else {
            library = JLibraryManager.findLibrary((Object)this.getSelectedLibrary());
        }
        if (library != null) {
            urlPath = library.getDefaultClassPath();
        }
        JavaBeanPath jbPath = new JavaBeanPath(urlPath);
        String filter = (String)this._filterBox.getSelectedItem();
        if (filter.equals(WizardsArb.getString(105))) {
            jbPath.setFilter(JavaBeanPath.NO_FILTER);
        } else if (filter.equals(WizardsArb.getString(411))) {
            jbPath.setFilter(JavaBeanPath.USE_MANIFEST);
        } else {
            jbPath.setFilter(JavaBeanPath.USE_BEANINFO);
        }
        this._componentPanel = new PackageClassChooser(1, (URLPath)jbPath);
        this._tree = this._componentPanel.getTree();
        this._panel.removeAll();
        this._panel.add((Component)this._componentPanel, "Center");
        this._panel.validate();
        this._panel.repaint();
        this._tree.getSelectionModel().setSelectionMode(4);
        this._tree.addTreeSelectionListener(this);
        this._iconFld.setText("");
        this._previewFld.setIcon(null);
    }

    private void changeImage() {
        this._urlChooser.setURLFilter((URLFilter)new DefaultURLFilter("Image File", GraphicsUtils.getImageExtensions()));
        this._urlChooser.setSelectionScope(0);
        this._urlChooser.showOpenDialog((Component)Ide.getMainWindow());
        URL[] selectedURLs = this._urlChooser.getSelectedURLs();
        if (selectedURLs.length > 0) {
            URL selectedURL = this._urlChooser.getSelectedURL();
            this._iconFld.setText(selectedURL.getPath());
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = toolkit.getImage(selectedURL);
            if (image != null) {
                this._previewFld.setIcon(new ImageIcon(image));
            }
        }
    }

    private void setImage(String classname) {
        boolean hasBeanInfo = false;
        try {
            Class<?> newClass = Class.forName(classname);
            BeanInfo info = Introspector.getBeanInfo(newClass);
            ImageIcon icon = new ImageIcon(info.getIcon(1));
            if (icon != null) {
                this._previewFld.setIcon(icon);
                this._iconFld.setText("Use BeanInfo Image");
                hasBeanInfo = true;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (!hasBeanInfo) {
            URL url = this.getClass().getResource(this._defaultIcon);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = toolkit.getImage(url);
            if (image != null) {
                this._previewFld.setIcon(new ImageIcon(image));
                this._iconFld.setText(this._defaultIcon);
            }
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this._tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        if (node.isLeaf()) {
            if (!node.isRoot()) {
                String[] selections = this._componentPanel.getSelections();
                this.setSelection(selections);
                String firstSelection = selections[0];
                this.setImage(firstSelection);
                this._selectImageBtn.setEnabled(true);
                this._defaultBtn.setEnabled(true);
            }
        } else {
            this.setSelection(null);
            this._iconFld.setText("");
            this._previewFld.setIcon(null);
            this._defaultBtn.setEnabled(false);
            this._selectImageBtn.setEnabled(false);
        }
    }

    public void setSelection(String[] s) {
        this._selection = s;
    }

    public String[] getSelection() {
        return this._selection;
    }

    public String getImageName() {
        return this._iconFld.getText();
    }
}

