/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.project;

import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.resource.GalleryArb;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardManager;
import oracle.javatools.data.PropertyStorage;
import oracle.jdevimpl.resource.WizardsArb;
import oracle.jdevimpl.wizard.project.ProjectWizardLauncher;

public class NewApplicationProjectWizard
extends Wizard {
    private Icon _icon;

    public String getShortLabel() {
        return GalleryArb.getString((int)100);
    }

    private String getTitle() {
        return WizardsArb.getString(49);
    }

    public String getLongLabel() {
        return GalleryArb.getString((int)158);
    }

    public boolean isAvailable(Context context) {
        return context != null && context.getWorkspace() != null;
    }

    public Icon getIcon() {
        if (this._icon == null) {
            this._icon = WizardsArb.getIcon(114);
        }
        return this._icon;
    }

    public boolean invoke(Context context) {
        boolean result = false;
        ProjectWizardLauncher launcher = new ProjectWizardLauncher(context, this.getTitle());
        launcher.addWelcomePage(WizardsArb.getString(381), WizardsArb.getString(465), "oracle.jdevimpl.wizard.project.NewApplicationProjectWizard", "f1_idewnewapplicationwelcome_html");
        launcher.addPage("oracle.jdevimpl.wizard.project.ProjectLocationPanel", "f1_idewnewapplicationlocation_html");
        launcher.addPage("oracle.jdevimpl.wizard.project.ProjectPathsPanel", "f1_idewnewapplicationpaths_html");
        launcher.addPage("oracle.jdevimpl.wizard.project.ProjectLibrariesPanel", "f1_idewnewapplicationlibraries_html");
        launcher.addFinishPage(WizardsArb.getString(72), WizardsArb.getString(468), null, "f1_idewnewprojwsourcesummary_html");
        launcher.setShowStepNumber(true);
        Project proj = launcher.runWizard();
        if (proj != null) {
            result = true;
            TechnologyScope scope = TechnologyScopeConfiguration.getInstance((PropertyStorage)proj).getTechnologyScope();
            scope.setTechnologyKeys(new String[]{"Swing/AWT", "JavaBeans", "Java", "Ant"});
            TechnologyScopeConfiguration.getInstance((PropertyStorage)proj).setTechnologyScope(scope);
            Context ctx = new Context(context);
            ctx.setProject(proj);
            WizardManager wizMgr = WizardManager.getInstance();
            Wizard appWiz = wizMgr.getWizard("oracle.jdeveloper.builder.application.ApplicationBuilder");
            if (appWiz != null) {
                wizMgr.invokeSecondaryWizard(appWiz, ctx, null, null);
            }
        }
        return result;
    }
}

