/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.project;

import java.awt.Component;
import java.net.URL;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.ide.dialogs.filter.DirectoryOptionsPanel;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ModelUtil;
import oracle.ide.wizard.FinishPanel;
import oracle.ide.wizard.WizardCallbacks;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JProjectLibraryList;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.resource.WizardsArb;

public class ProjFromSourceFinishPanel
extends FinishPanel {
    private transient WizardCallbacks _callbacks;
    private JTree _summaryTree;
    private DefaultMutableTreeNode _rootNode;
    private DefaultTreeModel _treeModel;
    private int _wizardType;

    public void onEntry(TraversableContext tc) {
        if (this._summaryTree == null) {
            String finishText = WizardsArb.getString(253);
            String finishDescr = WizardsArb.getString(210);
            this.setFinishText(finishText);
            this._summaryTree = this.createSummaryTree(finishDescr);
            this._treeModel = (DefaultTreeModel)this._summaryTree.getModel();
            this._rootNode = (DefaultMutableTreeNode)this._treeModel.getRoot();
        }
        this.populateSummaryTree(tc);
        this.expandSummaryTree();
        tc.getWizardCallbacks().wizardSetInitialFocus((Component)this._summaryTree);
    }

    private void populateSummaryTree(TraversableContext tc) {
        this._rootNode.removeAllChildren();
        Project tempProj = (Project)tc.get("Project");
        URL tmpURL = (URL)tc.get("ProjectURL");
        String nodeText = WizardsArb.format(258, URLFileSystem.getName((URL)tmpURL));
        this.createAndAddNode(this._rootNode, nodeText);
        nodeText = null;
        URLPath sourcePath = PathsConfiguration.getInstance((Project)tempProj).getSourcePath();
        if (sourcePath != null) {
            nodeText = WizardsArb.getString(269);
            DefaultMutableTreeNode srcPathNode = this.createAndAddNode(this._rootNode, nodeText);
            URL[] urls = sourcePath.getEntries();
            int i = 0;
            while (i < urls.length) {
                nodeText = URLFileSystem.getPlatformPathName((URL)urls[i]);
                this.createAndAddNode(srcPathNode, nodeText);
                ++i;
            }
        }
        Boolean copyFiles = (Boolean)tc.get("copy-files");
        nodeText = WizardsArb.format(286, copyFiles.toString());
        this.createAndAddNode(this._rootNode, nodeText);
        nodeText = null;
        tmpURL = JavaProject.getInstance((Project)tempProj).getOutputDirectory();
        nodeText = WizardsArb.format(397, URLFileSystem.getPlatformPathName((URL)tmpURL));
        this.createAndAddNode(this._rootNode, nodeText);
        JProjectLibraries libs = (JProjectLibraries)tc.find("oracle.jdevimpl.config.JProjectLibraries");
        if (libs != null) {
            nodeText = WizardsArb.getString(443);
            DefaultMutableTreeNode libNode = this.createAndAddNode(this._rootNode, nodeText);
            JLibrary[] libraries = libs.getLibraries();
            JProjectLibraryList libList = libs.getProjectLibraryList();
            if (libraries != null && libraries.length > 0) {
                int i = 0;
                while (i < libraries.length) {
                    nodeText = libraries[i].getName();
                    this.createAndAddNode(libNode, nodeText);
                    ++i;
                }
            }
        }
        this._treeModel.reload();
    }

    private DefaultMutableTreeNode createAndAddNode(DefaultMutableTreeNode parentNode, String newNodeText) {
        if (!ModelUtil.hasLength((String)newNodeText)) {
            return null;
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(newNodeText);
        parentNode.add(node);
        return node;
    }

    private void createCopySourceNodes(DirectoryOptionsPanel panel) {
        if (panel == null) {
            return;
        }
        Boolean copyFiles = new Boolean(panel.getCopyFiles());
        String nodeText = WizardsArb.format(286, copyFiles.toString());
        this.createAndAddNode(this._rootNode, nodeText);
    }
}

