/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.project;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.wizard.WizardCallbacks;
import oracle.jdeveloper.resource.JProjectArb;
import oracle.jdevimpl.resource.WizardsArb;
import oracle.jdevimpl.wizard.project.NewProjectPanel;
import oracle.jdevimpl.wizard.project.ProjectWizardUtils;

public class ProjectLocationPanel
extends DefaultTraversablePanel {
    BorderLayout layMain;
    JMultiLineLabel lblTop;
    NewProjectPanel pnlLocation;
    private URL _projURL;
    private WizardCallbacks _callbacks;

    private void $init$() {
        this.layMain = new BorderLayout();
        this.lblTop = new JMultiLineLabel();
        this.pnlLocation = new NewProjectPanel();
    }

    public ProjectLocationPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onEntry(TraversableContext dataContext) {
        this._callbacks = dataContext.getWizardCallbacks();
        URL projURL = (URL)dataContext.find("ProjectURL");
        this._init(projURL);
        this._callbacks.wizardSetInitialFocus((Component)this.pnlLocation.getDefaultFocusComponent());
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        boolean isBack = dataContext.getDirection() == 2;
        this.pnlLocation.setInteractiveMode(isBack ^ true);
        URL newURL = this.pnlLocation.getFileURL();
        if (newURL == null && !isBack) {
            throw new TraversalException(null);
        }
        if (ModelUtil.areDifferent((Object)this._projURL, (Object)newURL)) {
            if (newURL != null) {
                this._updateChildURL(newURL, dataContext, "OutputDirectory");
                this._updateChildURL(newURL, dataContext, "HtmlRootDir");
                this._updateURLPath(newURL, dataContext, "ProjectSourcePath");
            }
            dataContext.put("ProjectURL", (Object)newURL);
        }
    }

    private void _updateChildURL(URL newProjURL, TraversableContext dataContext, String key) {
        URL newURL;
        URL childURL = (URL)dataContext.find(key);
        if (childURL != null && ModelUtil.areDifferent((Object)childURL, (Object)(newURL = ProjectWizardUtils.updateURL(this._projURL, newProjURL, childURL)))) {
            dataContext.put(key, (Object)newURL);
        }
    }

    private void _updateURLPath(URL newProjURL, TraversableContext dataContext, String key) {
        URLPath newPath;
        URLPath path = (URLPath)dataContext.find(key);
        if (path != null && ModelUtil.areDifferent((Object)path, (Object)(newPath = ProjectWizardUtils.updateURLPath(this._projURL, newProjURL, path)))) {
            dataContext.put(key, (Object)newPath);
        }
    }

    private void _init(URL projURL) {
        if (projURL != null) {
            this._projURL = projURL;
            URL dirURL = URLFileSystem.getParent((URL)projURL);
            String projFile = URLFileSystem.getFileName((URL)projURL);
            this.pnlLocation.setDirectoryURL(dirURL);
            this.pnlLocation.setFileName(projFile);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.layMain);
        this.setDefaultTitle(WizardsArb.getString(97));
        this.lblTop.setText(JProjectArb.getString((int)43));
        this.add((Component)this.lblTop, "North");
        this.add((Component)((Object)this.pnlLocation), "Center");
    }
}

