/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.project;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.URLPathField;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.resource.ControlsArb;
import oracle.jdeveloper.resource.JProjectArb;
import oracle.jdevimpl.resource.WizardsArb;
import oracle.jdevimpl.wizard.project.ProjectWizardUtils;

public class ProjectPathsPanel
extends DefaultTraversablePanel {
    GridBagLayout layBottom;
    JMultiLineLabel lblTop;
    JLabel lblDefaultPkg;
    URLPathField fldSourcePath;
    JButton btnSourcePath;
    JTextField fldDefaultPkg;
    JLabel lblSourcePath;
    JLabel lblOutputDirectory;
    URLTextField fldOutputDirectory;
    JButton btnOutputDirectory;
    JPanel pnlBottom;
    BorderLayout layMain;
    private URLPath _initSourcePath;
    private URL _initOutputDir;

    private void $init$() {
        this.layBottom = new GridBagLayout();
        this.lblTop = new JMultiLineLabel();
        this.lblDefaultPkg = new JLabel();
        this.fldSourcePath = new URLPathField();
        this.btnSourcePath = new JButton();
        this.fldDefaultPkg = new JTextField();
        this.lblSourcePath = new JLabel();
        this.lblOutputDirectory = new JLabel();
        this.fldOutputDirectory = new URLTextField();
        this.btnOutputDirectory = new JButton();
        this.pnlBottom = new JPanel();
        this.layMain = new BorderLayout();
    }

    public ProjectPathsPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onEntry(TraversableContext dataContext) {
        String defPkg;
        WizardCallbacks _callbacks = dataContext.getWizardCallbacks();
        String wizardName = (String)dataContext.find("WizardName");
        if (ModelUtil.hasLength((String)wizardName) && wizardName.equals(WizardsArb.getString(49))) {
            _callbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
        }
        if (!dataContext.contains("DefaultPackage")) {
            if (dataContext.contains("ProjectURL")) {
                try {
                    URL url = (URL)dataContext.get("ProjectURL");
                    File projectFile = new File(url.getPath());
                    defPkg = JavaProject.generateDefaultPackageName((String)projectFile.getName());
                }
                catch (Exception e) {
                    defPkg = "";
                }
            } else {
                defPkg = "";
            }
        } else {
            defPkg = (String)dataContext.find("DefaultPackage");
        }
        if (defPkg != null) {
            this.fldDefaultPkg.setText(defPkg.trim());
        }
        URL projURL = (URL)dataContext.find("ProjectURL");
        this.fldSourcePath.setBaseFolderURL(URLFileSystem.getParent((URL)projURL));
        Project defProj = Ide.getDefaultProject();
        URL defProjURL = defProj.getURL();
        this._initSourcePath = (URLPath)dataContext.find("ProjectSourcePath");
        if (this._initSourcePath == null) {
            PathsConfiguration pathsConfiguration = PathsConfiguration.getInstance((Project)defProj);
            URL firstEntry = pathsConfiguration.getProjectSourcePath().getFirstEntry();
            this._initSourcePath = new URLPath(firstEntry);
            if (firstEntry == null) {
                URL defaultProjectDir = URLFileSystem.getParent((URL)defProjURL);
                String src = ModelArb.getString((int)64);
                URL sourceDir = URLFactory.newDirURL((URL)defaultProjectDir, (String)src);
                this._initSourcePath.add(sourceDir);
            }
            this._initSourcePath = ProjectWizardUtils.updateURLPath(defProjURL, projURL, this._initSourcePath);
        }
        this.fldSourcePath.setURLPath(this._initSourcePath);
        this._initOutputDir = (URL)dataContext.find("OutputDirectory");
        if (this._initOutputDir == null) {
            URL defOutDir = JavaProject.getInstance((Project)defProj).getOutputDirectory();
            this._initOutputDir = ProjectWizardUtils.updateURL(defProjURL, projURL, defOutDir);
        }
        this.fldOutputDirectory.setURL(this._initOutputDir);
        if (_callbacks != null) {
            _callbacks.wizardSetInitialFocus((Component)this.fldDefaultPkg);
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        String defPkg;
        URLPath srcPath = null;
        try {
            srcPath = this.fldSourcePath.getURLPath();
            if (srcPath.size() <= 0) {
                this.fldSourcePath.requestFocus();
                throw new TraversalException(JProjectArb.getString((int)10), JProjectArb.getString((int)46));
            }
            URL[] entries = srcPath.getEntries();
            int i = 0;
            while (i < entries.length) {
                if (!URLFileSystem.isValid((URL)entries[i])) {
                    this.fldSourcePath.requestFocus();
                    String path = URLFileSystem.getPlatformPathName((URL)entries[i]);
                    throw new TraversalException(JProjectArb.format((int)169, (Object)JProjectArb.getString((int)55), (Object)path), JProjectArb.getString((int)46));
                }
                ++i;
            }
            if (ModelUtil.areDifferent((Object)this._initSourcePath, (Object)srcPath)) {
                dataContext.put("ProjectSourcePath", (Object)srcPath);
            }
        }
        catch (URLPathField.BadEntryException e) {
            this.fldSourcePath.requestFocus();
            throw new TraversalException(ControlsArb.format((int)45, (Object)e.getBadEntry()));
        }
        URL outDir = this.fldOutputDirectory.getURL();
        if (outDir == null || !URLFileSystem.isValid((URL)outDir)) {
            this.fldOutputDirectory.requestFocus();
            throw new TraversalException(JProjectArb.format((int)169, (Object)JProjectArb.getString((int)36), (Object)this.fldOutputDirectory.getText().trim()), JProjectArb.getString((int)60));
        }
        if (ModelUtil.areDifferent((Object)this._initOutputDir, (Object)outDir)) {
            dataContext.put("OutputDirectory", (Object)outDir);
        }
        if (ModelUtil.hasLength((String)(defPkg = this.fldDefaultPkg.getText().trim()))) {
            URL pkgDir;
            if (!IdeUtil.isPackageIdentifier((String)defPkg)) {
                this.fldDefaultPkg.requestFocus();
                throw new TraversalException(JProjectArb.format((int)24, (Object)defPkg));
            }
            if (srcPath != null && srcPath.size() > 0 && !URLFileSystem.canCreate((URL)(pkgDir = URLFactory.newDirURL((URL)srcPath.getEntries()[0], (String)defPkg)))) {
                this.fldDefaultPkg.requestFocus();
                throw new TraversalException(JProjectArb.getString((int)22), JProjectArb.getString((int)147));
            }
        }
        dataContext.put("DefaultPackage", (Object)defPkg);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.layMain);
        this.setDefaultTitle(WizardsArb.getString(50));
        this.pnlBottom.setLayout(this.layBottom);
        this.lblTop.setText(JProjectArb.getString((int)70));
        ResourceUtils.resLabel((JLabel)this.lblDefaultPkg, (Component)this.fldDefaultPkg, (String)JProjectArb.getString((int)165));
        ResourceUtils.resLabel((JLabel)this.lblSourcePath, (Component)this.fldSourcePath, (String)JProjectArb.getString((int)103));
        this.fldSourcePath.setEditTitle(JProjectArb.getString((int)55));
        this.btnSourcePath.addActionListener((ActionListener)this.fldSourcePath);
        ResourceUtils.resButton((AbstractButton)this.btnSourcePath, (String)JProjectArb.getString((int)146));
        ResourceUtils.resLabel((JLabel)this.lblOutputDirectory, (Component)this.fldOutputDirectory, (String)JProjectArb.getString((int)150));
        this.btnOutputDirectory.addActionListener((ActionListener)this.fldOutputDirectory);
        ResourceUtils.resButton((AbstractButton)this.btnOutputDirectory, (String)JProjectArb.getString((int)126));
        this.add((Component)this.lblTop, "North");
        this.pnlBottom.add((Component)this.lblDefaultPkg, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.pnlBottom.add((Component)this.fldDefaultPkg, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 2, 0), 0, 0));
        this.pnlBottom.add((Component)this.lblSourcePath, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 2, 0), 0, 0));
        this.pnlBottom.add((Component)this.fldSourcePath, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlBottom.add((Component)this.btnSourcePath, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.pnlBottom.add((Component)this.lblOutputDirectory, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 2, 0), 0, 0));
        this.pnlBottom.add((Component)this.fldOutputDirectory, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlBottom.add((Component)this.btnOutputDirectory, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.add(this.pnlBottom, "Center");
    }
}

