/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.project;

import java.net.URL;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;

public final class ProjectWizardUtils {
    private ProjectWizardUtils() {
    }

    public static URLPath updateURLPath(URL oldProjURL, URL newProjURL, URLPath oldURLPath) {
        URLPath newPath = new URLPath();
        URL oldDir = URLFileSystem.getParent((URL)oldProjURL);
        URL newDir = URLFileSystem.getParent((URL)newProjURL);
        URL[] entries = oldURLPath.getEntries();
        int i = 0;
        while (i < entries.length) {
            URL entry = ProjectWizardUtils._updateRelativeURL(oldDir, newDir, entries[i]);
            newPath.add(entry);
            ++i;
        }
        return newPath;
    }

    public static URL updateURL(URL oldProjURL, URL newProjURL, URL oldURL) {
        URL oldDir = URLFileSystem.getParent((URL)oldProjURL);
        URL newDir = URLFileSystem.getParent((URL)newProjURL);
        return ProjectWizardUtils._updateRelativeURL(oldDir, newDir, oldURL);
    }

    private static URL _updateRelativeURL(URL oldDir, URL newDir, URL oldURL) {
        URL result = oldURL;
        String relPath = URLFileSystem.toRelativeSpec((URL)oldURL, (URL)oldDir, (boolean)true);
        if (relPath != null) {
            result = URLFactory.newURL((URL)newDir, (String)relPath);
        }
        return result;
    }
}

