/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.project;

import java.net.URL;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.Namespace;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.cmd.NewEmptyProjectCommand;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JProjectUtil;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.wizard.project.ProjectWizardKeys;

class WizardApplyHandler
implements ProjectWizardKeys {
    static void applyWizardChanges(Project project, Namespace wizardData, Workspace workspace) {
        JProjectLibraries newLibs;
        JProjectLibraries libs;
        URL url;
        String defPkg = !wizardData.contains("DefaultPackage") ? JavaProject.generateDefaultPackageName((Project)project) : (String)wizardData.get("DefaultPackage");
        NewEmptyProjectCommand.setProjectPackage(defPkg, project, workspace);
        URLPath srcPath = (URLPath)wizardData.get("ProjectSourcePath");
        if (srcPath != null) {
            PathsConfiguration.getInstance((Project)project).setProjectSourcePath(srcPath);
        }
        if ((url = (URL)wizardData.get("HtmlRootDir")) != null) {
            J2eeSettings.getInstance(project).setHtmlRootDirectory(url);
        }
        if ((url = (URL)wizardData.get("OutputDirectory")) != null) {
            url = URLFileSystem.canonicalize((URL)url);
            JProjectUtil.setOutputDirectory((Project)project, (URL)url);
        }
        if ((libs = (JProjectLibraries)wizardData.get("oracle.jdevimpl.config.JProjectLibraries")) != null && (newLibs = JProjectLibraries.getInstance((PropertyStorage)project)) != null) {
            libs.copyTo((Object)newLibs);
        }
    }

    WizardApplyHandler() {
    }
}

